; VDP.ASM : video emulation (texas instruments 9918)
	
	.model medium
	.386

include document.inc

; variables

EXTRN 		_g_fileset:FILESETTINGS, _g_bBitmapA:WORD, VDPReg:BYTE
PUBLIC		_BuildScreenBU, _BuildScreenTD, _Interrupt, _byScreenMode, _bScrModified
PUBLIC		_byBackClr, _pNameTbl, _lpBitmapA, _lpBitmapB, _lpVideoMem, _CalcUpdate

.const

Mode2Add		DW		0, 01600h, -0800h, 0800h

.data

_bScrModified	DW		0
_byScreenMode	DB		255
_byBackClr	DB		0
_lpBitmapA	DD		?
_lpBitmapB	DD		?
_lpVideoMem	DD		?
_pNameTbl		DW		?	; required for text copying
; stack variables
PatternTbl	EQU		WORD PTR [bp-2]	; 2
ColorTbl		EQU		WORD PTR [bp-4]	; 2
ClrMask		EQU		WORD PTR [bp-6]	; 2
SprAttTbl		EQU		WORD PTR [bp-8]	; 2
SprPatTbl		EQU		WORD PTR [bp-10]	; 2
SprSize		EQU		BYTE PTR [bp-11]    ; 1
SprCur		EQU		BYTE PTR [bp-12]	; 1
SprLine		EQU		BYTE PTR [bp-13]	; 1
SprIllegal	EQU		BYTE PTR [bp-14]	; 1
SprLinesBuf	EQU		BYTE PTR [bp-206]	; 192

.code

_BuildScreenBU	PROC	FAR
		enter	206, 0
		push		si
		push		di
		pushf
		; set _Interrupt
		mov		al, VDPReg + 1
		shl		al, 2
		and		al, 080h
		mov		VDPReg + 8, al
		; set background color
		mov		al, VDPReg + 7
		and		al, 15
		jz		$+4
		dec		al
		mov		_byBackClr, al
		; clear screen
		cld
		mov		es, WORD PTR _lpBitmapA + 2
		cmp		_g_bBitmapA, 0
		jnz		SHORT BitmapA
		mov		es, WORD PTR _lpBitmapB + 2
BitmapA:
		mov		fs, WORD PTR _lpVideoMem + 2
		xor		edi, edi
		mov		eax, 0a0a0a0ah
		mov		ecx, 256 * 192 / 4
rep		stosd
		xor		eax, eax
		; call appropriate screen function
		mov		ax, word ptr VDPReg
		; al = reg0 and ah = reg1
		; check if screen disabled
		test		ah, 040h
		jz		SHORT blank
		; find correct screen mode
		and		ax, 1100000000010b	; filter out m1, m2 and m3
		jz		SHORT Screen1
		cmp		ax, 1000000000000b	; m1 set ?
		jz		SHORT Screen0
		cmp		ax, 10b			; m2 set ?
		jnz		$+5
		jmp		Screen2
		cmp		ax, 100000000000b	; m3 set ?
		jnz		SHORT blank		; no legal setting!
		jmp		Screen3
blank:
		mov		_byScreenMode, 0ffh
		jmp		EndBuildScreen

Screen0:
		mov		_byScreenMode, 0
		; load foreground color
		call		LoadTbl
		mov		ah, VDPReg + 7
		shr		ah, 4
		add		ah, 10
		mov		di, 0bf08h
		mov		si, _pNameTbl		; orgin (nametbl) count
		mov		cx, 24
NxtRow:
		push		cx
		mov		cx, 40
NxtCol:
		push		cx
		; load ch number from nametable
		movzx	bx, BYTE PTR fs:[si]
		shl		bx, 3
		add		bx, PatternTbl
		; draw ch
		mov		cx, 8
NxtChRow:
		push		cx
		mov		al, fs:[bx]
		mov		cx, 6
NxtChCol:
		shl		al, 1
		jnc		$+5
		mov		es:[di], ah
		jz		SHORT EndRow
		inc		di
		loop		NxtChCol
EndRow:
		add		di, cx
		inc		bx
		sub		di, 0106h
		pop		cx
		loop		NxtChRow
		; ch drawn; next
		add		di, 0806h
		inc		si
		pop		cx
		loop		NxtCol
		sub		di, 08f0h
		pop		cx
		loop		NxtRow
		jmp		EndBuildScreen

Screen1:
		mov		_byScreenMode, 1
		call		LoadTbl
		call		Sprites
		mov		di, 0bf00h
		mov		si, _pNameTbl
		mov		cx, 24 * 32
nxtch1:
		push		cx
		; load ch number from nametable
		movzx	cx, BYTE PTR fs:[si]
		; load color from colortable
		mov		bx, cx
		shr		bx, 3
		add		bx, ColorTbl
		mov		dl, fs:[bx]
		mov		dh, dl
		and		dl, 15
		shr		dh, 4
		add		dx, 0a0ah
		; calculate pattern address
		mov		bx, cx
		shl		bx, 3
		add		bx, PatternTbl
		; draw ch
		mov		cx, 8
nxtchrow1:
		push		cx
		mov		al, fs:[bx]
		mov		cx, 8
nxtchcol1:
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1		; shl affects the zero-flag
		jnz		SHORT SkipPxl1
		jc		SHORT foreground1
		mov		es:[di], dl
		jmp		SHORT SkipPxl1
foreground1:
		mov		es:[di], dh
SkipPxl1:
		inc		di
		loop		nxtchcol1
		inc		bx
		sub		di, 0108h
		pop		cx
		loop		nxtchrow1
		pop		cx
		inc		si
		dec		cx
		test		cx, 31
		jz		SHORT nxtrow1
		add		di, 0808h
		jmp		SHORT nxtch1
nxtrow1:
		inc		cx
		sub		di, 0f8h
		loop		nxtch1
		jmp		EndBuildScreen
		
Screen2:
		mov		_byScreenMode, 2
		movzx	ax, BYTE PTR VDPReg + 2
		shl		ax, 10
		mov		_pNameTbl, ax
		mov		al, VDPReg + 3
		and		ax, 080h
		shl		ax, 6
		mov		ColorTbl, ax
		mov		al, VDPReg + 4
		and		ax, 4
		shl		ax, 11
		mov		PatternTbl, ax
		movzx	ax, BYTE PTR VDPReg + 5
		shl		ax, 7
		mov		SprAttTbl, ax
		movzx	ax, BYTE PTR VDPReg + 6
		shl		ax, 11
		mov		SprPatTbl, ax
		mov		ah, VDPReg + 3
		and		ah, 01fh
		mov		al, 11100000b
		shr		ax, 2
		mov		ClrMask, ax
		call		Sprites
		mov		di, 0bf00h
		mov		si, _pNameTbl
		call		DrawPart
		mov		al, VDPReg + 3
		and		ax, 040h
		shl		ax, 5
		add		ColorTbl, ax
		mov		al, VDPReg + 4
		and		ax, 2
		shl		ax, 10
		add		PatternTbl, ax
		call		DrawPart
		mov		bl, VDPReg + 3
		shr		bl, 4
		and		bx, 6
		mov		ax, Mode2Add[bx]
		add		ColorTbl, ax
		mov		bl, VDPReg + 4
		shl		bl, 1
		and		bx, 6
		mov		ax, Mode2Add[bx]
		add		PatternTbl, ax
		call		DrawPart
		jmp		EndBuildScreen

DrawPart:
		mov		cx, 8 * 32
nxtch2:
		push		cx
		; load ch number from nametable
		xor		bx, bx
		mov		bl, BYTE PTR fs:[si]
		shl		bx, 3
		; load pattern address
		push		si
		mov		si, bx
		add		si, PatternTbl
		; load color address
		and		bx, ClrMask
		add		bx, ColorTbl
		mov		cx, 8
nxtchrow2:
		mov		dl, fs:[bx]
		mov		dh, dl
		and		dl, 15
		shr		dh, 4
		add		dx, 0a0ah
		mov		al, fs:[si]
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl20
		mov		es:[di], dl
		jnc		short SkipPxl20
		mov		es:[di], dh
SkipPxl20:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl21
		mov		es:[di], dl
		jnc		short SkipPxl21
		mov		es:[di], dh
SkipPxl21:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl22
		mov		es:[di], dl
		jnc		short SkipPxl22
		mov		es:[di], dh
SkipPxl22:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl23
		mov		es:[di], dl
		jnc		short SkipPxl23
		mov		es:[di], dh
SkipPxl23:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl24
		mov		es:[di], dl
		jnc		short SkipPxl24
		mov		es:[di], dh
SkipPxl24:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl25
		mov		es:[di], dl
		jnc		short SkipPxl25
		mov		es:[di], dh
SkipPxl25:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl26
		mov		es:[di], dl
		jnc		short SkipPxl26
		mov		es:[di], dh
SkipPxl26:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT SkipPxl27
		mov		es:[di], dl
		jnc		short SkipPxl27
		mov		es:[di], dh
SkipPxl27:
		sub		di, 0107h
		inc		bx
		inc		si
		dec		cx
		jne		nxtchrow2
		pop		si
		inc		si
		pop		cx
		dec		cx
		test		cx, 31
		jz		nxtrow2
		add		di, 0808h
		jmp		nxtch2
nxtrow2:
		sub		di, 0f8h
		test		cx, cx
		jne		nxtch2
		retn

LoadTbl:
		movzx	ax, BYTE PTR VDPReg + 2
		shl		ax, 10
		mov		_pNameTbl, ax
		movzx	ax, BYTE PTR VDPReg + 3
		shl		ax, 6
		mov		ColorTbl, ax
		movzx	ax, BYTE PTR VDPReg + 4
		shl		ax, 11
		mov		PatternTbl, ax
		movzx	ax, BYTE PTR VDPReg + 5
		shl		ax, 7
		mov		SprAttTbl, ax
		movzx	ax, BYTE PTR VDPReg + 6
		shl		ax, 11
		mov		SprPatTbl, ax
		retn

Screen3:
		mov		_byScreenMode, 3
		call		LoadTbl
		call		Sprites
		sub		si, si
		mov		di, 0bf00h
		mov		cx, 24 * 32
nxtchar3:
		push		cx
		; get colors address (from pattern table !)
		mov		bx, _pNameTbl
		movzx	bx, BYTE PTR fs:[bx][si]
		shl		bx, 3
		mov		cx, si
		shr		cx, 4
		and		cx, 6
		or		bx, cx
		add		bx, PatternTbl
		mov		cx, 2
nxtchrow3:
		push	cx
		; get colors
		mov		dl, fs:[bx]
		mov		dh, dl
		and		dl, 15
		shr		dh, 4
		add		dx, 0a0ah
		mov		cx, 4
nxtch3:
		push		cx
		mov		cx, 4
nxt1:
		cmp		BYTE	PTR es:[di], 10
		jnz		SHORT SkipPxl3
		mov		es:[di], dh
SkipPxl3:
		inc		di
		loop		nxt1
		mov		cx, 4
nxt2:
		cmp		BYTE PTR es:[di], 10
		jnz		SHORT SkipPxl4
		mov		es:[di], dl
SkipPxl4:
		inc		di
		loop		nxt2
		pop		cx
		sub		di, 0108h
		loop		nxtch3
		inc		bx
		pop		cx
		loop		nxtchrow3
		inc		si
		pop		cx
		dec		cx
		test		cx, 31
		jz		SHORT nxtrow3
		add		di, 0808h
		jmp		SHORT nxtchar3
nxtrow3:
		inc		cx
		sub		di, 0f8h
		loop		nxtchar3
		jmp		EndBuildScreen
		
Sprites:
		test		WORD PTR _g_fileset, 1
		jz		SHORT IllegalSprites
		mov		si, SprAttTbl
		; set sprite size
		mov		bl, VDPReg + 1
		mov		al, 8
		test		bl, 2
		setnz	cl
		shl		al, cl
		mov		SprSize, al
		; set jump in di
		mov		di, OFFSET LargeSprite
		test		bl, 1
		jnz		$+5
		mov		di, OFFSET Sprite
		mov		cx, 32
NxtSprite:
		cmp		BYTE PTR fs:[si], 208
		je		SHORT NoFurtherSprites
		push		cx
		push		di
		call		di
		pop		di
		pop		cx
		add		si, 4
		loop		NxtSprite
NoFurtherSprites:
		retn

IllegalSprites:
		; the first four spriteslines are displayed on
		; one line, including transparent sprites
		; (color 0) or sprites with empty patterns
		; or sprites right of the screen
		push		es
		mov		ax, ss
		mov		es, ax
		lea		di, SprLinesBuf
		mov		eax, 05050505h
		mov		ecx, 192 / 4
rep		stosd
		xor		eax, eax
		pop		es
		mov		si, SprAttTbl
		; set sprite size
		mov		bl, VDPReg + 1
		mov		al, 8
		test		bl, 2
		setnz	cl
		shl		al, cl
		mov		SprSize, al
		; set jump in di
		mov		di, OFFSET IllegalLargeSprite
		test		bl, 1
		jnz		$+5
		mov		di, OFFSET IllegalSprite
		mov		cx, 32
		mov		SprLine, 255
		mov		SprIllegal, 0
NxtSprite2:
		cmp		BYTE PTR fs:[si], 208
		je		SHORT NoFurtherSprites2
		mov		SprCur, cl
		push		cx
		push		di
		call		di
		pop		di
		pop		cx
		add		si, 4
		loop		NxtSprite2
NoFurtherSprites2:
		mov		al, SprIllegal
		or		al, al
		jz		SHORT NoCollision1
		neg		al
		add		al, 32 + 040h ; illegal sprite detected bit
		or		VDPReg + 8, al
NoCollision1:
		retn

IllegalLine:
		cmp		SprLine, 255
		jz		SHORT Illegal
		cmp		SprLine, bh
		ja		SHORT NotIllegal
Illegal:
		mov		SprLine, bh
		mov		al, SprCur
		mov		SprIllegal, al
NotIllegal:
		retn

NotDisplay:
		movzx	dx, bh
		mov		cl, SprSize
NxtLine5:
		mov		di, dx
		cmp		bh, 191
		ja		SHORT NotIllegal2
		cmp		SprLinesBuf[di], 0
		jz		SHORT NotIllegal2
		dec		SprLinesBuf[di]
		jnz		$+5
		call		IllegalLine
NotIllegal2:
		dec		bh
		dec		dl
		loop		NxtLine5
		retn

IllegalSprite:
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		neg		bh
		add		bh, 190
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		NotDisplay
		add		dl, 10
		; horizontal correction
		mov		dh, SprSize
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT OnScreenHor
		sub		bl, 32
		jae		SHORT OnScreenHor
		add		dh, bl
		ja		NotDisplay
		sub		bl, bl
OnScreenHor:
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; illegal lines table
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		cl, SprSize
NxtLine:
		push		cx
		cmp		bh, 191
		ja		SHORT EndOfLine
		cmp		SprLinesBuf[si], 0
		jz		SHORT EndOfLine
		dec		SprLinesBuf[si]
		jnz		$+7
		call		IllegalLine
		jmp		SHORT EndOfLine
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
NxtPxl:
		shl		ax, 1
		jnc		SHORT BlankPxl
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl
NoCollision:
		mov		es:[bx], dl
BlankPxl:
		add		bl, 1
		dec		cl
		ja		NxtPxl
		add		bl, cl
		sub		bl, dh
EndOfLine:
		mov		ax, si
		dec		al
		mov		si, ax
		pop		cx
		inc		di
		sub		bh, 1	; dec doesn't affect the carry flag
		jc		$+4
		loop		NxtLine
		pop		si
		retn

NotDisplay2:
		movzx	dx, bh
		mov		cl, SprSize
		shl		cl, 1
NxtLine6:
		mov		di, dx
		cmp		bh, 191
		ja		SHORT NotIllegal3
		cmp		SprLinesBuf[di], 0
		jz		SHORT NotIllegal3
		dec		SprLinesBuf[di]
		jnz		$+5
		call		IllegalLine
NotIllegal3:
		dec		bh
		dec		dl
		loop		NxtLine6
		retn

IllegalLargeSprite:
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		neg		bh
		add		bh, 190
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		NotDisplay2
		add		dl, 10
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		test		BYTE PTR fs:[si+3], 080h
		jz		$+7
		sub		bl, 32
		jb		$+5
		jmp		OnScreenHor2
		mov		dh, bl
		add		dh, SprSize
		add		dh, SprSize
		jz		NotDisplay2
		inc		dh
		shr		dh, 1
		dec		bl 	; reverses bit 0
		and		bl, 1
		; illegal lines table count
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		cl, SprSize
		shl		cl, 1
NxtLine2:
		push		cx
		cmp		bh, 191
		ja		SHORT EndOfLine2
		cmp		SprLinesBuf[si], 0
		jz		SHORT EndOfLine2
		dec		SprLinesBuf[si]
		jnz		$+7
		call		IllegalLine
		jmp		SHORT EndOfLine2
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
NxtPxl2:
		shl		ax, 1
		jnc		SHORT BlankPxl3
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision2
		or		VDPReg + 8, 020h
		jmp		SHORT NotPxl2
NoCollision2:
		mov		es:[bx], dl
NotPxl2:
		or		bl, bl
		jz		SHORT BlankPxl3
		cmp		BYTE PTR es:[bx-1], 10
		jz		SHORT NoCollision3
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl3
NoCollision3:
		mov		es:[bx-1], dl
BlankPxl3:
		add		bl, 2
		dec		cl
		ja		NxtPxl2
		sub		bl, dh
		sub		bl, dh
EndOfLine2:
		mov		ax, si
		dec		al
		mov		si, ax
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		sub		bh, 1
		jc		$+4
		loop		NxtLine2
		pop		si
		retn
		
OnScreenHor2:
		; illegal lines table count
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		dh, SprSize
		mov		cl, dh
		shl		cl, 1
NxtLine3:
		push		cx
		mov		cl, dh
		cmp		bh, 191
		ja		SHORT EndOfLine3
		cmp		SprLinesBuf[si], 0
		jz		SHORT EndOfLine3
		dec		SprLinesBuf[si]
		jnz		$+7
		call		IllegalLine
		jmp		SHORT EndOfLine3
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
NxtPxl3:
		shl		ax, 1
		jnc		SHORT BlankPxl4
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision4
		or		VDPReg + 8, 020h
		jmp		SHORT NotPxl4
NoCollision4:
		mov		es:[bx], dl
NotPxl4:
		cmp		bl, 255
		jae		SHORT BlankPxl4
		cmp		BYTE PTR es:[bx+1], 10
		jz		SHORT NoCollision5
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl4
NoCollision5:
		mov		es:[bx+1], dl
BlankPxl4:
		add		bl, 2
		dec		cl
		ja		NxtPxl3; cf=0 and zf=0
EndOfLine3:
		add		bl, cl
		add		bl, cl
		sub		bl, dh
		sub		bl, dh
		mov		ax, si
		dec		al
		mov		si, ax
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		sub		bh, 1
		jc		$+4
		loop		NxtLine3
		pop		si
		retn

Sprite:
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		SHORT SkipSprite
		add		dl, 10
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		neg		bh
		add		bh, 190
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		mov		dh, SprSize
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT OnScreenHor3
		sub		bl, 32
		jae		SHORT OnScreenHor3
		add		dh, bl
		ja		SHORT SkipSprite
		sub		bl, bl
OnScreenHor3:
		; draw sprite
		mov		cl, SprSize
NxtLine4:
		push		cx
		cmp		bh, 191
		ja		SHORT EndOfLine8
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
NxtPxl4:
		shl		ax, 1
		jnc		SHORT BlankPxl8
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision8
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl8
NoCollision8:
		mov		es:[bx], dl
BlankPxl8:
		add		bl, 1
		dec		cl
		ja		NxtPxl4
		add		bl, cl
		sub		bl, dh
EndOfLine8:
		pop		cx
		sub		bh, 1	; dec doesn't affect the carry flag
		jc		SHORT SkipSprite
		inc		di
		loop		NxtLine4
SkipSprite:
		retn

LargeSprite:
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		SkipSprite
		add		dl, 10
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		neg		bh
		add		bh, 190
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT OnScreenHor9
		sub		bl, 32
		jae		SHORT OnScreenHor9
		mov		dh, bl
		add		dh, SprSize
		add		dh, SprSize
		jz		SkipSprite
		inc		dh
		shr		dh, 1
		dec		bl 	; reverses bit 0
		and		bl, 1
		; draw sprite
		mov		cl, SprSize
		shl		cl, 1
NxtLine9:
		push		cx
		cmp		bh, 191
		ja		SHORT EndOfLine7
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
NxtPxl9:
		shl		ax, 1
		jnc		SHORT BlankPxl2
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision9
		or		VDPReg + 8, 020h
		jmp		SHORT NotPxl
NoCollision9:
		mov		es:[bx], dl
NotPxl:
		or		bl, bl
		jz		SHORT BlankPxl2
		cmp		BYTE PTR es:[bx-1], 10
		jz		SHORT NoCollision20
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl2
NoCollision20:
		mov		es:[bx-1], dl
BlankPxl2:
		add		bl, 2
		dec		cl
		ja		NxtPxl9
		sub		bl, dh
		sub		bl, dh
EndOfLine7:
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		sub		bh, 1
		jc		SHORT SkipSprite2
		loop		NxtLine9
SkipSprite2:
		retn
		
OnScreenHor9:
		mov		dh, SprSize
		mov		cl, dh
		shl		cl, 1
NxtLine7:
		push		cx
		mov		cl, dh
		cmp		bh, 191
		ja		SHORT EndOfLine9
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
NxtPxl8:
		shl		ax, 1
		jnc		SHORT BlankPxl9
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT NoCollision6
		or		VDPReg + 8, 020h
		jmp		SHORT NotPxl3
NoCollision6:
		mov		es:[bx], dl
NotPxl3:
		cmp		bl, 255
		jae		SHORT BlankPxl9
		cmp		BYTE PTR es:[bx+1], 10
		jz		SHORT NoCollision7
		or		VDPReg + 8, 020h
		jmp		SHORT BlankPxl9
NoCollision7:
		mov		es:[bx+1], dl
BlankPxl9:
		add		bl, 2
		dec		cl
		ja		NxtPxl8	; cf=0 and zf=0
EndOfLine9:
		add		bl, cl
		add		bl, cl
		sub		bl, dh
		sub		bl, dh
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		sub		bh, 1
		jc		SHORT SkipSprite3
		loop		NxtLine7
SkipSprite3:
		retn

EndBuildScreen:
		popf
		pop		di
		pop		si
		leave
		mov		_bScrModified, 0
		ret
_BuildScreenBU	ENDP

_BuildScreenTD	PROC	FAR
		enter	206, 0
		push		si
		push		di
		pushf
		; set _Interrupt
		mov		al, VDPReg + 1
		shl		al, 2
		and		al, 080h
		mov		VDPReg + 8, al
		; set background color
		mov		al, VDPReg + 7
		and		al, 15
		jz		$+4
		dec		al
		mov		_byBackClr, al
		; clear screen
		cld
		mov		es, WORD PTR _lpBitmapA + 2
		cmp		_g_bBitmapA, 0
		jnz		SHORT BitmapA2
		mov		es, WORD PTR _lpBitmapB + 2
BitmapA2:
		mov		fs, WORD PTR _lpVideoMem + 2
		xor		edi, edi
		mov		eax, 0a0a0a0ah
		mov		ecx, 256 * 192 / 4
rep		stosd      
		xor		eax, eax
		; call appropriate screen function
		mov		ax, word ptr VDPReg
		; al = reg0 and ah = reg1
		; check if screen disabled
		test		ah, 040h
		jz		SHORT TDblank
		; find correct screen mode
		and		ax, 1100000000010b	; filter out m1, m2 and m3
		jz		SHORT TDScreen1
		cmp		ax, 1000000000000b	; m1 set ?
		jz		SHORT TDScreen0
		cmp		ax, 10b			; m2 set ?
		jnz		$+5
		jmp		TDScreen2
		cmp		ax, 100000000000b	; m3 set ?
		jnz		SHORT TDblank		; no legal setting!
		jmp		TDScreen3
TDblank:
		mov		_byScreenMode, 0ffh
		jmp		End_BuildScreenTD

TDScreen0:
		mov		_byScreenMode, 0
		; load foreground color
		call		TDLoadTbl
		mov		ah, VDPReg + 7
		shr		ah, 4
		add		ah, 10
		mov		di, 8
		mov		si, _pNameTbl		; orgin (nametbl) count
		mov		cx, 24
TDNxtRow:
		push		cx
		mov		cx, 40
TDNxtCol:
		push		cx
		; load ch number from nametable
		movzx	bx, BYTE PTR fs:[si]
		shl		bx, 3
		add		bx, PatternTbl
		; draw ch
		mov		cx, 8
TDNxtChRow:
		push		cx
		mov		al, fs:[bx]
		mov		cx, 6
TDNxtChCol:
		shl		al, 1
		jnc		$+5
		mov		es:[di], ah
		jz		SHORT TDEndRow
		inc		di
		loop		TDNxtChCol
TDEndRow:
		add		di, cx
		inc		bx
		add		di, 0100h - 6
		pop		cx
		loop		TDNxtChRow
		; ch drawn; next
		sub		di, 0800h - 6
		inc		si
		pop		cx
		loop		TDNxtCol
		add		di, 0710h
		pop		cx
		loop		TDNxtRow
		jmp		End_BuildScreenTD

TDScreen1:
		mov		_byScreenMode, 1
		call		TDLoadTbl
		call		TDSprites
		sub		di, di
		mov		si, _pNameTbl
		mov		cx, 24 * 32
TDnxtch1:
		push		cx
		; load ch number from nametable
		movzx	cx, BYTE PTR fs:[si]
		; load color from colortable
		mov		bx, cx
		shr		bx, 3
		add		bx, ColorTbl
		mov		dl, fs:[bx]
		mov		dh, dl
		and		dl, 15
		shr		dh, 4
		add		dx, 0a0ah
		; calculate pattern address
		mov		bx, cx
		shl		bx, 3
		add		bx, PatternTbl
		; draw ch
		mov		cx, 8
TDnxtchrow1:
		push		cx
		mov		al, fs:[bx]
		mov		cx, 8
TDnxtchcol1:
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1		; shl affects the zero-flag
		jnz		SHORT TDSkipPxl1
		jc		SHORT TDforeground1
		mov		es:[di], dl
		jmp		short TDSkipPxl1
TDforeground1:
		mov		es:[di], dh
TDSkipPxl1:
		inc		di
		loop		TDnxtchcol1
		inc		bx
		add		di, 0f8h
		pop		cx
		loop		TDnxtchrow1
		pop		cx
		inc		si
		dec		cx
		test		cx, 31
		jz		SHORT TDnxtrow1
		sub		di, 07f8h
		jmp		SHORT TDnxtch1
TDnxtrow1:
		inc		cx
		sub		di, 0f8h
		loop		TDnxtch1
		jmp		End_BuildScreenTD
		
TDScreen2:
		mov		_byScreenMode, 2
		movzx	ax, BYTE PTR VDPReg + 2
		shl		ax, 10
		mov		_pNameTbl, ax
		mov		al, VDPReg + 3
		and		ax, 080h
		shl		ax, 6
		mov		ColorTbl, ax
		mov		al, VDPReg + 4
		and		ax, 4
		shl		ax, 11
		mov		PatternTbl, ax
		movzx	ax, BYTE PTR VDPReg + 5
		shl		ax, 7
		mov		SprAttTbl, ax
		movzx	ax, BYTE PTR VDPReg + 6
		shl		ax, 11
		mov		SprPatTbl, ax
		mov		ah, VDPReg + 3
		and		ah, 01fh
		mov		al, 11100000b
		shr		ax, 2
		mov		ClrMask, ax
		call		TDSprites
		sub		di, di
		mov		si, _pNameTbl
		call		TDDrawPart
		mov		al, VDPReg + 3
		and		ax, 040h
		shl		ax, 5
		add		ColorTbl, ax
		mov		al, VDPReg + 4
		and		ax, 2
		shl		ax, 10
		add		PatternTbl, ax
		call		TDDrawPart
		mov		bl, VDPReg + 3
		shr		bl, 4
		and		bx, 6
		mov		ax, Mode2Add[bx]
		add		ColorTbl, ax
		mov		bl, VDPReg + 4
		shl		bl, 1
		and		bx, 6
		mov		ax, Mode2Add[bx]
		add		PatternTbl, ax
		call		TDDrawPart
		jmp		End_BuildScreenTD

TDDrawPart:
		mov		cx, 8 * 32
TDnxtch2:
		push		cx
		; load ch number from nametable
		xor		bx, bx
		mov		bl, BYTE PTR fs:[si]
		shl		bx, 3
		; load pattern address
		push		si
		mov		si, bx
		add		si, PatternTbl
		; load color address
		and		bx, ClrMask
		add		bx, ColorTbl
		mov		cx, 8
TDnxtchrow2:
		mov		dl, fs:[bx]
		mov		dh, dl
		and		dl, 15
		shr		dh, 4
		add		dx, 0a0ah
		mov		al, fs:[si]
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl20
		mov		es:[di], dl
		jnc		short TDSkipPxl20
		mov		es:[di], dh
TDSkipPxl20:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl21
		mov		es:[di], dl
		jnc		short TDSkipPxl21
		mov		es:[di], dh
TDSkipPxl21:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl22
		mov		es:[di], dl
		jnc		short TDSkipPxl22
		mov		es:[di], dh
TDSkipPxl22:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl23
		mov		es:[di], dl
		jnc		short TDSkipPxl23
		mov		es:[di], dh
TDSkipPxl23:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl24
		mov		es:[di], dl
		jnc		short TDSkipPxl24
		mov		es:[di], dh
TDSkipPxl24:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl25
		mov		es:[di], dl
		jnc		short TDSkipPxl25
		mov		es:[di], dh
TDSkipPxl25:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl26
		mov		es:[di], dl
		jnc		short TDSkipPxl26
		mov		es:[di], dh
TDSkipPxl26:
		inc		di
		cmp		BYTE PTR es:[di], 10
		rcl		al, 1
		jnz		SHORT TDSkipPxl27
		mov		es:[di], dl
		jnc		short TDSkipPxl27
		mov		es:[di], dh
TDSkipPxl27:
		add		di, 0f9h
		inc		bx
		inc		si
		dec		cx
		jne		TDnxtchrow2
		pop		si
		inc		si
		pop		cx
		dec		cx
		test		cx, 31
		jz		TDnxtrow2
		sub		di, 07f8h
		jmp		TDnxtch2
TDnxtrow2:
		sub		di, 0f8h
		test		cx, cx
		jne		TDnxtch2
		retn

TDLoadTbl:
		movzx	ax, BYTE PTR VDPReg + 2
		shl		ax, 10
		mov		_pNameTbl, ax
		movzx	ax, BYTE PTR VDPReg + 3
		shl		ax, 6
		mov		ColorTbl, ax
		movzx	ax, BYTE PTR VDPReg + 4
		shl		ax, 11
		mov		PatternTbl, ax
		movzx	ax, BYTE PTR VDPReg + 5
		shl		ax, 7
		mov		SprAttTbl, ax
		movzx	ax, BYTE PTR VDPReg + 6
		shl		ax, 11
		mov		SprPatTbl, ax
		retn

TDScreen3:
		mov		_byScreenMode, 3
		call		TDLoadTbl
		call		TDSprites
		sub		si, si
		sub		di, di
		mov		cx, 24 * 32
TDnxtchar3:
		push		cx
		; get colors address (from pattern table !)
		mov		bx, _pNameTbl
		movzx	bx, BYTE PTR fs:[bx][si]
		shl		bx, 3
		mov		cx, si
		shr		cx, 4
		and		cx, 6
		or		bx, cx
		add		bx, PatternTbl
		mov		cx, 2
TDnxtchrow3:
		push	cx
		; get colors
		mov		al, fs:[bx]
		mov		ah, al
		and		al, 15
		shr		ah, 4
		add		ax, 0a0ah
		mov		cx, 4
TDnxtch3: 
		push		cx
		mov		cx, 4
TDnxt1:
		cmp		BYTE	PTR es:[di], 10
		jnz		SHORT TDSkipPxl3
		mov		es:[di], ah
TDSkipPxl3:
		inc		di
		loop		TDnxt1
		mov		cx, 4
TDnxt2:
		cmp		BYTE PTR es:[di], 10
		jnz		SHORT TDSkipPxl4
		mov		es:[di], al
TDSkipPxl4:
		inc		di
		loop		TDnxt2
		pop		cx
		add		di, 0f8h
		loop		TDnxtch3
		inc		bx
		pop		cx
		loop		TDnxtchrow3
		inc		si
		pop		cx
		dec		cx
		test		cx, 31
		jz		SHORT TDnxtrow3
		sub		di, 07f8h
		jmp		SHORT TDnxtchar3
TDnxtrow3:
		inc		cx
		sub		di, 0f8h
		loop		TDnxtchar3
		jmp		End_BuildScreenTD
		
TDSprites:
		test		WORD PTR _g_fileset, 1
		jz		SHORT TDIllegalSprites
		mov		si, SprAttTbl
		; set sprite size
		mov		bl, VDPReg + 1
		mov		al, 8
		test		bl, 2
		setnz	cl
		shl		al, cl
		mov		SprSize, al
		; set jump in di
		mov		di, OFFSET TDLargeSprite
		test		bl, 1
		jnz		$+5
		mov		di, OFFSET TDSprite
		mov		cx, 32
TDNxtSprite:
		cmp		BYTE PTR fs:[si], 208
		je		SHORT TDNoFurtherSprites
		push		cx
		push		di
		call		di
		pop		di
		pop		cx
		add		si, 4
		loop		TDNxtSprite
TDNoFurtherSprites:
		retn

TDIllegalSprites:
		; the first four spriteslines are displayed on
		; one line, including transparent sprites
		; (color 0) or sprites with empty patterns
		; or sprites right of the screen
		push		es
		mov		ax, ss
		mov		es, ax
		lea		di, SprLinesBuf
		mov		eax, 05050505h
		mov		ecx, 192 / 4
rep		stosd      
		xor		eax, eax
		pop		es
		mov		si, SprAttTbl
		; set sprite size
		mov		bl, VDPReg + 1
		mov		al, 8
		test		bl, 2
		setnz	cl
		shl		al, cl
		mov		SprSize, al
		; set jump in di
		mov		di, OFFSET TDIllegalLargeSprite
		test		bl, 1
		jnz		$+5
		mov		di, OFFSET TDIllegalSprite
		mov		cx, 32
		mov		SprLine, 255
		mov		SprIllegal, 0
TDNxtSprite2:
		cmp		BYTE PTR fs:[si], 208
		je		SHORT TDNoFurtherSprites2
		mov		SprCur, cl
		push		cx
		push		di
		call		di
		pop		di
		pop		cx
		add		si, 4
		loop		TDNxtSprite2
TDNoFurtherSprites2:
		mov		al, SprIllegal
		or		al, al
		jz		SHORT TDNoCollision1
		neg		al
		add		al, 32 + 040h ; illegal sprite detected bit
		or		VDPReg + 8, al
TDNoCollision1:
		retn

TDIllegalLine:
		cmp		SprLine, 255
		jz		SHORT TDIllegal
		cmp		SprLine, bh
		ja		SHORT TDNotIllegal
TDIllegal:
		mov		SprLine, bh
		mov		al, SprCur
		mov		SprIllegal, al
TDNotIllegal:
		retn

TDNotDisplay:
		movzx	dx, bh
		mov		cl, SprSize
TDNxtLine5:
		mov		di, dx
		cmp		bh, 191
		ja		SHORT TDNotIllegal2
		cmp		SprLinesBuf[di], 0
		jz		SHORT TDNotIllegal2
		dec		SprLinesBuf[di]
		jnz		$+5
		call		TDIllegalLine
TDNotIllegal2:
		inc		bh
		inc		dl
		loop		TDNxtLine5
		retn

TDIllegalSprite:
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		inc		bh
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		TDNotDisplay
		add		dl, 10
		; horizontal correction
		mov		dh, SprSize
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT TDOnScreenHor
		sub		bl, 32
		jae		SHORT TDOnScreenHor
		add		dh, bl
		ja		TDNotDisplay
		sub		bl, bl
TDOnScreenHor:
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; illegal lines table
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		cl, SprSize
TDNxtLine:
		push		cx
		cmp		bh, 191
		ja		SHORT TDEndOfLine
		cmp		SprLinesBuf[si], 0
		jz		SHORT TDEndOfLine
		dec		SprLinesBuf[si]
		jnz		$+7
		call		TDIllegalLine
		jmp		SHORT TDEndOfLine
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
TDNxtPxl:
		shl		ax, 1
		jnc		SHORT TDBlankPxl
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl
TDNoCollision:
		mov		es:[bx], dl
TDBlankPxl:
		add		bl, 1
		dec		cl
		ja		TDNxtPxl	; zf=0 and cf=0
		add		bl, cl
		sub		bl, dh
TDEndOfLine:
		mov		ax, si
		inc		al
		mov		si, ax
		pop		cx
		inc		di
		inc		bh
		loop		TDNxtLine
		pop		si
		retn

TDNotDisplay2:
		movzx	dx, bh
		mov		cl, SprSize
		shl		cl, 1
TDNxtLine6:
		mov		di, dx
		cmp		bh, 191
		ja		SHORT TDNotIllegal3
		cmp		SprLinesBuf[di], 0
		jz		SHORT TDNotIllegal3
		dec		SprLinesBuf[di]
		jnz		$+5
		call		TDIllegalLine
TDNotIllegal3:
		inc		bh
		inc		dl
		loop		TDNxtLine6
		retn

TDIllegalLargeSprite:
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		inc		bh
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		TDNotDisplay2
		add		dl, 10
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		test		BYTE PTR fs:[si+3], 080h
		jz		$+7
		sub		bl, 32
		jb		$+5
		jmp		TDOnScreenHor2
		mov		dh, bl
		add		dh, SprSize
		add		dh, SprSize
		jz		TDNotDisplay2
		inc		dh
		shr		dh, 1
		dec		bl 	; reverses bit 0
		and		bl, 1
		; illegal lines table count
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		cl, SprSize
		shl		cl, 1
TDNxtLine2:
		push		cx
		cmp		bh, 191
		ja		SHORT TDEndOfLine2
		cmp		SprLinesBuf[si], 0
		jz		SHORT TDEndOfLine2
		dec		SprLinesBuf[si]
		jnz		$+7
		call		TDIllegalLine
		jmp		SHORT TDEndOfLine2
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
TDNxtPxl2:
		shl		ax, 1
		jnc		SHORT TDBlankPxl3
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision2
		or		VDPReg + 8, 020h
		jmp		SHORT TDNotPxl2
TDNoCollision2:
		mov		es:[bx], dl
TDNotPxl2:
		or		bl, bl
		jz		SHORT TDBlankPxl3
		cmp		BYTE PTR es:[bx-1], 10
		jz		SHORT TDNoCollision3
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl3
TDNoCollision3:
		mov		es:[bx-1], dl
TDBlankPxl3:
		add		bl, 2
		dec		cl
		ja		TDNxtPxl2	; zf=0 and cf=0
		sub		bl, dh
		sub		bl, dh
TDEndOfLine2:
		mov		ax, si
		inc		al
		mov		si, ax
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		inc		bh
		loop		TDNxtLine2
		pop		si
		retn

TDOnScreenHor2:
		; illegal lines table count
		push		si
		mov		si, bx
		shr		si, 8
		; draw sprite
		mov		dh, SprSize
		mov		cl, dh
		shl		cl, 1
TDNxtLine3:
		push		cx
		mov		cl, dh
		cmp		bh, 191
		ja		SHORT TDEndOfLine3
		cmp		SprLinesBuf[si], 0
		jz		SHORT TDEndOfLine3
		dec		SprLinesBuf[si]
		jnz		$+7
		call		TDIllegalLine
		jmp		SHORT TDEndOfLine3
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
TDNxtPxl3:
		shl		ax, 1
		jnc		SHORT TDBlankPxl4
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision4
		or		VDPReg + 8, 020h
		jmp		SHORT TDNotPxl4
TDNoCollision4:
		mov		es:[bx], dl
TDNotPxl4:
		cmp		bl, 255
		jae		SHORT TDBlankPxl4
		cmp		BYTE PTR es:[bx+1], 10
		jz		SHORT TDNoCollision5
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl4
TDNoCollision5:
		mov		es:[bx+1], dl
TDBlankPxl4:
		add		bl, 2
		dec		cl
		ja		TDNxtPxl3; cf=0 and zf=0
TDEndOfLine3:
		add		bl, cl
		add		bl, cl
		sub		bl, dh
		sub		bl, dh
		mov		ax, si
		inc		al
		mov		si, ax
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		inc		bh
		loop		TDNxtLine3
		pop		si
		retn

TDSprite:
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		SHORT TDSkipSprite
		add		dl, 10
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		inc		bh
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		mov		dh, SprSize
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT TDOnScreenHor3
		sub		bl, 32
		jae		SHORT TDOnScreenHor3
		add		dh, bl
		ja		SHORT TDSkipSprite
		sub		bl, bl
TDOnScreenHor3:
		; draw sprite
		mov		cl, SprSize
TDNxtLine4:
		push		cx
		cmp		bh, 191
		ja		SHORT TDEndOfLine8
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
TDNxtPxl4:
		shl		ax, 1
		jnc		SHORT TDBlankPxl8
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision8
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl8
TDNoCollision8:
		mov		es:[bx], dl
TDBlankPxl8:
		add		bl, 1
		dec		cl
		ja		TDNxtPxl4
		add		bl, cl
		sub		bl, dh
TDEndOfLine8:
		pop		cx
		inc		bh
		inc		di
		loop		TDNxtLine4
TDSkipSprite:
		retn

TDLargeSprite:
		; load color
		mov		dl, fs:[si+3]
		and		dl, 15
		jz		TDSkipSprite
		add		dl, 10
		; calculate destination address
		mov		bx, fs:[si]
		xchg		bh, bl
		inc		bh
		; calculate pattern address
		movzx	ax, BYTE PTR fs:[si+2]
		cmp		SprSize, 16
		jnz		$+4
		and		al, 11111100b
		shl		ax, 3
		add		ax, SprPatTbl
		mov		di, ax
		; horizontal correction
		test		BYTE PTR fs:[si+3], 080h
		jz		SHORT TDOnScreenHor9
		sub		bl, 32
		jae		SHORT TDOnScreenHor9
		mov		dh, bl
		add		dh, SprSize
		add		dh, SprSize
		jz		TDSkipSprite
		inc		dh
		shr		dh, 1
		dec		bl 	; reverses bit 0
		and		bl, 1
		; draw sprite
		mov		cl, SprSize
		shl		cl, 1
TDNxtLine9:
		push		cx
		cmp		bh, 191
		ja		SHORT TDEndOfLine7
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
		mov		cl, SprSize
		sub		cl, dh
		shl		ax, cl
		mov		cl, dh
TDNxtPxl9:
		shl		ax, 1
		jnc		SHORT TDBlankPxl2
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision9
		or		VDPReg + 8, 020h
		jmp		SHORT TDNotPxl
TDNoCollision9:
		mov		es:[bx], dl
TDNotPxl:
		or		bl, bl
		jz		SHORT TDBlankPxl2
		cmp		BYTE PTR es:[bx-1], 10
		jz		SHORT TDNoCollision20
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl2
TDNoCollision20:
		mov		es:[bx-1], dl
TDBlankPxl2:
		add		bl, 2
		dec		cl
		ja		TDNxtPxl9
		sub		bl, dh
		sub		bl, dh
TDEndOfLine7:
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		inc		bh
		loop		TDNxtLine9
TDSkipSprite2:
		retn
		
TDOnScreenHor9:
		mov		dh, SprSize
		mov		cl, dh
		shl		cl, 1
TDNxtLine7:
		push		cx
		mov		cl, dh
		cmp		bh, 191
		ja		SHORT TDEndOfLine9
		mov		ah, fs:[di]
		mov		al, fs:[di+16]
TDNxtPxl8:
		shl		ax, 1
		jnc		SHORT TDBlankPxl9
		cmp		BYTE PTR es:[bx], 10
		jz		SHORT TDNoCollision6
		or		VDPReg + 8, 020h
		jmp		SHORT TDNotPxl3
TDNoCollision6:
		mov		es:[bx], dl
TDNotPxl3:
		cmp		bl, 255
		jae		SHORT TDBlankPxl9
		cmp		BYTE PTR es:[bx+1], 10
		jz		SHORT TDNoCollision7
		or		VDPReg + 8, 020h
		jmp		SHORT TDBlankPxl9
TDNoCollision7:
		mov		es:[bx+1], dl
TDBlankPxl9:
		add		bl, 2
		dec		cl
		ja		TDNxtPxl8	; cf=0 and zf=0
TDEndOfLine9:
		add		bl, cl
		add		bl, cl
		sub		bl, dh
		sub		bl, dh
		pop		cx
		test		cx, 1
		jz		$+3
		inc		di
		inc		bh
		loop		TDNxtLine7
TDSkipSprite3:
		retn

End_BuildScreenTD:
		popf
		pop		di
		pop		si
		leave
		mov		_bScrModified, 0
		ret
_BuildScreenTD	ENDP

_Interrupt	PROC		FAR
		mov		al, VDPReg + 1
		shl		al, 2
		and		al, 080h
		cmp		_bScrModified, 0
		jz		SHORT KeepBits
		mov		VDPReg + 8, al
		ret
KeepBits:
		and		VDPReg + 8, 07fh
		or		VDPReg + 8, al
		ret
_Interrupt	ENDP

_CalcUpdate	PROC		FAR
		push		ds
		pushf
		push		edi
		push		esi
		mov		es, WORD PTR _lpBitmapA + 2
		mov		ds, WORD PTR _lpBitmapB + 2
		cld
		mov		ecx, 256 * 192 / 4
		sub		esi, esi
		sub		edi, edi
repz		cmpsd
		jz		SHORT same
		lea		ax, [di-4]
		shr		ax, 8
		std
		mov		ecx, 256 * 192 / 4
		mov		esi, 256 * 192 - 4
		mov		edi, 256 * 192 - 4
repz		cmpsd
		lea		dx, [di+4]
		shr		dx, 8
		jmp		short cu_end
same:	mov		ax, -1
		mov		dx, -1
cu_end:	pop		esi
		pop		edi
		popf
		pop		ds
		ret
_CalcUpdate	ENDP

			END
