; CPU.ASM : cpu emulation (zilog Z80a)
	
	.model medium
	.386

; variables
EXTRN		VDPReg:BYTE, ReadMemTbl:DWORD

EXTRN		ReadIO:NEAR, WriteIO:NEAR
EXTRN		_WriteMem:NEAR, _WriteMemW:NEAR, PushVal:NEAR, PopVal:NEAR

PUBLIC		_cpu, _regSP, _regPC, fIFF

; Crappy Turbo Assembler doesn't include private variables in debug mode
PUBLIC		_regAF, _regBC, _regHL, _regDE, _regIX, _regIY, _regI, _regSP

.data

EVEN
; general _registers
_regAF		DW	?
_regBC		DW	?
_regDE		DW	?
_regHL		DW	?
; alternate general _registers
_regAF_		DW	?
_regBC_		DW	?
_regDE_		DW	?
_regHL_		DW	?
; special purpose _registers
_regPC		DW	?
_regSP		DW	?
_regIX		DW	?
_regIY		DW	?
_regI		DB	?
; mode
fIFF			DB	?	; IFF nonzero if set
fIM2			DB	?	; nonzero if IM 2, otherwise zero
fINT			DW	0
; 8 bit _register alias
_regC		EQU	BYTE PTR _regBC
_regB		EQU	BYTE PTR _regBC + 1
_regE		EQU	BYTE PTR _regDE
_regD		EQU	BYTE PTR _regDE + 1
_regL		EQU	BYTE PTR _regHL
_regH		EQU	BYTE PTR _regHL + 1
_regIXl		EQU	BYTE PTR _regIX
_regIXh		EQU	BYTE PTR _regIX + 1
_regIYl		EQU	BYTE PTR _regIY
_regIYh		EQU	BYTE PTR _regIY + 1

; stack variables
RetVal		EQU	WORD PTR [bp-2]

.code

MREADMEM	MACRO
		mov		bx, cx
		rol		bx, 5
		and		bx, 11100b
		les		bx, ReadMemTbl[bx]
		and		ch, 01fh
		or		bx, cx
		mov		dh, es:[bx]
ENDM

MREADMEMW MACRO
		mov		bx, cx
		rol		bx, 5
		and		bx, 11100b
		les		bx, ReadMemTbl[bx]
		and		ch, 01fh
		or		bx, cx
		mov		dx, es:[bx]
ENDM

_cpu			PROC		FAR
	enter	2, 0
	push		si
	push		di
	mov		RetVal, 0
	; load _register variables
	mov		si, 3579545 / 60
	mov		di, _regPC
	mov		ax, _regAF
	cmp		fINT, 0
	je		short NofINT
; execute one instruction
	; fetch
	mov		bx, di
	rol		bx, 5
	and		bx, 11100b
	mov		cx, di
	les		bx, ReadMemTbl[bx]
	and		ch, 01fh
	or		bx, cx
	mov		edx, es:[bx]
	; decode & execute
	movzx	ebx, dl
	call		WORD PTR cs:JumpTbl[ebx*2]
	mov		fINT, 0
	jc		short cpu_end
NofINT:
	call		Interrupt
NextInt:

EVEN
	; fetch & decode & execute
	mov		bx, di
	rol		bx, 5
	and		bx, 11100b
	les		bx, ReadMemTbl[bx]
	mov		cx, di
	and		ch, 01fh
	or		bx, cx
	xor		ecx, ecx
	mov		edx, es:[bx]
	; decode & execute
	mov		cl, dl
	call		WORD PTR cs:JumpTbl[ecx*2]
	jnc		NextInt
cpu_end:
	; store _register variables
	mov		_regAF, ax
	mov		_regPC, di
	mov		ax, RetVal
	pop		di
	pop		si
	leave
	ret

EVEN

JumpTbl		DW	Opcode00, Opcode01, Opcode02, Opcode03, Opcode04, Opcode05, Opcode06, Opcode07
			DW	Opcode08, Opcode09, Opcode0a, Opcode0b, Opcode0c, Opcode0d, Opcode0e, Opcode0f
			DW	Opcode10, Opcode11, Opcode12, Opcode13, Opcode14, Opcode15, Opcode16, Opcode17
			DW	Opcode18, Opcode19, Opcode1a, Opcode1b, Opcode1c, Opcode1d, Opcode1e, Opcode1f
			DW	Opcode20, Opcode21, Opcode22, Opcode23, Opcode24, Opcode25, Opcode26, Opcode27
			DW	Opcode28, Opcode29, Opcode2a, Opcode2b, Opcode2c, Opcode2d, Opcode2e, Opcode2f
			DW	Opcode30, Opcode31, Opcode32, Opcode33, Opcode34, Opcode35, Opcode36, Opcode37
			DW	Opcode38, Opcode39, Opcode3a, Opcode3b, Opcode3c, Opcode3d, Opcode3e, Opcode3f
			DW	Opcode40, Opcode41, Opcode42, Opcode43, Opcode44, Opcode45, Opcode46, Opcode47
			DW	Opcode48, Opcode49, Opcode4a, Opcode4b, Opcode4c, Opcode4d, Opcode4e, Opcode4f
			DW	Opcode50, Opcode51, Opcode52, Opcode53, Opcode54, Opcode55, Opcode56, Opcode57
			DW	Opcode58, Opcode59, Opcode5a, Opcode5b, Opcode5c, Opcode5d, Opcode5e, Opcode5f
			DW	Opcode60, Opcode61, Opcode62, Opcode63, Opcode64, Opcode65, Opcode66, Opcode67
			DW	Opcode68, Opcode69, Opcode6a, Opcode6b, Opcode6c, Opcode6d, Opcode6e, Opcode6f
			DW	Opcode70, Opcode71, Opcode72, Opcode73, Opcode74, Opcode75, Opcode76, Opcode77
			DW	Opcode78, Opcode79, Opcode7a, Opcode7b, Opcode7c, Opcode7d, Opcode7e, Opcode7f
			DW	Opcode80, Opcode81, Opcode82, Opcode83, Opcode84, Opcode85, Opcode86, Opcode87
			DW	Opcode88, Opcode89, Opcode8a, Opcode8b, Opcode8c, Opcode8d, Opcode8e, Opcode8f
			DW	Opcode90, Opcode91, Opcode92, Opcode93, Opcode94, Opcode95, Opcode96, Opcode97
			DW	Opcode98, Opcode99, Opcode9a, Opcode9b, Opcode9c, Opcode9d, Opcode9e, Opcode9f
			DW	Opcodea0, Opcodea1, Opcodea2, Opcodea3, Opcodea4, Opcodea5, Opcodea6, Opcodea7
			DW	Opcodea8, Opcodea9, Opcodeaa, Opcodeab, Opcodeac, Opcodead, Opcodeae, Opcodeaf
			DW	Opcodeb0, Opcodeb1, Opcodeb2, Opcodeb3, Opcodeb4, Opcodeb5, Opcodeb6, Opcodeb7
			DW	Opcodeb8, Opcodeb9, Opcodeba, Opcodebb, Opcodebc, Opcodebd, Opcodebe, Opcodebf
			DW	Opcodec0, Opcodec1, Opcodec2, Opcodec3, Opcodec4, Opcodec5, Opcodec6, Opcodec7
			DW	Opcodec8, Opcodec9, Opcodeca, Opcodecb, Opcodecc, Opcodecd, Opcodece, Opcodecf
			DW	Opcoded0, Opcoded1, Opcoded2, Opcoded3, Opcoded4, Opcoded5, Opcoded6, Opcoded7
			DW	Opcoded8, Opcoded9, Opcodeda, Opcodedb, Opcodedc, Opcodedd, Opcodede, Opcodedf
			DW	Opcodee0, Opcodee1, Opcodee2, Opcodee3, Opcodee4, Opcodee5, Opcodee6, Opcodee7
			DW	Opcodee8, Opcodee9, Opcodeea, Opcodeeb, Opcodeec, Opcodeed, Opcodeee, Opcodeef
			DW	Opcodef0, Opcodef1, Opcodef2, Opcodef3, Opcodef4, Opcodef5, Opcodef6, Opcodef7
			DW	Opcodef8, Opcodef9, Opcodefa, Opcodefb, Opcodefc, Opcodefd, Opcodefe, Opcodeff

Opcodecb:
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblCB[ebx*2]

EVEN

JumpTblCB		DW	Opcodecb00, Opcodecb01, Opcodecb02, Opcodecb03, Opcodecb04, Opcodecb05, Opcodecb06, Opcodecb07
			DW	Opcodecb08, Opcodecb09, Opcodecb0a, Opcodecb0b, Opcodecb0c, Opcodecb0d, Opcodecb0e, Opcodecb0f
			DW	Opcodecb10, Opcodecb11, Opcodecb12, Opcodecb13, Opcodecb14, Opcodecb15, Opcodecb16, Opcodecb17
			DW	Opcodecb18, Opcodecb19, Opcodecb1a, Opcodecb1b, Opcodecb1c, Opcodecb1d, Opcodecb1e, Opcodecb1f
			DW	Opcodecb20, Opcodecb21, Opcodecb22, Opcodecb23, Opcodecb24, Opcodecb25, Opcodecb26, Opcodecb27
			DW	Opcodecb28, Opcodecb29, Opcodecb2a, Opcodecb2b, Opcodecb2c, Opcodecb2d, Opcodecb2e, Opcodecb2f
			DW	Opcodecb30, Opcodecb31, Opcodecb32, Opcodecb33, Opcodecb34, Opcodecb35, Opcodecb36, Opcodecb37
			DW	Opcodecb38, Opcodecb39, Opcodecb3a, Opcodecb3b, Opcodecb3c, Opcodecb3d, Opcodecb3e, Opcodecb3f
			DW	Opcodecb40, Opcodecb41, Opcodecb42, Opcodecb43, Opcodecb44, Opcodecb45, Opcodecb46, Opcodecb47
			DW	Opcodecb48, Opcodecb49, Opcodecb4a, Opcodecb4b, Opcodecb4c, Opcodecb4d, Opcodecb4e, Opcodecb4f
			DW	Opcodecb50, Opcodecb51, Opcodecb52, Opcodecb53, Opcodecb54, Opcodecb55, Opcodecb56, Opcodecb57
			DW	Opcodecb58, Opcodecb59, Opcodecb5a, Opcodecb5b, Opcodecb5c, Opcodecb5d, Opcodecb5e, Opcodecb5f
			DW	Opcodecb60, Opcodecb61, Opcodecb62, Opcodecb63, Opcodecb64, Opcodecb65, Opcodecb66, Opcodecb67
			DW	Opcodecb68, Opcodecb69, Opcodecb6a, Opcodecb6b, Opcodecb6c, Opcodecb6d, Opcodecb6e, Opcodecb6f
			DW	Opcodecb70, Opcodecb71, Opcodecb72, Opcodecb73, Opcodecb74, Opcodecb75, Opcodecb76, Opcodecb77
			DW	Opcodecb78, Opcodecb79, Opcodecb7a, Opcodecb7b, Opcodecb7c, Opcodecb7d, Opcodecb7e, Opcodecb7f
			DW	Opcodecb80, Opcodecb81, Opcodecb82, Opcodecb83, Opcodecb84, Opcodecb85, Opcodecb86, Opcodecb87
			DW	Opcodecb88, Opcodecb89, Opcodecb8a, Opcodecb8b, Opcodecb8c, Opcodecb8d, Opcodecb8e, Opcodecb8f
			DW	Opcodecb90, Opcodecb91, Opcodecb92, Opcodecb93, Opcodecb94, Opcodecb95, Opcodecb96, Opcodecb97
			DW	Opcodecb98, Opcodecb99, Opcodecb9a, Opcodecb9b, Opcodecb9c, Opcodecb9d, Opcodecb9e, Opcodecb9f
			DW	Opcodecba0, Opcodecba1, Opcodecba2, Opcodecba3, Opcodecba4, Opcodecba5, Opcodecba6, Opcodecba7
			DW	Opcodecba8, Opcodecba9, Opcodecbaa, Opcodecbab, Opcodecbac, Opcodecbad, Opcodecbae, Opcodecbaf
			DW	Opcodecbb0, Opcodecbb1, Opcodecbb2, Opcodecbb3, Opcodecbb4, Opcodecbb5, Opcodecbb6, Opcodecbb7
			DW	Opcodecbb8, Opcodecbb9, Opcodecbba, Opcodecbbb, Opcodecbbc, Opcodecbbd, Opcodecbbe, Opcodecbbf
			DW	Opcodecbc0, Opcodecbc1, Opcodecbc2, Opcodecbc3, Opcodecbc4, Opcodecbc5, Opcodecbc6, Opcodecbc7
			DW	Opcodecbc8, Opcodecbc9, Opcodecbca, Opcodecbcb, Opcodecbcc, Opcodecbcd, Opcodecbce, Opcodecbcf
			DW	Opcodecbd0, Opcodecbd1, Opcodecbd2, Opcodecbd3, Opcodecbd4, Opcodecbd5, Opcodecbd6, Opcodecbd7
			DW	Opcodecbd8, Opcodecbd9, Opcodecbda, Opcodecbdb, Opcodecbdc, Opcodecbdd, Opcodecbde, Opcodecbdf
			DW	Opcodecbe0, Opcodecbe1, Opcodecbe2, Opcodecbe3, Opcodecbe4, Opcodecbe5, Opcodecbe6, Opcodecbe7
			DW	Opcodecbe8, Opcodecbe9, Opcodecbea, Opcodecbeb, Opcodecbec, Opcodecbed, Opcodecbee, Opcodecbef
			DW	Opcodecbf0, Opcodecbf1, Opcodecbf2, Opcodecbf3, Opcodecbf4, Opcodecbf5, Opcodecbf6, Opcodecbf7
			DW	Opcodecbf8, Opcodecbf9, Opcodecbfa, Opcodecbfb, Opcodecbfc, Opcodecbfd, Opcodecbfe, Opcodecbff

Opcodeed:
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblED[ebx*2]

EVEN

JumpTblED		DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeed40, Opcodeed41, Opcodeed42, Opcodeed43, Opcodeed44, Opcodeed45, Opcodeed46, Opcodeed47
			DW	Opcodeed48, Opcodeed49, Opcodeed4a, Opcodeed4b, Opcodeed4c, Opcodeed4d, Opcodeed4e, Opcodeed4f
			DW	Opcodeed50, Opcodeed51, Opcodeed52, Opcodeed53, Opcodeed54, Opcodeed55, Opcodeed56, Opcodeed57
			DW	Opcodeed58, Opcodeed59, Opcodeed5a, Opcodeed5b, Opcodeed5c, Opcodeed5d, Opcodeed5e, Opcodeed5f
			DW	Opcodeed60, Opcodeed61, Opcodeed62, Opcodeed63, Opcodeed64, Opcodeed65, Opcodeed66, Opcodeed67
			DW	Opcodeed68, Opcodeed69, Opcodeed6a, Opcodeed6b, Opcodeed6c, Opcodeed6d, Opcodeed6e, Opcodeed6f
			DW	Opcodeed70, Opcodeed71, Opcodeed72, Opcodeed73, Opcodeed74, Opcodeed75, Opcodeed76, Opcodeedxx
			DW	Opcodeed78, Opcodeed79, Opcodeed7a, Opcodeed7b, Opcodeed7c, Opcodeed7d, Opcodeed7e, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeeda0, Opcodeeda1, Opcodeeda2, Opcodeeda3, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeeda8, Opcodeeda9, Opcodeedaa, Opcodeedab, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedb0, Opcodeedb1, Opcodeedb2, Opcodeedb3, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedb8, Opcodeedb9, Opcodeedba, Opcodeedbb, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx
			DW	Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx, Opcodeedxx

Opcodedd:
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblDD[ebx*2]

EVEN

JumpTblDD		DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodedd09, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodedd19, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodedd21, Opcodedd22, Opcodedd23, Opcodedd24, Opcodedd25, Opcodedd26, Opcodeddxx
			DW	Opcodeddxx, Opcodedd29, Opcodedd2a, Opcodedd2b, Opcodedd2c, Opcodedd2d, Opcodedd2e, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd34, Opcodedd35, Opcodedd36, Opcodeddxx
			DW	Opcodeddxx, Opcodedd39, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd44, Opcodedd45, Opcodedd46, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd4c, Opcodedd4d, Opcodedd4e, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd54, Opcodedd55, Opcodedd56, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd5c, Opcodedd5d, Opcodedd5e, Opcodeddxx
			DW	Opcodedd60, Opcodedd61, Opcodedd62, Opcodedd63, Opcodeddxx, Opcodedd65, Opcodedd66, Opcodedd67
			DW	Opcodedd68, Opcodedd69, Opcodedd6a, Opcodedd6b, Opcodedd6c, Opcodeddxx, Opcodedd6e, Opcodedd6f
			DW	Opcodedd70, Opcodedd71, Opcodedd72, Opcodedd73, Opcodedd74, Opcodedd75, Opcodeddxx, Opcodedd77
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd7c, Opcodedd7d, Opcodedd7e, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd84, Opcodedd85, Opcodedd86, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd8c, Opcodedd8d, Opcodedd8e, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd94, Opcodedd95, Opcodedd96, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedd9c, Opcodedd9d, Opcodedd9e, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodedda4, Opcodedda5, Opcodedda6, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddac, Opcodeddad, Opcodeddae, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddb4, Opcodeddb5, Opcodeddb6, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddbc, Opcodeddbd, Opcodeddbe, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddcb, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodedde1, Opcodeddxx, Opcodedde3, Opcodeddxx, Opcodedde5, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodedde9, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx
			DW	Opcodeddxx, Opcodeddf9, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx, Opcodeddxx

Opcodefd:
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblFD[ebx*2]

EVEN

JumpTblFD		DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefd09, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefd19, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefd21, Opcodefd22, Opcodefd23, Opcodefd24, Opcodefd25, Opcodefd26, Opcodefdxx
			DW	Opcodefdxx, Opcodefd29, Opcodefd2a, Opcodefd2b, Opcodefd2c, Opcodefd2d, Opcodefd2e, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd34, Opcodefd35, Opcodefd36, Opcodefdxx
			DW	Opcodefdxx, Opcodefd39, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd44, Opcodefd45, Opcodefd46, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd4c, Opcodefd4d, Opcodefd4e, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd54, Opcodefd55, Opcodefd56, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd5c, Opcodefd5d, Opcodefd5e, Opcodefdxx
			DW	Opcodefd60, Opcodefd61, Opcodefd62, Opcodefd63, Opcodefdxx, Opcodefd65, Opcodefd66, Opcodefd67
			DW	Opcodefd68, Opcodefd69, Opcodefd6a, Opcodefd6b, Opcodefd6c, Opcodefdxx, Opcodefd6e, Opcodefd6f
			DW	Opcodefd70, Opcodefd71, Opcodefd72, Opcodefd73, Opcodefd74, Opcodefd75, Opcodefdxx, Opcodefd77
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd7c, Opcodefd7d, Opcodefd7e, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd84, Opcodefd85, Opcodefd86, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd8c, Opcodefd8d, Opcodefd8e, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd94, Opcodefd95, Opcodefd96, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefd9c, Opcodefd9d, Opcodefd9e, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefda4, Opcodefda5, Opcodefda6, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdac, Opcodefdad, Opcodefdae, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdb4, Opcodefdb5, Opcodefdb6, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdbc, Opcodefdbd, Opcodefdbe, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdcb, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefde1, Opcodefdxx, Opcodefde3, Opcodefdxx, Opcodefde5, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefde9, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx
			DW	Opcodefdxx, Opcodefdf9, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx, Opcodefdxx

Opcodeddcb:
	; calculate address (IX+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	; jump to handler
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblDDCB[ebx*2]

Opcodefdcb:
	; calculate address (IY+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	; jump to handler
	movzx	ebx, dh
	jmp		WORD PTR cs:JumpTblDDCB[ebx*2]

EVEN

JumpTblDDCB	DW	Opcodeddcb00, Opcodeddcb01, Opcodeddcb02, Opcodeddcb03, Opcodeddcb04, Opcodeddcb05, Opcodeddcb06, Opcodeddcb07
			DW	Opcodeddcb08, Opcodeddcb09, Opcodeddcb0a, Opcodeddcb0b, Opcodeddcb0c, Opcodeddcb0d, Opcodeddcb0e, Opcodeddcb0f
			DW	Opcodeddcb10, Opcodeddcb11, Opcodeddcb12, Opcodeddcb13, Opcodeddcb14, Opcodeddcb15, Opcodeddcb16, Opcodeddcb17
			DW	Opcodeddcb18, Opcodeddcb19, Opcodeddcb1a, Opcodeddcb1b, Opcodeddcb1c, Opcodeddcb1d, Opcodeddcb1e, Opcodeddcb1f
			DW	Opcodeddcb20, Opcodeddcb21, Opcodeddcb22, Opcodeddcb23, Opcodeddcb24, Opcodeddcb25, Opcodeddcb26, Opcodeddcb27
			DW	Opcodeddcb28, Opcodeddcb29, Opcodeddcb2a, Opcodeddcb2b, Opcodeddcb2c, Opcodeddcb2d, Opcodeddcb2e, Opcodeddcb2f
			DW	Opcodeddcb30, Opcodeddcb31, Opcodeddcb32, Opcodeddcb33, Opcodeddcb34, Opcodeddcb35, Opcodeddcb36, Opcodeddcb37
			DW	Opcodeddcb38, Opcodeddcb39, Opcodeddcb3a, Opcodeddcb3b, Opcodeddcb3c, Opcodeddcb3d, Opcodeddcb3e, Opcodeddcb3f
			DW	Opcodeddcb40, Opcodeddcb41, Opcodeddcb42, Opcodeddcb43, Opcodeddcb44, Opcodeddcb45, Opcodeddcb46, Opcodeddcb47
			DW	Opcodeddcb48, Opcodeddcb49, Opcodeddcb4a, Opcodeddcb4b, Opcodeddcb4c, Opcodeddcb4d, Opcodeddcb4e, Opcodeddcb4f
			DW	Opcodeddcb50, Opcodeddcb51, Opcodeddcb52, Opcodeddcb53, Opcodeddcb54, Opcodeddcb55, Opcodeddcb56, Opcodeddcb57
			DW	Opcodeddcb58, Opcodeddcb59, Opcodeddcb5a, Opcodeddcb5b, Opcodeddcb5c, Opcodeddcb5d, Opcodeddcb5e, Opcodeddcb5f
			DW	Opcodeddcb60, Opcodeddcb61, Opcodeddcb62, Opcodeddcb63, Opcodeddcb64, Opcodeddcb65, Opcodeddcb66, Opcodeddcb67
			DW	Opcodeddcb68, Opcodeddcb69, Opcodeddcb6a, Opcodeddcb6b, Opcodeddcb6c, Opcodeddcb6d, Opcodeddcb6e, Opcodeddcb6f
			DW	Opcodeddcb70, Opcodeddcb71, Opcodeddcb72, Opcodeddcb73, Opcodeddcb74, Opcodeddcb75, Opcodeddcb76, Opcodeddcb77
			DW	Opcodeddcb78, Opcodeddcb79, Opcodeddcb7a, Opcodeddcb7b, Opcodeddcb7c, Opcodeddcb7d, Opcodeddcb7e, Opcodeddcb7f
			DW	Opcodeddcb80, Opcodeddcb81, Opcodeddcb82, Opcodeddcb83, Opcodeddcb84, Opcodeddcb85, Opcodeddcb86, Opcodeddcb87
			DW	Opcodeddcb88, Opcodeddcb89, Opcodeddcb8a, Opcodeddcb8b, Opcodeddcb8c, Opcodeddcb8d, Opcodeddcb8e, Opcodeddcb8f
			DW	Opcodeddcb90, Opcodeddcb91, Opcodeddcb92, Opcodeddcb93, Opcodeddcb94, Opcodeddcb95, Opcodeddcb96, Opcodeddcb97
			DW	Opcodeddcb98, Opcodeddcb99, Opcodeddcb9a, Opcodeddcb9b, Opcodeddcb9c, Opcodeddcb9d, Opcodeddcb9e, Opcodeddcb9f
			DW	Opcodeddcba0, Opcodeddcba1, Opcodeddcba2, Opcodeddcba3, Opcodeddcba4, Opcodeddcba5, Opcodeddcba6, Opcodeddcba7
			DW	Opcodeddcba8, Opcodeddcba9, Opcodeddcbaa, Opcodeddcbab, Opcodeddcbac, Opcodeddcbad, Opcodeddcbae, Opcodeddcbaf
			DW	Opcodeddcbb0, Opcodeddcbb1, Opcodeddcbb2, Opcodeddcbb3, Opcodeddcbb4, Opcodeddcbb5, Opcodeddcbb6, Opcodeddcbb7
			DW	Opcodeddcbb8, Opcodeddcbb9, Opcodeddcbba, Opcodeddcbbb, Opcodeddcbbc, Opcodeddcbbd, Opcodeddcbbe, Opcodeddcbbf
			DW	Opcodeddcbc0, Opcodeddcbc1, Opcodeddcbc2, Opcodeddcbc3, Opcodeddcbc4, Opcodeddcbc5, Opcodeddcbc6, Opcodeddcbc7
			DW	Opcodeddcbc8, Opcodeddcbc9, Opcodeddcbca, Opcodeddcbcb, Opcodeddcbcc, Opcodeddcbcd, Opcodeddcbce, Opcodeddcbcf
			DW	Opcodeddcbd0, Opcodeddcbd1, Opcodeddcbd2, Opcodeddcbd3, Opcodeddcbd4, Opcodeddcbd5, Opcodeddcbd6, Opcodeddcbd7
			DW	Opcodeddcbd8, Opcodeddcbd9, Opcodeddcbda, Opcodeddcbdb, Opcodeddcbdc, Opcodeddcbdd, Opcodeddcbde, Opcodeddcbdf
			DW	Opcodeddcbe0, Opcodeddcbe1, Opcodeddcbe2, Opcodeddcbe3, Opcodeddcbe4, Opcodeddcbe5, Opcodeddcbe6, Opcodeddcbe7
			DW	Opcodeddcbe8, Opcodeddcbe9, Opcodeddcbea, Opcodeddcbeb, Opcodeddcbec, Opcodeddcbed, Opcodeddcbee, Opcodeddcbef
			DW	Opcodeddcbf0, Opcodeddcbf1, Opcodeddcbf2, Opcodeddcbf3, Opcodeddcbf4, Opcodeddcbf5, Opcodeddcbf6, Opcodeddcbf7
			DW	Opcodeddcbf8, Opcodeddcbf9, Opcodeddcbfa, Opcodeddcbfb, Opcodeddcbfc, Opcodeddcbfd, Opcodeddcbfe, Opcodeddcbff

Opcodeedxx:
	add		di, 2
	sub		si, 8
	retn

Opcode00:	; nop
	; load _register into itself
Opcode7f:	; ld a,a
Opcode40:	; ld b,b
Opcode49:	; ld c,c
Opcode52:	; ld d,d
Opcode5b:	; ld e,e
Opcode64:	; ld h,h
Opcode6d:	; ld l,l
Opcodeddxx:	; no ix command: ignore prefix
Opcodefdxx:	; no iy command: ignore prefix
	inc		di
	sub		si, 4
	retn

; we do not always set the h and n flag correctly, as these
; flags are only used with daa (decimal adjust accumolater)
; which only operates correctly after the following commands:
; add, adc, sub, sbc and neg (8 bit versions)

; al contains the a _reg, and ah the flag _reg (the flags can be
; loaded the fasted lahf, and ax becomes unusable so al is the
; best choice for the a _reg)
; di contains the pc
; si contains the virtual clock count
; edx contains the current opcode

; 8 bit load group

Opcode78:	; ld a,b
	mov		al, _regB
	inc		di
	sub		si, 4
	retn

Opcode79:	; ld a,c
	mov		al, _regC
	inc		di
	sub		si, 4
	retn

Opcode7a:	; ld a,d
	mov		al, _regD
	inc		di
	sub		si, 4
	retn

Opcode7b:	; ld a,e
	mov		al, _regE
	inc		di
	sub		si, 4
	retn

Opcode7c:	; ld a,h
	mov		al, _regH
	inc		di
	sub		si, 4
	retn

Opcode7d:	; ld a,l
	mov		al, _regL
	inc		di
	sub		si, 4
	retn

Opcodedd7c:	; ld a,IXh*
	mov		al, _regIXh
	add		di, 2
	sub		si, 7
	retn

Opcodedd7d:	; ld a,IXl*
	mov		al, _regIXl
	add		di, 2
	sub		si, 7
	retn

Opcodefd7c:	; ld a,IYh*
	mov		al, _regIYh
	add		di, 2
	sub		si, 7
	retn

Opcodefd7d:	; ld a,IYl*
	mov		al, _regIYl
	add		di, 2
	sub		si, 7
	retn

Opcode7e:	; ld a,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		al, dh
	inc		di
	sub		si, 7
	retn

Opcode47:	; ld b,a
	mov		_regB, al
	inc		di
	sub		si, 4
	retn

Opcode41:	; ld b,c
	mov		dl, _regC
	mov		_regB, dl
	inc		di
	sub		si, 4
	retn

Opcode42:	; ld b,d
	mov		dl, _regD
	mov		_regB, dl
	inc		di
	sub		si, 4
	retn
	
Opcode43:	; ld b,e
	mov		dl, _regE
	mov		_regB, dl
	inc		di
	sub		si, 4
	retn

Opcode44:	; ld b,h
	mov		dl, _regH
	mov		_regB, dl
	inc		di
	sub		si, 4
	retn

Opcode45:	; ld b,l
	mov		dl, _regL
	mov		_regB, dl
	inc		di
	sub		si, 4
	retn

Opcodedd44:	; ld b,IXh*
	mov		dl, _regIXh
	mov		_regB, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd45:	; ld b,IXl*
	mov		dl, _regIXl
	mov		_regB, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd44:	; ld b,IYh*
	mov		dl, _regIYh
	mov		_regB, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd45:	; ld b,IYl*
	mov		dl, _regIYl
	mov		_regB, dl
	add		di, 2
	sub		si, 7
	retn

Opcode46:	; ld b,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regB, dh
	inc		di
	sub		si, 7
	retn

Opcode4f:	; ld c,a
	mov		_regC, al
	inc		di
	sub		si, 4
	retn

Opcode48:	; ld c,b
	mov		dl, _regB
	mov		_regC, dl
	inc		di
	sub		si, 4
	retn

Opcode4a:	; ld c,d
	mov		dl, _regD
	mov		_regC, dl
	inc		di
	sub		si, 4
	retn

Opcode4b:	; ld c,e
	mov		dl, _regE
	mov		_regC, dl
	inc		di
	sub		si, 4
	retn

Opcode4c:	; ld c,h
	mov		dl, _regH
	mov		_regC, dl
	inc		di
	sub		si, 4
	retn

Opcode4d:	; ld c,l
	mov		dl, _regL
	mov		_regC, dl
	inc		di
	sub		si, 4
	retn

Opcodedd4c:	; ld c,IXh*
	mov		dl, _regIXh
	mov		_regC, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd4d:	; ld c,IXl*
	mov		dl, _regIXl
	mov		_regC, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd4c:	; ld c,IYh*
	mov		dl, _regIYh
	mov		_regC, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd4d:	; ld c,IYl*
	mov		dl, _regIYl
	mov		_regC, dl
	add		di, 2
	sub		si, 7
	retn

Opcode4e:	; ld	c,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regC, dh
	inc		di
	sub		si, 7
	retn

Opcode57:	; ld d,a
	mov		_regD, al
	inc		di
	sub		si, 4
	retn

Opcode50:	; ld d,b
	mov		dl, _regB
	mov		_regD, dl
	inc		di
	sub		si, 4
	retn

Opcode51:	; ld d,c
	mov		dl, _regC
	mov		_regD, dl
	inc		di
	sub		si, 4
	retn
	
Opcode53:	; ld d,e
	mov		dl, _regE
	mov		_regD, dl
	inc		di
	sub		si, 4
	retn

Opcode54:	; ld d,h
	mov		dl, _regH
	mov		_regD, dl
	inc		di
	sub		si, 4
	retn

Opcode55:	; ld d,l
	mov		dl, _regL
	mov		_regD, dl
	inc		di
	sub		si, 4
	retn

Opcodedd54:	; ld d,IXh*
	mov		dl, _regIXh
	mov		_regD, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd55:	; ld d,IXl*
	mov		dl, _regIXl
	mov		_regD, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd54:	; ld d,IYh*
	mov		dl, _regIYh
	mov		_regD, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd55:	; ld d,IYl*
	mov		dl, _regIYl
	mov		_regD, dl
	add		di, 2
	sub		si, 7
	retn

Opcode56:	; ld	d,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regD, dh
	inc		di
	sub		si, 7
	retn

Opcode5f:	; ld e,a
	mov		_regE, al
	inc		di
	sub		si, 4
	retn

Opcode58:	; ld e,b
	mov		dl, _regB
	mov		_regE, dl
	inc		di
	sub		si, 4
	retn

Opcode59:	; ld e,c
	mov		dl, _regC
	mov		_regE, dl
	inc		di
	sub		si, 4
	retn
	
Opcode5a:	; ld e,d
	mov		dl, _regD
	mov		_regE, dl
	inc		di
	sub		si, 4
	retn

Opcode5c:	; ld e,h
	mov		dl, _regH
	mov		_regE, dl
	inc		di
	sub		si, 4
	retn

Opcode5d:	; ld e,l
	mov		dl, _regL
	mov		_regE, dl
	inc		di
	sub		si, 4
	retn

Opcodedd5c:	; ld e,IXh*
	mov		dl, _regIXh
	mov		_regE, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd5d:	; ld e,IXl*
	mov		dl, _regIXl
	mov		_regE, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd5c:	; ld e,IYh*
	mov		dl, _regIYh
	mov		_regE, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd5d:	; ld e,IYl*
	mov		dl, _regIYl
	mov		_regE, dl
	add		di, 2
	sub		si, 7
	retn

Opcode5e:	; ld	e,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regE, dh
	inc		di
	sub		si, 7
	retn

Opcode67:	; ld h,a
	mov		_regH, al
	inc		di
	sub		si, 4
	retn

Opcode60:	; ld h,b
	mov		dl, _regB
	mov		_regH, dl
	inc		di
	sub		si, 4
	retn

Opcode61:	; ld h,c
	mov		dl, _regC
	mov		_regH, dl
	inc		di
	sub		si, 4
	retn
	
Opcode62:	; ld h,d
	mov		dl, _regD
	mov		_regH, dl
	inc		di
	sub		si, 4
	retn

Opcode63:	; ld h,e
	mov		dl, _regE
	mov		_regH, dl
	inc		di
	sub		si, 4
	retn

Opcode65:	; ld h,l
	mov		dl, _regL
	mov		_regH, dl
	inc		di
	sub		si, 4
	retn

Opcode66:	; ld	h,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regH, dh
	inc		di
	sub		si, 7
	retn

Opcode6f:	; ld l,a
	mov		_regL, al
	inc		di
	sub		si, 4
	retn

Opcode68:	; ld l,b
	mov		dl, _regB
	mov		_regL, dl
	inc		di
	sub		si, 4
	retn

Opcode69:	; ld l,c
	mov		dl, _regC
	mov		_regL, dl
	inc		di
	sub		si, 4
	retn
	
Opcode6a:	; ld l,d
	mov		dl, _regD
	mov		_regL, dl
	inc		di
	sub		si, 4
	retn

Opcode6b:	; ld l,e
	mov		dl, _regE
	mov		_regL, dl
	inc		di
	sub		si, 4
	retn

Opcode6c:	; ld l,h
	mov		dl, _regH
	mov		_regL, dl
	inc		di
	sub		si, 4
	retn

Opcode6e:	; ld	l,(hl)
	mov		cx, _regHL
	MREADMEM
	mov		_regL, dh
	inc		di
	sub		si, 7
	retn

Opcodedd67:	; ld IXh,a*
	mov		_regIXh, al
	add		di, 2
	sub		si, 7
	retn

Opcodefd67:	; ld IYh,a*
	mov		_regIYh, al
	add		di, 2
	sub		si, 7
	retn

Opcodedd60:	; ld IXh,b*
	mov		dl, _regB
	mov		_regIXh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd60:	; ld IYh,b*
	mov		dl, _regB
	mov		_regIYh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd61:	; ld IXh,c*
	mov		dl, _regC
	mov		_regIXh, dl
	add		di, 2
	sub		si, 7
	retn
	
Opcodefd61:	; ld IYh,c*
	mov		dl, _regC
	mov		_regIYh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd62:	; ld IXh,d*
	mov		dl, _regD
	mov		_regIXh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd62:	; ld IYh,d*
	mov		dl, _regD
	mov		_regIYh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd63:	; ld IXh,e*
	mov		dl, _regE
	mov		_regIXh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd63:	; ld IYh,e*
	mov		dl, _regE
	mov		_regIYh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd65:	; ld IXh,IXl*
	mov		dl, _regIXl
	mov		_regIXh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd65:	; ld IYh,IYl*
	mov		dl, _regIYl
	mov		_regIYh, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd6f:	; ld IXl,a*
	mov		_regIXl, al
	add		di, 2
	sub		si, 7
	retn

Opcodefd6f:	; ld IYl,a*
	mov		_regIYl, al
	add		di, 2
	sub		si, 7
	retn

Opcodedd68:	; ld IXl,b*
	mov		dl, _regB
	mov		_regIXl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd68:	; ld IYl,b*
	mov		dl, _regB
	mov		_regIYl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd69:	; ld IXl,c*
	mov		dl, _regC
	mov		_regIXl, dl
	add		di, 2
	sub		si, 7
	retn
	
Opcodefd69:	; ld IYl,c*
	mov		dl, _regC
	mov		_regIYl, dl
	add		di, 2
	sub		si, 7
	retn
	
Opcodedd6a:	; ld IXl,d*
	mov		dl, _regD
	mov		_regIXl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd6a:	; ld IYl,d*
	mov		dl, _regD
	mov		_regIYl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd6b:	; ld IXl,e*
	mov		dl, _regE
	mov		_regIXl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd6b:	; ld IYl,e*
	mov		dl, _regE
	mov		_regIYl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodedd6c:	; ld IXl,IXh*
	mov		dl, _regIXh
	mov		_regIXl, dl
	add		di, 2
	sub		si, 7
	retn

Opcodefd6c:	; ld IYl,IYh*
	mov		dl, _regIYh
	mov		_regIYl, dl
	add		di, 2
	sub		si, 7
	retn

Opcode3e:	; ld a,n
	mov		al, dh
	add		di, 2
	sub		si, 7
	retn

Opcode06:	; ld b,n
	mov		_regB, dh
	add		di, 2
	sub		si, 7
	retn

Opcode0e:	; ld c,n
	mov		_regC, dh
	add		di, 2
	sub		si, 7
	retn

Opcode16:	; ld d,n
	mov		_regD, dh
	add		di, 2
	sub		si, 7
	retn
	
Opcode1e:	; ld e,n
	mov		_regE, dh
	add		di, 2
	sub		si, 7
	retn

Opcode26:	; ld h,n
	mov		_regH, dh
	add		di, 2
	sub		si, 7
	retn

Opcode2e:	; ld l,n
	mov		_regL, dh
	add		di, 2
	sub		si, 7
	retn

Opcodedd26:	; ld IXh,n*
	shr		edx, 16
	mov		_regIXh, dl
	add		di, 3
	sub		si, 10
	retn

Opcodefd26:	; ld IYh,n*
	shr		edx, 16
	mov		_regIYh, dl
	add		di, 3
	sub		si, 10
	retn

Opcodedd2e:	; ld IXl,n*
	shr		edx, 16
	mov		_regIXl, dl
	add		di, 3
	sub		si, 10
	retn

Opcodefd2e:	; ld IYl,n*
	shr		edx, 16
	mov		_regIYl, dl
	add		di, 3
	sub		si, 10
	retn

Opcode77:	; ld (hl),a
	mov		cx, _regHL
	mov		dh, al
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode70:	; ld (hl),b
	mov		cx, _regHL
	mov		dh, _regB
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode71:	; ld (hl),c
	mov		cx, _regHL
	mov		dh, _regC
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode72:	; ld (hl),d
	mov		cx, _regHL
	mov		dh, _regD
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode73:	; ld (hl),e
	mov		cx, _regHL
	mov		dh, _regE
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode74:	; ld (hl),h
	mov		cx, _regHL
	mov		dh, ch	; = _regH
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode75:	; ld (hl),l
	mov		cx, _regHL
	mov		dh, cl	; = _regL
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode36:	; ld (hl),n
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 10
	retn

Opcode0a:	; ld a,(bc)
	mov		cx, _regBC
	MREADMEM
	mov		al, dh
	inc		di
	sub		si, 7
	retn

Opcode1a:	; ld a,(de)
	mov		cx, _regDE
	MREADMEM
	mov		al, dh
	inc		di
	sub		si, 7
	retn

Opcode3a:	; ld a,(nn)
	shr		edx, 8
	mov		cx, dx
	MREADMEM
	mov		al, dh
	add		di, 3
	sub		si, 13
	retn

Opcode02:	; ld	(bc),a
	mov		cx, _regBC
	mov		dh, al
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode12:	; ld	(de),a
	mov		cx, _regDE
	mov		dh, al
	call		_WriteMem
	inc		di
	sub		si, 7
	retn

Opcode32:	; ld	(nn),a
	shr		edx, 8
	mov		cx, dx
	mov		dh, al
	call		_WriteMem
	add		di, 3
	sub		si, 13
	retn

Opcodeed47:	; ld i,a
	mov		_regI, al
Opcodeed4f:	; ld r,a
	add		di, 2
	sub		si, 9
	retn

Opcodeed57:	; ld a,i
	mov		dl, ah
	and		dl, 1
	mov		al, _regI
	; set flags
	or		al, al
	lahf
	and		ah, 0c0h
	or		ah, fIFF
	or		ah, dl
	add		di, 2
	sub		si, 9
	retn

Opcodeed5f:	; ld a,r
	mov		dl, ah
	and		dl, 1
	mov		ax, si	; pretty random, I hope
	; set flags
	or		al, al
	lahf
	and		ah, 0c0h
	or		ah, fIFF
	or		ah, dl
	add		di, 2
	sub		si, 9
	retn

Opcodedd36:	; ld (ix+d),n
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	call		_WriteMem
	add		di, 4
	sub		si, 19
	retn

Opcodefd36:	; ld (iy+d),n
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	call		_WriteMem
	add		di, 4
	sub		si, 19
	retn

Opcodedd77:	; ld (ix+n),a
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, al
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn
      
Opcodedd70:	; ld (ix+n),b
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regB
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd71:	; ld (ix+n),c
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regC
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd72:	; ld (ix+n),d
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regD
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd73:	; ld (ix+n),e
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regE
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd74:	; ld (ix+n),h
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regH
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd75:	; ld (ix+n),l
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	mov		dh, _regL
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd77:	; ld (iy+n),a
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, al
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn
      
Opcodefd70:	; ld (iy+n),b
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regB
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd71:	; ld (iy+n),c
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regC
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd72:	; ld (iy+n),d
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regD
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd73:	; ld (iy+n),e
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regE
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd74:	; ld (iy+n),h
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regH
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodefd75:	; ld (iy+n),l
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	mov		dh, _regL
	call		_WriteMem
	add		di, 3
	sub		si, 19
	retn

Opcodedd7e:	; ld a,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		al, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd46:	; ld b,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regB, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd4e:	; ld c,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regC, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd56:	; ld d,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regD, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd5e:	; ld e,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regE, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd66:	; ld h,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regH, dh
	add		di, 3
	sub		si, 19
	retn

Opcodedd6e:	; ld l,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	mov		_regL, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd7e:	; ld a,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		al, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd46:	; ld b,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regB, dh
	add		di, 3 
	sub		si, 19
	retn

Opcodefd4e:	; ld c,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regC, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd56:	; ld d,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regD, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd5e:	; ld e,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regE, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd66:	; ld h,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regH, dh
	add		di, 3
	sub		si, 19
	retn

Opcodefd6e:	; ld l,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	mov		_regL, dh
	add		di, 3
	sub		si, 19
	retn

; 16 bit load group

Opcode01:	; ld bc,nn
	shr		edx, 8
	mov		_regBC, dx
	add		di, 3
	sub		si, 10
	retn

Opcode11:	; ld de,nn
	shr		edx, 8
	mov		_regDE, dx
	add		di, 3
	sub		si, 10
	retn

Opcode21:	; ld hl,nn
	shr		edx, 8
	mov		_regHL, dx
	add		di, 3
	sub		si, 10
	retn

Opcode31:	; ld sp,nn
	shr		edx, 8
	mov		_regSP, dx
	add		di, 3
	sub		si, 10
	retn

Opcodedd21:	; ld ix,nn
	shr		edx, 16
	mov		_regIX, dx
	add		di, 4
	sub		si, 14
	retn

Opcodefd21:	; ld iy,nn
	shr		edx, 16
	mov		_regIY, dx
	add		di, 4
	sub		si, 14
	retn

Opcode2a:	; ld hl,(nn)
	shr		edx, 8
	mov		cx, dx
	MREADMEMW
	mov		_regHL, dx
	add		di, 3
	sub		si, 16
	retn

Opcodeed4b:	; ld bc,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regBC, dx
	add		di, 4
	sub		si, 20
	retn

Opcodeed5b:	; ld de,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regDE, dx
	add		di, 4
	sub		si, 20
	retn

Opcodeed6b:	; ld hl,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regHL, dx
	add		di, 4
	sub		si, 20
	retn

Opcodeed7b:	; ld sp,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regSP, dx
	add		di, 4
	sub		si, 20
	retn

Opcodedd2a:	; ld ix,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regIX, dx
	add		di, 4
	sub		si, 20
	retn

Opcodefd2a:	; ld iy,(nn)
	shr		edx, 16
	mov		cx, dx
	MREADMEMW
	mov		_regIY, dx
	add		di, 4
	sub		si, 20
	retn

Opcode22:	; ld (nn),hl
	shr		edx, 8
	mov		cx, dx
	mov		dx, _regHL
	call		_WriteMemW
	add		di, 3
	sub		si, 16
	retn

Opcodeed43:	; ld (nn),bc
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regBC
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodeed53:	; ld (nn),de
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regDE
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodeed63:	; ld (nn),hl
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regHL
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodeed73:	; ld (nn),sp
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regSP
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodedd22:	; ld (nn),ix
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regIX
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodefd22:	; ld (nn),iy
	shr		edx, 16
	mov		cx, dx
	mov		dx, _regIY
	call		_WriteMemW
	add		di, 4
	sub		si, 20
	retn

Opcodef9:	; ld sp,hl
	mov		dx, _regHL
	mov		_regSP, dx
	inc		di
	sub		si, 6
	retn

Opcodeddf9:	; ld sp,ix
	mov		dx, _regIX
	mov		_regSP, dx
	add		di, 2
	sub		si, 10
	retn

Opcodefdf9:	; ld sp,iy
	mov		dx, _regIY
	mov		_regSP, dx
	add		di, 2
	sub		si, 10
	retn

Opcodef5:	; push af
	mov		dl, ah
	mov		dh, al	; bytes exchanged
	call		PushVal
	inc		di
	sub		si, 11
	retn

Opcodec5:	; push bc
	mov		dx, _regBC
	call		PushVal
	inc		di
	sub		si, 11
	retn

Opcoded5:	; push de
	mov		dx, _regDE
	call		PushVal
	inc		di
	sub		si, 11
	retn

Opcodee5:	; push hl
	mov		dx, _regHL
	call		PushVal
	inc		di
	sub		si, 11
	retn

Opcodedde5:	; push ix
	mov		dx, _regIX
	call		PushVal
	add		di, 2
	sub		si, 15
	retn

Opcodefde5:	; push iy
	mov		dx, _regIY
	call		PushVal
	add		di, 2
	sub		si, 15
	retn

Opcodef1:	; pop af
	call		PopVal
	mov		al, dh
	mov		ah, dl	; bytes exchanged
	inc		di
	sub		si, 10
	retn

Opcodec1:	; pop bc
	call		PopVal
	mov		_regBC, dx
	inc		di
	sub		si, 10
	retn

Opcoded1:	; pop de
	call		PopVal
	mov		_regDE, dx
	inc		di
	sub		si, 10
	retn

Opcodee1:	; pop hl
	call		PopVal
	mov		_regHL, dx
	inc		di
	sub		si, 10
	retn

Opcodedde1:	; pop ix
	call		PopVal
	mov		_regIX, dx
	add		di, 2
	sub		si, 14
	retn

Opcodefde1:	; pop iy
	call		PopVal
	mov		_regIY, dx
	add		di, 2
	sub		si, 14
	retn

; exchange group

Opcodeeb:	; ex de,hl
	mov		cx, _regHL
	xchg		_regDE, cx
	mov		_regHL, cx
	inc		di
	sub		si, 4
	retn

Opcode08:	; ex af,af'
	xchg		_regAF_, ax
	inc		di
	sub		si, 4
	retn

Opcoded9:	; exx
	mov		cx, _regBC
	xchg		_regBC_, cx
	mov		_regBC, cx
	mov		cx, _regDE
	xchg		_regDE_, cx
	mov		_regDE, cx
	mov		cx, _regHL
	xchg		_regHL_, cx
	mov		_regHL, cx
	inc		di
	sub		si, 4
	retn

Opcodee3:	; ex (sp),hl
	mov		cx, _regSP
	MREADMEMW
	xchg		_regHL, dx
	mov		cx, _regSP
	call		_WriteMemW
	inc		di
	sub		si, 19
	retn

Opcodedde3:	; ex (sp),ix
	mov		cx, _regSP
	MREADMEMW
	xchg		_regIX, dx
	mov		cx, _regSP
	call		_WriteMemW
	add		di, 2
	sub		si, 23
	retn

Opcodefde3:	; ex (sp),iy
	mov		cx, _regSP
	MREADMEMW
	xchg		_regIY, dx
	mov		cx, _regSP
	call		_WriteMemW
	add		di, 2
	sub		si, 23
	retn

; block transfer

Opcodeeda0:	; ldi
	and		ah, 0c1h
	mov		cx, _regHL
	MREADMEM
	mov		cx, _regDE
	call		_WriteMem
	inc		_regHL
	inc		_regDE
	dec		_regBC
	jz		$+5
	or		ah, 100b
	add		di, 2
	sub		si, 16
	retn

Opcodeedb0:	; ldir
	and		ah, 0c1h
RepLdir:
	mov		cx, _regHL
	MREADMEM
	mov		cx, _regDE
	call		_WriteMem
	inc		_regHL
	inc		_regDE
	dec		_regBC
	jz		SHORT NotRepLdir
	sub		si, 21
	jnc		SHORT RepLdir
	; time's up !
	retn
NotRepLdir:
	add		di, 2
	sub		si, 16
	retn

Opcodeeda8:	; ldd
	and		ah, 0c1h
	mov		cx, _regHL
	MREADMEM
	mov		cx, _regDE
	call		_WriteMem
	dec		_regHL
	dec		_regDE
	dec		_regBC
	jz		$+5
	or		ah, 100b
	add		di, 2
	sub		si, 16
	retn

Opcodeedb8:	; lddr
	and		ah, 0c1h
RepLddr:
	mov		cx, _regHL
	MREADMEM
	mov		cx, _regDE
	call		_WriteMem
	dec		_regHL
	dec		_regDE
	dec		_regBC
	jz		SHORT NotRepLddr
	sub		si, 21
	jnc		SHORT RepLddr
	; time's up
	retn
NotRepLddr:
	add		di, 2
	sub		si, 16
	retn

; Search group

Opcodeeda1:	; cpi
	mov		cx, _regHL
	MREADMEM
	mov		cl, ah
	and		cl, 1
	cmp		al, dh
	lahf
	and		ah, 0d0h
	or		ah, cl
	inc		_regHL
	dec		_regBC
	jz		$+5
	or		ah, 100b
	add		di, 2
	sub		si, 16
	retn

Opcodeedb1:	; cpir
	mov		dl, ah
	and		dl, 1
RepCpir:
	mov		cx, _regHL
	MREADMEM
	cmp		al, dh
	lahf
	and		ah, 0d0h
	inc		_regHL
	dec		_regBC
	jz		SHORT NotRepCpir
	or		ah, 100b
	sahf
	jz		SHORT NotRepCpir
	sub		si, 21
	jnc		SHORT RepCpir
	; time's up !
	retn
NotRepCpir:
	or		ah, dl
	add		di, 2
	sub		si, 16
	retn

Opcodeeda9:	; cpd
	mov		cx, _regHL
	MREADMEM
	mov		cl, ah
	and		cl, 1
	cmp		al, dh
	lahf
	and		ah, 0d0h
	or		ah, cl
	dec		_regHL
	dec		_regBC
	jz		$+5
	or		ah, 100b
	add		di, 2
	sub		si, 16
	retn
	
Opcodeedb9:	; cpdr
	mov		dl, ah
	and		dl, 1
RepCpdr:
	mov		cx, _regHL
	MREADMEM
	cmp		al, dh
	lahf
	and		ah, 0d0h
	dec		_regHL
	dec		_regBC
	jz		SHORT NotRepCpdr
	or		ah, 100b
	sahf
	jz		SHORT NotRepCpdr
	sub		si, 21
	jnc		SHORT RepCpdr
	; time's up !
	retn
NotRepCpdr:
	or		ah, dl
	add		di, 2
	sub		si, 16
	retn

; 8 bit arithmetic and logical group

Opcode87:	; add a,a
	add		al, al
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn
OFadd:
	and		ah, 0f9h
	or		ah, 4
	inc		di
	sub		si, 4
	retn

Opcode80:	; add a,b
	add		al, _regB
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode81:	; add a,c
	add		al, _regC
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode82:	; add a,d
	add		al, _regD
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode83:	; add a,e
	add		al, _regE
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode84:	; add a,h
	add		al, _regH
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode85:	; add a,l
	add		al, _regL
	lahf
	jo		SHORT OFadd
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcodedd84:	; add a,IXh*
	add		al, _regIXh
	lahf
	jo		SHORT OFiadd
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn
OFiadd:
	and		ah, 0f9h
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodefd84:	; add a,IYh*
	add		al, _regIYh
	lahf
	jo		SHORT OFiadd
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodedd85:	; add a,IXl*
	add		al, _regIXl
	lahf
	jo		SHORT OFiadd
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodefd85:	; add a,IYl*
	add		al, _regIYl
	lahf
	jo		SHORT OFiadd
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodec6:	; add a,n
	add		al, dh
	lahf
	jo		SHORT OFaddan
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn
OFaddan:
	and		ah, 0f9h
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcode86:	; add a,(hl)
	mov		cx, _regHL
	MREADMEM
	add		al, dh
	lahf
	jo		SHORT OFaddahl
	and		ah, 0f9h
	inc		di
	sub		si, 7
	retn
OFaddahl:
	and		ah, 0f9h
	or		ah, 4
	inc		di
	sub		si, 7
	retn

Opcodedd86:	; add a,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	add		al, dh
	lahf
	jo		SHORT OFaddaix
	and		ah, 0f9h
	add		di, 3
	sub		si, 19
	retn
OFaddaix:
	and		ah, 0f9h
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn
	
Opcodefd86:	; add a,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	add		al, dh
	lahf
	jo		SHORT OFaddaiy
	and		ah, 0f9h
	add		di, 3
	sub		si, 19
	retn
OFaddaiy:
	and		ah, 0f9h
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn

Opcode8f:	; adc a,a
	sahf
	adc		al, al
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn
OFadc:
	and		ah, 0f9h
	or		ah, 4
	inc		di
	sub		si, 4
	retn

Opcode88:	; adc a,b
	sahf
	adc		al, _regB
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn
	
Opcode89:	; adc a,c
	sahf
	adc		al, _regC
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode8a:	; adc a,d
	sahf
	adc		al, _regD
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode8b:	; adc a,e
	sahf
	adc		al, _regE
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode8c:	; adc a,h
	sahf
	adc		al, _regH
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode8d:	; adc a,l
	sahf
	adc		al, _regL
	lahf
	jo		SHORT OFadc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcodedd8c:	; adc a,IXh*
	sahf
	adc		al, _regIXh
	lahf
	jo		SHORT OFiadc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn
OFiadc:
	and		ah, 0f9h
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodefd8c:	; adc a,IYh*
	sahf
	adc		al, _regIYh
	lahf
	jo		SHORT OFiadc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodedd8d:	; adc a,IXl*
	sahf
	adc		al, _regIXl
	lahf
	jo		SHORT OFiadc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodefd8d:	; adc a,IYl*
	sahf
	adc		al, _regIYl
	lahf
	jo		SHORT OFiadc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodece:	; adc a,n
	sahf
	adc		al, dh
	lahf
	jo		SHORT OFadcan
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn
OFadcan:
	and		ah, 0f9h
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcode8e:	; adc a,(hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	adc		al, dh
	lahf
	jo		SHORT OFadcahl
	and		ah, 0f9h
	inc		di
	sub		si, 7
	retn
OFadcahl:
	and		ah, 0f9h
	or		ah, 4
	inc		di
	sub		si, 7
	retn

Opcodedd8e:	; adc a,(ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM  
	sahf
	adc		al, dh
	lahf
	jo		SHORT OFadcaix
	and		ah, 0f9h
	add		di, 3
	sub		si, 19
	retn
OFadcaix:
	and		ah, 0f9h
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn
	
Opcodefd8e:	; adc a,(iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	sahf
	adc		al, dh
	lahf
	jo		SHORT OFadcaiy
	and		ah, 0f9h
	add		di, 3
	sub		si, 19
	retn
OFadcaiy:
	and		ah, 0f9h
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn

Opcode97:	; sub a
	mov		ax, 04200h	; always!
	inc		di
	sub		si, 4
	retn

Opcode90:	; sub b
	sub		al, _regB
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn
OFsub:
	or		ah, 6
	inc		di
	sub		si, 4
	retn

Opcode91:	; sub c
	sub		al, _regC
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode92:	; sub d
	sub		al, _regD
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode93:	; sub e
	sub		al, _regE
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode94:	; sub h
	sub		al, _regH
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode95:	; sub l
	sub		al, _regL
	lahf
	jo		SHORT OFsub
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodedd94:	; sub IXh*
	sub		al, _regIXh
	lahf
	jo		SHORT OFisub
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFisub:
	or		ah, 6
	add		di, 2
	sub		si, 7
	retn

Opcodefd94:	; sub IYh*
	sub		al, _regIYh
	lahf
	jo		SHORT OFisub
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodedd95:	; sub IXl*
	sub		al, _regIXl
	lahf
	jo		SHORT OFisub
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodefd95:	; sub IYl*
	sub		al, _regIYl
	lahf
	jo		SHORT OFisub
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcoded6:	; sub n
	sub		al, dh
	lahf
	jo		SHORT OFsubn
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFsubn:
	or		ah, 6
	add		di, 2
	sub		si, 7
	retn

Opcode96:	; sub (hl)
	mov		cx, _regHL
	MREADMEM
	sub		al, dh
	lahf
	jo		SHORT OFsubhl
	and		ah, 0fbh
	inc		di
	sub		si, 7
	retn
OFsubhl:
	or		ah, 6
	inc		di
	sub		si, 7
	retn

Opcodedd96:	; sub (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	sub		al, dh
	lahf
	jo		SHORT OFsubix
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFsubix:
	or		ah, 6
	add		di, 3
	sub		si, 19
	retn

Opcodefd96:	; sub (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	sub		al, dh
	lahf
	jo		SHORT OFsubiy
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFsubiy:
	or		ah, 6
	add		di, 3
	sub		si, 19
	retn

Opcode9f:	; sbc a
	; result is 0 or FF, and OF=0
	sahf
	sbb		al, al
	lahf
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode98:	; sbc b
	sahf
	sbb		al, _regB
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn
OFsbc:
	or		ah, 6
	inc		di
	sub		si, 4
	retn

Opcode99:	; sbc c
	sahf
	sbb		al, _regC
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode9a:	; sbc d
	sahf
	sbb		al, _regD
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode9b:	; sbc e
	sahf
	sbb		al, _regE
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode9c:	; sbc h
	sahf
	sbb		al, _regH
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode9d:	; sbc l
	sahf
	sbb		al, _regL
	lahf
	jo		SHORT OFsbc
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodedd9c:	; sbc IXh*
	sahf
	sbb		al, _regIXh
	lahf
	jo		SHORT OFisbc
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFisbc:
	or		ah, 6
	add		di, 2
	sub		si, 7
	retn

Opcodefd9c:	; sbc IYh*
	sahf
	sbb		al, _regIYh
	lahf
	jo		SHORT OFisbc
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodedd9d:	; sbc IXl*
	sahf
	sbb		al, _regIXl
	lahf
	jo		SHORT OFisbc
	and		ah, 0fbh
	inc		di
	sub		si, 7
	retn

Opcodefd9d:	; sbc IYl*
	sahf
	sbb		al, _regIYl
	lahf
	jo		SHORT OFisbc
	and		ah, 0fbh
	inc		di
	sub		si, 7
	retn

Opcodede:	; sbc n
	sahf
	sbb		al, dh
	lahf
	jo		SHORT OFsbcn
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFsbcn:
	or		ah, 6
	add		di, 2
	sub		si, 7
	retn

Opcode9e:	; sbc (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	sbb		al, dh
	lahf
	jo		SHORT OFsbchl
	and		ah, 0fbh
	inc		di
	sub		si, 7
	retn
OFsbchl:
	or		ah, 6
	inc		di
	sub		si, 7
	retn

Opcodedd9e:	; sbc (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	sahf
	sbb		al, dh
	lahf
	jo		SHORT OFsbcix
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFsbcix:
	or		ah, 6
	add		di, 3
	sub		si, 19
	retn

Opcodefd9e:	; sbc (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	sahf
	sbb		al, dh
	lahf
	jo		SHORT OFsbciy
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFsbciy:
	or		ah, 6
	add		di, 3
	sub		si, 19
	retn

Opcodea7:	; and a
	and		al, al
	lahf
	inc		di
	sub		si, 4
	retn

Opcodea0:	; and b
	and		al, _regB
	lahf
	inc		di
	sub		si, 4
	retn
	
Opcodea1:	; and c
	and		al, _regC
	lahf
	inc		di
	sub		si, 4
	retn

Opcodea2:	; and d
	and		al, _regD
	lahf
	inc		di
	sub		si, 4
	retn

Opcodea3:	; and e
	and		al, _regE
	lahf
	inc		di
	sub		si, 4
	retn

Opcodea4:	; and h
	and		al, _regH
	lahf
	inc		di
	sub		si, 4
	retn

Opcodea5:	; and l
	and		al, _regL
	lahf
	inc		di
	sub		si, 4
	retn

Opcodedda4:	; and IXh*
	and		al, _regIXh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefda4:	; and IYh*
	and		al, _regIYh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodedda5:	; and IXl*
	and		al, _regIXl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefda5:	; and IYl*
	and		al, _regIYl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodee6:	; and n
	and		al, dh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodea6:	; and (hl)
	mov		cx, _regHL
	MREADMEM
	and		al, dh
	lahf
	inc		di
	sub		si, 7
	retn

Opcodedda6:	; and (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	and		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodefda6:	; and (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	and		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodeaf:	; xor a
	mov		ax, 04400h	; always !
	inc		di
	sub		si, 4
	retn

Opcodea8:	; xor b
	xor		al, _regB
	lahf
	inc		di
	sub		si, 4
	retn
	
Opcodea9:	; xor c
	xor		al, _regC
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeaa:	; xor d
	xor		al, _regD
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeab:	; xor e
	xor		al, _regE
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeac:	; xor h
	xor		al, _regH
	lahf
	inc		di
	sub		si, 4
	retn

Opcodead:	; xor l
	xor		al, _regL
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeddac:	; xor IXh*
	xor		al, _regIXh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefdac:	; xor IYh*
	xor		al, _regIYh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodeddad:	; xor IXl*
	xor		al, _regIXl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefdad:	; xor IYl*
	xor		al, _regIYl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodeee:	; xor n
	xor		al, dh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodeae:	; xor (hl)
	mov		cx, _regHL
	MREADMEM
	xor		al, dh
	lahf
	inc		di
	sub		si, 7
	retn

Opcodeddae:	; xor (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	xor		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodefdae:	; xor (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	xor		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodeb7:	; or a
	or		al, al
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeb0:	; or b
	or		al, _regB
	lahf
	inc		di
	sub		si, 4
	retn
	
Opcodeb1:	; or c
	or		al, _regC
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeb2:	; or d
	or		al, _regD
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeb3:	; or e
	or		al, _regE
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeb4:	; or h
	or		al, _regH
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeb5:	; or l
	or		al, _regL
	lahf
	inc		di
	sub		si, 4
	retn

Opcodeddb4:	; or IXh*
	or		al, _regIXh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefdb4:	; or IYh*
	or		al, _regIYh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodeddb5:	; or IXl*
	or		al, _regIXl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodefdb5:	; or IYl*
	or		al, _regIYl
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodef6:	; or n
	or		al, dh
	lahf
	add		di, 2
	sub		si, 7
	retn

Opcodeb6:	; or (hl)
	mov		cx, _regHL
	MREADMEM
	or		al, dh
	lahf
	inc		di
	sub		si, 7
	retn

Opcodeddb6:	; or (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	or		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodefdb6:	; or (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	or		al, dh
	lahf
	add		di, 3
	sub		si, 19
	retn

Opcodebf:	; cp a
	mov		ah, 042h
	inc		di
	sub		si, 4
	retn

Opcodeb8:	; cp b
	cmp		al, _regB
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn
OFcp:
	or		ah, 4
	inc		di
	sub		si, 4
	retn

Opcodeb9:	; cp c
	cmp		al, _regC
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodeba:	; cp d
	cmp		al, _regD
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodebb:	; cp e
	cmp		al, _regE
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodebc:	; cp h
	cmp		al, _regH
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodebd:	; cp l
	cmp		al, _regL
	lahf
	jo		SHORT OFcp
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodeddbc:	; cp IXh*
	cmp		al, _regIXh
	lahf
	jo		SHORT OFicp
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFicp:
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodefdbc:	; cp IYh*
	cmp		al, _regIYh
	lahf
	jo		SHORT OFicp
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodeddbd:	; cp IXl*
	cmp		al, _regIXl
	lahf
	jo		SHORT OFicp
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodefdbd:	; cp IYl*
	cmp		al, _regIYl
	lahf
	jo		SHORT OFicp
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodefe:	; cp n
	cmp		al, dh
	lahf
	jo		SHORT OFcpn
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFcpn:
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodebe:	; cp (hl)
	mov		cx, _regHL
	MREADMEM
	cmp		al, dh
	lahf
	jo		SHORT OFcphl
	and		ah, 0fbh
	inc		di
	sub		si, 7
	retn
OFcphl:
	or		ah, 4
	inc		di
	sub		si, 7
	retn

Opcodeddbe:	; cp (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	MREADMEM
	cmp		al, dh
	lahf
	jo		SHORT OFcpix
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFcpix:
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn

Opcodefdbe:	; cp (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	MREADMEM
	cmp		al, dh
	lahf
	jo		SHORT OFcpiy
	and		ah, 0fbh
	add		di, 3
	sub		si, 19
	retn
OFcpiy:
	or		ah, 4
	add		di, 3
	sub		si, 19
	retn

Opcode3c:	; inc a
	sahf
	inc		al
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn
OFinc:
	or		ah, 4
	inc		di
	sub		si, 4
	retn

Opcode04:	; inc b
	sahf
	inc		_regB
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode0c:	; inc c
	sahf
	inc		_regC
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode14:	; inc d
	sahf
	inc		_regD
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode1c:	; inc e
	sahf
	inc		_regE
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode24:	; inc h
	sahf
	inc		_regH
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcode2c:	; inc l
	sahf
	inc		_regL
	lahf
	jo		SHORT OFinc
	and		ah, 0f9h
	inc		di
	sub		si, 4
	retn

Opcodedd24:	; inc IXh*
	sahf
	inc		_regIXh
	lahf
	jo		SHORT OFiinc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn
OFiinc:
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodefd24:	; inc IYh*
	sahf
	inc		_regIYh
	lahf
	jo		SHORT OFiinc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodedd2c:	; inc IXl*
	sahf
	inc		_regIXl
	lahf
	jo		SHORT OFiinc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcodefd2c:	; inc IYl*
	sahf
	inc		_regIYl
	lahf
	jo		SHORT OFiinc
	and		ah, 0f9h
	add		di, 2
	sub		si, 7
	retn

Opcode34:	; inc (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	inc		dh
	lahf
	jo		SHORT of_inc_hl
	and		ah, 0fbh
	mov		cx, _regHL
	call		_WriteMem
	inc		di
	sub		si, 11
	retn
of_inc_hl:
	or		ah, 4
	mov		cx, _regHL
	call		_WriteMem
	inc		di
	sub		si, 11
	retn

Opcodedd34:	; inc (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	push		cx
	MREADMEM
	sahf
	inc		dh
	lahf
	jo		SHORT of_inc_ix
	and		ah, 0fbh
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn
of_inc_ix:
	or		ah, 4
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn

Opcodefd34:	; inc (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	push		cx
	MREADMEM
	sahf
	inc		dh
	lahf
	jo		SHORT of_inc_iy
	and		ah, 0fbh
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn
of_inc_iy:
	or		ah, 4
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn

Opcode3d:	; dec a
	sahf
	dec		al
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn
OFdec:
	or		ah, 4
	inc		di
	sub		si, 4
	retn

Opcode05:	; dec b
	sahf
	dec		_regB
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode0d:	; dec c
	sahf
	dec		_regC
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode15:	; dec d
	sahf
	dec		_regD
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode1d:	; dec e
	sahf
	dec		_regE
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode25:	; dec h
	sahf
	dec		_regH
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcode2d:	; dec l
	sahf
	dec		_regL
	lahf
	jo		SHORT OFdec
	and		ah, 0fbh
	inc		di
	sub		si, 4
	retn

Opcodedd25:	; dec IXh*
	sahf
	dec		_regIXh
	lahf
	jo		SHORT OFidec
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFidec:
	or		ah, 4
	add		di, 2
	sub		si, 7
	retn

Opcodefd25:	; dec IYh*
	sahf
	dec		_regIYh
	lahf
	jo		SHORT OFidec
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodedd2d:	; dec IXl*
	sahf
	dec		_regIXl
	lahf
	jo		SHORT OFidec
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcodefd2d:	; dec IYl*
	sahf
	dec		_regIYl
	lahf
	jo		SHORT OFidec
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn

Opcode35:	; dec (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	dec		dh
	lahf
	jo		SHORT of_dec_hl
	and		ah, 0fbh
	mov		cx, _regHL
	call		_WriteMem
	inc		di
	sub		si, 11
	retn
of_dec_hl:
	or		ah, 4
	mov		cx, _regHL
	call		_WriteMem
	inc		di
	sub		si, 11
	retn

Opcodedd35:	; dec (ix+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIX
	push		cx
	MREADMEM
	sahf
	dec		dh
	lahf
	jo		SHORT of_dec_ix
	and		ah, 0fbh
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn
of_dec_ix:
	or		ah, 4
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn

Opcodefd35:	; dec (iy+d)
	shr		edx, 16
	movsx	cx, dl
	add		cx, _regIY
	push		cx
	MREADMEM
	sahf
	dec		dh
	lahf
	jo		SHORT of_dec_iy
	and		ah, 0fbh
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn
of_dec_iy:
	or		ah, 4
	pop		cx
	call		_WriteMem
	add		di, 3
	sub		si, 23
	retn

; 16 bit arithmetic group

Opcode09:	; add hl,bc
	and		ah, 0fch
	mov		cx, _regBC
	add		_regHL, cx
	adc		ah, 0
	inc		di
	sub		si, 11
	retn
	
Opcode19:	; add hl,de
	and		ah, 0fch
	mov		cx, _regDE
	add		_regHL, cx
	adc		ah, 0
	inc		di
	sub		si, 11
	retn

Opcode29:	; add hl,hl
	and		ah, 0fch
	shl		_regHL, 1
	adc		ah, 0
	inc		di
	sub		si, 11
	retn

Opcode39:	; add hl,sp
	and		ah, 0fch
	mov		cx, _regSP
	add		_regHL, cx
	adc		ah, 0
	inc		di
	sub		si, 11
	retn
	
Opcodeed4a:	; adc hl,bc
	mov		cx, _regBC
	sahf
	adc		_regHL, cx
	lahf
	jo		SHORT OFadchl
	and		ah, 0f9h
	add		di, 2
	sub		si, 15
	retn
OFadchl:
	and		ah, 0f9h
	or		ah, 4
	add		di, 2
	sub		si, 15
	retn

Opcodeed5a:	; adc hl,de
	mov		cx, _regDE
	sahf
	adc		_regHL, cx
	lahf
	jo		SHORT OFadchl
	and		ah, 0f9h
	add		di, 2
	sub		si, 15
	retn

Opcodeed6a:	; adc hl,hl
	mov		cx, _regHL
	sahf
	adc		_regHL, cx
	lahf
	jo		SHORT OFadchl
	and		ah, 0f9h
	add		di, 2
	sub		si, 15
	retn

Opcodeed7a:	; adc hl,sp
	mov		cx, _regSP
	sahf
	adc		_regHL, cx
	lahf
	jo		SHORT OFadchl
	and		ah, 0f9h
	add		di, 2
	sub		si, 15
	retn

Opcodeed42:	; sbc hl,bc
	mov		cx, _regBC
	sahf
	sbb		_regHL, cx
	lahf
	jo		SHORT OFsbchl16
	and		ah, 0fbh
	add		di, 2
	sub		si, 15
	retn
OFsbchl16:
	or		ah, 4
	add		di, 2
	sub		si, 15
	retn

Opcodeed52:	; sbc hl,de
	mov		cx, _regDE
	sahf
	sbb		_regHL, cx
	lahf
	jo		SHORT OFsbchl16
	and		ah, 0fbh
	add		di, 2
	sub		si, 15
	retn

Opcodeed62:	; sbc hl,hl
	; result is 0 or FFFF, and OF=0
	sahf
	sbb		cx, cx
	lahf
	and		ah, 0fbh
	mov		_regHL, cx
	add		di, 2
	sub		si, 15
	retn

Opcodeed72:	; sbc hl,sp
	mov		cx, _regSP
	sahf
	sbb		_regHL, cx
	lahf
	jo		SHORT OFsbchl16
	and		ah, 0fbh
	add		di, 2
	sub		si, 15
	retn

Opcodedd09:	; add ix,bc
	and		ah, 0fch
	mov		cx, _regBC
	add		_regIX, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodedd19:	; add ix,de
	and		ah, 0fch
	mov		cx, _regDE
	add		_regIX, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodedd29:	; add ix,ix
	and		ah, 0fch
	shl		_regIX, 1
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodedd39:	; add ix,sp
	and		ah, 0fch
	mov		cx, _regSP
	add		_regIX, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodefd09:	; add iy,bc
	and		ah, 0fch
	mov		cx, _regBC
	add		_regIY, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodefd19:	; add iy,de
	and		ah, 0fch
	mov		cx, _regDE
	add		_regIY, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodefd29:	; add iy,iy
	and		ah, 0fch
	shl		_regIY, 1
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcodefd39:	; add iy,sp
	and		ah, 0fch
	mov		cx, _regSP
	add		_regIY, cx
	adc		ah, 0
	add		di, 2
	sub		si, 15
	retn

Opcode03:	; inc bc
	inc		_regBC
	inc		di
	sub		si, 6
	retn

Opcode13:	; inc de
	inc		_regDE
	inc		di
	sub		si, 6
	retn
	
Opcode23:	; inc hl
	inc		_regHL
	inc		di
	sub		si, 6
	retn

Opcode33:	; inc sp
	inc		_regSP
	inc		di
	sub		si, 6
	retn

Opcodedd23:	; inc ix
	inc		_regIX
	add		di, 2
	sub		si, 10
	retn

Opcodefd23:	; inc iy
	inc		_regIY
	add		di, 2
	sub		si, 10
	retn

Opcode0b:	; dec bc
	dec		_regBC
	inc		di
	sub		si, 6
	retn

Opcode1b:	; dec de
	dec		_regDE
	inc		di
	sub		si, 6
	retn

Opcode2b:	; dec hl
	dec		_regHL
	inc		di
	sub		si, 6
	retn
	
Opcode3b:	; dec sp
	dec		_regSP
	inc		di
	sub		si, 6
	retn

Opcodedd2b:	; dec ix
	dec		_regIX
	add		di, 2
	sub		si, 10
	retn

Opcodefd2b:	; dec iy
	dec		_regIY
	add		di, 2
	sub		si, 10
	retn

; rotate and shift group

Opcode07:	; rlca
	sahf
	rol		al, 1
	lahf
	inc		di
	sub		si, 4
	retn

Opcode0f:	; rrca
	sahf
	ror		al, 1
	lahf
	inc		di
	sub		si, 4
	retn

Opcode17:	; rla
	sahf
	rcl		al, 1
	lahf
	inc		di
	sub		si, 4
	retn

Opcode1f:	; rra
	sahf
	rcr		al, 1
	lahf
	inc		di
	sub		si, 4
	retn

Opcodecb07:	; rlc a
	sahf
	rol		al, 1
	setc		dl
	or		al, al
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb00:	; rlc b
	sahf
	rol		_regB, 1
	setc		dl
	cmp		_regB, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb01:	; rlc c
	sahf
	rol		_regC, 1
	setc      dl
	cmp		_regC, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb02:	; rlc d
	sahf
	rol		_regD, 1
	setc      dl
	cmp		_regD, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb03:	; rlc e
	sahf
	rol		_regE, 1
	setc      dl
	cmp		_regE, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb04:	; rlc h
	sahf
	rol		_regH, 1
	setc      dl
	cmp		_regH, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb05:	; rlc l
	sahf
	rol		_regL, 1
	setc      dl
	cmp		_regL, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb06:	; rlc (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb00:	; b=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb01:	; c=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb02:	; d=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb03:	; e=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb04:	; h=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb05:	; l=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb06:	; rlc (ix+d)
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb07:	; b=rlc (ix+d)*
	push		cx
	MREADMEM
	sahf
	rol		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb0f:	; rrc a
	sahf
	ror		al, 1
	setc      dl
	or		al, al
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb08:	; rrc b
	sahf
	ror		_regB, 1
	setc      dl
	cmp		_regB, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb09:	; rrc c
	sahf
	ror		_regC, 1
	setc      dl
	cmp		_regC, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb0a:	; rrc d
	sahf
	ror		_regD, 1
	setc      dl
	cmp		_regD, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb0b:	; rrc e
	sahf
	ror		_regE, 1
	setc      dl
	cmp		_regE, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb0c:	; rrc h
	sahf
	ror		_regH, 1
	setc      dl
	cmp		_regH, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb0d:	; rrc l
	sahf
	ror		_regL, 1
	setc      dl
	cmp		_regL, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb0e:	; rrc (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb08:	; b=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb09:	; c=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0a:	; d=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0b:	; e=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0c:	; h=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0d:	; l=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0e:	; rrc (ix+d)
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb0f:	; a=rrc (ix+d)*
	push		cx
	MREADMEM
	sahf
	ror		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb17:	; rl a
	sahf
	rcl		al, 1
	setc      dl
	or		al, al
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb10:	; rl b
	sahf
	rcl		_regB, 1
	setc      dl
	cmp		_regB, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb11:	; rl c
	sahf
	rcl		_regC, 1
	setc      dl
	cmp		_regC, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb12:	; rl d
	sahf
	rcl		_regD, 1
	setc      dl
	cmp		_regD, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb13:	; rl e
	sahf
	rcl		_regE, 1
	setc      dl
	cmp		_regE, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb14:	; rl h
	sahf
	rcl		_regH, 1
	setc      dl
	cmp		_regH, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb15:	; rl l
	sahf
	rcl		_regL, 1
	setc      dl
	cmp		_regL, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb16:	; rl (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb10:	; b=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb11:	; c=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb12:	; d=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb13:	; e=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb14:	; h=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb15:	; l=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb16:	; rl (ix+d)
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb17:	; a=rl (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcl		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb1f:	; rr a
	sahf
	rcr		al, 1
	setc      dl
	or		al, al
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb18:	; rr b
	sahf
	rcr		_regB, 1
	setc      dl
	cmp		_regB, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb19:	; rr c
	sahf
	rcr		_regC, 1
	setc      dl
	cmp		_regC, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb1a:	; rr d
	sahf
	rcr		_regD, 1
	setc      dl
	cmp		_regD, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb1b:	; rr e
	sahf
	rcr		_regE, 1
	setc      dl
	cmp		_regE, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb1c:	; rr h
	sahf
	rcr		_regH, 1
	setc      dl
	cmp		_regH, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb1d:	; rr l
	sahf
	rcr		_regL, 1
	setc      dl
	cmp		_regL, 0
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb1e:	; rr (hl)
	mov		cx, _regHL
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb18:	; b=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb19:	; c=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1a:	; d=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1b:	; e=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1c:	; h=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1d:	; l=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1e:	; rr (ix+d)
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb1f:	; a=rr (ix+d)*
	push		cx
	MREADMEM
	sahf
	rcr		dh, 1
	setc      dl
	or		dh, dh
	lahf
	or		ah, dl
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb27:	; sla a
	sal		al, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb20:	; sla b
	sal		_regB, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb21:	; sla c
	sal		_regC, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb22:	; sla d
	sal		_regD, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb23:	; sla e
	sal		_regE, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb24:	; sla h
	sal		_regH, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb25:	; sla l
	sal		_regL, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb26:	; sla (hl)
	mov		cx, _regHL
	MREADMEM
	sal		dh, 1
	lahf
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb20:	; b=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regB, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb21:	; c=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regC, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb22:	; d=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regD, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb23:	; e=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regE, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb24:	; h=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regH, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb25:	; l=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		_regL, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb26:	; sla (ix+d)
	push		cx
	MREADMEM
	sal		dh, 1
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb27:	; a=sla (ix+d)*
	push		cx
	MREADMEM
	sal		dh, 1
	mov		al, dh
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb2f:	; sra a
	sar		al, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb28:	; sra b
	sar		_regB, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb29:	; sra c
	sar		_regC, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb2a:	; sra d
	sar		_regD, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb2b:	; sra e
	sar		_regE, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb2c:	; sra h
	sar		_regH, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb2d:	; sra l
	sar		_regL, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb2e:	; sra (hl)
	mov		cx, _regHL
	MREADMEM
	sar		dh, 1
	lahf
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb28:	; b=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb29:	; c=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2a:	; d=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2b:	; e=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2c:	; h=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2d:	; l=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2e:	; sra (ix+d)
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb2f:	; a=sra (ix+d)*
	push		cx
	MREADMEM
	sar		dh, 1
	lahf
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb37:	; sll a*
	shl		al, 1
	inc		al		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb30:	; sll b*
	shl		_regB, 1
	inc		_regB		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb31:	; sll c*
	shl		_regC, 1
	inc		_regC		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb32:	; sll d*
	shl		_regD, 1
	inc		_regD		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb33:	; sll e*
	shl		_regE, 1
	inc		_regE		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb34:	; sll h*
	shl		_regH, 1
	inc		_regH		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb35:	; sll l*
	shl		_regL, 1
	inc		_regL		; make bit 1 high
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb36:	; sll (hl)*
	mov		cx, _regHL
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb30:	; b=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb31:	; c=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb32:	; d=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb33:	; e=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb34:	; h=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb35:	; l=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb36:	; sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb37:	; a=sll (ix+d)*
	push		cx
	MREADMEM
	shl		dh, 1
	inc		dh		; make bit 1 high
	lahf
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb3f:	; srl a
	shr		al, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb38:	; srl b
	shr		_regB, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb39:	; srl c
	shr		_regC, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb3a:	; srl d
	shr		_regD, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb3b:	; srl e
	shr		_regE, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb3c:	; srl h
	shr		_regH, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb3d:	; srl l
	shr		_regL, 1
	lahf
	add		di, 2
	sub		si, 8
	retn

Opcodecb3e:	; srl (hl)
	mov		cx, _regHL
	MREADMEM
	shr		dh, 1
	lahf
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb38:	; b=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb39:	; c=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3a:	; d=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3b:	; e=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3d:	; h=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3c:	; l=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3e:	; srl (ix+d)
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb3f:	; a=srl (ix+d)*
	push		cx
	MREADMEM
	shr		dh, 1
	lahf
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeed67:	; rrd
	mov		cx, _regHL
	MREADMEM
	mov		dl, dh
	mov		dh, al
	ror		dx, 4
	shr		dh, 4
	and		al, 0f0h
	mov		cl, ah
	and		cl, 1
	or		al, dh
	lahf
	or		ah, cl
	mov		dh, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 18
	retn
	
Opcodeed6f:	; rld
	mov		cx, _regHL
	MREADMEM
	mov		dl, dh
	mov		dh, al
	shl		dh, 4
	rol		dx, 4
	and		al, 0f0h
	mov		cl, ah
	and		cl, 1
	or		al, dh
	lahf
	or		ah, cl
	mov		dh, dl
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 18
	retn

; bit test, set and reset group

Opcodecb47:	; bit a,0
	and		ah, 1
	mov		dl, ah
	test		al, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb40:	; bit b,0
	and		ah, 1
	mov		dl, ah
	test		_regB, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb41:	; bit c,0
	and		ah, 1
	mov		dl, ah
	test		_regC, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb42:	; bit d,0
	and		ah, 1
	mov		dl, ah
	test		_regD, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb43:	; bit e,0
	and		ah, 1
	mov		dl, ah
	test		_regE, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb44:	; bit h,0
	and		ah, 1
	mov		dl, ah
	test		_regH, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb45:	; bit l,0
	and		ah, 1
	mov		dl, ah
	test		_regL, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb4f:	; bit a,1
	and		ah, 1
	mov		dl, ah
	test		al, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb48:	; bit b,1
	and		ah, 1
	mov		dl, ah
	test		_regB, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb49:	; bit c,1
	and		ah, 1
	mov		dl, ah
	test		_regC, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb4a:	; bit d,1
	and		ah, 1
	mov		dl, ah
	test		_regD, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb4b:	; bit e,1
	and		ah, 1
	mov		dl, ah
	test		_regE, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb4c:	; bit h,1
	and		ah, 1
	mov		dl, ah
	test		_regH, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb4d:	; bit l,1
	and		ah, 1
	mov		dl, ah
	test		_regL, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb57:	; bit a,2
	and		ah, 1
	mov		dl, ah
	test		al, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb50:	; bit b,2
	and		ah, 1
	mov		dl, ah
	test		_regB, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb51:	; bit c,2
	and		ah, 1
	mov		dl, ah
	test		_regC, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb52:	; bit d,2
	and		ah, 1
	mov		dl, ah
	test		_regD, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb53:	; bit e,2
	and		ah, 1
	mov		dl, ah
	test		_regE, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb54:	; bit h,2
	and		ah, 1
	mov		dl, ah
	test		_regH, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb55:	; bit l,2
	and		ah, 1
	mov		dl, ah
	test		_regL, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb5f:	; bit a,3
	and		ah, 1
	mov		dl, ah
	test		al, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb58:	; bit b,3
	and		ah, 1
	mov		dl, ah
	test		_regB, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb59:	; bit c,3
	and		ah, 1
	mov		dl, ah
	test		_regC, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb5a:	; bit d,3
	and		ah, 1
	mov		dl, ah
	test		_regD, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb5b:	; bit e,3
	and		ah, 1
	mov		dl, ah
	test		_regE, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb5c:	; bit h,3
	and		ah, 1
	mov		dl, ah
	test		_regH, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb5d:	; bit l,3
	and		ah, 1
	mov		dl, ah
	test		_regL, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb67:	; bit a,4
	and		ah, 1
	mov		dl, ah
	test		al, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb60:	; bit b,4
	and		ah, 1
	mov		dl, ah
	test		_regB, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb61:	; bit c,4
	and		ah, 1
	mov		dl, ah
	test		_regC, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb62:	; bit d,4
	and		ah, 1
	mov		dl, ah
	test		_regD, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb63:	; bit e,4
	and		ah, 1
	mov		dl, ah
	test		_regE, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb64:	; bit h,4
	and		ah, 1
	mov		dl, ah
	test		_regH, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb65:	; bit l,4
	and		ah, 1
	mov		dl, ah
	test		_regL, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb6f:	; bit a,5
	and		ah, 1
	mov		dl, ah
	test		al, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb68:	; bit b,5
	and		ah, 1
	mov		dl, ah
	test		_regB, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb69:	; bit c,5
	and		ah, 1
	mov		dl, ah
	test		_regC, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb6a:	; bit d,5
	and		ah, 1
	mov		dl, ah
	test		_regD, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb6b:	; bit e,5
	and		ah, 1
	mov		dl, ah
	test		_regE, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb6c:	; bit h,5
	and		ah, 1
	mov		dl, ah
	test		_regH, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb6d:	; bit l,5
	and		ah, 1
	mov		dl, ah
	test		_regL, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb77:	; bit a,6
	and		ah, 1
	mov		dl, ah
	test		al, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb70:	; bit b,6
	and		ah, 1
	mov		dl, ah
	test		_regB, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb71:	; bit c,6
	and		ah, 1
	mov		dl, ah
	test		_regC, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb72:	; bit d,6
	and		ah, 1
	mov		dl, ah
	test		_regD, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb73:	; bit e,6
	and		ah, 1
	mov		dl, ah
	test		_regE, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb74:	; bit h,6
	and		ah, 1
	mov		dl, ah
	test		_regH, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb75:	; bit l,6
	and		ah, 1
	mov		dl, ah
	test		_regL, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb7f:	; bit a,7
	and		ah, 1
	mov		dl, ah
	test		al, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb78:	; bit b,7
	and		ah, 1
	mov		dl, ah
	test		_regB, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb79:	; bit c,7
	and		ah, 1
	mov		dl, ah
	test		_regC, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb7a:	; bit d,7
	and		ah, 1
	mov		dl, ah
	test		_regD, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb7b:	; bit e,7
	and		ah, 1
	mov		dl, ah
	test		_regE, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb7c:	; bit h,7
	and		ah, 1
	mov		dl, ah
	test		_regH, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb7d:	; bit l,7
	and		ah, 1
	mov		dl, ah
	test		_regL, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 8
	retn

Opcodecb46:	; bit (hl),0
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 1
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb40:	; bit (ix+d),0*
Opcodeddcb41:	; bit (ix+d),0*
Opcodeddcb42:	; bit (ix+d),0*
Opcodeddcb43:	; bit (ix+d),0*
Opcodeddcb44:	; bit (ix+d),0*
Opcodeddcb45:	; bit (ix+d),0*
Opcodeddcb46:	; bit (ix+d),0
Opcodeddcb47:	; bit (ix+d),0*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 1
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb4e:	; bit (hl),1
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 2
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb48:	; bit (ix+d),1*
Opcodeddcb49:	; bit (ix+d),1*
Opcodeddcb4a:	; bit (ix+d),1*
Opcodeddcb4b:	; bit (ix+d),1*
Opcodeddcb4c:	; bit (ix+d),1*
Opcodeddcb4d:	; bit (ix+d),1*
Opcodeddcb4e:	; bit (ix+d),1
Opcodeddcb4f:	; bit (ix+d),1*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 2
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb56:	; bit (hl),2
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 4
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb50:	; bit (ix+d),2*
Opcodeddcb51:	; bit (ix+d),2*
Opcodeddcb52:	; bit (ix+d),2*
Opcodeddcb53:	; bit (ix+d),2*
Opcodeddcb54:	; bit (ix+d),2*
Opcodeddcb55:	; bit (ix+d),2*
Opcodeddcb56:	; bit (ix+d),2
Opcodeddcb57:	; bit (ix+d),2*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 4
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb5e:	; bit (hl),3
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 8
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb58:	; bit (ix+d),3*
Opcodeddcb59:	; bit (ix+d),3*
Opcodeddcb5a:	; bit (ix+d),3*
Opcodeddcb5b:	; bit (ix+d),3*
Opcodeddcb5c:	; bit (ix+d),3*
Opcodeddcb5d:	; bit (ix+d),3*
Opcodeddcb5e:	; bit (ix+d),3
Opcodeddcb5f:	; bit (ix+d),3*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 8
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb66:	; bit (hl),4
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 010h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb60:	; bit (ix+d),4*
Opcodeddcb61:	; bit (ix+d),4*
Opcodeddcb62:	; bit (ix+d),4*
Opcodeddcb63:	; bit (ix+d),4*
Opcodeddcb64:	; bit (ix+d),4*
Opcodeddcb65:	; bit (ix+d),4*
Opcodeddcb66:	; bit (ix+d),4
Opcodeddcb67:	; bit (ix+d),4*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 010h
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb6e:	; bit (hl),5
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 020h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb68:	; bit (ix+d),5*
Opcodeddcb69:	; bit (ix+d),5*
Opcodeddcb6a:	; bit (ix+d),5*
Opcodeddcb6b:	; bit (ix+d),5*
Opcodeddcb6c:	; bit (ix+d),5*
Opcodeddcb6d:	; bit (ix+d),5*
Opcodeddcb6e:	; bit (ix+d),5
Opcodeddcb6f:	; bit (ix+d),5*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 020h
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb76:	; bit (hl),6
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 040h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb70:	; bit (ix+d),6*
Opcodeddcb71:	; bit (ix+d),6*
Opcodeddcb72:	; bit (ix+d),6*
Opcodeddcb73:	; bit (ix+d),6*
Opcodeddcb74:	; bit (ix+d),6*
Opcodeddcb75:	; bit (ix+d),6*
Opcodeddcb76:	; bit (ix+d),6
Opcodeddcb77:	; bit (ix+d),6*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 040h
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb7e:	; bit (hl),7
	mov		cx, _regHL
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 080h
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeddcb78:	; bit (ix+d),7*
Opcodeddcb79:	; bit (ix+d),7*
Opcodeddcb7a:	; bit (ix+d),7*
Opcodeddcb7b:	; bit (ix+d),7*
Opcodeddcb7c:	; bit (ix+d),7*
Opcodeddcb7d:	; bit (ix+d),7*
Opcodeddcb7e:	; bit (ix+d),7
Opcodeddcb7f:	; bit (ix+d),7*
	MREADMEM
	and		ah, 1
	mov		dl, ah
	test		dh, 080h
	lahf
	or		ah, dl
	add		di, 4
	sub		si, 20
	retn

Opcodecb87:	; res 0,a
	and		al, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb80:	; res 0,b
	and		_regB, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb81:	; res 0,c
	and		_regC, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb82:	; res 0,d
	and		_regD, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb83:	; res 0,e
	and		_regE, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb84:	; res 0,h
	and		_regH, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb85:	; res 0,l
	and		_regL, NOT 1
	add		di, 2
	sub		si, 8
	retn

Opcodecb8f:	; res 1,a
	and		al, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb88:	; res 1,b
	and		_regB, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb89:	; res 1,c
	and		_regC, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb8a:	; res 1,d
	and		_regD, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb8b:	; res 1,e
	and		_regE, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb8c:	; res 1,h
	and		_regH, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb8d:	; res 1,l
	and		_regL, NOT 2
	add		di, 2
	sub		si, 8
	retn

Opcodecb97:	; res 2,a
	and		al, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb90:	; res 2,b
	and		_regB, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb91:	; res 2,c
	and		_regC, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb92:	; res 2,d
	and		_regD, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb93:	; res 2,e
	and		_regE, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb94:	; res 2,h
	and		_regH, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb95:	; res 2,l
	and		_regL, NOT 4
	add		di, 2
	sub		si, 8
	retn

Opcodecb9f:	; res 3,a
	and		al, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb98:	; res 3,b
	and		_regB, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb99:	; res 3,c
	and		_regC, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb9a:	; res 3,d
	and		_regD, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb9b:	; res 3,e
	and		_regE, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb9c:	; res 3,h
	and		_regH, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecb9d:	; res 3,l
	and		_regL, NOT 8
	add		di, 2
	sub		si, 8
	retn

Opcodecba7:	; res 4,a
	and		al, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba0:	; res 4,b
	and		_regB, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba1:	; res 4,c
	and		_regC, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba2:	; res 4,d
	and		_regD, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba3:	; res 4,e
	and		_regE, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba4:	; res 4,h
	and		_regH, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecba5:	; res 4,l
	and		_regL, NOT 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbaf:	; res 5,a
	and		al, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecba8:	; res 5,b
	and		_regB, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecba9:	; res 5,c
	and		_regC, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbaa:	; res 5,d
	and		_regD, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbab:	; res 5,e
	and		_regE, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbac:	; res 5,h
	and		_regH, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbad:	; res 5,l
	and		_regL, NOT 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb7:	; res 6,a
	and		al, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb0:	; res 6,b
	and		_regB, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb1:	; res 6,c
	and		_regC, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb2:	; res 6,d
	and		_regD, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb3:	; res 6,e
	and		_regE, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb4:	; res 6,h
	and		_regH, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb5:	; res 6,l
	and		_regL, NOT 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbbf:	; res 7,a
	and		al, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb8:	; res 7,b
	and		_regB, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbb9:	; res 7,c
	and		_regC, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbba:	; res 7,d
	and		_regD, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbbb:	; res 7,e
	and		_regE, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbbc:	; res 7,h
	and		_regH, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbbd:	; res 7,l
	and		_regL, NOT 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecb86:	; res 0,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 1
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb80:	; b=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb81:	; c=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb82:	; d=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb83:	; e=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb84:	; h=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb85:	; l=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb86:	; res 0,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 1
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb87:	; a=res 0,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 1
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb8e:	; res 1,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 2
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb88:	; b=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb89:	; c=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8a:	; d=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8b:	; e=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8c:	; h=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8d:	; l=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8e:	; res 1,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 2
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb8f:	; a=res 1,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 2
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb96:	; res 2,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 4
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb90:	; b=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb91:	; c=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb92:	; d=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb93:	; e=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb94:	; h=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb95:	; l=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb96:	; res 2,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 4
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb97:	; a=res 2,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 4
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecb9e:	; res 3,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 8
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcb98:	; b=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb99:	; c=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9a:	; d=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9b:	; e=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9c:	; h=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9d:	; l=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9e:	; res 3,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 8
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcb9f:	; a=res 3,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 8
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecba6:	; res 4,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 010h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcba0:	; b=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba1:	; c=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba2:	; d=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba3:	; e=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba4:	; h=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba5:	; l=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba6:	; res 4,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 010h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba7:	; a=res 4,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 010h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbae:	; res 5,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 020h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcba8:	; b=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcba9:	; c=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbaa:	; d=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbab:	; e=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbac:	; h=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbad:	; l=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbae:	; res 5,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 020h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbaf:	; a=res 5,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 020h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbb6:	; res 6,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 040h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbb0:	; b=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb1:	; c=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb2:	; d=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb3:	; e=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb4:	; h=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb5:	; l=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb6:	; res 6,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 040h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb7:	; a=res 6,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 040h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbbe:	; res 7,(hl)
	mov		cx, _regHL
	MREADMEM
	and		dh, NOT 080h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbb8:	; b=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbb9:	; c=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbba:	; d=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbbb:	; e=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbbc:	; h=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbbd:	; l=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbbe:	; res 7,(ix+d)
	push		cx
	MREADMEM
	and		dh, NOT 080h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbbf:	; a=res 7,(ix+d)*
	push		cx
	MREADMEM
	and		dh, NOT 080h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbc7:	; set 0,a
	or		al, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc0:	; set 0,b
	or		_regB, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc1:	; set 0,c
	or		_regC, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc2:	; set 0,d
	or		_regD, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc3:	; set 0,e
	or		_regE, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc4:	; set 0,h
	or		_regH, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbc5:	; set 0,l
	or		_regL, 1
	add		di, 2
	sub		si, 8
	retn

Opcodecbcf:	; set 1,a
	or		al, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbc8:	; set 1,b
	or		_regB, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbc9:	; set 1,c
	or		_regC, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbca:	; set 1,d
	or		_regD, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbcb:	; set 1,e
	or		_regE, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbcc:	; set 1,h
	or		_regH, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbcd:	; set 1,l
	or		_regL, 2
	add		di, 2
	sub		si, 8
	retn

Opcodecbd7:	; set 2,a
	or		al, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd0:	; set 2,b
	or		_regB, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd1:	; set 2,c
	or		_regC, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd2:	; set 2,d
	or		_regD, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd3:	; set 2,e
	or		_regE, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd4:	; set 2,h
	or		_regH, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbd5:	; set 2,l
	or		_regL, 4
	add		di, 2
	sub		si, 8
	retn

Opcodecbdf:	; set 3,a
	or		al, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbd8:	; set 3,b
	or		_regB, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbd9:	; set 3,c
	or		_regC, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbda:	; set 3,d
	or		_regD, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbdb:	; set 3,e
	or		_regE, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbdc:	; set 3,h
	or		_regH, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbdd:	; set 3,l
	or		_regL, 8
	add		di, 2
	sub		si, 8
	retn

Opcodecbe7:	; set 4,a
	or		al, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe0:	; set 4,b
	or		_regB, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe1:	; set 4,c
	or		_regC, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe2:	; set 4,d
	or		_regD, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe3:	; set 4,e
	or		_regE, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe4:	; set 4,h
	or		_regH, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe5:	; set 4,l
	or		_regL, 010h
	add		di, 2
	sub		si, 8
	retn

Opcodecbef:	; set 5,a
	or		al, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe8:	; set 5,b
	or		_regB, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbe9:	; set 5,c
	or		_regC, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbea:	; set 5,d
	or		_regD, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbeb:	; set 5,e
	or		_regE, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbec:	; set 5,h
	or		_regH, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbed:	; set 5,l
	or		_regL, 020h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf7:	; set 6,a
	or		al, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf0:	; set 6,b
	or		_regB, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf1:	; set 6,c
	or		_regC, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf2:	; set 6,d
	or		_regD, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf3:	; set 6,e
	or		_regE, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf4:	; set 6,h
	or		_regH, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf5:	; set 6,l
	or		_regL, 040h
	add		di, 2
	sub		si, 8
	retn

Opcodecbff:	; set 7,a
	or		al, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf8:	; set 7,b
	or		_regB, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbf9:	; set 7,c
	or		_regC, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbfa:	; set 7,d
	or		_regD, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbfb:	; set 7,e
	or		_regE, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbfc:	; set 7,h
	or		_regH, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbfd:	; set 7,l
	or		_regL, 080h
	add		di, 2
	sub		si, 8
	retn

Opcodecbc6:	; set 0,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 1
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbc0:	; b=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc1:	; c=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc2:	; d=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc3:	; e=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc4:	; h=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc5:	; l=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc6:	; set 0,(ix+d)
	push		cx
	MREADMEM
	or		dh, 1
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc7:	; a=set 0,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 1
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbce:	; set 1,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 2
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbc8:	; b=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbc9:	; c=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbca:	; d=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbcb:	; e=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbcc:	; h=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbcd:	; l=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbce:	; set 1,(ix+d)
	push		cx
	MREADMEM
	or		dh, 2
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbcf:	; a=set 1,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 2
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbd6:	; set 2,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 4
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbd0:	; b=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd1:	; c=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd2:	; d=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd3:	; e=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd4:	; h=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd5:	; l=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd6:	; set 2,(ix+d)
	push		cx
	MREADMEM
	or		dh, 4
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd7:	; a=set 2,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 4
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbde:	; set 3,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 8
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbd8:	; b=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbd9:	; c=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbda:	; d=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbdb:	; e=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbdc:	; h=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbdd:	; l=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbde:	; set 3,(ix+d)
	push		cx
	MREADMEM
	or		dh, 8
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbdf:	; a=set 3,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 8
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbe6:	; set 4,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 010h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbe0:	; b=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe1:	; c=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe2:	; d=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe3:	; e=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe4:	; h=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe5:	; l=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe6:	; set 4,(ix+d)
	push		cx
	MREADMEM
	or		dh, 010h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe7:	; a=set 4,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 010h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbee:	; set 5,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 020h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbe8:	; b=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbe9:	; c=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbea:	; d=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbeb:	; e=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbec:	; h=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbed:	; l=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbee:	; set 5,(ix+d)
	push		cx
	MREADMEM
	or		dh, 020h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbef:	; a=set 5,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 020h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbf6:	; set 6,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 040h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbf0:	; b=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf1:	; c=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf2:	; d=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf3:	; e=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf4:	; h=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf5:	; l=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf6:	; set 6,(ix+d)
	push		cx
	MREADMEM
	or		dh, 040h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf7:	; a=set 6,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 040h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodecbfe:	; set 7,(hl)
	mov		cx, _regHL
	MREADMEM
	or		dh, 080h
	mov		cx, _regHL
	call		_WriteMem
	add		di, 2
	sub		si, 15
	retn

Opcodeddcbf8:	; b=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regB, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbf9:	; c=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regC, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbfa:	; d=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regD, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbfb:	; e=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regE, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbfc:	; h=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regH, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbfd:	; l=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		_regL, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbfe:	; set 7,(ix+d)
	push		cx
	MREADMEM
	or		dh, 080h
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

Opcodeddcbff:	; a=set 7,(ix+d)*
	push		cx
	MREADMEM
	or		dh, 080h
	mov		al, dh
	pop		cx
	call		_WriteMem
	add		di, 4
	sub		si, 23
	retn

; input and output groups

Opcodedb:	; in a,(n)
	mov		dl, dh
	call		ReadIO
	mov		al, dh
	add		di, 2
	sub		si, 11
	retn

Opcodeed78:	; in a,(c)
	mov		dl, _regC
	call		ReadIO
	mov		al, dh
	mov		dl, ah
	and		dl, 1
	or		al, al
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeed40:	; in b,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regB, dh
	add		di, 2
	sub		si, 12
	retn
	
Opcodeed48:	; in c,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regC, dh
	add		di, 2
	sub		si, 12
	retn

Opcodeed50:	; in d,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regD, dh
	add		di, 2
	sub		si, 12
	retn

Opcodeed58:	; in e,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regE, dh
	add		di, 2
	sub		si, 12
	retn

Opcodeed60:	; in h,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regH, dh
	add		di, 2
	sub		si, 12
	retn

Opcodeed68:	; in l,(c)
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	mov		_regL, dh
	add		di, 2
	sub		si, 12
	retn

Opcodeed70:	; in (c)* / in f,(c)*
	mov		dl, _regC
	call		ReadIO
	mov		dl, ah
	and		dl, 1
	or		dh, dh
	lahf
	or		ah, dl
	add		di, 2
	sub		si, 12
	retn

Opcodeeda2:	; ini
	mov		dl, _regC
	call		ReadIO
	mov		cx, _regHL
	call		_WriteMem
	inc		_regHL
	and		ah, 1
	dec		_regB
	jnz		$+5
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedb2:	; inir
	and		ah, 1
RepInir:
	mov		dl, _regC
	call		ReadIO
	mov		cx, _regHL
	call		_WriteMem
	inc		_regHL
	dec		_regB
	jz		SHORT NotRepInir
	sub		si, 21
	jnc		SHORT RepInir
	retn
NotRepInir:
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedaa:	; ind
	mov		dl, _regC
	call		ReadIO
	mov		cx, _regHL
	call		_WriteMem
	dec		_regHL
	and		ah, 1
	dec		_regB
	jnz		$+5
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedba:	; indr
	and		ah, 1
RepIndr:
	mov		dl, _regC
	call		ReadIO
	mov		cx, _regHL
	call		_WriteMem
	dec		_regHL
	dec		_regB
	jz		SHORT NotRepIndr
	sub		si, 21
	; time's up !
	jnc		SHORT RepIndr
	retn
NotRepIndr:
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn
	
Opcoded3:	; out (n),a
	mov		dl, dh
	mov		dh, al
	call		WriteIO
	add		di, 2
	sub		si, 11
	retn

Opcodeed79:	; out (c),a
	mov		dh, al
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed41:	; out (c),b
	mov		dx, _regBC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed49:	; out (c),c
	mov		dh, _regC
	mov		dl, dh
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed51:	; out (c),d
	mov		dh, _regD
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed59:	; out (c),e
	mov		dh, _regE
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed61:	; out (c),h
	mov		dh, _regH
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed69:	; out (c),l
	mov		dh, _regL
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeed71:	; out (c),0*
	mov		dh, 0
	mov		dl, _regC
	call		WriteIO
	add		di, 2
	sub		si, 12
	retn

Opcodeeda3:	; outi
	mov		cx, _regHL
	MREADMEM
	mov		dl, _regC
	call		WriteIO
	inc		_regHL
	and		ah, 1
	dec		_regB
	jnz		$+5
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedb3:	; otir
	and		ah, 1
RepOtir:
	mov		cx, _regHL
	MREADMEM
	mov		dl, _regC
	call		WriteIO
	inc		_regHL
	dec		_regB
	jz		SHORT NotRepOtir
	sub		si, 21
	jnc		SHORT RepOtir
	; time's up !
	retn
NotRepOtir:
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedab:	; outd
	mov		cx, _regHL
	MREADMEM
	mov		dl, _regC
	call		WriteIO
	dec		_regHL
	and		ah, 1
	dec		_regB
	jnz		$+5
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

Opcodeedbb:	; otdr
	and		ah, 1
RepOtdr:
	mov		cx, _regHL
	MREADMEM
	mov		dl, _regC
	call		WriteIO
	dec		_regHL
	dec		_regB
	jz		SHORT NotRepOtdr
	sub		si, 21
	jnc		SHORT RepOtdr
	; time's up !
	retn
NotRepOtdr:
	or		ah, 040h
	add		di, 2
	sub		si, 16
	retn

; jump group

Opcodec3:	; jp nn
	shr		edx, 8
	mov		di, dx
	sub		si, 10
	retn
	
Opcodeda:	; jp c,nn
	sahf
	jc		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcoded2:	; jp nc,nn
	sahf
	jnc		Opcodec3
	add		di, 3
	sub		si, 10
	retn
	
Opcodeca:	; jp z,nn
	sahf
	jz		Opcodec3
	add		di, 3
	sub		si, 10
	retn
	
Opcodec2:	; jp nz,nn
	sahf
	jnz		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcodeea:	; jp pe,nn
	sahf
	jpe		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcodee2:	; jp po,nn
	sahf
	jpo		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcodefa:	; jp m,nn
	sahf
	js		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcodef2:	; jp p,nn
	sahf
	jns		Opcodec3
	add		di, 3
	sub		si, 10
	retn

Opcode76:	; halt
	inc		di
	; check if interrupts enabled
	cmp		fIFF, 0
	jne		SHORT EndProcess
	mov		RetVal, 1		; return code 1: infinite loop
EndProcess:
	stc
	retn

Opcode18:	; jr n
	cmp		dh, 0feh
	je		EndProcess
	add		di, 2
	movsx	bx, dh
	add		di, bx
	sub		si, 12
	retn

Opcode38:	; jr c,n
	sahf
	jc		Opcode18
	add		di, 2
	sub		si, 7
	retn

Opcode30:	; jr nc,n
	sahf
	jnc		Opcode18
	add		di, 2
	sub		si, 7
	retn

Opcode28:	; jr z,n
	sahf
	jz		Opcode18
	add		di, 2
	sub		si, 7
	retn

Opcode20:	; jr nz,n
	sahf
	jnz		Opcode18
	add		di, 2
	sub		si, 7
	retn

Opcodee9:	; jp hl
	mov		di, _regHL
	sub		si, 4
	retn

Opcodedde9:	; jp ix
	mov		di, _regIX
	sub		si, 8
	retn

Opcodefde9:	; jp iy
	mov		di, _regIY
	sub		si, 8
	retn

Opcode10:	; djnz n
	add		di, 2
	dec		_regB
	je		SHORT NoJr
	movsx	bx, dh
	add		di, bx
	sub		si, 13
	retn
NoJr:
	sub		si, 8
	retn

; call group

Opcodecd:	; call nn
	add		di, 3
	shr		edx, 8
	xchg		dx, di
	call		PushVal
	sub		si, 17
	retn

Opcodec4:	; call nz,nn
	sahf
	jnz		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodecc:	; call z,nn
	sahf
	jz		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcoded4:	; call nc,nn
	sahf
	jnc		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodedc:	; call c,nn
	sahf
	jc		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodee4:	; call po,nn
	sahf
	jpo		Opcodecd
	add		di, 3
	sub		si, 10
	retn
	
Opcodeec:	; call pe,nn
	sahf
	jpe		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodef4:	; call p,nn
	sahf
	jns		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodefc:	; call m,nn
	sahf
	js		Opcodecd
	add		di, 3
	sub		si, 10
	retn

Opcodeed4d:	; reti
Opcodeed45:	; retn
Opcodeed55:	; reti/n*
Opcodeed5d:	; reti/n*
Opcodeed65:	; reti/n*
Opcodeed6d:	; reti/n*
Opcodeed75:	; reti/n*
Opcodeed7d:	; reti/n*
	; these commands are handled the same as ret
	; as there is only one interrupt device: the vdp (no daisy chains)
	; also, there are no non mask-able interrupts
Opcodec9:	; ret
	call		PopVal
	mov		di, dx
	sub		si, 10
	retn

Opcodec0:	; ret nz
	sahf
	jnz		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodec8:	; ret z
	sahf
	jz		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcoded0:	; ret nc
	sahf
	jnc		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcoded8:	; ret c
	sahf
	jc		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodee0:	; ret po
	sahf
	jpo		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodee8:	; ret pe
	sahf
	jpe		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodef0:	; ret p
	sahf
	jns		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodef8:	; ret m
	sahf
	js		Opcodec9
	inc		di
	sub		si, 5
	retn

Opcodec7:	; rst 0
	lea		dx, [di+1]
	call		PushVal
	sub		di, di
	sub		si, 11
	retn

Opcodecf:	; rst 8
	lea		dx, [di+1]
	call		PushVal
	mov		di, 8
	sub		si, 11
	retn

Opcoded7:	; rst 10
	lea		dx, [di+1]
	call		PushVal
	mov		di, 010h
	sub		si, 11
	retn

Opcodedf:	; rst 18
	lea		dx, [di+1]
	call		PushVal
	mov		di, 018h
	sub		si, 11
	retn

Opcodee7:	; rst 20
	lea		dx, [di+1]
	call		PushVal
	mov		di, 020h
	sub		si, 11
	retn

Opcodeef:	; rst 28
	lea		dx, [di+1]
	call		PushVal
	mov		di, 028h
	sub		si, 11
	retn

Opcodef7:	; rst 30
	lea		dx, [di+1]
	call		PushVal
	mov		di, 030h
	sub		si, 11
	retn

Opcodeff:	; rst 38
	lea		dx, [di+1]
	call		PushVal
	mov		di, 038h
	sub		si, 11
	retn

; general purpose arithmetic

Opcode27:	; daa
	test		ah, 2
	jnz		SHORT Decrement
	sahf
	daa
	lahf
	mov		dl, al
	and		dl, 028h
	or		ah, dl
	inc		di
	sub		si, 4
	retn
Decrement:
	sahf
	das
	lahf
	mov		dl, al
	and		dl, 028h
	or		ah, dl
	inc		di
	sub		si, 4
	retn

Opcode2f:	; cpl
	not		al
	inc		di
	sub		si, 4
	retn

Opcodeed44:	; neg
Opcodeed4c:	; neg*
Opcodeed54:	; neg*
Opcodeed5c:	; neg*
Opcodeed64:	; neg*
Opcodeed6c:	; neg*
Opcodeed74:	; neg*
Opcodeed7c:	; neg*
	neg		al
	lahf
	jo		SHORT OFneg
	and		ah, 0fbh
	add		di, 2
	sub		si, 7
	retn
OFneg:
	or		ah, 6
	add		di, 2
	sub		si, 7
	retn

Opcode3f:	; ccf
	btc		ax, 8
	inc		di
	sub		si, 4
	retn

Opcode37:	; scf
	or		ah, 1
	inc		di
	sub		si, 4
	retn

; miscellaneous CPU control

Opcodef3:	; di
	mov		fIFF, 0
	inc		di
	sub		si, 4
	retn
	
; there is only one device that generates an interrupt: the vdp
; it always provides value ffh (opcode of rst 38h)
; and thus, there are no daisy chains

EndOfTimeSlice:
	mov		fINT, 1
	retn
Opcodefb:	; ei
	mov		fIFF, 100b	; for LD A,R and LD A,I
Skip:
	inc		di
	sub		si, 4
	jc		short EndOfTimeSlice
	; no interrupts after ei, so execute one command
	mov		bx, di
	rol		bx, 5
	and		bx, 11100b
	les		bx, ReadMemTbl[bx]
	mov		cx, di
	and		ch, 01fh
	or		bx, cx
	mov		edx, es:[bx]
	cmp		dl, 0fbh
	je		short Skip	; cannot be nested
	movzx	ebx, dl
	call		WORD PTR cs:JumpTbl[ebx*2]
Interrupt:
	test		VDPReg + 8, 080h
	je		SHORT NoInt
	cmp		fIFF, 0
	je		SHORT NoInt
	; generate interrupt
	mov		fIFF, 0	; disable interrupts
	cmp		fIM2, 0
	jne		SHORT DoInt2
	mov		dx, di	; im 0 works the same as im 1
	call		PushVal
	mov		di, 038h
NoInt:
	clc
	retn
DoInt2:
	mov		ch, _regI
	mov		cl, 0ffh
	MREADMEMW
	xchg		di, dx
	call		PushVal
	clc
	retn

Opcodeed46:	; im 0
Opcodeed66:	; im 0*
Opcodeed4e:	; im 0/1*
Opcodeed6e:	; im 0/1*
Opcodeed56:	; im 1
Opcodeed76:	; im 1*
	mov		fIM2, 0
	add		di, 2
	sub		si, 8
	retn

Opcodeed5e:	; im 2
Opcodeed7e:	; im 2*
	mov		fIM2, 1
	add		di, 2
	sub		si, 8
	retn

_cpu			ENDP

			END
