/*
  pcm2cas.c 1.1: PCM to P2000 tape image converter
  Copyright (C) Marcel de Kogel 1996
  You may not distribute this software commercially
  Please, notify me if you make any changes to this file
*/

#include <stdio.h>
#include <stdlib.h>

#define BAUDRATE        2400
#define SAMPLERATE      44100

int border=64;          /* lowest signal considered negative */

FILE *infile;
FILE *outfile;

static int totalcount=0;

void putbyte (int a)
{
 static unsigned char buffer[1024];
 static int bufcount=0;
 if (a>=0)
 {
  ++totalcount;
  buffer[bufcount]=a;
  if (++bufcount==1024)
  {
   fwrite (buffer,1,bufcount,outfile);
   bufcount=0;
  }
 }
 else
  if (bufcount)
  {
   fwrite (buffer,1,bufcount,outfile);
   bufcount=0;
  }
}

int getbit (void)
{
 static int bufcount=0;
 static unsigned char buffer[1024];
 int a;
 if (!bufcount)
 {
  bufcount=fread (buffer,1,1024,infile);
  if (!bufcount) return -1;
 }
 a=buffer[1024-bufcount];
 --bufcount;
 return (a<border)? 1:0;
}

void putbit (int t)
{
 static int busy=0;
 static int bits=0;
 static int a=0;
 static int count=0;
 if (!busy && !t)
 {
  if (++count==10)
  {
   static int old=0;
   int i,j;
   static int bufcount=0;
   i=totalcount-old;
   printf ("%u",totalcount);
   j=i%(1024+256);
   if (j==1024 || j==256 || j==0) printf ("\n");
   else printf (" Error in block %u - %u bytes\n",bufcount/2,i);
   old=totalcount;
   ++bufcount;
  }
  return;
 }
 count=0;
 if (!busy)
 {
  busy=1;
  return;
 }
 t=(t)? 0:1;
 a|=(t<<bits);
 if (++bits==8)
 {
  putbyte (a);
  busy=0;
  bits=0;
  a=0;
 }
}

void putint (int count,int t)
{
 int i;
 i=(count*BAUDRATE+(SAMPLERATE/2))/SAMPLERATE;
 if (i>10 || i<0) i=10;
 for (;i;i--)
  putbit (t);
}

int main (int argc,char *argv[])
{
 int a;
 int count;
 printf ("pcm2cas 1.1: PCM to P2000 tape image converter\n"
         "Copyright (C) Marcel de Kogel 1996\n");
 if (argc<3)
 {
  printf ("Usage: pcm2cas <pcm file> <tape image> [border]\n");
  return 1;
 }
 infile=fopen (argv[1],"rb");
 if (!infile)
 {
  printf ("Can't open %s\n",argv[1]);
  return 1;
 }
 outfile=fopen (argv[2],"wb");
 if (!infile)
 {
  printf ("Can't open %s\n",argv[2]);
  return 1;
 }
 if (argc>3) border=atoi(argv[1]);
 count=0;
 while (1)
 {
  while ((a=getbit())==0)
   ++count;
  putint (count,0);
  if (a<0)
   break;
  count=1;
  while ((a=getbit())==1)
   ++count;
  putint (count,1);
  if (a<0)
   break;
  count=1;
 }
 putbyte (-1);
 fclose (infile);
 fclose (outfile);
}

