/***************************************************************************/
/*            DDITODSK.  A MSX disk image converter: DDI to DSK            */
/*          By Josep F. Hervas'96  (hervas@alufis34.ffisic.uv.es)          */
/*-------------------------------------------------------------------------*/
/*   As you can see, this program is very simple. Enjoy it and copy it to  */
/* all MSX-maniacs.                                                        */
/*   The only thing this program does is to copy the DDI file without its  */
/* header into a DSK file in order to being used with MARAT FAYZULLIN'S    */
/* great MSX emulator (FMSX).                                              */
/***************************************************************************/


#include <stdio.h>
#include <string.h>

void main (int argn, char *argv[])
{
	FILE *f, *g;
	int i;
	char byte;

	printf("\nDDITODSK by Josep F. Hervas'96.\n");

	if (argn==1 || strcmp(argv[1],"/?")==0 || strcmp(argv[1],"/h")==0)
		printf("\nSyntax: DDITODSK disk1.ddi disk2.dsk.\n");
	else
	{
		f=fopen(argv[1],"rb");
		g=fopen(argv[2],"wb");
		if ((f!=NULL) && (g!=NULL))
		{
			printf("\nConverting... ");
			fseek(f, 0x1200, SEEK_CUR);
			while (!feof(f))
			{
				i=fread(&byte, 1, 1, f);
				if (i==1) fwrite(&byte, 1, 1, g);
			}
			printf("DONE.\n");
		}
		else
		{
			if (f==NULL) printf("\n\aError!: Unable to find source file.\n");
			else printf("\n\aError!: Can't create destination file.\n");
		}
		fcloseall();
		printf("\n\nIf you have any question about this program or if you want to cheer me ;)");
		printf("\njust send an email to hervas@alufis34.ffisic.uv.es\n");
	}
}