{$I-,G+}
unit DAGood;

interface uses DAtable, Crt;

const
  Box1      = 'Ŀٳ';
  Box2      = 'ͻͼ';
  Box3      = 'ͻĽ';

  ParamS    : string[14]=('/*#$&%~^@!|"`');  { - must be last}
  HexChar   : string[16]=('0123456789ABCDEF');
  IndexName : array[1..2] of string[2]=('IX','IY');
  IndexVar  : array[1..2] of string[8]=('(IX|)','(IY|)');
  IndexName8: array[1..2] of string[2]=('di','si');
  IndexVar8 : array[1..2] of string[8]=('[di|]','[si|]');
  SegName   : array[0..1] of string[2]=('ds','cs');
  DAAval    : array[0..1] of string[3]=('daa','das');
  Z80SName  : array[0..1] of string[1]=('','>');
  WrkHeader : string[16]='DA_WorkFile V1.0';
  Format    : array[False..True] of string[4]=('8088 ','Z80 ');
  TabSize   : byte=10;
  InterSize : byte=4;
  RealDataLoc: boolean = False;

  MaxLabels = 1000;
  MaxBlocks = 8;

  BCode     = 1;
  BData     = 2;

  LCode     = 1;
  LData     = 2;
  LTable    = 3;

  BIOSenabled    : boolean = True;
  BIOShigh       : word    = $159;

  MaxFol         = 10;

type
 LabelType   = string[8];
  ByteArray  = array[0..65535-1] of byte;
 PByteArray  = ^ByteArray;
  LabelArray = array[1..MaxLabels] of LabelType;
 PLabelArray = ^LabelArray;

 tScreen     = array[0..79, 0..24, 0..1] of byte;

var
 f                          : file;
 t, dtf                     : text;
 FileName                   : string;
 FileLength                 : longint;

 PrgMem, ShadowH, ShadowL   : PByteArray;
 Labels                     : PLabelArray;

 PrgType, PrgStart,
 PrgBegin, PrgLength,
 PrgData                    : word;
 PLow, PHigh                : word;

 LabelNum, TinyLabels       : word;
 MemPos, DumpPos, RealPos,
 OriginPos, CallerPos       : word;
 LineNo                     : integer;

 GreedCall                  : array[1..10] of word;
 DumpChar                   : boolean;

 ProcQ                      : array[1..1000] of word;
 Proc                       : array[1..5000] of word;
 ProcNum, TotalProcs        : integer;

 Follow                     : array[1..MaxFol] of word;
 FolNum                     : byte;

 FindString, FControl       : string;
 FindPos                    : word;

 KeyReg                     : array[1..10] of word;
 Z80                        : boolean;
 CharDec                    : byte;

 PageByte                   : word;
 Adds                       : array[1..14] of word;

 ILength                    : byte;
 IndexNo, SegmentNo         : byte;
 IndexOfs                   : shortint;
 LabelNo                    : integer;

 OldScr                     : tScreen;
 ScrBuf                     : tScreen absolute $B800:0;
 ScrSeg, ScrOfs             : word;

 CurHeader                  : string[16];
 ErrorLine                  : byte;
 OldDump, sadr              : word;
 DAttr                      : boolean;

 IPtr                       : word;

 ldw                        : boolean;

procedure StartUp;

procedure Box(x, y :byte; w, h : shortint; attr:byte; s:string);

implementation

Procedure ShowKeyboardHelp; forward;

function Hex2(b:byte):string;
begin
 Hex2:=HexChar[b shr 4+1]+HexChar[b and $F+1]
end;

function Hex4(w:word):string;
begin
 Hex4:=HexChar[w shr 12+1]+HexChar[(w shr 8) and $F+1]+
       HexChar[(w shr 4) and $F+1]+HexChar[w and $F+1];
end;

function DataByte(b:byte):string;
begin
 DataByte:='0'+HexChar[b shr 4+1]+HexChar[b and $F+1]+'h';
end;

function Index(b:shortint):string;
var sgn:char; bb:byte;
begin
 if b<0 then begin bb:=-b; sgn:='-' end else begin bb:=b;sgn:='+';end;
 Index:=Sgn+'0'+HexChar[bb shr 4+1]+HexChar[bb and $F+1]+'h';
end;

function DataWord(w:word):string;
begin
 DataWord:='0'+HexChar[w shr 12+1]+HexChar[(w shr 8) and $F+1]+
               HexChar[(w shr 4) and $F+1]+HexChar[w and $F+1]+'h';
end;

function SStr(w:word;d:byte):string;
var s:string;
begin
 Str(w:d,s);
 SStr:=s;
end;

function Strg(ch : char; Num : byte) : string;
var a : String;
begin
 a[0] := char(num);
 fillchar(a[1],num,ch);
 Strg := a;
end;

function GetByte(addr:word):string;
var b:byte;
begin
 b:=PrgMem^[addr];
 GetByte:='0'+HexChar[b shr 4+1]+HexChar[b and $F+1]+'h';
end;

function GetWord(addr:word):string;
var w:word;
begin
 w:=PrgMem^[addr+1] shl 8+PrgMem^[addr];
 GetWord:='0'+HexChar[w shr 12+1]+HexChar[(w shr 8) and $F+1]+
              HexChar[(w shr 4) and $F+1]+HexChar[w and $F+1]+'h';
end;

function GetHex4(addr:word):string;
var w:word;
begin
 w:=PrgMem^[addr+1] shl 8+PrgMem^[addr];
 GetHex4:=HexChar[w shr 12+1]+HexChar[(w shr 8) and $F+1]+
        HexChar[(w shr 4) and $F+1]+HexChar[w and $F+1];
end;

procedure Box;
var i, j:byte;
begin
 dec(w);dec(h);
 for i:=1 to w-1 do
   begin
    mem[ScrSeg:ScrOfs+y*2*80+(x+i)*2]:=byte(s[2]);
    mem[ScrSeg:ScrOfs+y*2*80+(x+i)*2+1]:=attr;
    mem[ScrSeg:ScrOfs+(y+h)*2*80+(x+i)*2]:=byte(s[5]);
    mem[ScrSeg:ScrOfs+(y+h)*2*80+(x+i)*2+1]:=attr;
   end;
 for i:=1 to h-1 do
   begin
    mem[ScrSeg:ScrOfs+(y+i)*2*80+x*2]:=byte(s[7]);
    mem[ScrSeg:ScrOfs+(y+i)*2*80+x*2+1]:=attr;
    mem[ScrSeg:ScrOfs+(y+i)*2*80+(x+w)*2]:=byte(s[8]);
    mem[ScrSeg:ScrOfs+(y+i)*2*80+(x+w)*2+1]:=attr;
   end;
 mem[ScrSeg:ScrOfs+y*2*80+x*2]:=byte(s[1]);
 mem[ScrSeg:ScrOfs+y*2*80+x*2+1]:=attr;
 mem[ScrSeg:ScrOfs+y*2*80+(x+w)*2]:=byte(s[3]);
 mem[ScrSeg:ScrOfs+y*2*80+(x+w)*2+1]:=attr;
 mem[ScrSeg:ScrOfs+(y+h)*2*80+x*2]:=byte(s[4]);
 mem[ScrSeg:ScrOfs+(y+h)*2*80+x*2+1]:=attr;
 mem[ScrSeg:ScrOfs+(y+h)*2*80+(x+w)*2]:=byte(s[6]);
 mem[ScrSeg:ScrOfs+(y+h)*2*80+(x+w)*2+1]:=attr;
end;

procedure ClearLine(l,attr:byte);
var i:byte;
begin
 for i:=0 to 79 do
  mem[ScrSeg:ScrOfs+i*2+l*80*2+1]:=attr;
end;

procedure WriteTo(s:string;x,y,attr:byte);
var i:integer;
begin
 for i:=0 to Length(s)-1 do
   begin
    mem[ScrSeg:ScrOfs+i*2+x*2+y*80*2]  :=byte(s[i+1]);
    mem[ScrSeg:ScrOfs+i*2+x*2+y*80*2+1]:=attr;
   end;
end;

function Space(l:byte):string;
var i:byte; s:string;
begin
 s:='';for i:=1 to l do s:=s+' ';Space:=s
end;

function Strng(l:byte;ch:char):string;
var i:byte; s:string;
begin
 s:='';for i:=1 to l do s:=s+ch;Strng:=s
end;

procedure Suck(var s:string);
var i:integer;
begin
 i:=1; while i<=Length(s) do if s[i]=' ' then Delete(s, i, 1) else Inc(i);
end;

procedure Replace(var Dest:string;Source:string;p:byte);
begin
 Delete(Dest,p,1); Insert(Source, Dest, p);
end;

function LabelExist(addr:word):boolean;
var w:word;
begin
 LabelExist:=True;
{ if ShadowH^[addr] and $10>0 then begin LabelNo:=0; Exit end;}
 w:=(ShadowH^[addr] and $7) shl 8+ShadowL^[addr];
 if w>0 then begin LabelNo:=w end else LabelExist:=False;
end;

function DisAsmZ80(addr:word):string;
var dt,lb:byte; LNo, ad, nml:word; r:boolean;
function Instruction:string;
var s:string;c,p:byte;i:integer;
begin
 IndexNo:=0; IndexOfs:=0;
 s:=Instr[PrgMem^[iptr]];
 SegmentNo:=(ShadowH^[iptr] shr 5) and 1;
 repeat
  for c:=1 to Length(ParamS) do
   begin
    p:=Pos(Params[c], s);
    if p>0 then break;
   end;
  if c=Length(ParamS) then c:=0;
  if c>0 then
  case ParamS[c] of
   '/' : Replace(s,Space(InterSize-p+3), p);
   '*' : begin
          Inc(ILength,2);
          case ShadowH^[iptr+1] shr 6 of
           00, 01, 02 : Replace(s, GetWord(iptr+1), p);
           03 : begin
                 ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
                 r:=False;
                 if (ad>=PLow) and (ad<=PHigh) then
                    if LabelExist(ad)
                       then begin Replace(s, 'offset '+Labels^[LabelNo], p); r:=true; end;
                 if not r then Replace(s, 'offset L'+Hex4(ad), p);
                end;
          end;
         end;
   '#' : begin
          Inc(ILength, 1);
          if IndexNo>0 then Inc(iptr);
          Replace(s, GetByte(iptr+1), p);
         end;
   '&' : begin
          ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
             if LabelExist(ad)
                then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r then Replace(s, 'L'+Hex4(ad), p);
          Inc(ILength, 2);
         end;
   '$' : begin
          ad:=iptr+shortint(PrgMem^[iptr+1])+2;
          Inc(ILength, 1);
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
               if LabelExist(ad)
                  then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r then Replace(s, 'L'+Hex4(ad), p);
         end;
   '%' : begin
          ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
          Inc(ILength, 2);
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
               if LabelExist(ad)
                  then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r and (ad>=PrgData) then begin Replace(s, DataWord(ad), p);r:=true end;
          if not r then Replace(s, Hex4(ad), p);
         end;
   '~' : if IndexNo>0 then
          begin
           Replace(s,IndexVar[IndexNo],p);
           Inc(ILength);
          end else Replace(s, '(HL)', p);
   '"' : Replace(s, Z80SName[SegmentNo],p);
   '|' : begin
          Replace(s,Index(IndexOfs),p);
         end;
   '^' : if IndexNo>0 then
          begin
           Replace(s, IndexName[IndexNo], p);
          end else Replace(s, 'HL', p);
   '!' : Replace(s, 'Bad opcode', p);
   '@' : begin
          Inc(ILength);Inc(iptr);
          case s[p+1] of
     {CB}  '0' : if IndexNo>0 then
                   begin
                    {Inc(iptr);
                    Inc(ILength);}
                    s:=InstrCB[PrgMem^[iptr+1]]
                   end else s:=InstrCB[PrgMem^[iptr]];
     {ED}  '1' : s:=InstrED[PrgMem^[iptr]];
     {DD}  '2' : begin {IX}
                  IndexNo:=1;
                  s:=Instr[PrgMem^[iptr]];
                  IndexOfs:=shortint(PrgMem^[iptr+1]);
                 end;
     {FD}  '3' : begin {IX}
                  IndexNo:=2;
                  s:=Instr[PrgMem^[iptr]];
                  IndexOfs:=shortint(PrgMem^[iptr+1]);
                 end;
          end;
         end;
  end;
 until p=0;
 Instruction:=s;
end;
function ByteBlock:string;
var s:string;Done:boolean;i:byte;w,l:word;
begin
 Done:=False;w:=iptr;s:='';i:=0;
 repeat
  s:=s+DataByte(PrgMem^[w]); Inc(w); Inc(i);
  l:=ShadowH^[w] shl 8+ShadowL^[w];
  if (ShadowH^[w]<>$40) or (l and $3FFF>$0) or (i>3) then Done:=True else if i<4 then s:=s+',';
  if not Done then Inc(ILength);
 until Done;
 ByteBlock:='db'+Space(InterSize)+s;
end;

function WordBlock:string;
var s:string;
begin
 Inc(ILength);
 WordBlock:='dw'+Space(InterSize)+DataWord(PrgMem^[iptr]+PrgMem^[iptr+1] shl 8);
end;

function Address:string;
var s:string;sd:word;
begin
 Inc(ILength);
 ad:=PrgMem^[iptr]+PrgMem^[iptr+1] shl 8;
 if (ad>=PLow) and (ad<=PHigh) then
    if LabelExist(ad)
       then begin Address:='dw'+Space(InterSize)+'offset '+Labels^[LabelNo]; Exit end;
 Address:='dw'+Space(InterSize)+'offset L'+Hex4(ad);
end;
var s:string;i:integer;
begin
 iptr:=addr;
 ILength:=1;
 LNo:=(ShadowH^[iptr] and $7) shl 8+ShadowL^[iptr];
 dt:=ShadowH^[iptr] shr 6;{only 2 high bits}
 lb:=(ShadowH^[iptr] shr 4) and $3;
 case dt of
  00 : s:=Instruction;
  01 : s:=ByteBlock;
  02 : s:=WordBlock;
  03 : s:=Address;
 end;
 if LNo>0 then s:=Labels^[LNo]+':'+Space(TabSize-Length(Labels^[LNo])-1)+s
          else if ShadowH^[addr] and $10>0
                  then s:='L'+Hex4(addr)+':'+Space(TabSize-6)+s
                  else s:=Space(TabSize)+s;
 while Length(s)<43 do s:=s+' ';
 DisAsmZ80:=s;
end;

function DisAsm8088(addr:word):string;
var dt,lb:byte; LNo, ad, nml:word; r:boolean;
function Instruction:string;
var s:string;c,p:byte;i:integer;
begin
 IndexNo:=0; IndexOfs:=0;
 s:=Instr8088[PrgMem^[iptr]];
 SegmentNo:=(ShadowH^[iptr] shr 5) and 1;
 repeat
  for c:=1 to Length(ParamS) do
   begin
    p:=Pos(Params[c], s);
    if p>0 then break;
   end;
  if c=Length(ParamS) then c:=0;
  if c>0 then
  case ParamS[c] of
   '/' : Replace(s,Space(InterSize-p+3), p);
   '*' : begin
          Inc(ILength,2);
          case ShadowH^[iptr+1] shr 6 of
           00, 01, 02 : Replace(s, GetWord(iptr+1), p);
           03 : begin
                 ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
                 r:=False;
                 if (ad>=PLow) and (ad<=PHigh) then
                    if LabelExist(ad)
                       then begin Replace(s, 'offset '+Labels^[LabelNo], p); r:=true; end;
                 if not r then Replace(s, 'offset L'+Hex4(ad), p);
                end;
          end;
         end;
   '#' : begin
          Inc(ILength, 1);
          if IndexNo>0 then Inc(iptr);
          Replace(s, GetByte(iptr+1), p);
         end;
   '&' : begin
          ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
             if LabelExist(ad)
                then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r then Replace(s, 'L'+Hex4(ad), p);
          Inc(ILength, 2);
         end;
   '$' : begin
          ad:=iptr+shortint(PrgMem^[iptr+1])+2;
          Inc(ILength, 1);
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
               if LabelExist(ad)
                  then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r then Replace(s, 'L'+Hex4(ad), p);
         end;
   '%' : begin
          ad:=PrgMem^[iptr+1]+PrgMem^[iptr+2] shl 8;
          Inc(ILength, 2);
          r:=False;
          if (ad>=PLow) and (ad<=PHigh) then
               if LabelExist(ad)
                  then begin Replace(s, Labels^[LabelNo], p); r:=true; end;
          if not r and ((ad>PrgBegin+PrgLength) or (ad<PrgBegin)) then begin Replace(s, DataWord(ad), p);r:=true end;
          if not r then
             if (PrgMem^[iptr] in [$3A,$32])
               then begin Insert('byte ptr ',s,p-3); Replace(s, 'L'+Hex4(ad), p+9); end
               else begin Insert('word ptr ',s,p-3); Replace(s, 'L'+Hex4(ad), p+9); end;
         end;
   '~' : if IndexNo>0 then
          begin
           Replace(s,IndexVar8[IndexNo],p);
           Inc(ILength);
          end else Replace(s, '[bx]', p);
   '"' : Replace(s, SegName[SegmentNo],p);
   '`' : Replace(s, DAAval[SegmentNo],p);
   '|' : begin
          Replace(s,Index(IndexOfs),p);
         end;
   '^' : if IndexNo>0 then
          begin
           Replace(s, IndexName8[IndexNo], p);
          end else Replace(s, 'bx', p);
   '!' : Replace(s, 'Bad opcode', p);
   '@' : begin
          Inc(ILength);Inc(iptr);
          case s[p+1] of
     {CB}  '0' : if IndexNo>0 then
                   begin
                    {Inc(iptr);
                    Inc(ILength);}
                    s:=InstrCB8088[PrgMem^[iptr+1]]
                   end else s:=InstrCB8088[PrgMem^[iptr]];
     {ED}  '1' : s:=InstrED8088[PrgMem^[iptr]];
     {DD}  '2' : begin {IX}
                  IndexNo:=1;
                  s:=Instr8088[PrgMem^[iptr]];
                  IndexOfs:=shortint(PrgMem^[iptr+1]);
                 end;
     {FD}  '3' : begin {IX}
                  IndexNo:=2;
                  s:=Instr8088[PrgMem^[iptr]];
                  IndexOfs:=shortint(PrgMem^[iptr+1]);
                 end;
          end;
         end;
  end;
 until p=0;
 Instruction:=s;
end;
function ByteBlock:string;
var s:string;Done:boolean;i:byte;w,l:word;
begin
 Done:=False;w:=iptr;s:='';i:=0;
 repeat
  s:=s+DataByte(PrgMem^[w]); Inc(w); Inc(i);
  l:=ShadowH^[w] shl 8+ShadowL^[w];
  if (ShadowH^[w]<>$40) or (l and $3FFF>$0) or (i>3) then Done:=True else if i<4 then s:=s+',';
  if not Done then Inc(ILength);
 until Done;
 ByteBlock:='db'+Space(InterSize)+s;
end;
function WordBlock:string;
var s:string;
begin
 Inc(ILength);
 WordBlock:='dw'+Space(InterSize)+DataWord(PrgMem^[iptr]+PrgMem^[iptr+1] shl 8);
end;
function Address:string;
var s:string;sd:word;
begin
 Inc(ILength);
 ad:=PrgMem^[iptr]+PrgMem^[iptr+1] shl 8;
 if (ad>=PLow) and (ad<=PHigh) then
    if LabelExist(ad)
       then begin Address:='dw'+Space(InterSize)+'offset '+Labels^[LabelNo]; Exit end;
 Address:='dw'+Space(InterSize)+'offset L'+Hex4(ad);
end;
var s:string;i:integer;
begin
 iptr:=addr;
 ILength:=1;
 LNo:=(ShadowH^[iptr] and $7) shl 8+ShadowL^[iptr];
 dt:=ShadowH^[iptr] shr 6;{only 2 high bits}
 lb:=(ShadowH^[iptr] shr 4) and $3;
 case dt of
  00 : s:=Instruction;
  01 : s:=ByteBlock;
  02 : s:=WordBlock;
  03 : s:=Address;
 end;
 if LNo>0 then s:=Labels^[LNo]+':'+Space(TabSize-Length(Labels^[LNo])-1)+s
          else if ShadowH^[addr] and $10>0
                  then s:='L'+Hex4(addr)+':'+Space(TabSize-6)+s
                  else s:=Space(TabSize)+s;
 while Length(s)<43 do s:=s+' ';
 DisAsm8088:=s;
end;

procedure SetTinyLabel(addr:word);{1-code, 2-data, 3-table }
var l:word;
begin
 if (addr<PLow) or (addr>PHigh) then Exit;
 l:=ShadowH^[addr] shr 8+ShadowL^[addr];
 if l and $1FFF=0 then
     begin
      ShadowH^[addr]:=ShadowH^[addr] or $10;
      Inc(TinyLabels);
      WriteTo('Tiny  labels :  '+Hex4(TinyLabels),58,18,$30);
     end;
end;

procedure ScanProc(addr:word);
var ip,w:word;Done:boolean;b,c,st:byte;IL,l:byte;i:integer;

procedure AddNewProc(addr:word);
var l:word;i:integer;
begin
 if BIOSenabled and (addr<=BIOShigh) then Exit;
 if (addr<PrgBegin) or (addr>PrgBegin+PrgLength) then
    begin
     WriteTo('Call beyond program area: '+Hex4(addr),47,6,$1F);
     WriteTo('at '+Hex4(ip)+': (A)bort or (I)gnore?',47,7,$1F);
     repeat
      case upCase(readkey) of
       'A' : halt(2000);
       'I' : begin
              WriteTo(Strg(' ',30),47,6,$30);
              WriteTo(Strg(' ',30),47,7,$30);
              Exit;
             end;
      end;
     until false;
    end;

 for i:=1 to TotalProcs+1 do
  if (i<=TotalProcs) and (Proc[i]=addr) then
       begin
        break
       end;
 if i>TotalProcs then
   begin
    Inc(TotalProcs); Proc[TotalProcs]:=addr;
    Inc(ProcNum);    ProcQ[ProcNum]:=addr;
      WriteTo('Entry points :  '+Hex4(TotalProcs),58,17,$30);
   end;
end;

begin
 Done:=False;
 ip:=addr;
 repeat
  b:=Stat[PrgMem^[ip]]; IL:=1;
  ShadowH^[ip]:=ShadowH^[ip] and $3F;
  st:=b shr 4;  l:=b and 7;
  Inc(IL, l);
  case st of
    0 : {ordinary command};
    3 : {(HL)-oriented command};
    1,2,10 :
        begin {Load reg16, data }
         w:=PrgMem^[ip+1]+PrgMem^[ip+2] shl 8;
         if (w>=PLow) and (w<=PHigh) then
           begin
            SetTinyLabel(w);
            ShadowH^[ip+1]:=ShadowH^[ip+1] or $C0;
            ShadowH^[ip+2]:=ShadowH^[ip+2] or $C0;
           end;
        end;
    5 : begin {CB prefix}
         Inc(IL);
        end;
    6 : begin {ED prefix}
         Inc(ip);
         b:=StatED[PrgMem^[ip]];
         Inc(IL, b and 7);
        end;
    7,8 : begin {DD,FD-prefix}
           if PrgMem^[ip+1]=$CB then
             begin
              ShadowH^[ip+1]:=ShadowH^[ip+1] and $3F;
              inc(IL,3);
             end   else
             if Stat[PrgMem^[ip+1]] and $F0=$30 then
               begin
                Inc(IL,Stat[PrgMem^[ip+1]] and $7);
                Inc(IL,2);
               end;
          end;
   11 : begin {JR}
         w:=ip+shortint(PrgMem^[ip+1])+2;
         SetTinyLabel(w);
         AddNewProc(w);
         Done:=True;
        end;
   12 : begin {JR conditional}
         w:=ip+shortint(PrgMem^[ip+1])+2;
         SetTinyLabel(w);
         AddNewProc(w);
        end;
    9 : begin {JP}
         w:=PrgMem^[ip+1]+PrgMem^[ip+2] shl 8;
         SetTinyLabel(w);
         AddNewProc(w);
         Done:=True;
        end;
   14 : begin {call}
         w:=PrgMem^[ip+1]+PrgMem^[ip+2] shl 8;
          for i:=1 to 10 do
             if GreedCall[i]=w then
               begin
                Done:=True;
               end;
          SetTinyLabel(w);
          AddNewProc(w);
        end;
   13 : begin {JP conditional, CALL conditional }
         w:=PrgMem^[ip+1]+PrgMem^[ip+2] shl 8;
         SetTinyLabel(w);
         AddNewProc(w);
        end;
   15 : begin {RET or JP (HL)}
         Done:=True;
        end;
   else Halt(3000)
  end;
  Inc(ip, IL);
  if not ((ip>=PLow) or (ip<=PHigh)) then Done:=True;
 until Done;
end;

procedure Scan(addr:word);
var cp,ln:word;i:integer;
begin
 WriteTo('[Scanning area]',60,16,$3F);
 SetTinyLabel(addr);
 ProcNum:=0;
 Inc(ProcNum); ProcQ[ProcNum]:=addr;
 while ProcNum>0 do
   begin
    cp:=ProcQ[1];
    if ProcNum>1 then
      begin
       for i:=2 to ProcNum do ProcQ[i-1]:=ProcQ[i];
       ProcQ[i]:=0;
      end;
    Dec(ProcNum);
    ScanProc(cp);
   end;
 WriteTo(Strng(15,''),60,16,$3F);
end;

procedure DrawEnvir;
var i,j:byte;
begin
 for i:=0 to 79 do
   for j:=0 to 24 do
     begin
      mem[ScrSeg:ScrOfs+i*2+j*80*2]:=32;
      mem[ScrSeg:ScrOfs+i*2+j*80*2+1]:=$3F;
     end;
 ClearLine(0,$40);
 WriteTo('PROGRAM RECOMPILE SYSTEM', 3, 0, $47);
 ClearLine(24,$20);
 WriteTo('F1     F2 Label  F3 Reloc  F4 Data  F5 Code  F6 Word  F7 Address  F8 Delete', 1, 24, $2B);
 WriteTo('Source active: '+FileName+'GAM',31,0,$4C);
 WriteTo('InitAddress: '+Hex4(PrgStart),60,0,$47);
 Box(0,01,80,16,$3F,Box2);
 Box(0,16,80,08,$3F,Box2);
 for i:=2 to 15 do
   begin
    mem[ScrSeg:ScrOfs+i*80*2+45*2]:=byte('');
    mem[ScrSeg:ScrOfs+i*80*2+45*2+1]:=$3F;
   end;
 mem[ScrSeg:ScrOfs+01*80*2+45*2]:=byte('');
 mem[ScrSeg:ScrOfs+16*80*2+45*2]:=byte('');

 for i:=17 to 22 do
   begin
    mem[ScrSeg:ScrOfs+i*80*2+56*2]:=byte('');
    mem[ScrSeg:ScrOfs+i*80*2+56*2+1]:=$3F;
   end;
 mem[ScrSeg:ScrOfs+16*80*2+56*2]:=byte('');
 mem[ScrSeg:ScrOfs+23*80*2+56*2]:=byte('');
 mem[ScrSeg:ScrOfs+16*80*2+00*2]:=byte('');
 mem[ScrSeg:ScrOfs+16*80*2+79*2]:=byte('');

 GotoXY(9, 18);
 WriteTo('Memory position :',47,2,$30);
 WriteTo('ASM Format '+Format[Z80],60,22,$30);
end;

procedure ProHalt;
var i:byte; SysSeg:word;
begin
 {$IFDEF Debug}
 if ExitCode=0 then Halt;
 {$ENDIF}
 TextAttr:=7; ClrScr; Write(' ');
 case ExitCode of
  0    : writeln('Halted.');
  1    : writeln('No parameters specified!');
  2    : writeln('Bad file name or file not found!');
  3    : writeln('Bad file type, use MAKEGAM.EXE to convert one!');
  203  : writeln('Not enough memory for program.');
  1000 : writeln('Forced error #'+'001 (Scan - out of scanning area)');
  2000 : writeln('Forced error #'+'002 AddNewProc beyond ProgArea');
  3000 : writeln('Forced error #'+'003 (unknown Stat for opcode when scanning)');
 end;
 for i:=0 to 79 do mem[$B800:i*2+1]:=$1F;
 if ErrorAddr=nil then Halt;
 Write('ProHalt : ');
 asm
 @a: mov ax, word ptr cs:[@a-2] {get SYSTEM segment throw Write proc}
  mov SysSeg, ax
  mov  ax, word ptr ErrorAddr+2
  add  ax, PrefixSeg
  add  ax, 10h
  push ax
  mov  ax, word ptr ErrorAddr
  push ax
  mov  ax, ExitCode
  push SysSeg; push 10Fh; retf { call special function from SYSTEM.TPU }
 end;
end;

procedure TypeError(No:word);
var i,attr:byte;
begin
 case No of
  0      : attr:=$33;
  1..31  : attr:=$44;
  50     : attr:=$55;
  else     attr:=$11;
 end;
 for i:=47 to 77 do Mem[ScrSeg:ScrOfs+i*2+6*160+1]:=attr;
 case No of {0-must ne free}
   1 : WriteTo('Bad header in WorkFile!',50,6,$4C);
   2 : WriteTo('Error while rewrite WorkFile!',46,6,$4C);
   3 : WriteTo('Error while write WorkFile!',46,6,$4C);
   4 : WriteTo('Error while read WorkFile!',48,6,$4C);
   5 : WriteTo('Such WorkFile does not exist!',48,6,$4C);
   6 : WriteTo('Bad WorkFile contents!',48,6,$4C);
  10 : WriteTo('Can''t make ASM file!',48,6,$4C);
  11 : WriteTo('Can''t write to ASM file!',48,6,$4C);
  29 : WriteTo('Label not found!',54,6,$4C);
  32 : WriteTo('Search string not found!',48,6,$1B);
  33 : WriteTo('CodeSeg bit not found!',48,6,$4C);
  40 : WriteTo('WorkFile saved normally!',50,6,$1B);
  41 : WriteTo('WorkFile loaded OK!',52,6,$1B);
  50 : WriteTo('ASM file saved OK!',53,6,$5F);
  53 : WriteTo('ASM file saving aborted.',50,6,$4B);
  58 : WriteTo('SYM file loaded.',50,6,$1B);
  59 : WriteTo('CTL file loaded.',50,6,$1B);
  100: WriteTo('Real Data Offsets OFF',50,6,$1B);
  101: WriteTo('Real Data Offsets ON',50,6,$1B);
 end;
 ErrorLine:=7;
end;

Procedure ToggleRealPos;
var S : String;
begin
 RealDataLoc := not RealDataLoc;
 TypeError(100 + byte(RealDataLoc));
end;

procedure LoadEnvir; forward;

procedure LoadFile;
var i,p,l:byte; tf:file;
begin
 if ParamCount<1 then Halt(1);
 FileName:=ParamStr(1);
 Assign(f, FileName); ReSet(f, 1); if IOresult>0 then Halt(2);
 BlockRead(f, PrgType, 4); if PrgType<>$4241 then Halt(3);
 if FileSize(f)>16384 then PrgLength:=32768 else PrgLength:=16384;
 PrgBegin:=PrgStart and $C000;
 Seek(f, 0);
 BlockRead(f, PrgMem^[PrgBegin], PrgLength);
 Close(f);
 PLow:=PrgBegin; PHigh:=PrgBegin+PrgLength;
 PrgData:=$E000;
 p:=0;l:=0;
 for i:=1 to Length(FileName) do
  begin
   FileName[i]:=UpCase(FileName[i]);
   if FileName[i]='.' then p:=i;
   if (FileName[i] in ['A'..'Z','0'..'9','-']) and (l=0) then l:=i;
   if FileName[i]='\' then l:=0;
  end;
 Delete(FileName,p+1,3);
 Delete(FileName,1,l-1);
 Assign(tf, FileName+'WRK'); Reset(tf,1);
 if IOresult=0 then begin ldw:=True; Close(tf); end else ldw:=False;
 if IOresult>0 then ;
end;

procedure GetString(var s:string;ln:byte;x,y,attr:byte);
var p:byte;
begin

end;

function EnterRange(var r1,r2:word):boolean;
var ch:char;c,p:byte;ln,t:word;ox,oy:byte;i:integer;
s:array[1..3] of string;
d:array[1..3] of word;
procedure Restore;var i:byte;
begin
 for i:=0 to 3 do WriteTo(Space(15), 50, 6+i,$33);
 GotoXY(ox, oy);
end;
begin
 ox:=WhereX; oy:=WhereY;
 WriteTo('< Enter range >', 50, 6, $3E);
 c:=1;p:=1;d[1]:=r1;d[2]:=r2;
 repeat
  d[3]:=d[2]-d[1]+1;
  WriteTo(' From : '+Hex4(d[1])+' ', 51, 7, $1F);
  WriteTo(' To   : '+Hex4(d[2])+' ', 51, 8, $1F);
  WriteTo(' Len  : '+Hex4(d[3])+' ', 51, 9, $1F);
  GotoXY(59+p, 7+c);
  ch:=ReadKey;
  case ch of
   #0 : case ReadKey of
         #77 : if p<4 then Inc(p);
         #75 : if p>1 then Dec(p);
         #72 : if c>1 then Dec(c) else c:=3;
         #80 : if c<3 then Inc(c) else c:=1;
        end;
   '0'..'9','A'..'F','a'..'f' :
         begin
          s[1]:=Hex4(d[1]);s[2]:=Hex4(d[2]);s[3]:=Hex4(d[3]);
          s[c][p]:=ch; if p<4 then Inc(p);
          Val('$'+s[c], t, i);
          case c of
           1, 2 : d[c]:=t;
           3 : d[2]:=d[1]+t-1;
          end;
         end;
   #27 : begin
          Restore;
          EnterRange:=False;
          Exit
         end;
   #13 : begin
          Restore;
          r1:=d[1];r2:=d[2];
          EnterRange:=True;
          Exit;
         end;
  end;
 until False;
end;

function EnterAddr(var r:word):boolean;
var ch:char;c,p:byte;ln,t:word;ox,oy:byte;i:integer;
s:string;d:word;
procedure Restore;var i:byte;
begin
 for i:=0 to 3 do WriteTo(Space(15), 50, 6+i,$33);
 GotoXY(ox, oy);
end;
begin
 ox:=WhereX; oy:=WhereY;
 WriteTo('< Enter addr >', 50, 6, $3E);
 c:=1;p:=1;d:=r;
 repeat
  WriteTo(' Addr : '+Hex4(d)+' ', 51, 7, $1F);
  GotoXY(59+p, 7+c);
  ch:=ReadKey;
  case ch of
   #0 : case ReadKey of
         #77 : if p<4 then Inc(p);
         #75 : if p>1 then Dec(p);
        end;
   '+' : Inc(d);
   '-' : Dec(d);
   '0'..'9','A'..'F','a'..'f' :
         begin
          s:=Hex4(d);
          s[p]:=ch; if p<4 then Inc(p);
          Val('$'+s, t, i);
          d:=t;
         end;
   #27 : begin
          Restore; EnterAddr:=False;
          Exit
         end;
   #13 : begin
          Restore; r:=d; EnterAddr:=True;
          Exit;
         end;
  end;
 until False;
end;

procedure MakeCode;
var w1, w2:word;i:longint;
begin
 w1:=RealPos; w2:=RealPos;
 if not EnterRange(w1, w2) then Exit;
 for i:=0 to (w2-w1) do
  ShadowH^[w1+i]:=$00 or (ShadowH^[w1+i] and $3F);
end;

procedure MakeData;
var w1, w2:word;i:longint;
begin
 w1:=RealPos; w2:=RealPos;
 if not EnterRange(w1, w2) then Exit;
 for i:=0 to (w2-w1) do
  ShadowH^[w1+i]:=$40 or (ShadowH^[w1+i] and $3F);
end;

procedure MakeWord;
var w1, w2:word;i:longint;
begin
 w1:=RealPos; w2:=RealPos;
 if not EnterRange(w1, w2) then Exit;
 for i:=0 to (w2-w1) do
  ShadowH^[w1+i]:=$80 or (ShadowH^[w1+i] and $3F);
end;

procedure MakeAddress;
var w1, w2:word;i:longint;
begin
 w1:=RealPos; w2:=RealPos;
 if not EnterRange(w1, w2) then Exit;
 for i:=0 to (w2-w1) do
  ShadowH^[w1+i]:=$80 or (ShadowH^[w1+i] and $3F);
end;

procedure ContinueSearch;
var i:word;j:integer;
begin
 if FindString='' then Exit;
 while FindPos<=PrgBegin+PrgLength do
   begin
    for j:=1 to Length(FindString)+1 do
      if (j<=Length(FindString)) and (FControl[j]<>'X') and
         (PrgMem^[FindPos+j-1]<>byte(FindString[j])) then break;
    if j>Length(FindString) then begin MemPos:=FindPos; LineNo:=1; Exit end;
    Inc(FindPos);
   end;
 TypeError(32);
end;

procedure FindBytes;
var s,c:string;Done,Tab:boolean;ch:char;cur,p,b:byte;bt:string[2];i:integer;
begin
 s:='';c:='';
 Done:=False;Tab:=False;
 cur:=0;bt:='';p:=1;
 WriteTo('Find:',47,8,$30);
 repeat
  ch:=ReadKey;
  case Ch of
   #0 : case ReadKey of
         #75 : if p>1 then Dec(p);
         #77 : if p<Length(s) then Inc(p);
        end;
   #27 : begin WriteTo('     ',47,8,$30);Exit; end;
   'A'..'F','a'..'f','0'..'9': if Length(s)<10 then bt:=bt+UpCase(ch);
   'x','X' : begin Insert(#0,s,p); Insert('X',c,p); Inc(p) end;
   #13 : Done:=True;
   #9  : begin Done:=True; Tab:=True end;
   #08 : if bt[0]>#0 then bt:='' else
         if p>1 then begin Dec(p);Delete(s,p,1);Delete(c,p,1);end;
  end;
  if Length(bt)=2 then
    begin
     Val('$'+bt,b,i);
     Insert(char(b),s,p);
     Insert('O',c,p);
     bt:='';
     Inc(p);
    end;
  WriteTo(Space(31),48,9,$30);
  for i:=1 to Length(s) do
   if c[i]<>'X' then WriteTo(Hex2(byte(s[i])),45+i*3,9,$30)
                else WriteTo('XX',45+i*3,9,$30);
  if i>Length(s) then i:=0;
  WriteTo(bt,45+i*3+3,9,$30);
 until Done;
 WriteTo('     ',47,8,$30);
 FindString:=s; FControl:=c;
 if Tab then FindPos:=RealPos else FindPos:=PrgBegin;
 ContinueSearch;
end;

function GetGameID:string;
var s:string;
begin
 if Length(FileName)<5
    then s:=Copy(FileName,1,Length(FileName)-1)
    else s:=Copy(FileName,1,4);
 while Length(s)<4 do s:=s+'_';
 GetGameID:=s
end;

Procedure OutToFile(var T : Text; var S : string);
var I,J : Integer;
begin
 For I := 1 to 8 do
     case S[I] of
      ' ',':' : break;
      '+','-' : begin
                 FillChar(S[1], 8, ' ');
                 break;
                end;
     end;
 While (S <> '') and (S[length(S)] = ' ') do Dec(byte(S[0]));
 I := (length(S) div 8) * 8;
 While I > 0 do
       begin
        J := I;
        While (S[J] = ' ') and (J > I - 7) do Dec(J);
        if J < I then begin Inc(J); Delete(S, J, I - J); S[J] := #9; end;
        Dec(I, 8);
       end;
 Writeln(T, S);
end;

procedure SaveAsmFile;
const switchToCode : string[8] = '; [data]';
      switchToData : string[8] = '; [code]';
label ProcExit;
var ip, LNo, prgl:word;s,temps:string;i:integer;data:boolean;
begin
 Assign(t,FileName+'ASM'); ReWrite(t);
 Assign(dtf,FileName+'ADS'); ReWrite(dtf);
 if IOresult>0 then begin TypeError(10);Exit end;
 ip:=PrgBegin; lno:=0;
 prgl:=PrgLength div 100;
 WriteTo('Lines saved  :',58,19,$30);
 WriteTo('In progress  :',58,20,$30);
 WriteTo('[Saving *.ASM files]',58,16,$3F);
 WriteTo('ASM Format '+Format[Z80],60,22,$30);
 Writeln(t,';',
     #13#10'; This file was created by MSX PROGRAM''s RECOMPILER ',
     #13#10';           (C) 1995 by FRIENDS Software            ',
     #13#10';',
     #13#10'MainSeg   segment para public use16'#13#10,
     #13#10'          jumps',
     #13#10'          .Alpha',
     #13#10'          locals  @@',
     #13#10'          .model  Medium',
     #13#10' GameID   equ  '''+GetGameID+'''',
     #13#10'          include \msx\asm\savegame.asm',
     #13#10'          include \msx\asm\frndlogo.asm',
     #13#10'          assume  cs:MainSeg, ds:ZDatSeg, ss:ZDatSeg',
     #13#10'          include \msx\asm\MSXmacro.ASM',
     #13#10'          include \msx\asm\MSXvideo.ASM',
     #13#10'          include \msx\asm\MSXenvir.ASM'#13#10,
     #13#10' CSegAddr dw seg MainSeg',
     #13#10' DSegAddr dw seg ZDatSeg'#13#10
 );
 data:=true;
 if RealDataLoc then begin TempS := 'org '+Hex4(ip)+'h'; OutToFile(dtf, TempS); end;
 repeat
  if Z80 then s:=DisAsmZ80(ip) else s:=DisAsm8088(ip);
  if (ShadowH^[ip] and $20>0) or (ShadowH^[ip] shr 6=0) then
    begin
     if data then OutToFile(t,switchToCode);
     OutToFile(t,s); if IOresult>0 then begin TypeError(11);Close(t);Exit end;
     data := false;
    end else
    begin
     if not data
        then begin
              OutToFile(dtf,switchToData);
              if RealDataLoc
                 then begin
                       TempS := 'org 0'+Hex4(ip)+'h';
                       OutToFile(dtf, TempS);
                      end;
             end;
     for i:=1 to Length(s) do if s[i]=':' then begin s[i]:=' ';break end;
     OutToFile(dtf,s); if IOresult>0 then begin TypeError(11);Close(t);Exit end;
     data := true;
    end;
  inc(ip, ILength);
  Inc(LNo); Str(LNo:5,s);
  WriteTo(s,73,19,$30);
  i:=(ip-PrgBegin) div PrgL; Str(i:3,s);
  WriteTo(s+'%',74,20,$30);
  if keypressed then
    begin
     case ReadKey of
      #0 : case ReadKey of
	    #77 :;
	   end;
      #27 : begin TypeError(53);Goto ProcExit end;
     end;
    end;
 until ip>PrgBegin+PrgLength;
 TypeError(50);
ProcExit:
 WriteTo(Strng(20,''),58,16,$3F);
 Writeln(t,'MainSeg   ends'#13#10,
     #13#10'ZDatSeg   segment para public use16',
     #13#10'          org  0',
     #13#10'          db   0, 0, 0, 0',
     #13#10'          dw   offset MSXfont',
     #13#10'          db   98h, 98h, 0, 0, 0, 0, 0, 0, 0, 0'#13#10,
     #13#10'ifDef StdFont',
     #13#10'          include \msx\asm\msxfont.asm',
     #13#10'else',
     #13#10'msxfont   db   0',
     #13#10'endIf',
     #13#10'          include ',FileName+'ADS',
     #13#10'          org  0FFFEh',
     #13#10'          db   ?',
     #13#10'ZDatSeg   ends'#13#10,
     #13#10'_VRAM     segment para public use16',
     #13#10'          db 16384 dup (?)',
     #13#10' WorkNAM  db 32*24 dup (?)',
     #13#10' WorkSAT  db 32*4 dup (?)',
     #13#10' WorkSGT  db 256*8 dup (?)',
     #13#10'_VRAM     ends'#13#10,
     #13#10'          end ProgStart');
 Close(t); Close(dtf);
end;

function UpString(s:string):string;
var i:byte;
begin
 UpString:=s;
 for i:=1 to Length(s) do UpString[i]:=UpCase(s[i]);
end;

function CutString(var d:word;var s:string):boolean;
var i:integer;ls:string;
begin
 ls:='XXXX';for i:=1 to 4 do ls[i]:=s[i];
 Delete(s, 1, 5); Val('$'+ls,d,i);
 if i>0 then CutString:=False else CutString:=True;
end;

procedure SetLabelName(ad:word;s:string);
var i:integer;ls,orls:string;Ln:word;
begin
 Suck(s); if s='' then Exit;
 ls:=Copy(s,1,8);orls:=ls;
 for i:=1 to Length(ls) do ls[i]:=UpCase(s[i]);
 Ln:=(ShadowH^[ad] and $7) shl 8+ShadowL^[ad];
 for i:=1 to LabelNum do if Labels^[i]='' then begin Ln:=i;break end;
 if (Ln=0) and (LabelNum>=MaxLabels) then Exit;
 if Ln>0 then Labels^[Ln]:='!';
 for i:=1 to LabelNum do if ls=UpString(Labels^[i]) then Exit;
 if Ln=0 then begin Inc(LabelNum);Ln:=LabelNum; end;
 Labels^[Ln]:=orls;
 ShadowH^[ad]:=(ShadowH^[ad] and $E0)+(Hi(Ln) and $7);
 ShadowL^[ad]:=Lo(Ln);
end;

procedure ImportSymbols;
label CTL, DOC, Exit;
var t:text;s:string;w,ad:word;i:integer;ch:char;c:byte;
begin
 Assign(t, FileName+'SYM'); {Label names}
 ReSet(t); if IOResult>0 then Goto CTL;
 repeat
  ReadLn(t, s);
  if CutString(ad, s) then SetLabelName(ad, s);
  WriteTo('Label '+Copy(s,1,8)+' at '+Hex4(ad)+'    ',51,13,$30);
 until (s[1]=#26) or Eof(t);
 Close(t);
 TypeError(58);
CTL:
 Assign(t, FileName+'CTL'); {Data type ranges}
 ReSet(t); if IOResult>0 then Goto DOC;
 repeat
  ReadLn(t, s);
  if CutString(ad, s) then
    begin
     ch:=s[1];
     case ch of
      'B':c:=$40;
      'W':c:=$80;
      'I':c:=0;
      else c:=0;
     end;
     WriteTo('  Area type '+s[1]+' at '+Hex4(ad)+'    ',51,13,$30);
     for w:=ad to PrgBegin+PrgLength do
      ShadowH^[w]:=(ShadowH^[w] and $3F) or c;
    end;
 until (s[1]=#26) or Eof(t);
 Close(t);
 TypeError(59);
DOC:
 Assign(t, FileName+'DOC');    {Comments}
 ReSet(t); if IOResult>0 then Goto Exit;
 Close(t);
Exit:
 WriteTo(Strng(28,' '),51,13,$30);
end;

procedure GetLabelName(var ln:string);
var ox,oy,p:byte;s:string;ch:char;l:word;i:integer;
begin
 WriteTo('[ Real address : '+Hex4(RealPos)+' ]', 3, 1, $3F);
 ox:=WhereX; oy:=WhereY; s:=Space(8); p:=1;
 l:=(ShadowH^[RealPos] and $7) shl 8+ShadowL^[RealPos];
 if l>0 then s:=Labels^[l];
 repeat
  WriteTo(s, 2, LineNo+1, $1F);
  GotoXY(2+p, LineNo+2);
  ch:=ReadKey;
  case ch of
   #0  : case ReadKey of
          #75 : if p>1 then Dec(p);
          #77 : if p<9 then Inc(p);
          #83 : begin Delete(s, p, 1); s:=s+' '; end;
         end;
   'A'..'Z', 'a'..'z', '_','+','-'
       : if p<9 then
         begin
          Delete(s, 8, 1);
          Insert(ch, s, p); Inc(p);
         end;
   '0'..'9' : if (p>1) and (p<9) then
         begin
          Delete(s, 8, 1);
          Insert(ch, s, p); Inc(p);
         end;
   #8  : if p>1 then begin Dec(p); Delete(s, p, 1); s:=s+' ' end;
   #27 : begin
          GotoXY(ox, oy);
          WriteTo(Strng(24,''), 3, 1, $3F);
          ln:='';
          Exit;
         end;
   ':',#13 : begin
              GotoXY(ox, oy);
              WriteTo(Strng(24,''), 3, 1, $3F);
              ln:=s;
              Exit;
             end;
  end;
 until False;
 GotoXY(ox, oy);
end;

procedure InitAllVars;
var i:byte;
begin
 TinyLabels:=0;
 FillChar(GreedCall,20,$FF);
 ProcNum:=0;
 FindString:=''; FindPos:=PrgBegin;
 MemPos:=PrgBegin; DumpPos:=PrgBegin; LineNo:=1;
 OriginPos:=PrgStart;
 Follow[1]:=PrgStart; FolNum:=1;
 LabelNum:=0;
 SetLabelName(PrgBegin,'ModBegin');
 SetLabelName(PrgStart,'ModStart');
 MemPos:=PrgStart;DumpPos:=MemPos; OldDump:=DumpPos+1;
 RealPos:=MemPos;
 ErrorLine:=0; DAttr:=True; Z80:=True;
 for i:=1 to 10 do KeyReg[i]:=PrgStart;
 CharDec:=0; DumpChar:=False;
end;

procedure ShowPoints;
var i:byte;
begin
 for i:=1 to 10 do
   WriteTo(Hex4(GreedCall[i]),50+((i-1) mod 5)*5,11+(i-1) div 5,$30);
 for i:=1 to 10 do
   WriteTo(Hex4(KeyReg[i]),50+((i-1) mod 5)*5,14+(i-1) div 5,$30);
end;

procedure SaveEnvir;
begin
 Assign(f,FileName+'WRK'); ReWrite(f,1);
 if IOresult>0 then begin TypeError(2);Exit end;
 BlockWrite(f,WrkHeader[1], 16);
 BlockWrite(f,PrgType,14);
 BlockWrite(f,ShadowH^[PrgBegin],PrgLength);
 BlockWrite(f,ShadowL^[PrgBegin],PrgLength);
 BlockWrite(f,LabelNum,16);
 BlockWrite(f,GreedCall,21); {GreedCall,GreeCallNum}
 BlockWrite(f,Labels^,SizeOf(Labels^));
 BlockWrite(f,Follow,SizeOf(Follow)+1);{Follow,FolNum}
 BlockWrite(f,KeyReg,10*2+2);
 BlockWrite(f,RealDataLoc,1);
 if IOresult>0 then begin TypeError(3);Exit end;
 Close(f);
 TypeError(40);
end;

procedure LoadEnvir;
begin
 Assign(f,FileName+'WRK'); ReSet(f,1);
 if IOresult>0 then begin TypeError(5);Exit end;
 CurHeader[0]:=#16;
 BlockRead(f, CurHeader[1], 16);
 if IOresult>0 then TypeError(6);
 if WrkHeader<>CurHeader then begin TypeError(1);Exit; end;
 BlockRead(f,PrgType,14);
 BlockRead(f,ShadowH^[PrgBegin],PrgLength);
 BlockRead(f,ShadowL^[PrgBegin],PrgLength);
 BlockRead(f,LabelNum,16);
 BlockRead(f,GreedCall,21); {GreedCall,GreeCallNum}
 BlockRead(f,Labels^,SizeOf(Labels^));
 BlockRead(f,Follow,SizeOf(Follow)+1);{Follow,FolNum}
 BlockRead(f,KeyReg,10*2+2);
 if IOresult>0 then
   begin
    TypeError(4);
    InitAllVars;
    ShowPoints;
    Exit;
   end;
 BlockRead(f,RealDataLoc,1); inOutRes := 0;
 Close(f);
 ShowPoints;
 TypeError(41);
 WriteTo('ASM Format '+Format[Z80],60,22,$30);
end;

procedure ShowDump;
var i:integer;attr:byte;
begin
 if CharDec<>0 then WriteTo('['+Hex2(CharDec)+']',2,16,$3F) else WriteTo('',2,16,$3F);
 if (RealPos>=DumpPos) and (RealPos<=DumpPos+6*16) then DAttr:=True;
 if (OldDump=DumpPos) and not DAttr then Exit;
 if DumpChar then
 for i:=0 to 6*48-1 do
  begin
   if DumpPos+i=RealPos then begin attr:=$17; DAttr:=True end else attr:=$30;
   WriteTo(Char(Byte(PrgMem^[DumpPos+i]+CharDec)), (i mod 48)+8, i div 48+17, attr);
   if i mod 48=0 then WriteTo(Hex4(DumpPos+i)+':', 2, i div 48+17, $30);
  end    else
 for i:=0 to 6*16-1 do
  begin
   if DumpPos+i=RealPos then begin attr:=$17; DAttr:=True end else attr:=$30;
   WriteTo(Hex2(PrgMem^[DumpPos+i]), (i and 15)*3+8, i div 16+17, attr);
   WriteTo(' ', (i and 15)*3+8+2, i div 16+17,$30);
   if i and 15=0 then WriteTo(Hex4(DumpPos+i)+':', 2, i div 16+17, $30);
  end;
 OldDump:=DumpPos;
end;

procedure ShowList;
var i, attr:byte; ip:word; s:string;
begin
 ip:=MemPos; PageByte:=0;
 for i:=1 to 14 do
  begin
   if i=LineNo then attr:=$17 else attr:=$30;
   if Z80 then s:=DisAsmZ80(ip) else s:=DisAsm8088(ip);
   if ip=OriginPos then s:=chr(16)+s else s:=' '+s;
   if (ShadowH^[ip] and $20<>0) and (ShadowH^[ip] shr 6<>0) then s[11]:='';
   WriteTo(s,1,i+1,attr);
   inc(ip, ILength); inc(PageByte, ILength);
   Adds[i]:=ILength;
  end;
end;

procedure DeleteLabel(ad:word);
var i:integer;l:word;
begin
 if (ShadowH^[ad] and $10=0) and (LabelNum=0) then Exit;
 l:=(ShadowH^[ad] and $0F) shl 8+ShadowL^[ad];
 ShadowH^[ad]:=ShadowH^[ad] and $E0;ShadowL^[ad]:=0;
 if (l=0) or (LabelNum=0) then Exit;
 Labels^[l]:='';
 if l=LabelNum then Dec(LabelNum);
 for i:=LabelNum downto 1 do
   begin
    if Labels^[i]<>'' then break;
    Dec(LabelNum);
   end;
end;

procedure GoUp;
var i, attr:byte; ip:word; s:string;
begin
 ip:=MemPos-22;
 repeat
  s:=DisAsmZ80(ip); inc(ip, ILength);
 until ip>=MemPos;
 Dec(MemPos,ILength);
end;

procedure PageUp;
var i:byte;
begin
 for i:=1 to 14 do GoUp;
end;

procedure ShowStatus;
var i:byte;s:string;
begin
 RealPos:=MemPos;
 for i:=2 to LineNo do Inc(RealPos,Adds[i-1]);
 WriteTo(Hex4(RealPos), 65, 2, $30);
 if (RealPos>=PrgBegin) and (RealPos<=PrgBegin+PrgLength) then
   begin
    i:=(RealPos-PrgBegin) div (PrgLength div 100);
    Str(i:3,s); WriteTo(s+'%',70,2,$30);
   end else WriteTo(' Out ',70,2,$30);
 WriteTo('Labels :'+SStr(LabelNum,4),47,3,$30);
end;

procedure PutPixel(x,y:integer;Col:byte);
begin
 mem[$A000:x+y*320]:=Col;
end;

procedure ShowGraphics(addr:word; Mode : byte);
var p:word; x,y:word; i:integer; rc,cc,a,c,lcl:byte;

procedure ShowByte;
const yp : array[0..15] of byte =
     (0,0,47,72,33,9,249,11,39,64,43,67,144,62,28,15);
      ch : array[0..7] of byte =
     ($7E,$81,$A5,$81,$BD,$99,$81,$7E);
var   bc : byte;
begin
 if Mode = 0
    then for bc:=0 to 7 do
             if c and ($80 shr bc)<>0
                then PutPixel(x+bc,y,15)
                else
    else for bc:=0 to 7 do
             if ch[lcl] and (1 shl bc) <> 0
                then PutPixel(x+bc,y,yp[c and $0F])
                else PutPixel(x+bc,y,yp[c shr 4]);
 lcl := (lcl + 1) and 7;
 Inc(y); Inc(rc);
 if rc=16
    then begin
          Inc(x,8); Dec(y,16); rc:=0; inc(cc);
          if cc=18 then begin Inc(y,16); x:=32; cc:=0; rc:=0; end;
         end;
end;

begin
 OldScr:=ScrBuf;
 asm mov ax, 13h; int 10h end;
 p:=addr; x:=32; y:=90; rc:=0; cc:=0; lcl := 0;
 repeat
  a:=PrgMem^[p]; Inc(p);
  if a=0 then break;
  if a and $80=0
   then begin
         c:=PrgMem^[p]; Inc(p);
         for i:=1 to a do
             ShowByte;
        end
   else begin
         for i:=1 to a and $7F do
          begin
           c:=PrgMem^[p]; Inc(p);
           ShowByte;
          end;
        end;
 until false;
 ReadKey;
 asm mov ax,3; int 10h end;
 ScrBuf:=OldScr;
end;

var ln:string;
    i:word;

procedure StartUp;
begin
 ExitProc:=@ProHalt;
 ScrSeg:=Seg(ScrBuf); ScrOfs:=Ofs(ScrBuf);
 GetMem(PrgMem, 65535);  FillChar(PrgMem^, 65535, 0);
 GetMem(ShadowH, 65535); FillChar(ShadowH^, 65535, $40);
 GetMem(ShadowL, 65535); FillChar(ShadowL^, 65535, $00);
 New(Labels); FillChar(Labels^, SizeOf(Labels^), 0);
 if ParamCount<1 then Halt(1);
 LoadFile;
 InitAllVars;
 DrawEnvir;
 ShowPoints;
 if ldw then LoadEnvir;
 repeat
  ShowStatus;
  ShowList;
  ShowDump;
  case ReadKey of
   #0 : case ReadKey of
         #59 : ShowKeyboardHelp;
         #75 : Dec(DumpPos);
         #77 : Inc(DumpPos);
         #72 : if LineNo>1  then dec(LineNo) else GoUp;
         #80 : if LineNo<14 then inc(LineNo) else inc(MemPos, Adds[1]);
         #73 : PageUp;
         #81 : Inc(MemPos, PageByte);
         #60 : begin GetLabelName(ln); if ln<>'' then SetLabelName(RealPos,ln); end;
         #61 : begin
                GetLabelName(ln); ln:=UpString(ln);
                While (ln <> '') and (ln[length(ln)] = ' ') do Dec(byte(ln[0]));
                if ln<>'' then
                   for i:=PrgBegin to PrgBegin+PrgLength do
                     if LabelExist(i) and (copy(UpString(Labels^[LabelNo]),1,length(ln))=ln)
                        then begin
                              MemPos:=i; LineNo:=1;
                              break;
                             end;
                if i=PrgBegin+PrgLength then TypeError(29);
               end;
         #62 : MakeData;
         #63 : MakeCode;
         #64 : MakeWord;
         #65 : MakeAddress;
         #66 : DeleteLabel(RealPos);
{F9}     #67 : Scan(RealPos);
{Alt+ F9}#112: begin                  {if code}
                if ShadowH^[RealPos] and $C0=0 then
                 case Stat[PrgMem^[RealPos]] shr 4 of
                  1 : begin {LD reg16, xx}
                       sadr:=PrgMem^[RealPos+1]+PrgMem^[RealPos+2] shl 8;
                       ShadowH^[RealPos+1]:=ShadowH^[RealPos] or $C0;
                       ShadowH^[RealPos+2]:=ShadowH^[RealPos+1] or $C0;
                      end;
                  else sadr:=0; {invalid oper. to scan over}
                 end        else
                 begin                {if data, make }
                  sadr:=PrgMem^[RealPos]+PrgMem^[RealPos+1] shl 8;
                  ShadowH^[RealPos]:=ShadowH^[RealPos] or $C0;
                  ShadowH^[RealPos+1]:=ShadowH^[RealPos+1] or $C0;
                 end;
                if (sadr>=PrgBegin) and (sadr<PrgBegin+PrgLength)
                  then Scan(sadr);
                ShadowH^[RealPos]:=ShadowH^[RealPos] or $20;
               end;
{Ctrl+F9}#102: SaveASMfile;
{Ctrl+F2}#95 : ShadowH^[RealPos]:=ShadowH^[RealPos] xor $10;
{Alt +F2}#105: if ShadowH^[RealPos] shr 6=0 then
                  ShadowH^[RealPos+1]:=(ShadowH^[RealPos+1] xor $80) or $40 else
                   begin
                    ShadowH^[RealPos]:=(ShadowH^[RealPos] xor $80) or $40;
                    ShadowH^[RealPos+1]:=(ShadowH^[RealPos+1] xor $80) or $40;
                   end;
{ShiftF2}#85 : if ShadowH^[RealPos] shr 6=0 then
                  ShadowH^[RealPos+1]:=(ShadowH^[RealPos+1] xor $80) or $40 else
                   begin
                    sadr:=PrgMem^[RealPos]+PrgMem^[RealPos+1] shl 8;
                    ShadowH^[RealPos]:=(ShadowH^[RealPos] xor $80) or $40;
                    ShadowH^[RealPos+1]:=(ShadowH^[RealPos+1] xor $80) or $40;
                    SetTinyLabel(sadr);
                   end;
{Alt +x} #45 : Halt;
{Alt +1} #120: begin MemPos:=KeyReg[1];  LineNo:=1 end;
{Alt +2} #121: begin MemPos:=KeyReg[2];  LineNo:=1 end;
{Alt +3} #122: begin MemPos:=KeyReg[3];  LineNo:=1 end;
{Alt +4} #123: begin MemPos:=KeyReg[4];  LineNo:=1 end;
{Alt +5} #124: begin MemPos:=KeyReg[5];  LineNo:=1 end;
{Alt +6} #125: begin MemPos:=KeyReg[6];  LineNo:=1 end;
{Alt +7} #126: begin MemPos:=KeyReg[7];  LineNo:=1 end;
{Alt +8} #127: begin MemPos:=KeyReg[8];  LineNo:=1 end;
{Alt +9} #128: begin MemPos:=KeyReg[9];  LineNo:=1 end;
{Alt +0} #129: begin MemPos:=KeyReg[10]; LineNo:=1 end;
{Alt +Q} #16 : SaveEnvir;
{Alt +W} #17 : LoadEnvir;
{Alt +R} #19 : ToggleRealPos;
{Alt +S} #31 : ShadowH^[RealPos]:=ShadowH^[RealPos] xor $20;
{Alt +I} #23 : ImportSymbols;
{Alt +D} #32 : DumpPos:=RealPos;
{Alt +G} #34 : begin
                for sadr:=1 to 10 do if GreedCall[sadr]=RealPos
                  then begin GreedCall[sadr]:=$FFFF;sadr:=100;break end;
                if sadr<>100 then for sadr:=1 to 10 do if GreedCall[sadr]=$FFFF then
                  begin GreedCall[sadr]:=RealPos; break end;
                ShowPoints;
               end;
        end;
{ end of doublecoded chars }
{Ctrl+D} #4  : begin
                for sadr:=RealPos+1 to PrgBegin+PrgLength do
                  if (ShadowH^[sadr] shr 6>0) and (ShadowH^[sadr+1] shr 6>0)
                  and (ShadowH^[sadr+2] shr 6>0) and (ShadowH^[sadr+3] shr 6>0)
                    then break;
                if sadr<PrgBegin+PrgLength then begin MemPos:=sadr;LineNo:=1 end;
               end;
{Ctrl+T} #20 : begin
                for sadr:=RealPos+1 to PrgBegin+PrgLength do
                    if Pos('offset', DisAsmZ80(sadr)) > 0 then break;
                if sadr<PrgBegin+PrgLength then begin MemPos:=sadr; LineNo:=1 end;
               end;
{Ctrl+C} #3  : DumpChar:=not DumpChar;
{Ctrl+A} #1  : begin
                for sadr:=RealPos+1 to PrgBegin+PrgLength do
                  if (ShadowH^[sadr] and $20>0) then break;
                if sadr<PrgBegin+PrgLength then begin MemPos:=sadr;LineNo:=1 end
                   else TypeError(33);
               end;
{Ctrl+G} #7  : begin
                sadr:=RealPos;
                if EnterAddr(sadr) then begin MemPos:=sadr; LineNo:=1; end;
               end;
{Ctrl+O} #15 : begin MemPos:=OriginPos; LineNo:=1 end;
{Ctrl+N} #14 : OriginPos:=RealPos;
{Ctrl+F} #6  : begin
                Inc(FolNum); if FolNum>MaxFol then FolNum:=MaxFol;
                Follow[FolNum]:=RealPos;
                LineNo:=1;
                if ShadowH^[RealPos] and $C0=0 then
                  case Stat[PrgMem^[RealPos]] shr 4 of
                   11,12:MemPos:=RealPos+shortint(PrgMem^[RealPos+1])+2;
                   else MemPos:=PrgMem^[RealPos+1]+PrgMem^[RealPos+2] shl 8;
                  end        else
                  MemPos:=PrgMem^[RealPos]+PrgMem^[RealPos+1] shl 8;
               end;
{Ctrl+P} #16 : begin
                LineNo:=1;
                if FolNum>0 then begin MemPos:=Follow[FolNum];Dec(FolNum) end
                            else MemPos:=Follow[1];
               end;
{Ctrl+R} #18 : begin
                FindString:=chr(Lo(RealPos))+chr(Hi(RealPos));
                FControl:=FindString;
                FindPos:=PrgBegin;
                ContinueSearch;
               end;

{Ctrl+S} #19 : FindBytes;
{Ctrl+L} #12 : begin Inc(FindPos);ContinueSearch; end;
{Ctrl+B} #2  : begin MemPos:=PrgBegin;LineNo:=1 end;
{Ctrl+Z} #26 : begin Z80:=not Z80;WriteTo('ASM Format '+Format[Z80],60,22,$30);end;
{Shift1} '!' : begin KeyReg[1]:=RealPos; ShowPoints end;
{Shift2} '@' : begin KeyReg[2]:=RealPos; ShowPoints  end;
{Shift3} '#' : begin KeyReg[3]:=RealPos; ShowPoints  end;
{Shift4} '$' : begin KeyReg[4]:=RealPos; ShowPoints  end;
{Shift5} '%' : begin KeyReg[5]:=RealPos; ShowPoints  end;
{Shift6} '^' : begin KeyReg[6]:=RealPos; ShowPoints  end;
{Shift7} '&' : begin KeyReg[7]:=RealPos; ShowPoints  end;
{Shift8} '*' : begin KeyReg[8]:=RealPos; ShowPoints  end;
{Shift9} '(' : begin KeyReg[9]:=RealPos; ShowPoints  end;
{Shift0} ')' : begin KeyReg[10]:=RealPos;ShowPoints  end;
         '+' : Inc(CharDec);
         '-' : Dec(CharDec);
{enter}  #13 : ShowGraphics(RealPos, 0);
{Ctrl/En}#10 : ShowGraphics(RealPos, 1);
{Space}  #32 : ShadowH^[RealPos]:=ShadowH^[RealPos] xor $20;
{$IFDEF Debug}
{Shift~} '~' : begin
                asm nop end{ Here will be extra stop }
               end;
         #27 : Halt;
{$ENDIF}
  end;
  memw[0:$41A]:=memw[0:$41C];
  if ErrorLine>0 then Dec(ErrorLine); if ErrorLine=1 then TypeError(0);
 until False;
end;

Procedure SaveArea(X,Y,W,H : Word; var P : Pointer);
var i : Word;
begin
 GetMem(P, W*H*2+6);
 if P = NIL then Exit;
 i := X * 2 + Y * 160;
 Move(I, pByteArray(P)^[0], 2);
 Move(W, pByteArray(P)^[2], 2);
 Move(H, pByteArray(P)^[4], 2);
 for i:=Y to Y+H-1 do
     Move(mem[ScrSeg:I*160+X*2],pByteArray(P)^[6+(I-Y)*W*2],W*2);
end;

Procedure RestoreArea(var P : Pointer);
var i,a,w,h : Word;
begin
 if P = NIL then Exit;
 Move(pByteArray(P)^[0], A, 2);
 Move(pByteArray(P)^[2], W, 2);
 Move(pByteArray(P)^[4], H, 2);
 for i:=0 to H-1 do
     Move(pByteArray(P)^[6+I*W*2],mem[ScrSeg:A+I*160],W*2);
 FreeMem(P, W*H*2+6); P:=NIL;
end;

Procedure ShowKeyboardHelp;
var Back : Pointer;
begin
 SaveArea(4,2,72,22,Back);
 Box(4,2,72,22,$7F,Box2);
 WriteTo(' Keyboard Quick Help ', 30, 2, $1F);
 WriteTo(' F2 Global label at c.p.            F6 Define data area (word)       ', 5, 03, $70);
 WriteTo(' F3 Find global label               F7 Define offset table           ', 5, 04, $70);
 WriteTo(' F4 Define data area (byte)         F8 Delete label (!)              ', 5, 05, $70);
 WriteTo(' F5 Define code area                F9 Scan from cursor position     ', 5, 06, $70);
 WriteTo(' Alt+F2 Toggle offset/word          Ctrl+F2 Set/Delete Lxxx label    ', 5, 07, $70);
 WriteTo(' Alt+F9 Scan from WORD at c.p.      Ctrl+F9 Save ASM files           ', 5, 08, $70);
 WriteTo(' Shft+F2 Make offset and create tiny label where it points            ', 5, 09, $70);
 WriteTo(' Ctrl+1..9 set mark #1..#9          Alt+1..9 Goto mark #1..#9        ', 5, 10, $70);
 WriteTo(' Ctrl+P Previous operator           Ctrl+R Find reference            ', 5, 11, $70);
 WriteTo(' Ctrl+S Find bytes (X - unknwn)     Ctrl+L Find next occurence       ', 5, 12, $70);
 WriteTo(' Ctrl+B Begin of module             Ctrl+Z Change asm format         ', 5, 13, $70);
 WriteTo(' Alt+G Define "greed" call          Ctrl+D Find next data from c.p.  ', 5, 14, $70);
 WriteTo(' Alt+Q Save .WRK file               Ctrl+C Hex/char dump, "+"/"-"    ', 5, 15, $70);
 WriteTo(' Alt+W Load .WRK file               Ctrl+A Find next address ref.    ', 5, 16, $70);
 WriteTo(' Alt+S Move to data/code segment    Ctrl+G Goto address, "+"/"-"     ', 5, 17, $70);
 WriteTo(' Alt+I Import .SYM, .CTL files      Ctrl+O Goto origin               ', 5, 18, $70);
 WriteTo(' Alt+D Dump offset to c.p.          Ctrl+N Set origin                ', 5, 19, $70);
 WriteTo(' Alt+X Quit the program             Ctrl+F Follow operator           ', 5, 20, $70);
 WriteTo(' Alt+R Toggle real data pos.                                         ', 5, 22, $70);
 WriteTo(' Enter  Unpack graphics at c.p.     Ctrl+T Find next label ref.      ', 5, 21, $70);
 readKey;
 RestoreArea(Back);
end;

end.
