; 
;  VIDEO.ASM  - procs for grafix IO 
; 				    
; 

rVRAMptr	dw	0
wVRAMptr	dw	0

VDPStat 	db	0    ; 50 times per second is set to 1
IRQdisabled	db	1    ; disable IRQ emualation (DI performed)

VRAMsegaddr	dw	seg _VRAM

TFileHandle	dw	?
FreeVideo	proc	near
		push	ds
ifdef SaveVRAM
		mov	dx, cs
		mov	ds, dx
		mov	dx, offset VRAMfileName
		mov	ah, 3Ch
		xor	cx, cx
		int	21h	 ; Create File
		jc	Failed
		mov	TfileHandle, ax ; save file handle
		mov	bx, ax
		mov	cx, 4000h
		mov	dx, seg _VRAM
		mov	ds, dx
		xor	dx, dx
		mov	ah, 40h
		int	21h	; Write VRAM to this file
		jc	Failed
		mov	ah, 3Eh
		mov	bx, TFileHandle ; restore saved file handle
		int	21h		   ; & close file.
endif
;Now Save a part of DatSeg
ifdef SaveDSeg
		mov	dx, cs
		mov	ds, dx
		mov	dx, offset DSegFileName
		mov	ah, 3Ch
		xor	cx, cx
		int	21h	 ; Create File
		jc	Failed
		mov	TfileHandle, ax ; save file handle
		mov	bx, ax
		mov	cx, 01000h
		mov	dx, seg ZDatSeg
		mov	ds, dx
		mov	dx, 0E000h
		mov	ah, 40h
		int	21h	; Write DatSeg to this file
		jc	Failed
		mov	ah, 3Eh
		mov	bx, TfileHandle ; restore saved file handle
		int	21h	 ; close the file
endif
;Now Save 16384 bytes of SndBuf - PSG data
ifdef SaveSounds
		mov	dx, cs
		mov	ds, dx
		mov	dx, offset SndFileName
		mov	ah, 3Ch
		xor	cx, cx
		int	21h	 ; Create File
		jc	Failed
		mov	TfileHandle, ax ; save file handle
		mov	bx, ax
		mov	cx, 04000h ;65536 bytes
		mov	dx, seg SndBuf
		mov	ds, dx
		xor	dx, dx
		mov	ah, 40h
		int	21h	; Write DatSeg to this file
		jc	Failed
		mov	ah, 3Eh
		mov	bx, TfileHandle ; restore saved file handle
		int	21h	 ; close the file
endif
    Failed:

                pop     ds
		mov	dx, cs
		mov	ds, dx
		mov	ax, 3
		int	10h

  ifdef   MegaShit
                cmp     IsOverflowInc, 0
                jz      @NoOverM
                mov     ah, 9
                lea     dx, OverMess
                push    cs
                pop     ds
                int     21h
     @NoOverM:
  endif
                ret
FreeVideo	endp

ifdef  MegaShit
 OverMess      db       'Warning! INCREM overflow detected!',7,13,10,'$'
endif

ifdef SaveVRAM
 VRAMfileName   db      '_(vram)_.dat',0
 SavedOk        db      'VRAM.DAT is saved succesfully',7,13,10,'$'
endif

ifdef SaveDseg
DSegFileName	db	'_(dseg)_.dat',0
endif
ifdef SaveSounds
SndFileName	db	'_(psgd)_.dat',0
endif

VideoSeg	dw	0A000h

comment ^   This was the fail, big fail...
Pal		db	000h,000h,000h,000h,000h,000h,000h,02Ah
		db	000h,000h,039h,000h,000h,000h,030h,000h
		db	000h,03Fh,028h,008h,008h,022h,02Ah,03Fh
		db	037h,006h,006h,03Fh,00Dh,00Dh,033h,024h
		db	00Dh,03Fh,032h,000h,000h,017h,000h,039h
		db	011h,035h,02Ah,02Ah,02Ah,03Fh,03Fh,03Fh
^
Pal		db	000h,000h,000h,000h,000h,000h,009h,036h
		db	009h,01Bh,03Fh,01Bh,009h,009h,03Fh,012h
		db	01Bh,03Fh,02Dh,009h,009h,012h,036h,03Fh
		db	03Fh,009h,009h,03Fh,01Bh,01Bh,036h,036h
		db	009h,036h,036h,024h,009h,024h,009h,036h
		db	012h,02Dh,02Dh,02Dh,02Dh,03Fh,03Fh,03Fh


PattAddr:	dw	   4,	5,   6,   7,   8,   9,	10,  11,  12,  13,  14,  15,  16,  17,	18,  19
		dw	  20,  21,  22,  23,  24,  25,	26,  27,  28,  29,  30,  31,  32,  33,	34,  35
		dw	 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339
		dw	 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355
		dw	 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659
		dw	 660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675
		dw	 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979
		dw	 980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995
		dw	1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299
		dw	1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315
		dw	1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619
		dw	1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635
		dw	1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939
		dw	1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955
		dw	2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259
		dw	2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275
		dw	2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,2576,2577,2578,2579
		dw	2580,2581,2582,2583,2584,2585,2586,2587,2588,2589,2590,2591,2592,2593,2594,2595
		dw	2884,2885,2886,2887,2888,2889,2890,2891,2892,2893,2894,2895,2896,2897,2898,2899
		dw	2900,2901,2902,2903,2904,2905,2906,2907,2908,2909,2910,2911,2912,2913,2914,2915
		dw	3204,3205,3206,3207,3208,3209,3210,3211,3212,3213,3214,3215,3216,3217,3218,3219
		dw	3220,3221,3222,3223,3224,3225,3226,3227,3228,3229,3230,3231,3232,3233,3234,3235
		dw	3524,3525,3526,3527,3528,3529,3530,3531,3532,3533,3534,3535,3536,3537,3538,3539
		dw	3540,3541,3542,3543,3544,3545,3546,3547,3548,3549,3550,3551,3552,3553,3554,3555
		dw	3844,3845,3846,3847,3848,3849,3850,3851,3852,3853,3854,3855,3856,3857,3858,3859
		dw	3860,3861,3862,3863,3864,3865,3866,3867,3868,3869,3870,3871,3872,3873,3874,3875
		dw	4164,4165,4166,4167,4168,4169,4170,4171,4172,4173,4174,4175,4176,4177,4178,4179
		dw	4180,4181,4182,4183,4184,4185,4186,4187,4188,4189,4190,4191,4192,4193,4194,4195
		dw	4484,4485,4486,4487,4488,4489,4490,4491,4492,4493,4494,4495,4496,4497,4498,4499
		dw	4500,4501,4502,4503,4504,4505,4506,4507,4508,4509,4510,4511,4512,4513,4514,4515
		dw	4804,4805,4806,4807,4808,4809,4810,4811,4812,4813,4814,4815,4816,4817,4818,4819
		dw	4820,4821,4822,4823,4824,4825,4826,4827,4828,4829,4830,4831,4832,4833,4834,4835
		dw	5124,5125,5126,5127,5128,5129,5130,5131,5132,5133,5134,5135,5136,5137,5138,5139
		dw	5140,5141,5142,5143,5144,5145,5146,5147,5148,5149,5150,5151,5152,5153,5154,5155
		dw	5444,5445,5446,5447,5448,5449,5450,5451,5452,5453,5454,5455,5456,5457,5458,5459
		dw	5460,5461,5462,5463,5464,5465,5466,5467,5468,5469,5470,5471,5472,5473,5474,5475
		dw	5764,5765,5766,5767,5768,5769,5770,5771,5772,5773,5774,5775,5776,5777,5778,5779
		dw	5780,5781,5782,5783,5784,5785,5786,5787,5788,5789,5790,5791,5792,5793,5794,5795
		dw	6084,6085,6086,6087,6088,6089,6090,6091,6092,6093,6094,6095,6096,6097,6098,6099
		dw	6100,6101,6102,6103,6104,6105,6106,6107,6108,6109,6110,6111,6112,6113,6114,6115
		dw	6404,6405,6406,6407,6408,6409,6410,6411,6412,6413,6414,6415,6416,6417,6418,6419
		dw	6420,6421,6422,6423,6424,6425,6426,6427,6428,6429,6430,6431,6432,6433,6434,6435
		dw	6724,6725,6726,6727,6728,6729,6730,6731,6732,6733,6734,6735,6736,6737,6738,6739
		dw	6740,6741,6742,6743,6744,6745,6746,6747,6748,6749,6750,6751,6752,6753,6754,6755
		dw	7044,7045,7046,7047,7048,7049,7050,7051,7052,7053,7054,7055,7056,7057,7058,7059
		dw	7060,7061,7062,7063,7064,7065,7066,7067,7068,7069,7070,7071,7072,7073,7074,7075
		dw	7364,7365,7366,7367,7368,7369,7370,7371,7372,7373,7374,7375,7376,7377,7378,7379
		dw	7380,7381,7382,7383,7384,7385,7386,7387,7388,7389,7390,7391,7392,7393,7394,7395

SGTbase 	dw	1800h
COLbase 	dw	0000h
PATbase 	dw	2000h
NAMbase 	dw	3800h
SATbase 	dw	3B00h

VideoChip	dw	3D4h

VideoInit	proc	far
		mov	ax, 0
		mov	es, ax
		mov	ax, es:[463h]
		mov	VideoChip, ax

		mov	ax,0Dh
		int	10h

;                mov     dx,3C2h
;                mov     al,067h
;                out     dx,al

		mov	dx,VideoChip
		add	dx,6
	 @M0:	in	al,dx
		test	al,8
		jnz	@M0
	 @M1:	in	al,dx
		test	al,8
		jz	@M1

		mov	dx, 3C0h
		mov	cl, 16
@@NextColor:
		mov	al, 16
		sub	al, cl
		out	dx, al
		jmp	$+2
		out	dx, al
		loop	@@NextColor
		mov	al, 17
		out	dx, al
		mov	al, 0
		out	dx, al
		mov	dx, VideoChip
		add	dx, 6
		in	al, dx
		mov	dx, 3C0h
		mov	al, 20h
		out	dx, al

		cld
		mov	cx, 16
		lea	si, Pal
		xor	bl, bl

      @@2:	mov	al, bl
		mov	dx, 3C8h
		out	dx, al
		inc	dx
		jmp	$+2
		jmp	$+2
		jmp	$+2
		push	cx
		mov	cx, 3
      @@3:	mov	al, cs:[si]
		inc	si
		out	dx, al
		loop	@@3
		pop	cx
		inc	bl
		Loop	@@2
		call	SetBorder
		ret
VideoInit	endp

MaxLine 	equ	192
ifnDef noSprLimit
SpriteLine	db	MaxLine dup (0)
endIf

PATaddr 	dw	?
COLaddr 	dw	?
NSprite 	dw	?
DrawArray	db	32*16 dup ('_()_')
LineAddress	dw	   4,  44,  84, 124, 164, 204, 244, 284, 324, 364, 404, 444, 484, 524, 564, 604
		dw	 644, 684, 724, 764, 804, 844, 884, 924, 964,1004,1044,1084,1124,1164,1204,1244
		dw	1284,1324,1364,1404,1444,1484,1524,1564,1604,1644,1684,1724,1764,1804,1844,1884
		dw	1924,1964,2004,2044,2084,2124,2164,2204,2244,2284,2324,2364,2404,2444,2484,2524
		dw	2564,2604,2644,2684,2724,2764,2804,2844,2884,2924,2964,3004,3044,3084,3124,3164
		dw	3204,3244,3284,3324,3364,3404,3444,3484,3524,3564,3604,3644,3684,3724,3764,3804
		dw	3844,3884,3924,3964,4004,4044,4084,4124,4164,4204,4244,4284,4324,4364,4404,4444
		dw	4484,4524,4564,4604,4644,4684,4724,4764,4804,4844,4884,4924,4964,5004,5044,5084
		dw	5124,5164,5204,5244,5284,5324,5364,5404,5444,5484,5524,5564,5604,5644,5684,5724
		dw	5764,5804,5844,5884,5924,5964,6004,6044,6084,6124,6164,6204,6244,6284,6324,6364
		dw	6404,6444,6484,6524,6564,6604,6644,6684,6724,6764,6804,6844,6884,6924,6964,7004
		dw	7044,7084,7124,7164,7204,7244,7284,7324,7364,7404,7444,7484,7524,7564,7604,7644

RefreshStopped	db	0		; 1 if refresh incomplete
RefreshResume	dw	0		; Address to resume refresh
SuspendRefresh	dw	0		; Address of procedure to switch to
ProgramDS	dw	0		; Old DS (instead of PUSH)
ProgramSS	dw	0		; Old SS
ProgramSP	dw	0		; Old SP
ProgramCX	dw	0		; Instead of PUSH
OldEAX		dd	?
OldEBX		dd	?
OldECX		dd	?
OldEDX		dd	?
OldESI		dd	?
OldEDI		dd	?
OldEBP		dd	?
OldDS		dw	?
OldES		dw	?
OldFlags	dw	?

ShowVRAM	proc	near
		cmp	RefreshStopped, 1
		jne	@@fromStart
		mov	eax,OldEAX
		mov	ebx,OldEBX
		mov	ecx,OldECX
		mov	edx,OldEDX
		mov	esi,OldESI
		mov	edi,OldEDI
		mov	ebp,OldEBP
		mov	ds,OldDS
		mov	es,OldES
		push	OldFlags
		popf
		mov	RefreshStopped, 0
		sti
		jmp	word ptr cs:RefreshResume

@@fromStart:	mov	ProgramDS,ds
		cld
		cli
		xor	eax,eax
ifnDef noSprLimit
		mov	es, CSegAddr
		lea	di, SpriteLine
		mov	cx, MaxLine/4
		rep	stos dword ptr es:[di]
endIf
		mov	es, VRAMsegaddr
		mov	ds, VRAMsegaddr
		lea	di, WorkNAM    ; preserve for work
		mov	si, NAMbase    ; NAME table
		mov	cx, 32*24/4
		rep	movsd
		mov	si, SATbase    ; preserve for work
		mov	cx, 32	       ; Sprite Attribute Table
		rep	movsd
		mov	si, SGTbase    ;
		mov	cx, 2048/4
		rep	movsd
		sti

		add	VideoSeg,200h
		and	byte ptr VideoSeg+1,11101111b
		mov	es, VideoSeg
		mov	dx, 3CEh
		mov	ax, 0205h  ; set write mode 2
		out	dx, ax
		mov	al, 8
		out	dx, al
		inc	dx

	  ; Output pattern data - background
		lea	bx, WorkNAM ;{PNTbase}
		mov	cx, 0	    ;pattern counter

 @@NextPattern: mov	ProgramCX,cx
		mov	al, ds:[bx] ;{charcode}
		mov	ah, ch
		shl	ax, 3	    ;{pattern's data start address}

		mov	bp, cx
		shl	bp, 1
		mov	di, word ptr PattAddr[bp]

		mov	si, PATbase  ;{COLbase}
		add	si, ax
		mov	PATaddr, si
		mov	si, COLbase
		add	si, ax
		mov	COLaddr, si
		mov	cx, 8

 @@NextPattRow: mov	si, PATaddr
		mov	al, [si]
		mov	si, COLaddr
		mov	ah, [si]

		not	al     ; Output this shit:  al=PGT, ah=COL
		out	dx, al
		mov	es:[di], ah
		not	al
		out	dx, al
		mov	al, es:[di]
		ror	ah, 4
		mov	es:[di], ah

		inc	PATaddr
		inc	COLaddr
		add	di, 40
		loop	@@NextPattRow

		inc	bx
		mov	cx,ProgramCX
		inc	cx
		cmp	cx, 768
		jc	@@NextPattern

     ; Scan for invisible sprite lines
		lea	si, WorkSAT
		mov	di,offset DrawArray
		mov	ax,seg DrawArray
		mov	es,ax
		mov	nSprite, 32
		mov	bh, 0
@@CheckNextSpr: mov	bl, byte ptr ds:[si+0]	; Y coord
		cmp	bl,208
		je	@@SkipSprites
		inc	bl
		cmp	bl, MaxLine
		jc	@@NormCoord
		cmp	bl, 0F0h  ;-16
		jc	@@OutOfScreen
   @@NormCoord: movzx	ax, byte ptr ds:[si+2]	; No
ifnDef Spr8x8
		shr	al, 2	    ; is divided by 4 (16x16 SprSize)
		mov	bp, ax
		shl	bp, 5	    ; *32 - SpriteDataSize
		mov	cx, 16
else
		mov	bp, ax
		shl	bp, 3	    ; *8 - SpriteDataSize
		mov	cx, 8
endIf
		add	bp, offset WorkSGT ; address in VRAM

       @@1:	cmp	bl, MaxLine  ; is line on screen?
		jnc	@@LineDone
ifnDef Spr8x8
		mov	al, ds:[bp+10h] ; test if sprite line contains
		mov	ah, ds:[bp+00h] ; something.
else
		mov	ah, byte ptr ds:[bp]
		mov	al, 0
endIf
ifnDef noSprLimit
		inc	byte ptr SpriteLine[bx]
endIf
		test	ax,ax
		jz	@@LineDone
ifnDef NoSprLimit
		cmp	byte ptr SpriteLine[bx],4
		ja	@@LineDone
endIf
		stosw				; Store pattern line
		mov	al,ds:[si+1]		; X coord
		mov	ah,bl			; Y coord
		stosw
		mov	al,ds:[si+3]		; Color & shift
		stosb
		test	al,00001111b
		jnz	@@LineDone
		sub	di,5
    @@LineDone: inc	bl
		inc	bp
		loop	@@1

 @@OutOfScreen: add	si, 4	; Next SAT record
		dec	nSprite
		jnz	@@CheckNextSpr

@@SkipSprites:	mov	ax,VideoSeg
		mov	es,ax
		mov	ax,seg DrawArray
		mov	ds,ax

		mov	dx,3CEh
		mov	ax,0005h			; set write mode 0
		out	dx,ax
		mov	ax,0F01h
		out	dx,ax

@@nextLine:	cmp	di,offset DrawArray
		jbe	@@drawDone
		sub	di,5

		movzx	bx,byte ptr [di+3]		; Y coord
		shl	bx,1
		mov	si,LineAddress[bx]		; Addr
		mov	ah,byte ptr [di+4]		; Color
		mov	cx,ax
		shr	cx,10				; X-32?
		and	cl,32
		and	ah,15
		mov	al,0
		out	dx,ax

		movzx	ax,byte ptr [di+2]		; X coord
		sub	ax,cx

		setl	bl
		cmp	ax,-8
		setl	cl
		add	bl,cl
		cmp	ax,-16
		jle	@@nextLine
		mov	bh,0
		shl	bx,1
		jmp	word ptr cs:@@jumpTbl1[bx]
@@jumpTbl1:	dw	offset @@checkHi, offset @@clipOneL, offset @@clipTwoL

@@checkHi:	cmp	ax,240
		setg	bl
		cmp	ax,248
		setge	cl
		add	bl,cl
		shl	bx,1
		jmp	word ptr cs:@@jumpTbl2[bx]
@@jumpTbl2:	dw	offset @@noClip, offset @@clipOneH, offset @@clipTwoH

@@clipOneL:	mov	cl,al
		and	cl,7
		sub	cl,16
		neg	cl
		sar	ax,3
		add	si,ax
		movzx	eax,word ptr [di]
		shl	eax,cl

		rol	eax,16
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si+1],al

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si+2],al

		jmp	@@nextLine

@@clipTwoL:	mov	cl,al
		and	cl,7
		sub	cl,16
		neg	cl
		sar	ax,3
		add	si,ax
		movzx	eax,word ptr [di]
		shl	eax,cl

		mov	al,8
		out	dx,ax
		or	es:[si+2],al

		jmp	@@nextLine

@@clipOneH:	mov	cl,al
		and	cl,7
		sub	cl,16
		neg	cl
		sar	ax,3
		add	si,ax
		movzx	eax,word ptr [di]
		shl	eax,cl

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si],al

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si+1],al

		jmp	@@nextLine

@@clipTwoH:	mov	cl,al
		and	cl,7
		sub	cl,16
		neg	cl
		sar	ax,3
		add	si,ax
		movzx	eax,word ptr [di]
		shl	eax,cl

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si],al

		jmp	@@nextLine

@@noClip:	mov	cl,al
		and	cl,7
		sub	cl,16
		neg	cl
		sar	ax,3
		add	si,ax
		movzx	eax,word ptr [di]
		shl	eax,cl

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si],al

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si+1],al

		rol	eax,8
		mov	ah,al
		mov	al,8
		out	dx,ax
		or	es:[si+2],al

		jmp	@@nextLine
@@drawDone:	mov	SuspendRefresh, 0
		mov	dx,03D4h
		mov	al,12
		mov	ah,byte ptr VideoSeg+1
		shl	ah,4
		out	dx,ax
		mov	ds,ProgramDS
		ret
ShowVRAMend	label	near
ShowVRAM	endp

L013E		proc	near  ; Read VDP status
		cmp	VDPstat, 0
		mov	al, 00h
		je	@@ResVDP
		mov	al, 80h
@@ResVDP:	mov	VDPstat, 0  ; enable "VDP interrupts"
		ret
L013E		endp

BorderCol	db	0
SetBorder	proc	near
		push	cx
		mov	ch, BorderCol
		mov	cl, 0
		push	dx
		push	ax
		xor	ax, ax
		mov	dx, VideoChip
		add	dl, 6
		shr	cx, 8
		and	cl, 0Fh
		mov	al, cl
		add	cx, cx
		add	cx, ax
		lea	bx, Pal
		add	bx, cx
		mov	al, ah
		mov	dl, 0C8h
		out	dx, al
		inc	dx
		jmp	$+2    ; small pause for some @#$%^ VGA cards
		jmp	$+2
		jmp	$+2
		mov	al, cs:[bx]
		out	dx, al
		mov	al, cs:[bx+1]
		out	dx, al
		mov	al, cs:[bx+2]
		out	dx, al
		pop	ax
		pop	dx
		pop	cx
		ret
SetBorder	endp

L0047		proc	near	 ; WRTVDP  ( cl )<-ch (data)
		push	cx
		push	bx
		and	cl,07Fh
		cmp	cl, 8
		jnc	@@Exit
		mov	bl, cl
		xor	cl, cl
		xor	bh, bh
		mov	ds:[0F3DFh+bx],ch
		shl	bl, 1
		jmp	word ptr cs:@@RegTable+bx
   @@RegTable:	dw	offset @@Reg00 ; ModeReg 1
		dw	offset @@Reg01 ; ModeReg 2
		dw	offset @@Reg02 ; Pnt Table
		dw	offset @@Reg03 ; Ct  Table
		dw	offset @@Reg04 ; Pgt Table
		dw	offset @@Reg05 ; Sat Table
		dw	offset @@Reg06 ; Sgt Table
		dw	offset @@Reg07 ; colors
    @@Reg00:	jmp	@@Exit
    @@Reg01:	push	dx
		mov	dx,VideoChip
		add	dl,6
		in	al,dx
		mov	al,ch
		and	al,01000000b			; Enable display?
		shr	al,1
		mov	dx,3C0h
	       ;out	dx,al
		test	ch,00100000b			; Enable interrupts?
		setz	VDPstat
		pop	dx
		jmp	@@Exit
    @@Reg02:	shl	cx, 2
		mov	NAMbase, cx
		jmp	@@Exit
    @@Reg03:	and	ch, 080h
		shr	cx, 2
		mov	COLbase, cx
		jmp	@@Exit
    @@Reg04:	and	ch, 004h
		shl	cx, 3
		mov	PATbase, cx
		jmp	@@Exit
    @@Reg05:	shr	cx, 1
		mov	SATbase, cx
		jmp	@@Exit
    @@Reg06:	shl	cx, 3
		mov	SGTbase, cx
		jmp	@@Exit
    @@Reg07:	; Color change for (color0 & border) low 4 bytes
		cmp	BorderCol, ch
		je	@@Exit
		mov	BorderCol, ch
		call	SetBorder
    @@Exit:	pop	bx
		pop	cx
		_EI
		ret
L0047		endp

L004A		proc	near  ; VPEEK [bx] -> al
		and	bx, 3FFFh
		mov	es, VRAMsegAddr
		mov	al, es:[bx]
		ret
L004A		endp

L004D		proc	near  ; VPOKE [bx] a byte (al)
		and	bx, 3FFFh
		mov	es, VRAMsegAddr
		mov	es:[bx], al
		ret
L004D		endp

L0050		proc	near
		lahf
		and	bx, 3FFFh
		mov	rVRAMptr, bx
		sahf
		ret
L0050		endp

L0053		proc	near ; SETWRT [bx]-vram addr
		lahf
		and	bx, 3FFFh
		mov	wVRAMptr, bx
		sahf
		ret
L0053		endp

L0056		proc	near ; FILVRM [bx]-vram addr, cx-len, al-byte
		cld
		push	di
		mov	es, VRAMsegAddr
		and	bx, 3FFFh
		mov	di, bx
		rep	stosb
		pop	di
		ret
L0056		endp

L0059		proc	near  ; LDIRVM	Send VRAM block to RAM, bx-VRAM, dx-RAM
		cld
		mov	IRQdisabled, 1
		push	si
		push	di
		mov	es, word ptr cs:DSegAddr
		mov	ds, VRAMsegAddr
		and	bx, 3FFFh
		mov	si, bx ; source is VRAM ds:bx
		mov	di, dx ; destination is RAM es:dx
		rep	movsb
		mov	dx, di
		pop	di
		pop	si
		mov	ds, word ptr cs:DSegAddr
		mov	IRQdisabled, 0
		ret
L0059		endp

L005C		proc	near  ; LDIRVM	Send byte block to VRAM, bx-ram, dx-vr
		cld
		push	si
		push	di
		mov	es, VRAMsegAddr
		xchg	bx, dx
		and	bx, 3FFFh
		mov	si, dx ; source is RAM ds:bx
		mov	di, bx ; destination is VRAM es:dx
		rep	movsb
		mov	dx, si
		pop	di
		pop	si
		ret
L005C		endp

L0062		proc	near	; Set screen color
		mov	al,ds:[0F3EBh]
		mov	BorderCol,al
		call	SetBorder
		ret
L0062		endp

L0069		proc	near	; Clear all sprites
		mov	es, VRAMsegAddr
		xor	eax, eax
		mov	di, SATbase
		mov	cx, 32
		rep	stosd
		mov	di, SGTbase
		mov	cx, 2048/4
		rep	stosd
		ret
L0069		endp

L0072		proc	near	; Set Screen2 & clear screen
		cld
		mov	es, VRAMsegAddr
		mov	cx, 4000h / 4
		xor	eax, eax
		xor	di, di
		rep	stos dword ptr es:[di]
L0072		endp

L007E		proc	near	; Set Screen2
		mov	SGTbase,3800h
		mov	COLbase,2000h
		mov	PATbase,0000h
		mov	NAMbase,1800h
		mov	SATbase,1B00h
		ret
L007E		endp

Out98		proc	near  ; Send a byte to VRAM ( VRAMptr )
		push	bx
		lahf
		mov	es, VRAMsegAddr
		mov	bx, wVRAMptr
		and	bx, 3FFFh
		mov	es:[bx], al
		inc	wVRAMptr
		sahf
		pop	bx
		ret
Out98		endp

Out99		proc	near	; Set destination VRAM address
		pushf
		push	ax
		xor	@@lohi,1
		jz	@@hi
		mov	@@data,al
		jmp	@@endm
@@hi:		mov	ah,al
		and	ah,11000000b
		cmp	ah,10000000b
		jne	@@setAddr
		push	cx
		mov	cl,al
		and	cl,00111111b
		mov	ch,@@data
		call	L0047
		pop	cx
		jmp	@@endm
@@setAddr:	test	ah,ah
		je	@@setRead
		mov	ah,al
		mov	al,@@data
		mov	wVRAMptr, ax
		jmp	@@endm
@@setRead:	mov	ah,al
		mov	al,@@data
		mov	rVRAMptr, ax
@@endm: 	pop	ax
		popf
		ret
@@lohi		db	0
@@data		db	0
Out99		endp

In98		proc	near		; Load a byte from VRAM ( VRAMptr )
		push	bx
		lahf
		mov	es, VRAMsegAddr
		mov	bx, rVRAMptr
		and	bx, 3FFFh
		mov	al, es:[bx]
		inc	rVRAMptr
		sahf
		pop	bx
		ret
In98		endp

In99		proc	near		; Seems to be a kind of EI for VDP
		mov	VDPstat,0	; Read VDP status register (?)
		ret
In99		endp
