; 
;  ENVIR.ASM  - procs for environment (keyboard, etc) 
; 						      
; 
		include \msx\asm\AdlibIO.asm

ifnDef SpeakerVol
SpeakerVol	equ	6
endIf

IntFreq 	equ	60
SoundMultiplier =	16
MSXvideoDivider =	1234DCh / (IntFreq * SoundMultiplier)

SysTimer	dw	?    ; Maintain 18hz system interrupts rate
PRGTimer	db	?    ; Countdown for 50hz
Increm          dw      0    ; Incrementor, every 50t
IsOverflowInc   db      0

GameStop	db	0    ; if non-zero no interrupts

Decider 	dw	0    ; decs 450 t/s
DevSpeaker	equ	0
DevAdlib	equ	1

; These lines must be in original order!!
VoiceAFreq	dw	00000h	 ; 0-1
VoiceBFreq	dw	00000h	 ; 2-3
VoiceCFreq	dw	00000h	 ; 4-5
NPeriod 	db	000h	 ; 6
MixMode 	db	3Fh	 ; 7
VoiceAVol	db	00h	 ; 8
VoiceBVol	db	00h	 ; 9
VoiceCVol	db	00h	 ; A
WaveFreq	dw	0000h	 ; B-C
Wave		db	000h	 ; D
JoystickA	db	0FFh	 ; E (all bits are off)
psgPortA	db	0FFh	 ; F
VoiceAdec       dw      0
VoiceBdec	dw	0
VoiceCdec	dw	0

port0AAh	db	?	 ; I/O port 0AAh (kbd row)

SoundDevice	db	0, 0

InitProcs	dw	offset IBMPCinit
		dw	offset AdlibInit

SoundProcs	dw	offset DummyProc
		dw	offset AdLib

NoSoundProcs	dw	offset PCnoSound
		dw	offset AdLibnoSound

CurVoice	db	0
nSkipChannel	db	0
PSGregister	db	0		; Currently addresable PSG register
NoiseSeed	dw	0
NoiseActive	db	0
CallVideo	db	0
SoundRefresh	dw	offset DummyProc
TempAX		dw	0
TempBX		dw	0
TempCX		dw	0
TempDX		dw	0

DummyProc	proc	near
		ret
DummyProc	endp

HookHandler	proc	near
		push	bx		; All just as in original MSX BIOS
		push	dx		; (learned from ZANAC) (see 0FD9Ah)
		push	cx
		PUSH_AF
		EXX
		EX_A_A
		push	bx
		push	dx
		push	cx
		PUSH_AF
		push	si
		push	di

		call	word ptr ds:[0FD9Bh]
		call	word ptr ds:[0FDA0h]

		_EI
		pop	di
		pop	si
		POP_AF
		pop	cx
		pop	dx
		pop	bx
		EX_A_A
		EXX
		POP_AF
		pop	cx
		pop	dx
		pop	bx
		ret
HookHandler	endp

; << Program Entry Point >> 
ProgStart:	mov	ax,seg ZDatSeg
		mov	ss,ax
		mov	sp,0FFFEh
		call	ShowLogo
		mov	ax,seg _VRAM
		mov	es,ax
		xor	di,di
		mov	cx,16384/4
		xor	eax,eax
		rep	stosd
		mov	bx,seg ZDatSeg
		mov	ds,bx
		mov	es,bx
		mov	di,0C000h
		mov	cx,4000h/4
		rep	stosd
		mov	word ptr ds:[0FD9Bh],offset DummyProc
		mov	word ptr ds:[0FDA0h],offset DummyProc

		call	InitEnvir
		call	VideoInit
		jmp	ModStart

;  ax - exitcode 
HaltProc	proc	far
		push	ax
		call	FreeEnvir
		call	FreeVideo
		pop	ax
		cmp	ax, MsgNum
		jnc	@@JustHalt     ; MessageNo is invalid
		mov	bx, ax
		shl	bx, 1
		mov	ds, CSegAddr
		mov	dx, HaltMsg+bx ; proper halt message
		mov	ah, 9
		int	21h
		mov	ax, 0B800h
		mov	es, ax
		mov	cx, 80
		mov	al, 01Fh
		xor	di, di
    @@NextAttr: inc	di
		stosb
		loop	@@NextAttr
   @@JustHalt:	mov	ax, 4C00h
		int	21h
HaltProc	endp

PSGfh           dw      ?
PSGfile         db      'psg.dat', 0

;  ********************************************
InitEnvir	proc	far
		mov	ax, 3508h
		int	21h
		mov	word ptr cs:[OldInt08+0], bx
		mov	word ptr cs:[OldInt08+2], es
		push	ds
		mov	dx, seg    Int08Handler
		mov	ds, dx
		mov	dx, offset Int08Handler
		mov	ax, 2508h
		int	21h
		pop	ds
    ifndef NoTimerUp
		mov	al, 36h
		out	43h, al
		mov	ax,MSXvideoDivider
		jmp	$+2
		out	40h, al
		xchg	ah, al
		jmp	$+2
		out	40h, al
    endif
		mov	SysTimer, 1
		mov	PrgTimer, 1
		mov	ax, 3509h
		int	21h
		mov	word ptr cs:[OldInt09+0], bx
		mov	word ptr cs:[OldInt09+2], es
		push	ds
		mov	dx, seg    Int09Handler
		mov	ds, dx
		mov	dx, offset Int09Handler
		mov	ax, 2509h
		int	21h
		pop	ds
		call	DetectHardware

ifdef   MegaShit
                mov     dx, cs
                mov     ds, dx
                mov     dx, offset PSGfile
                mov     ah, 3Ch
                xor     cx, cx
                int     21h      ; Create File
                jc      _fo_Failed

                mov     PSGfh, ax ; save file handle
 _fo_Failed:

endif
                mov     ds, DSegAddr

                retf
InitEnvir	endp

FreeEnvir	proc	far
		cli
		mov	al, 36h
		out	43h, al
		xor	al, al
		jmp	$+2
		out	40h, al
		jmp	$+2
		out	40h, al
		push	ds
; Free Timer
		mov	dx, word ptr cs:[OldInt08+0]
		mov	ds, word ptr cs:[OldInt08+2]
		mov	ax, 2508h
		int	21h
; Free Keyboard
		mov	dx, word ptr cs:[OldInt09+0]
		mov	ds, word ptr cs:[OldInt09+2]
		mov	ax, 2509h
		int	21h
		pop	ds
		sti
		call	NoSound

ifdef MegaShit
                call    FlushPSGbuf

                mov     ah, 3Eh
                mov     bx, PSGfh
                int     21h

endif

                retf
FreeEnvir	endp
;
; Hangs up, if not catched Timer!!!
;
DetectHardware	proc	near
		SendAdlib 0460h
		SendAdlib 0480h
		ReadAdlib
		mov	S1, al
		SendAdlib 02FFh
		SendAdlib 0421h
		mov	Decider, 36   ;  80 mcs
    @@Wait80ms: cmp	Decider, 0
		jnz	@@Wait80ms
		ReadAdlib
		mov	S2, al
		SendAdlib 0460h
		SendAdlib 0480h
		mov	al, S1
		and	al, 0E0h
		jnz	@@NoAdlib
		mov	al, S2
		and	al, 0E0h
		cmp	al, 0C0h
		jnz	@@NoAdlib
		mov	SoundDevice, DevAdlib
  @@NoAdlib:	;  Maybe detect smth else here
  @@DetectDone:
		mov	bx, word ptr SoundDevice
		shl	bx, 1
		call	word ptr cs:[InitProcs+bx]
		retn
DetectHardware	endp

     S1 	db	(?)
     S2 	db	(?)

;	     {00} {01} {02} {03} {04} {05} {06} {07} {08} {09} {0A} {0B} {0C} {0D} {0E} {0F}
KbdData  db  000h,000h,020h,030h,040h,050h,060h,070h,080h,011h,021h,010h,000h,000h,067h,047h
	 db  074h,055h,033h,084h,025h,075h,035h,073h,054h,064h,000h,000h,087h,026h,072h,015h
	 db  023h,043h,053h,063h,083h,014h,024h,000h,000h,000h,016h,000h,085h,065h,013h,045h
	 db  082h,044h,034h,000h,000h,000h,016h,047h,036h,018h,046h,066h,076h,086h,017h,027h ;Alt will be GRAPH
; 40h
	 db  000h,000h,000h,000h,000h,000h,056h,028h,068h,000h,000h,058h,000h,088h,000h,077h ;Scroll Lock will be KANA, End will be SELECT
	 db  078h,000h,038h,048h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
	 db  000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
	 db  000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h

KeyRow	 db	 0FFh ;{00} 0 '6/&','5/%','4/$','3/#','2/"','1/!',';/+','9/)'
	 db	 0FFh ;{01} 1 '','','','','','','',''
	 db	 0FFh ;{02} 2 '','','','','','','',''
	 db	 0FFh ;{03} 3 '','','','','','','',''
	 db	 0FFh ;{04} 4 '','','','','','','',''
	 db	 0FFh ;{05} 5 '','','','','','','',''
	 db	 0FFh ;{06} 6 'F3','F2','F1','rus','caps','graph','ctrl','shift'
	 db	 0FFh ;{07} 7 'Ent','sel','BS','Stop','Tab','Esc','F5','F4'
	 db	 0FFh ;{08} 8 'RGHT','DOWN','UP','LEFT','DEL','INS','HOME','Space'
	 db	 0FFh ;{09} 9 '','','','','','','',''
	 db	 0FFh ;{0A} A '','','','','','','',''
	 db	 0FFh ;{0B}
	 db	 0FFh ;{0C}
	 db	 0FFh ;{0D}
	 db	 0FFh ;{0E}
	 db	 0FFh ;{0F}
PrgExit  db	 0

L0141		proc	near  ; Read Keyboard, al - row number, al - status
		cmp	al,010h
		ja	@@outOfRange
		push	bx
		mov	bx, offset KeyRow
		add	bl, al
		adc	bh, 0
	       ;mov	cl, al	;??? Why ???
		mov	al, byte ptr cs:[bx]
		clc	      ; in original MSX-BIOS this flag is destroyed
		pop	bx
		mov	IRQdisabled, 0
		ret
@@outOfRange:	mov	al,0FFh
		ret
L0141		endp

OldInt09	dd	(?)
Int09Handler	proc	far
		push ax
		push bx
		push cx

		in   al, 60h
		mov  ch, al

		in   al, 61h
		mov  ah, al
		or   al, 80h
		out  61h, al
		xchg ah, al
		out  61h, al

		cmp  ch,1		     ; Check for menu key
		sete al
		or   PrgExit,al

		mov  al, ch
		and  al, 7Fh

		mov  bx, offset KbdData
		SegCS xlat
		mov  cl, al
		and  al, 0Fh
		mov  bx, offset KeyRow
		add  bl, al
		adc  bh, 0

		shr  cl, 4
		jcxz @Exit

		dec  cl
		mov  al, 1
		shl  al, cl

		or   ch, ch
		jns  @Pressed
		or   byte ptr cs:[bx], al
		jmp  @Exit
@Pressed:	not  al
		and  byte ptr cs:[bx], al
@Extended:
@Exit:		cmp	GameStop, 0

ifnDef noKeyboardHook
		jz	@@MyHandler
else
		push	ds
		xor	ax,ax
		mov	ds,ax
		mov	ax,ds:[041Ah]
		mov	ds:[041Ch],ax
		pop	ds
endIf

		pop	cx
		pop	bx
		pop	ax
		jmp	dword ptr OldInt09

@@MyHandler:	mov	al, 20h
		out	20h, al

		pop	cx
		pop	bx
		pop	ax
		iret
Int09Handler	endp

OldInt08	dd	(?)
Int08Handler	proc	far
		push	ax
		mov	al, 60h 	; Enable back interrupts
		out	20h, al
		sti
		pop	ax
		cmp	GameStop,0
		jne	Look4system

                dec     PRGtimer
		jne	@@onlySound
		mov	PRGtimer, SoundMultiplier

    ifdef MegaShit
                add     Increm, 1
                jnc     @NoOver
                mov     IsOverflowInc, 1
     @NoOver:
    endif

                cmp     Decider, 1
		cmc
		sbb	Decider, 0   ; always dec. to 0

		cmp	IRQdisabled, 0; if was DI
		jnz	@@onlySound

		cmp	SuspendRefresh,0
		jz	@@callHook
		cmp	word ptr [esp+2],seg MainSeg
		jne	@@callHook
		cmp	word ptr [esp],offset ShowVRAM
		jb	@@callHook
		cmp	word ptr [esp],offset ShowVRAMend
		ja	@@callHook
		push	ax
		xor	ax,ax
		xchg	ax,SuspendRefresh
		xchg	ax,[esp+2]
		mov	RefreshResume,ax
		mov	ax,[esp+6]
		mov	OldFlags,ax
		pop	ax

		mov	OldEAX,eax
		mov	OldEBX,ebx
		mov	OldECX,ecx
		mov	OldEDX,edx
		mov	OldESI,esi
		mov	OldEDI,edi
		mov	OldEBP,ebp
		mov	OldDS,ds
		mov	OldES,es
		mov	ds,ProgramDS
		mov	RefreshStopped,1
		mov	di,[esp+8]
		mov	si,[esp+10]
		mov	bx,[esp+16]
		mov	dx,[esp+18]
		mov	cx,[esp+20]
		mov	ax,[esp+22]

@@callHook:	push	ax
		push	es
		push	ds
		mov	ax, seg ZDatSeg
		mov	ds, ax
		call	HookHandler  ; now call Hook FD9A
		pop	ds
		pop	es
		pop	ax
@@onlySound:	call	SoundRefresh
Look4System:	add	SysTimer,MSXvideoDivider
		jc	@@DoOld08
		iret
@@DoOld08:	jmp	dword ptr OldInt08 ; perform system needs
Int08Handler	endp

RefreshOnce	proc	near
		call	ShowVRAM
		cmp	PrgExit, 0
		je	@@locEx
		mov	GameStop, 1
		call	NoSound
		call	LoadSaveMenu
		call	VideoInit
		mov	GameStop, 0
		mov	PrgExit, 0
@@locEx:	ret
RefreshOnce	endp

DrawScreen	proc	near
		pushf
		pusha
		call	RefreshOnce
		popa
		popf
		ret
DrawScreen	endp

L0024		proc	near ; EnaSlot
		ret
L0024		endp

PCsound 	proc	near
		push	dx
		mov	ax, 10
		mul	bx
		pop	dx
		mov	bx, ax
SetCh2count:	in	al, 61h
		test	al, 3
		jne	@@Skip
		or	al, 3
		out	61h, al
		mov	al, 0B6h
		out	43h, al
@@Skip: 	mov	al, bl
		out	42h, al
		mov	al, bh
		out	42h, al
@@TooLow:	ret
PCsound 	endp

PCnosound	proc	near
		in	al, 61h
		and	al, 0FCh
		out	61h, al
		ret
PCnosound	endp

DummySound	proc	near
		ret
DummySound	endp

;* Enable (AL=1) or disable (AL=0) music *;
msxSetSound	proc	far
		test	al, al
		jz	@@SkipIt
		mov	bx, word ptr SoundDevice
		shl	bx, 1
		call	word ptr InitProcs[bx]
@@SkipIt:	ret
msxSetSound	endp

; init PCspeaker. What a big  job!
IBMPCinit	proc	near
		mov	SoundRefresh, offset IBMPCplay
		ret	; good enough
IBMPCinit	endp

Envelope	proc	near
		push	dx
		xor	bx,bx
		mov	cx,3
@@1:		mov	al,VoiceAvol[bx]
		test	al,00010000b
		jz	@@nextVoice
		mov	dx,WaveFreq
		shl	bx,1
		not	dx
		and	dh,00111111b
		add	VoiceAdec[bx],dx
		sbb	al,0
		shr	bx,1
		test	al,00010000b
		jnz	@@SetIt
		mov	al,0
@@SetIt:	mov	VoiceAvol[bx],al
@@nextVoice:	inc	bx
		loop	@@1
		pop	dx
		ret
Envelope	endp

IBMPCplay	proc	near
		push	ax
		push	bx
		push	cx
		push	fs
		mov	ax,seg MusicFlag
		mov	fs,ax
		cmp	fs:MusicFlag,1
		jne	@@noSound

		cmp	PRGtimer, SoundMultiplier
		je	@@nextChannel
		call	Envelope
		cmp	NoiseActive,1
		je	@@makeNoise
		jmp	@@locEx

@@nextChannel:	mov	NoiseActive,0
		mov	nSkipChannel,7
@@nextVoice:	dec	nSkipChannel
		jz	@@noSound
		mov	cl,CurVoice
		mov	bl,cl
		mov	al,cl
		inc	al
		cmp	al,6
		jb	@@voiceOK
		mov	al,0
@@voiceOK:	mov	CurVoice,al
		cmp	bl,3
		jb	@@noNoise
		sub	bl,3
@@noNoise:	mov	bh,0
		mov	al,VoiceAvol[bx]
		and	al,0Fh
		cmp	al,SpeakerVol
		jbe	@@nextVoice
		mov	al,1
		shl	ax,cl
		test	MixMode,al
		jnz	@@nextVoice
		cmp	cl,2
		ja	@@makeNoise
		shl	bx,1
		mov	bx,VoiceAfreq[bx]
		test	bx,bx
		je	@@nextVoice
		call	PCsound
@@locEx:	pop	fs
		pop	cx
		pop	bx
		pop	ax
		ret
@@noSound:	call	PCnoSound
		jmp	@@locEx
@@makeNoise:	mov	NoiseActive,1
		mov	bx,NoiseSeed
		rol	bx,5
		xor	bx,0DEADh
		add	bl,bh
		sbb	bh,05Eh
		mov	NoiseSeed,bx
		and	bh,0Fh
		add	bh,6
		call	SetCh2count
		jmp	@@locEx
IBMPCplay	endp

NoSound 	proc	near
		mov	bx, word ptr SoundDevice
		shl	bx, 1
		jmp	word ptr cs:[NoSoundProcs+bx]
NoSound 	endp

L0020		proc	near
		cmp	bx,dx
		ret
L0020		endp

L003B		proc	near
		int 3
		ret
L003B		endp

L0041		proc	near
		mov	dx,VideoChip
		add	dl,6
		in	al,dx
		mov	al,0
		mov	dx,3C0h
		out	dx,al
		ret
L0041		endp

L0044		proc	near
		mov	dx,VideoChip
		add	dl,6
		in	al,dx
		mov	al,20h
		mov	dx,3C0h
		out	dx,al
		ret
L0044		endp

; Stop music; clear & init PLAY queues; no sound
L0090		proc	near
		call	NoSound
		ret
L0090		endp

ifdef    Megashit

 PSGbuf          db   4000 dup (0)   ; Special buffer

PSGbp           dw   0

FlushPSGbuf     proc    near
                mov     GameStop, 1   ; pause the game

                pusha
                push    ds

                mov     bx, PSGfh
                mov     cx, PSGbp
                mov     dx, cs
                mov     ds, dx
                mov     dx, offset PSGbuf
                mov     ah, 40h
                int     21h

                mov     PSGbp, 0

                pop     ds
                popa

                mov     GameStop, 0
                ret
FlushPSGbuf     endp

endif

; write to PSG, send al-regNo, dl-data
L0093		proc	near
		push	bx
		push	ax
		pushf
		cmp	al, 0Eh
		jc	@@PSGwrite  ; test where is write JOYSTICK or PSG
		mov	psgPortA, dl
		jmp	@@Exit

   @@PSGwrite:

ifdef MegaShit
                push    si
                push    ax

                mov     bx, offset VoiceAfreq     ; skip, if value is
                add     bl, al                    ; not changed
		adc	bh, 0
                cmp     cs:[bx], dl
                jz      NoFlush

    ;            mov     ah, dl
    ;            cmp     ax, 0B807h  ; Too often command, so skip it
    ;            jz      NoFlush


                mov     si, PSGbp
                mov     bx, word ptr Increm
                mov     Increm, 0
                mov     word ptr cs:[PSGbuf + si+0], bx  ; 0,1
                mov     byte ptr cs:[PSGbuf + si+2], al  ; 2
                mov     byte ptr cs:[PSGbuf + si+3], dl  ; 3
                add     si, 4
                mov     PSGbp, si

                cmp     si, 4000
                jl      NoFlush

                call    FlushPSGbuf
      NoFlush:
                pop     ax
                pop     si
endif

                mov     bx, offset VoiceAfreq
		add	bl, al
		adc	bh, 0
		mov	cs:[bx], dl
		mov	bx,seg MusicFlag
		mov	fs,bx
		cmp	fs:MusicFlag, 1
		jne	@@Exit
		mov	bx, word ptr SoundDevice
		shl	bx, 1
		call	word ptr cs:[SoundProcs+bx]
    @@Exit:	popf
		pop	ax
		pop	bx
		ret
L0093		endp

L0096		proc	near ; read from PSG or joystick, al-regNo, get al-data
		push	bx
		cmp	al,0Eh
		jbe	@@regOK
		mov	al,0Eh
@@regOK:	mov	bx, offset VoiceAfreq
		add	bl, al
		adc	bh, 0
		mov	al,cs:[bx]
		pop	bx
		ret
L0096		endp

; Display functional key list
L009C		proc	near
		int 3
		ret
L009C		endp

; Read (wait) a keystroke; return AL = code
L009F		proc	near
		mov	GameStop,1
		mov	ax,0C01h
		int	21h
		mov	GameStop,0
		ret
L009F		endp

L00D5		proc	near
		test	al,al
		mov	al,0
		jnz	@@joystick
		push	bx
		mov	bl,byte ptr KeyRow[8]
		mov	bh,0
		shr	bl,4
		mov	al,StickVal[bx]
		pop	bx
@@joystick:	ret
; 4 lower bits are keys:	
StickVal	db	0     ; 0000
		db	3     ; 0001
		db	5     ; 0010
		db	4     ; 0011
		db	1     ; 0100
		db	2     ; 0101
		db	0     ; 0110
		db	3     ; 0111
		db	7     ; 1000
		db	0     ; 1001
		db	6     ; 1010
		db	5     ; 1011
		db	8     ; 1100
		db	1     ; 1101
		db	7     ; 1110
		db	0     ; 1111
L00D5		endp

L00D8		proc	near
		test	al,al
		mov	al,0
		jnz	@@joystick
		test	byte ptr KeyRow[8],0000001b
		jnz	@@joystick
		mov	al,255
@@joystick:	ret
L00D8		endp

; Start tape and load header
L00E1		proc	near
		int 3
		ret
L00E1		endp

; Read byte from tape into A
L00E4		proc	near
		int 3
		ret
L00E4		endp

; Stop reading tape
L00E7		proc	near
		int 3
		ret
L00E7		endp

; Enable motor and write header
L00EA		proc	near
		int 3
		ret
L00EA		endp

; Write A to tape
L00ED		proc	near
		int 3
		ret
L00ED		endp

; Stop writing to tape
L00F0		proc	near
		int 3
		ret
L00F0		endp

; Motor on/off (A)
L00F3		proc	near
		int 3
		ret
L00F3		endp

; Turn CAPS on(al=0) / off(al<>0)
L0132		proc	near
		ret
L0132		endp

L0135		proc	near
;		test	al,al	; Risout uses it (?)
;		setne	al
;		mov	ah,al
;		shl	al,1
;		or	ah,al
;		in	al,61h
;		and	al,not 3
;		or	al,ah
;		out	61h,al
		ret
L0135		endp

; Read Primary Slot Register
L0138		proc	near
		mov	al,11010100b ; RAM ROM ROM BIOS
		ret
L0138		endp

; Write to primary slot register
L013B		proc	near
		ret
L013B		endp

; Clear keyboard buffer
L0156		proc	near
		mov	ax,0C06h
		mov	dl,0FFh
		int	21h
		ret
L0156		endp

Info		db	'MSX Recompiler System',4
Copyright	db	'Copyright (c) 1994-1995 by FRIENDS software',4
Authors 	db	'Programmed by R0B0drunk',4
About		db	'(100% Assembler programming)',4
Action		db	'Hail all FRIENDS like:',4
FucksGoesTo	db	'AndyZ, BC, GameLord!',4
AndThis 	db	'Look for our newest games!'

MsgNum		equ	1   ; total two messages
HaltNormal	equ	0
HaltNoMem	equ	1

HaltMsg 	dw	offset Msg_noError

Msg_noError	db	' Program terminated.',13,10,'$'
RegisterI	db	?
RegisterR	dd	?

TempFlag	dw	?
DJNZflag	dw	?
