// sound.c
#include <windows.h>
#include <mmsystem.h>
#include <assert.h>
#include <string.h>
#include "resource.h"
#include "msx.h"
#include "sound.h"
#include "dialogs.h"
#include "midi.h"

SOUNDINFO			g_sndinf ;
HMIDIOUT			hMidi ;
extern const char	g_szAppName[] ;
extern HWND		g_hwndMain ;
extern BYTE		PSGReg[] ;
BYTE				PSGVol[3], PSGNot[3] ;

int TPtoNote (int tp)
	{
	int		n ;
	static const int BASED_CODE	tptbl[] = {
		9, 9, 10, 10, 11, 12, 12, 13, 14, 15, 16, 17, 18, 
		19, 20, 21, 22, 24, 25, 26, 28, 30, 31, 33, 35, 
		37, 39, 42, 44, 47, 50, 52, 56, 62, 66, 70, 74, 
		78, 83, 88, 93, 99, 104, 111, 117, 124, 131, 139, 
		147, 156, 165, 175, 186, 197, 208, 221, 234, 247, 
		262, 278, 294, 312, 330, 350, 371, 393, 416, 441, 
		467, 494, 524, 555, 588, 623, 660, 699, 741, 785, 
		831, 881, 933, 988, 1047, 1109, 1175, 1245, 1319, 
		1398, 1481, 1569, 1662, 1761, 1866, 1976, 2094, 
		2218, 2350, 2490, 2638, 2795, 2961, 3137, 3324, 
		3521, 3731, 4096 } ;
	
	assert (tp >= 0 && tp < 4096) ;
	
	if (tp < 8)
		return -1 ;
	else
		{
		n = 0 ;
		while (tptbl[n] <= tp)
			n++ ;
		
		return 127 - n ;
		}
	}

void SoundOpen ()
	{
	MIDIOUTCAPS	caps ;
	BOOL			bFound ;
	char			szBuf[MAXERRORLENGTH] ;
	UINT			u ;
	int			i ;
	
	hMidi = NULL ;
	
	if (g_sndinf.szDevice[0] == 0)
		return ;
	
	bFound = FALSE ;
	for (i=-1;i<(int)midiOutGetNumDevs ();i++)	
		{
		if (!midiOutGetDevCaps (i, &caps, sizeof (MIDIOUTCAPS) ) && 
			!strcmp (caps.szPname, g_sndinf.szDevice) )
			{
			bFound = TRUE ;
			break ;
			}
		}
	
	if (bFound == FALSE)
		{
		MessageID (g_hwndMain, IDS_MIDIDEVNOTFOUND, MB_ICONEXCLAMATION) ;
		return ;
		}
	
	u = midiOutOpen (&hMidi, i, (DWORD)g_hwndMain, NULL, CALLBACK_WINDOW) ;
	if (u)
		{
		midiOutGetErrorText (u, szBuf, sizeof (szBuf) ) ;
		MessageBox (g_hwndMain, szBuf, g_szAppName, MB_ICONEXCLAMATION) ;
		return ;
		}
	
	PSGVol[0] = PSGVol[1] = PSGVol[2] = 0 ;
	
	midiOutShortMsg (hMidi, 
		MAKEMIDISHORTMSG (MIDI_CONTROL_CHANGE, 0, MIDI_POLY_MODE_ON, 0) ) ;
	midiOutShortMsg (hMidi, 
		MAKEMIDISHORTMSG (MIDI_PROGRAM_CHANGE, 0, 54, 0) ) ;

	midiOutShortMsg (hMidi, 
		MAKEMIDISHORTMSG (MIDI_CONTROL_CHANGE, 0, MIDI_ATTACK_TIME, 0) ) ;
	midiOutShortMsg (hMidi, 
		MAKEMIDISHORTMSG (MIDI_CONTROL_CHANGE, 0, MIDI_RELEASE_TIME, 0) ) ;
	}

static void NEAR Silent (int i)
	{
	assert (hMidi) ;
	
	if (PSGVol[i])
		{
		midiOutShortMsg (hMidi, 
			MAKEMIDISHORTMSG (MIDI_NOTE_OFF, 0, PSGNot[i], 127) ) ;
		PSGVol[i] = 0 ;
		}
	}

static BYTE NEAR SoundGetVol (int i)
	{
	static const BYTE BASED_CODE	vol[] = {
		0, 9, 17, 25, 34, 42, 51, 59, 68, 76, 85, 93, 102, 110, 119, 127 } ; 
	
	if (PSGReg[8 + i] & 0x10)
		return 127 ;
	return vol[PSGReg[8 + i] & 15] ;
	}

void SoundUpdate ()
	{
	int		i ;
	BYTE		vol ;
	
	if (hMidi)
		{
		if (PSGReg[7] & 1 || PSGReg[8] == 0 || *(WORD*)&PSGReg[0] < 8)
			Silent (0) ;
		else
			{
			i = TPtoNote (*(WORD*)&PSGReg[0]) ;
			if (i == -1)
				Silent (0) ;
			else
				{
				vol = SoundGetVol (0) ;
				if (PSGNot[0] != (BYTE)i || PSGVol[0] != vol)
					{
					Silent (0) ;
					PSGNot[0] = (BYTE)i ;
					PSGVol[0] = vol ;
					midiOutShortMsg (hMidi, 
						MAKEMIDISHORTMSG (MIDI_NOTE_ON, 0, PSGNot[0], PSGVol[0]) ) ;
					}
				}
			}
		
		if (PSGReg[7] & 2 || PSGReg[9] == 0 || *(WORD*)&PSGReg[2] < 8)
			Silent (1) ;
		else
			{
			i = TPtoNote (*(WORD*)&PSGReg[2]) ;
			if (i == -1)
				Silent (1) ;
			else
				{
				vol = SoundGetVol (1) ;
				if (PSGNot[1] != (BYTE)i || PSGVol[1] != vol)
					{
					Silent (1) ;
					PSGNot[1] = (BYTE)i ;
					PSGVol[1] = vol ;
					midiOutShortMsg (hMidi, 
						MAKEMIDISHORTMSG (MIDI_NOTE_ON, 0, PSGNot[1], PSGVol[1]) ) ;
					}
				}
			}
		
		if (PSGReg[7] & 4 || PSGReg[10] == 0 || *(WORD*)&PSGReg[4] < 8)
			Silent (2) ;
		else
			{
			i = TPtoNote (*(WORD*)&PSGReg[4]) ;
			if (i == -1)
				Silent (2) ;
			else
				{
				vol = SoundGetVol (2) ;
				if (PSGNot[2] != (BYTE)i || PSGVol[2] != vol)
					{
					Silent (2) ;
					PSGNot[2] = (BYTE)i ;
					PSGVol[2] = vol ;
					midiOutShortMsg (hMidi, 
						MAKEMIDISHORTMSG (MIDI_NOTE_ON, 0, PSGNot[2], PSGVol[2]) ) ;
					}
				}
			}
		}
	}

void SoundPause ()
	{
	int		i ;
	
	if (hMidi)
		{
		for (i=0;i<3;i++)
			Silent (i) ;
		}
	}

void SoundClose ()
	{
	if (hMidi)
		{
		SoundPause () ;
		
		midiOutReset (hMidi) ;
		midiOutClose (hMidi) ;
		hMidi = NULL ;
		}
	}
