// printer.c
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <stdlib.h>
#include <string.h>
#include <print.h>
#include <assert.h>
#include "resource.h"
#include "printer.h"
#include "msxcore.h"
#include "write.h"
#include "dialogs.h"
#include "statbar.h"
#include "msx.h"
#include "mem.h"

// variables
BYTE _huge*		g_lpbyPrint ;
DWORD			g_dwPrintSize ;
BOOL				g_bUserAbort ;
HWND				g_hDlgPrint ;
PRINTFONTS		g_prnfnt ;
static PRINTDLG	g_pd = {
	sizeof (PRINTDLG), 0, 0, 0, 0, 0L, 
	0, 0, 0, 0, 0, 0, 0L, NULL, NULL, MAKEINTRESOURCE (IDD_PRINT), NULL, 0, 0 } ;
extern const char	g_szAppName[] ;
extern HWND		g_hwndMain ;
extern HINSTANCE	g_hInstance ;
extern BOOL		g_bPrint ;

void FAR PrintCode (BYTE byCode)
	{
	if (g_lpbyPrint == NULL)
		{
		if (!NewGlobal ((void FAR**)&g_lpbyPrint, GHND, 0x4000) )
			return ;
		}
	else	if (GlobalSize (GlobalPtrHandle (g_lpbyPrint) ) <= g_dwPrintSize)
		{
		if (!SizeGlobal ((void FAR**)&g_lpbyPrint, g_dwPrintSize + 0x4000) )
			{
			ClearPrint (FALSE) ;
			return ;
			}
		}
	
	g_lpbyPrint[g_dwPrintSize++] = byCode ;
	if (g_bPrint == FALSE)
		{
		g_bPrint = TRUE ;
		SetIndicators () ;
		}
	}

void ClearPrint (BOOL bConfirm)
	{
	if (bConfirm)
		{
		DeActivate () ;
		if (IDYES != MessageID (g_hwndMain, IDS_MSGPRINTDEL, 
			MB_YESNO | MB_ICONQUESTION) )
			return ;
		}
	
	g_dwPrintSize = 0L ;
		
	if (g_lpbyPrint != NULL)
		{
		FreeGlobal ((void FAR**)&g_lpbyPrint) ;
		g_lpbyPrint = NULL ;
		}
	
	g_bPrint = FALSE ;
	SetIndicators () ;
	}

// flush buffer command found in buffer.
BOOL FAR PASCAL _export FlushBufferDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	RECT		rc ;
	int		x, y ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// disable close menu item
			DeleteMenu (GetSystemMenu (hDlg, FALSE), SC_CLOSE, MF_BYCOMMAND) ;
			
			// center dialog on screen
			GetWindowRect (GetDesktopWindow (), &rc) ;
			x = rc.right / 2 ;
			y = rc.bottom / 2 ;
			
			GetWindowRect (hDlg, &rc) ;
			x -= (rc.right - rc.left) / 2 ;
			y -= (rc.bottom - rc.top) / 2 ;
			
			SetWindowPos (hDlg, 0, x, y, -1, -1, SWP_NOSIZE | SWP_NOZORDER) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDC_NO:
				case IDC_NOALL:
				case IDC_YES:
				case IDC_YESALL:
					EndDialog (hDlg, wParam) ;
					
					break ;
				}
			
			return TRUE ;
		}
	
	return FALSE ;
	}

static void NEAR SavePrintAsText (HWND hwnd, char *szBuf)
	{
	HFILE		hFile ;
	char 		_huge* lpText, _huge* lpTextPtr ;
	DWORD		dw, dwSize ;
	int			i, n, a, nFlush ;
	HCURSOR		hcurOld ;
	
	// maximum: twice as much
	if (!NewGlobal ((void FAR**)&lpText, GMEM_MOVEABLE, g_dwPrintSize * 2) )
		return ;
	
	lpTextPtr = lpText ;
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	nFlush = 0 ;
	
	// text file, so skip everything but text and convert to ansi 
	dw = 0L ;
	while (dw<g_dwPrintSize)
		{
		i = 0 ;
		while ((dw + i) < g_dwPrintSize && 
			(unsigned)(lpTextPtr[i] = g_lpbyPrint[dw + i]) >= 32)
				i++ ;
		
		if (i)
			{
			MsxToAnsiBuf (lpTextPtr, i) ;
			lpTextPtr += i ;
			dw += i ;
			}
		
		if (dw >= g_dwPrintSize)
			break ;
		
		switch (g_lpbyPrint[dw++])
			{
			case 1:	// special symbol
				if (dw >= g_dwPrintSize)
					break ;
				
				*lpTextPtr = (g_lpbyPrint[dw++] - 64) ;
				MsxToAnsiBuf (lpTextPtr++, 1) ;
				break ;
			
			case 9:	// tab
				*lpTextPtr++ = '\t' ;
				break ;
			
			case 10:	// lf
			case 11:	// lf
				*lpTextPtr++ = '\r' ;
				*lpTextPtr++ = '\n' ;
				
				if (dw >= g_dwPrintSize)
					break ;
				
				switch (g_lpbyPrint[dw])
					{
					case 13:
						dw++ ;
					}
				
				break ;
			
			case 13:	// cr
				*lpTextPtr++ = '\r' ;
				*lpTextPtr++ = '\n' ;
				
				if (dw >= g_dwPrintSize)
					break ;
				
				switch (g_lpbyPrint[dw])
					{
					case 10:
					case 11:
						dw++ ;
					}
				
				break ;
			
			case 27:	// escape
				if (dw >= g_dwPrintSize)
					break ;
				
				switch (g_lpbyPrint[dw++])
					{
					case 'c':
					case 'C':
						dw++ ;
						break ;
					
					case 'T':
					case 't':
					case 'Z':
					case 'z':
						dw += 2L ;
						break ;
					
					case '/':
					case 'L':
					case 'l':
					case 'O':
					case 'o':
						dw += 3L ;
						break ;
					
					case 'G':
					case 'g':
						dw += 3L ;
					case 'S':
					case 's':
						if (dw + 2 < g_dwPrintSize)
							{
							for (a=0,i=1000;i>=1;i/=10)
								{
								n = g_lpbyPrint[dw++] - '0' ;
								if (n < 0 || n > 9)
									n = 0 ;
								a += n * i ;
								}
							dw += (DWORD)(UINT) a ;
							}
						else
							dw += 3L ;
						
						break ;
					
					case ')':
					case '(':
						while (dw < g_dwPrintSize)
							{
							n = g_lpbyPrint[dw++] ;
							
							if ( (n < '0' || n > '9') && n != ',')
								break ;
							}
						
						break ;
					
					case '@':
						goto ResetPrinter ;
					}
				
				break ;
			
ResetPrinter:	
			case 8:
				switch (nFlush)
					{
					case IDC_YESALL:
						lpTextPtr = lpText ;
					case IDC_NOALL:
						break ;
					
					default:
						ShowCursor (FALSE) ;
						SetCursor (hcurOld) ;
						
						nFlush = DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_FLUSHBUFFER), 
							hwnd, FlushBufferDlgProc) ;
						if (nFlush == IDC_YES || nFlush == IDC_YESALL)
							lpTextPtr = lpText ;
						
						hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
						ShowCursor (TRUE) ;
					}
				
				break ;
			}
		}
	
	dwSize = (DWORD) (lpTextPtr - lpText) ;
	for (dw=0L;dw<dwSize;dw++)
		if (lpText[dw++] > ' ')
			break ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	if (dw < dwSize)
		{
		// save actual file
		hFile = _lcreat (szBuf, 0) ;
		if (hFile == HFILE_ERROR || 
			_hwrite (hFile, lpText, (long)dwSize) != (long)dwSize)
			{
			// error
			if (hFile != HFILE_ERROR)
				{
				_lclose (hFile) ;
				OpenFile (szBuf, NULL, OF_DELETE) ;
				}
			
			DeActivate () ;
			MessageID (hwnd, IDS_ERRSAVE, MB_OK | MB_ICONEXCLAMATION) ;
			}
		else
			{
			// succes
			_lclose (hFile) ;
			
			ClearPrint (TRUE) ;
			}
		}
	else
		{
		DeActivate () ;
		MessageID (hwnd, IDS_ERRNOTEXT, MB_OK | MB_ICONEXCLAMATION) ;
		}
	
	FreeGlobal ((void FAR**)&lpText) ;
	}

// write file saving
static INFOPAGE	*pPageCHP, *pPagePAP ;
static int 		nPageCHP, nPagePAP, nHpsDBL, nHpsCPI, nChars ;
static DWORD		dwText, dwPrint ;
static BOOL		bEnter, bIngnoreEnter, bSucces ;
static char		_huge* lpText ;

static BOOL NEAR CheckTextSize (DWORD dwAdd/*addition memory required*/)
	{
	if (GlobalSize (GlobalPtrHandle (lpText) ) < dwText + dwAdd)
		{
		if (!SizeGlobal ((void FAR**)&lpText, dwText + dwAdd) )
			{
			bSucces = FALSE ;
			return FALSE ;
			}
		}
	
	return TRUE ;
	}

static void NEAR NextCHP (CHP *pChpNew, int nState)
// nState: 0 = first, 1 = inter, 2 = last
	{
	static CHP		*pChp, chpLast ;
	static FOD		*pFod ;
	static const CHP	ChpStand = { 0xff, 0, 24, 0, 0, 0 } ;
	int				nSize  ;
	
	// is end ?
	if (nState == 2)
		{
		pFod->fcLim = 128L + dwText ;
		
		return ;
		}
	
	// calc font size
	pChpNew->hps = g_prnfnt.nSize * 2 * nHpsDBL * (pChpNew->hpsPos ? 7 : 10) / nHpsCPI ;
	
	// is start ?
	if (nState == 0)
		{
		pPageCHP[0].fcFirst = 128L ;
		pPageCHP[0].cfod    = 0 ;
		nPageCHP = 0 ;
		pChp = (CHP*) (&pPageCHP[0].byInfo[122] + 1) ;
		pFod = (FOD*) &pPageCHP[0].byInfo[0] ;
		}
	else
		{
		if (!memcmp (pChpNew, &chpLast, sizeof (CHP) ) )
			return ;
		}
	
	chpLast = *pChpNew ;
	
	// calc difference to standard CHP
	nSize = sizeof (CHP) ;
	while (((PBYTE)pChpNew)[nSize - 1] == ((PBYTE)&ChpStand)[nSize - 1])nSize-- ;
	
	if (nState != 0)
		{
		pFod->fcLim = dwText + 128L ;
		pFod++ ;
		}
	
	if ((int) ((PBYTE)pChp - (PBYTE)pFod) < (7 + nSize) )
		{
		if (LocalSize ((HLOCAL)pPageCHP) < (UINT) (128 * (nPageCHP + 2) ) )
			{
			if (!SizeLocal ((void**)&pPageCHP, 128 * (nPageCHP + 6) ) )
				{
				bSucces = FALSE ;
				return ;
				}
			}
		nPageCHP++ ;
		pPageCHP[nPageCHP].fcFirst = dwText + 128L ;
		pChp = (CHP*) (&pPageCHP[nPageCHP].byInfo[122] + 1) ;
		pFod = (FOD*) &pPageCHP[nPageCHP].byInfo[0] ;
		}
	
	((PBYTE)pChp) -= nSize + 1 ;
	pFod->bfprop = (WORD) 
		((PBYTE)pChp - ((PBYTE)&pPageCHP[nPageCHP] + 4) ) ;
	memcpy ((PBYTE)pChp + 1, pChpNew, nSize) ;
	*((PBYTE)pChp) = nSize ;
		
	pPageCHP[nPageCHP].cfod++ ;
	}

static BOOL NEAR NextPAP (PAP* pPapNew, int nState)
	{
	static PAP	*pPap ;
	static FOD	*pFod ;
	static BOOL	bLastPic ;
	int			nSize ;
	DWORD		dw ;
	
	if (nState == 2)
		{
		if (!bEnter)
			{
			lpText[dwText++] = '\r' ;
			lpText[dwText++] = '\n' ;
			}
		
		pFod->fcLim = 128L + dwText ;
		
		return TRUE ;
		}
	
	// is start ?
	if (nState == 0)
		{
		pPagePAP[0].fcFirst = 128L ;
		pPagePAP[0].cfod    = 0 ;
		nPagePAP = 0 ;
		pPap = (PAP*) (&pPagePAP[0].byInfo[122] + 1) ;
		pFod = (FOD*) &pPagePAP[0].byInfo[0] ;
		bLastPic = FALSE ;
		}
	
	// calc size
	if (pPapNew->rhc)
		nSize = 17 ;
	else if (pPapNew->dyaLine != 240)
		nSize = 12 ;
	else 
		nSize = 1 ;
	
	if (nState != 0)
		{
		// must begin/end at paragraph end
		if (pPapNew->rhc || bLastPic)
			{
			// picture, thus must be end of line
			if (!bEnter)
				{
				lpText[dwText++] = '\r' ;
				lpText[dwText++] = '\n' ;
				bIngnoreEnter = TRUE ;
				nChars = 0 ;
				}
			pFod->fcLim = dwText + 128L ;
			pFod++ ;
			}
		else
			{
			// non-picture, thus search for nearest enter
			dw = dwText - 1L ;
			while (dw != 0xffffffff)
				{
				if (lpText[dw] == '\n')
					{
					// found
					dw++ ;
					break ;
					}
				dw-- ;
				}
			
			pFod->fcLim = dw + 128L ;
			pFod++ ;
			}
		}
	
	if ((int) ((PBYTE)pPap - (PBYTE)pFod) < (7 + nSize) )
		{
		if (LocalSize ((HLOCAL)pPagePAP) < (UINT) (128 * (nPagePAP + 2) ) )
			{
			if (!SizeLocal ((void**)&pPagePAP, 128 * (nPageCHP + 6) ) )
				{
				bSucces = FALSE ;
				return FALSE ;
				}
			}
		nPagePAP++ ;
		pPagePAP[nPagePAP].fcFirst = dwText + 128L ;
		pPap = (PAP*) (&pPagePAP[nPagePAP].byInfo[122] + 1) ;
		pFod = (FOD*) &pPagePAP[nPagePAP].byInfo[0] ;
		}
	
	((PBYTE)pPap) -= nSize + 1 ;
	pFod->bfprop = (WORD) 
		((PBYTE)pPap - ((PBYTE)&pPagePAP[nPagePAP] + 4) ) ;
	memcpy ((PBYTE)pPap + 1, pPapNew, nSize) ;
	*((PBYTE)pPap) = nSize ;
	
	pPagePAP[nPagePAP].cfod++ ;
	
	bLastPic = (pPapNew->rhc != 0) ;
	
	return TRUE ;
	}

static int NEAR GetColumns ()
	{
	switch (nHpsCPI)
		{
		case 10:
			return 80 ;
		
		case 12:
			return 96 ;
		
		case 17:
			return 136 ;
		
		case 11:
			return 90 ;
		}
	
	assert (0) ;
	
	return 80 ;
	}

static BOOL NEAR QueueEnd (HWND hwnd)
	{
	bSucces = (MessageID (hwnd, IDS_QUEUEINCOMP, MB_ICONINFORMATION | MB_YESNO) == IDYES) ;
	
	return bSucces ;
	}

static int NEAR GetDigits (HWND hwnd, int nDigits)
	{
	int		 a, n ;
	
	if (dwPrint + nDigits > g_dwPrintSize)
		{
		dwPrint += nDigits ;
		
		QueueEnd (hwnd) ;
		
		return -1 ;
		}
	
	a=0 ;
	while (nDigits--)
		{
		n = g_lpbyPrint[dwPrint++] - '0' ;
		if (n < 0 || n > 9)
			n = 0 ;
		a *= 10 ;
		a += n ;
		}
	
	return a ;
	}

static void NEAR AddPicture (HWND hwnd, CHP *pChp, PAP *pPap)
	{
	PICTURE	pic, _huge* lpPic ;
	int		nLength, nWidth, nWidthBytes, nLines ;
	int		i, n, y, a ;
	BYTE		byData ;
	DWORD	dw ;
	BOOL		bPic ;
	
	nLines = 0 ;
	
	if (!CheckTextSize (sizeof (PICTURE) ) )
		return ;
	
	pPap->rhc = 0x10 ;
	if (!NextPAP (pPap, 1) )
		return ;
	
	lpPic = (PICTURE _huge*)&lpText[dwText] ;
	dwText += sizeof (PICTURE) ;
	
	bPic = TRUE ;
	while (bPic && !g_bUserAbort)
		{
		// ignore any cr/lf
		dw = dwPrint ;
		// one lf, any cr
		while (g_lpbyPrint[dw] == 13 && dw < g_dwPrintSize)dw++ ;
		if (g_lpbyPrint[dw] == 10 && dw < g_dwPrintSize)dw++ ;
		while (g_lpbyPrint[dw] == 13 && dw < g_dwPrintSize)dw++ ;
		if (g_lpbyPrint[dw++] == 27)
			{
			i = 0 ;
			switch (g_lpbyPrint[dw++])
				{
				case 'G':
				case 'g':
					if (dwPrint + 7 > g_dwPrintSize)
						{
						dwPrint += 7 ;
						QueueEnd (hwnd) ;
						
						bPic = FALSE ;
						continue ;
						}
					
					for (i=0,a=100;a>=1;a/=10)
						{
						n = g_lpbyPrint[dw++] - '0' ;
						if (n < 0 || n > 9)
							n = 0 ;
						i += n * a ;
						}
					
					if (i <= 65)
						i = 60 ;
					else if (i <= 75)
						i = 72 ;
					else if (i <= 85)
						i = 80 ;
					else if (i <= 95)
						i = 90 ;
					else if (i <= 125)
						i = 120 ;
					else if (i <= 145)
						i = 136 ;
					else
						i = 240 ;
					break ;
				
				case 'S':
				case 's':
					if (dwPrint + 4 > g_dwPrintSize)
						{
						dwPrint += 4 ;
						QueueEnd (hwnd) ;
						
						bPic = FALSE ;
						continue ;
						}
					
					i = GetColumns () ;
					break ;
				
				default:
					bPic = FALSE ;
					continue ;
				}
			
			if (nLines == 0)
				nLength = i ;
			else	if (i != nLength)
				{
				bPic = FALSE ;
				continue ;
				}
			
			for (i=0,a=1000;a>=1;a/=10)
				{
				n = g_lpbyPrint[dw++] - '0' ;
				if (n < 0 || n > 9)
					n = 0 ;
				i += n * a ;
				}
			if (nLines == 0)
				nWidth = i ;
			else if (i != nWidth)
				{
				bPic = FALSE ;
				continue ;
				}
			
			nWidthBytes = (nWidth + 15) / 16 * 2 ;
			}
		else
			{
			bPic = FALSE ;
			continue ;
			}
		
		dwPrint = dw ;
		if (dwPrint + nWidth > g_dwPrintSize)
			{
			dwPrint += nWidth ;
			QueueEnd (hwnd) ;
							
			bPic = FALSE ;
			continue ;
			}
		
		if (!CheckTextSize ((DWORD)nWidthBytes*8L) )
			return ;
		
		for (y=0;y<8;y++)
			{
			for (i=0;i<nWidth;i+=8)
				{
				byData = 0 ;
				for (n=0;n<8;n++)
					{
					byData |= ( (g_lpbyPrint[dwPrint + i + n] & (1 << y) ) == 0) << (7 - n) ;
					}
				lpText[dwText + i / 8] = byData ;
				}
			dwText += nWidthBytes ;
			}
		
		dwPrint += nWidth ;
		nLines++ ;
		}
	
	if (nLines > 0 && !g_bUserAbort)
		{
		memset (&pic, 0, sizeof (PICTURE) ) ;
		pic.mfp.mm          = 0xe3 ;
		// picture size Microsoft Word uses
		pic.mfp.xExt        = (WORD) ((long)nWidth * 1440L / (long)nLength) ;
		pic.mfp.yExt        = 240 * nLines;
		// picture size Microsoft Write uses
		pic.dxaSize         = pic.mfp.xExt ;
		pic.dyaSize         = pic.mfp.yExt ;
		// bitmap properties
		pic.bm.bmWidth      = nWidth ;
		pic.bm.bmHeight     = 8 * nLines ;
		pic.bm.bmWidthBytes = nWidthBytes ;
		pic.bm.bmPlanes     = 1 ;
		pic.bm.bmBitsPixel  = 1 ;
		pic.cbHeader        = sizeof (PICTURE) ;
		pic.cbSize          = (DWORD)nWidthBytes * 8L * (DWORD)nLines ;
		pic.mx              = 1000 ;
		pic.my              = 1000 ;
		
		hmemcpy ((void _huge*)lpPic, &pic, sizeof (PICTURE) ) ;
		bEnter = TRUE ;
		bIngnoreEnter = FALSE ;
		}
	else
		{
		// correct dwText
		dwText -= sizeof (PICTURE) ;
		}
	pPap->rhc = 0 ;
	NextPAP (pPap, 1) ;
	}

static void NEAR StartWrite (CHP *pChp, PAP *pPap, SEP *pSep)
	{
	// character info
	pChp->byReserved = 1 ;
	pChp->fFormat = (g_prnfnt.nWeight > 550) | 
		g_prnfnt.bItalic << 1 | !g_prnfnt.bNormalDef << 2 ;
	pChp->hpsPos = pChp->byReserved2[0] = pChp->byReserved2[1] = 0 ;
	nHpsDBL = 1 ;
	nHpsCPI = 10 ;
	NextCHP (pChp, 0) ;
	
	// paragraph info
	memset (pPap, 0, sizeof (PAP) ) ;
	pPap->byReserved     = 61 ;
	pPap->byReserved2[0] = 30 ;
	pPap->dyaLine        = 240 ;
	bEnter = TRUE ;
	bIngnoreEnter = FALSE ;
	NextPAP (pPap, 0) ;
	
	// margins
	pSep->cch           = sizeof (SEP) - 1 ;
	pSep->wReserved     = 0 ;
	pSep->yaMac         = 144 * 110 ;
	pSep->xaMac         = 144 * 85 ;
	pSep->wReserved2    = 0xffff ;
	pSep->yaTop         = 144 * 5 ;
	pSep->dyaText       = 144 * 100;
	pSep->xaLeft        = 144 * 5 ;
	pSep->dxaText       = 144 * 75 ;
	}

static void NEAR SavePrintAsWrite (HWND hwnd, char *szBuf)
	{
	HFILE			hFile ;
	WRITEFILEHEADER	wrihdr ;
	PAP				pap ;
	FFN				*pffn ;
	CHP				chp ;
	SEP				sep ;
	SETB				setb ;
	BYTE				byFonts[128], bySep[128] ;
	int				i, n, nFlush, nPageTXT, nTabs[32], nTab ;
	BYTE				byBuf[256] ;
	DWORD			dw ;
	HCURSOR			hcurOld ;
	
	if (!NewGlobal ((void FAR**)&lpText, GHND, g_dwPrintSize * 2) )
		return ;
	
	if (!NewLocal ((void**)&pPageCHP, LPTR, 0x400) )
		return ;
	
	if (!NewLocal ((void**)&pPagePAP, LPTR, 0x400) )
		return ;
	
	nFlush = 0 ;
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	SetStatTextID (IDS_CONVERT) ;
	
	// tabs
	for (i=0;i<32;i++)
		nTabs[i] = (i + 1) * 8 ;
	nTab = nChars = 0 ;
	
	StartWrite (&chp, &pap, &sep) ;
	
	// start conversion
	dwText = 0L ;
	dwPrint = 0L ;
	
	bSucces = TRUE ;
	while (dwPrint<g_dwPrintSize && bSucces && !g_bUserAbort)
		{
		for (i=0;i<sizeof (byBuf);i++)
			{
			byBuf[i] = g_lpbyPrint[dwPrint + i] ;
			if (byBuf[i] < 32 || (dwPrint + i >= g_dwPrintSize) )
				break ;
			}
		
		if (i)
			{
			if (!CheckTextSize (i) )
				break ;
			MsxToAnsiBuf (byBuf, i) ;
			hmemcpy (&lpText[dwText], byBuf, i) ;
			dwText += i ;
			dwPrint += i ;
			bIngnoreEnter = bEnter = FALSE ;
			nChars += i ;
			}
		
		if (dwPrint >= g_dwPrintSize)
			break ;
		
		switch (g_lpbyPrint[dwPrint++])
			{
			case 1:	// special symbol
				if (!CheckTextSize (1) )
					break ;
				lpText[dwText] = (g_lpbyPrint[dwPrint++] - 64) ;
				MsxToAnsiBuf (&lpText[dwText++], 1) ;
				bIngnoreEnter = bEnter = FALSE ;
				nChars++ ;
				break ;
			
			case 9:	// tab
				for (i=0;i<32;i++)
					if (nTabs[i] > nChars)
						break ;
				
				if (i != 32)
					{
					n = nTabs[i] - nChars ;
					if (!CheckTextSize (n) )
						break ;
					for (i=0;i<n;i++)
						lpText[dwText++] = ' ' ;
					nChars += n ;
					bIngnoreEnter = bEnter = FALSE ;
					}
				
				break ;
			
			case 10:	// lf
			case 11:	// lf
				if (!bIngnoreEnter)
					{
					if (!CheckTextSize (2) )
						break ;
					lpText[dwText++] = '\r' ;
					lpText[dwText++] = '\n' ;
					nChars = 0 ;
					}
				else
					bIngnoreEnter = FALSE ;
				
				switch (g_lpbyPrint[dwPrint])
					{
					case 13:
						dwPrint++ ;
					}
				bEnter = TRUE ;
				
				break ;
			
			case 12:	// form-feed
				if (!CheckTextSize (1) )
					break ;
				lpText[dwText++] = '\f' ;
				bIngnoreEnter = bEnter = FALSE ;
				break ;
			
			case 13:	// cr
				if (!bIngnoreEnter)
					{
					if (!CheckTextSize (2) )
						break ;
					lpText[dwText++] = '\r' ;
					lpText[dwText++] = '\n' ;
					nChars = 0 ;
					}
				else
					bIngnoreEnter = FALSE ;
				
				switch (g_lpbyPrint[dwPrint])
					{
					case 10:
					case 11:
						dwPrint++ ;
					}
				
				bEnter = TRUE ;
				break ;
			
			// double width
			case 14:
				nHpsDBL = 2 ;
				NextCHP (&chp, 1) ;
				break ;
			
			case 15:
				nHpsDBL = 1 ;
				NextCHP (&chp, 1) ;
				break ;
			
			case 27:	// escape
				if (dwPrint >= g_dwPrintSize)
					{
					QueueEnd (hwnd) ;
					break ;
					}
				
				switch (g_lpbyPrint[dwPrint++])
					{
					case 'C':
					case 'c':
						if (dwPrint >= g_dwPrintSize)
							{
							QueueEnd (hwnd) ;
							break ;
							}
						
						switch (g_lpbyPrint[dwPrint++])
							{
							// super/subscript
							case 'S':
								chp.hpsPos = 4 ;
								NextCHP (&chp, 1) ;
								break ;
							
							case 'U':
								chp.hpsPos = (BYTE) -4 ;
								NextCHP (&chp, 1) ;
								break ;
							
							case 'u':
							case 's':
								chp.hpsPos = 0 ;
								NextCHP (&chp, 1) ;
								break ;
							
							// italic
							case 'I':
								chp.fFormat |= 2 ;
								NextCHP (&chp, 1) ;
								break ;
							
							case 'i':
								chp.fFormat &= ~2 ;
								NextCHP (&chp, 1) ;
								break ;
							
							// bold
							case 'D':
							case 'B':
								chp.fFormat |= 1 ;
								NextCHP (&chp, 1) ;
								break ;
							
							case 'd':
							case 'b':
								chp.fFormat &= ~1 ;
								NextCHP (&chp, 1) ;
								break ;
							}
						
						break ;
					
					// fonts size
					case 'N':
					case 'n':
						nHpsCPI = 10 ;
						NextCHP (&chp, 1) ;
						break ;
					
					case 'E':
					case 'e':
						nHpsCPI = 12 ;
						NextCHP (&chp, 1) ;
						break ;
					
					case 'Q':
						nHpsCPI = 17 ;
						NextCHP (&chp, 1) ;
						break ;
					
					case 'P':
						nHpsCPI = 11 ;
						NextCHP (&chp, 1) ;
						break ;
					
					// underline
					case 'X':
					case 'x':
						chp.byReserved2[0] = 1 ;
						NextCHP (&chp, 1) ;
						break ;
					
					case 'Y':
					case 'y':
						chp.byReserved2[0] = 0 ;
						NextCHP (&chp, 1) ;
						break ;
					
					// font
					case '!':
						chp.fFormat |= 4 ;
						NextCHP (&chp, 1) ;
						break ;
					
					case '"':
						chp.fFormat &= ~4 ;
						NextCHP (&chp, 1) ;
						break ;
					
					// interline spacing
					case 'A':
					case 'a':
						pap.dyaLine = 240 ;
						NextPAP (&pap, 1) ;
						break ;
					
					case 'B':
					case 'b':
						pap.dyaLine = 160 ;
						NextPAP (&pap, 1) ;
						break ;
					
					case 'T':
					case 't':
						i = GetDigits (hwnd, 2) ;
						if (i != -1)
							{
							pap.dyaLine = i * 10 ;
							NextPAP (&pap, 1) ;
							}
						break ;
					
					case 'Z':
					case 'z':
						i = GetDigits (hwnd, 2) ;
						if (i != -1)
							{
							pap.dyaLine = i * 20 / 3 ;
							NextPAP (&pap, 1) ;
							}
						break ;
					
					// tabs
					case '2':
						nTab = 0 ;
						for (i=0;i<32;i++)
							nTabs[i] = (i + 1) * 8 ;
						break ;
					
					case ')':
						nTab = 0 ;
					case '(':
						for (;nTab<32;nTab++)
							{
							i = GetDigits (hwnd, 3) ;
							if (i == -1)
								break ;
							
							if (nTab && nTabs[nTab - 1] >= i)
								{
								nTab-- ;	// another tab allowed
								continue ;
								}
							
							nTabs[nTab] = i ;
							
							if (dwPrint >= g_dwPrintSize)
								break ;
							
							if (g_lpbyPrint[dwPrint++] != ',')
								break ;
							}
						// tabs may not be ascending any more, but who cares?
						break ;
					
					// margins
					case 'L': // left margin
					case 'l':
						n = GetDigits (hwnd, 3) ;
						if (n != -1)
							{
							i = GetColumns () ;
							if (n > i)
								n = i ;
							sep.dxaText += sep.xaLeft ;
							sep.xaLeft = (n * 144 / i) * 75 + 144 * 5 ;
							sep.dxaText -= sep.xaLeft ;
							}
						break ;
					
					case '/': // right margin
						n = GetDigits (hwnd, 3) ;
						if (n != -1)
							{
							i = GetColumns () ;
							if (n > i)
								n = i ;
							sep.dxaText = (144 * n / i) * 75 - sep.xaLeft + 144 * 5 ;
							}
						break ;
					
					case 'O':
					case 'o':
						if (dwPrint >= g_dwPrintSize)
							{
							QueueEnd (hwnd) ;
							break ;
							}
						
						i = g_lpbyPrint[dwPrint++] ;
						switch (i)
							{
							// top margin
							case 'S':
							case 's':
								// OSOO is emulated because it will result in 00 lines
								i = GetDigits (hwnd, 2) ;
								if (i != -1)
									{
									if (i > 220)
										i = 220 ;
									sep.dyaText += sep.yaTop ;
									sep.yaTop = (144 * i / 220) * 100 + 1440 / 2 ;
									sep.dyaText -= sep.yaTop ;
									}
								break ;
							
							// page length
							case 'I':
							case 'i':
								i = GetDigits (hwnd, 2) ;
								if (i != -1)
									{
									if (i > 10)
										i = 10 ;
									sep.dyaText = i * 1440 - sep.yaTop + 144 * 5 ;
									}
								break ;
							
							default:
								n = GetDigits (hwnd, 2) ;
								if (n != -1)
									{
									n += (i - '0') * 100 ;
									if (n > 220)
										n = 220 ;
									sep.dyaText = (144 * n / 220) * 100 - sep.yaTop + 144 * 5 ;
									}
								break ;
							}
						
						break ;
					
					case '@':
						goto ResetPrinter ;
					
					// pictures
					case 'G':
					case 'g':
					case 'S':
					case 's':
						dwPrint -= 2L ;
						AddPicture (hwnd, &chp, &pap) ;
						break ;
					}
				
				break ;
				
ResetPrinter:	
			case 8:
				switch (nFlush)
					{
					default:
						nFlush = DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_FLUSHBUFFER), 
							g_hDlgPrint, FlushBufferDlgProc) ;
						if (nFlush == IDC_NO || nFlush == IDC_NOALL)
							break ;
						
					case IDC_YESALL:
						// reset buffer
						for (i=0;i<32;i++)
							nTabs[i] = (i + 1) * 8 ;
						nTab = nChars = 0 ;
						
						StartWrite (&chp, &pap, &sep) ;
						
						dwText = 0L ;
					case IDC_NOALL:
						
						break ;
					}
				
				break ;
			}
		
		}
	
	if (bSucces)
		{
		for (dw=0L;dw<dwText;dw++)
			if (lpText[dw++] > ' ')
				break ;
		
		if (dw >= dwText)
			{
			DeActivate () ;
			MessageID (hwnd, IDS_NOQUEUEDATA, MB_OK | MB_ICONEXCLAMATION) ;
			}
		else
			{
			NextCHP (&chp, 2) ;
			NextPAP (&pap, 2) ;
			nPageTXT = (int) ( (dwText + 127L) / 128L) ;
			nPageCHP++ ;
			nPagePAP++ ;
			if (CheckTextSize ((DWORD)nPageTXT * 128UL - dwText) )
				{
				// set header
				memset (&wrihdr, 0, sizeof (WRITEFILEHEADER) ) ;
				wrihdr.wIndent = 0137061 ;
				wrihdr.wTool   = 0125400 ;
				wrihdr.fcMac   = dwText + 128L ;
				wrihdr.pnPara  = nPageCHP + nPageTXT + 1 ;
				wrihdr.pnFntb  = nPageCHP + nPagePAP + nPageTXT + 1 ;
				wrihdr.pnSep   = nPageCHP + nPagePAP + nPageTXT + 1 ;
				wrihdr.pnSetb  = nPageCHP + nPagePAP + nPageTXT + 2 ;
				wrihdr.pnPgtb  = nPageCHP + nPagePAP + nPageTXT + 3 ;
				wrihdr.pnFfntb = nPageCHP + nPagePAP + nPageTXT + 3 ;
				wrihdr.pnMac   = nPageCHP + nPagePAP + nPageTXT + 4 ;
				
				// set fonts (as face names cannot exceed 32 bytes
				// two face names can always be stored in one page)
				memset (byFonts, 0, sizeof (byFonts) ) ;
				byFonts[0] = 2 ;
				pffn = (FFN*)&byFonts[2] ;
				n = strlen (g_prnfnt.szNormalFaceName) + 1 ;
				pffn->cbFfn = n + 1 ;
				pffn->ffid  = FF_SWISS ;
				strcpy ((char*)&pffn->szFfn, (char*)&g_prnfnt.szNormalFaceName) ;
				((BYTE*)pffn) += n + 3 ;
				n = strlen (g_prnfnt.szQualityFaceName) + 1 ;
				pffn->cbFfn = n + 1 ;
				pffn->ffid  = FF_ROMAN ;
				strcpy ((char*)&pffn->szFfn, (char*)&g_prnfnt.szQualityFaceName) ;
				
				// sep page
				memset (bySep, 0, 128) ;
				memcpy (bySep, &sep, sizeof (SEP) ) ;
				
				// sed page
				memset (&setb, 0, 128) ;
				setb.csed = 2 ;
				setb.csedMax = 2 ;
				setb.sed[0].cp = dwText + 128L ;
				setb.sed[0].fcSep = wrihdr.pnSep * 128 ;
				setb.sed[1].cp = dwText + 128L ;
				setb.sed[1].fcSep = 0xffffffff ;
				
				// create and save actual file
				hFile = _lcreat (szBuf, 0) ;
				if (hFile == HFILE_ERROR || 
					_lwrite (hFile, &wrihdr, 128) != 128 || 
					_hwrite (hFile, lpText, (long)nPageTXT * 128L) != (long)nPageTXT * 128L || 
					_lwrite (hFile, pPageCHP, (128 * nPageCHP) ) != (UINT) (128 * nPageCHP) || 
					_lwrite (hFile, pPagePAP, (128 * nPagePAP) ) != (UINT) (128 * nPagePAP) || 
					_lwrite (hFile, bySep, 128) != 128 || 
					_lwrite (hFile, &setb, 128) != 128 || 
					_lwrite (hFile, byFonts, 128) != 128)
					{
					// error
					if (hFile != HFILE_ERROR)
						{
						_lclose (hFile) ;
						OpenFile (szBuf, NULL, OF_DELETE) ;
						}
					
					DeActivate () ;
					MessageID (hwnd, IDS_ERRSAVE, MB_OK | MB_ICONEXCLAMATION) ;
					bSucces = FALSE ;
					}
				else
					{
					// succes
					_lclose (hFile) ;
					
					ClearPrint (TRUE) ;
					}
				}
			}
		}
	
	FreeGlobal ((void FAR**)&lpText) ;
	FreeLocal ((void**)&pPageCHP) ;
	FreeLocal ((void**)&pPagePAP) ;
	
	SetStatTextID (0) ;
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	}

static void NEAR SavePrintAsData (HWND hwnd, char *szBuf)
	{
	HFILE		hFile ;
	
	hFile = _lcreat (szBuf, 0) ;
	if (hFile == HFILE_ERROR || 
		_hwrite (hFile, g_lpbyPrint, (long)g_dwPrintSize) != (long)g_dwPrintSize)
		{
		// error
		if (hFile != HFILE_ERROR)
			{
			_lclose (hFile) ;
			OpenFile (szBuf, NULL, OF_DELETE) ;
			}
		
		DeActivate () ;
		MessageID (hwnd, IDS_ERRSAVE, MB_OK | MB_ICONEXCLAMATION) ;
		}
	else
		{
		// succes
		_lclose (hFile) ;
		
		ClearPrint (TRUE) ;
		}
	}

void SavePrint (HWND hwnd)
	{
	static const char BASED_CODE 	szFilter[] = "Write Files (*.wri)\0*.wri\0"
		"Text Files (*.txt)\0*.txt\0Raw Data (*.*)\0*.*\0", 
		BASED_CODE 	szTitle[] = "Save Printer Queue" ;
	OPENFILENAME	ofn ;
	char			szBuf[_MAX_PATH] ;
	
	szBuf[0] = '\0' ;
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = hwnd ;
	ofn.lpstrFilter = szFilter ;
	ofn.lpstrFile   = szBuf ;
	ofn.nMaxFile    = sizeof (szBuf) ;
	ofn.lpstrTitle  = szTitle ;
	ofn.Flags       = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT ;
	
	DeActivate () ;
	if (GetSaveFileName (&ofn) )
		{
		switch ((int)ofn.nFilterIndex)
			{
			case 1:
				SavePrintAsWrite (hwnd, szBuf) ;
				break ;
			
			case 2:
				SavePrintAsText (hwnd, szBuf) ;
				break ;
			
			case 3:
				SavePrintAsData (hwnd, szBuf) ;
			}
		}
	}

// fonts dialog functions
static PRINTFONTS	*pPrnFnts ;

static HDC NEAR GetPrinterIC ()
	{
	DEVNAMES		FAR* lpDevNames ;
	DEVMODE		FAR* lpDevMode ;
	HDC			hdc ;
	char			*szDevice, *szDriver, *szOutput, szPrinter [80] ;
	
	if (g_pd.hDevNames)
		{
		lpDevNames = (DEVNAMES FAR*)GlobalLock (g_pd.hDevNames) ;
		
		if (g_pd.hDevMode)
			{
			lpDevMode = (DEVMODE FAR*)GlobalLock (g_pd.hDevMode) ;
			
			hdc = CreateIC (((LPSTR)lpDevNames)+lpDevNames->wDriverOffset, 
				((LPSTR)lpDevNames)+lpDevNames->wDeviceOffset, 
				((LPSTR)lpDevNames)+lpDevNames->wOutputOffset, lpDevMode) ;
			GlobalUnlock (g_pd.hDevMode) ;
			}
		else
			{
			hdc = CreateIC (((LPSTR)lpDevNames)+lpDevNames->wDriverOffset, 
				((LPSTR)lpDevNames)+lpDevNames->wDeviceOffset, 
				((LPSTR)lpDevNames)+lpDevNames->wOutputOffset, NULL) ;
			}
		
		GlobalUnlock (g_pd.hDevNames) ;
		}
	else
		{
     	GetProfileString ("windows", "device", ",,,", szPrinter, 80) ;
		
		if (NULL != (szDevice = strtok (szPrinter, "," )) &&
			NULL != (szDriver = strtok (NULL, ", ")) &&
			NULL != (szOutput = strtok (NULL, ", ")))
			hdc =  CreateIC (szDriver, szDevice, szOutput, NULL) ;
		else
			hdc = NULL ;
		}
	
	return hdc ; 
	}

static void NEAR SetCheckBtns (HWND hDlg)
	{
	static const char BASED_CODE szNormal[] = "&Normal Font%s", 
		BASED_CODE szDefault[] = " (default)", 
		BASED_CODE szQuality[] = "&Quality Font%s" ;
	char			szBuf[32] ;
	
	wsprintf (szBuf, szNormal, (pPrnFnts->bNormalDef ? (LPCSTR) szDefault : (LPCSTR) "") ) ;
	SetWindowText (GetDlgItem (hDlg, rad1), szBuf) ;
	wsprintf (szBuf, szQuality, (!pPrnFnts->bNormalDef ? (LPCSTR) szDefault : (LPCSTR) "") ) ;
	SetWindowText (GetDlgItem (hDlg, rad2), szBuf) ;
	}

BOOL FAR PASCAL _export FontDlgProc (HWND hDlg, UINT message, UINT wParam, LONG lParam)
	{
	static int	bNormalLast ;
	char			szBuf[LF_FACESIZE] ;
	int			i ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			SetCheckBtns (hDlg) ;
			SendDlgItemMessage (hDlg, rad1, BM_SETCHECK, 1, 0L) ;
			bNormalLast = TRUE ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case btn1:
					pPrnFnts->bNormalDef = (BOOL)SendDlgItemMessage (hDlg, rad1, 
						BM_GETCHECK, 0, 0L) ;
					SetCheckBtns (hDlg) ;
					
					return TRUE ;
				
				case rad1:
					if (!bNormalLast)
						{
						i = (int) SendDlgItemMessage (hDlg, cmb1, 
							CB_GETCURSEL, 0, 0L) ;
						SendDlgItemMessage (hDlg, cmb1, 
							CB_GETLBTEXT, i, (LPARAM)(LPSTR) szBuf) ;
						if (strlen (szBuf) )
							strcpy (pPrnFnts->szQualityFaceName, szBuf) ;
						
						SendDlgItemMessage (hDlg, cmb1, CB_SELECTSTRING, 
							(WPARAM) -1, (LPARAM)(LPSTR) pPrnFnts->szNormalFaceName) ;
						
						bNormalLast = TRUE ;
						
						PostMessage (hDlg, WM_COMMAND, (WPARAM) cmb1, 
							((DWORD) (CBN_SELCHANGE)) << 16 | (DWORD)(WORD)GetDlgItem (hDlg, cmb1) ) ;
						}
					
					return TRUE ;
				
				case rad2:
					if (bNormalLast)
						{
						i = (int) SendDlgItemMessage (hDlg, cmb1, 
							CB_GETCURSEL, 0, 0L) ;
						SendDlgItemMessage (hDlg, cmb1, 
							CB_GETLBTEXT, i, (LPARAM)(LPSTR) szBuf) ;
						if (strlen (szBuf) )
							strcpy (pPrnFnts->szNormalFaceName, szBuf) ;
						
						SendDlgItemMessage (hDlg, cmb1, CB_SELECTSTRING, 
							(WPARAM) -1, (LPARAM)(LPSTR) pPrnFnts->szQualityFaceName) ;
						
						bNormalLast = FALSE ;
						
						PostMessage (hDlg, WM_COMMAND, (WPARAM) cmb1, 
							((DWORD) (CBN_SELCHANGE)) << 16 | (DWORD)(WORD)GetDlgItem (hDlg, cmb1) ) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

void SetFonts (HWND hwnd)
	{
	CHOOSEFONT	cf ;
	LOGFONT		lgfnt ;
	HDC			hdc ;
	PRINTFONTS	prnfnt ;
	
	hdc = GetDC (NULL) ;
	
	memset (&lgfnt, 0, sizeof (LOGFONT) ) ;
	lgfnt.lfHeight = -MulDiv (g_prnfnt.nSize, 
		GetDeviceCaps (hdc, LOGPIXELSY), 72) ;
	lgfnt.lfWeight = g_prnfnt.nWeight ;
	lgfnt.lfItalic = (BYTE) g_prnfnt.bItalic ;
	strcpy ((char*)lgfnt.lfFaceName, g_prnfnt.szNormalFaceName) ;
	
	memset (&cf, 0, sizeof (CHOOSEFONT) ) ;
	cf.lStructSize    = sizeof (CHOOSEFONT) ;
	cf.hwndOwner      = hwnd ;
	cf.lpLogFont      = &lgfnt ;
	cf.hInstance      = g_hInstance ;
	cf.hDC            = GetPrinterIC () ;
	if (cf.hDC != NULL)
		{
		cf.Flags          = CF_ENABLETEMPLATE | CF_ANSIONLY | 
			CF_BOTH | CF_INITTOLOGFONTSTRUCT | CF_LIMITSIZE | CF_ENABLEHOOK ;
		}
	else
		{
		cf.Flags          = CF_ENABLETEMPLATE | CF_ANSIONLY | 
			CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT | CF_LIMITSIZE | CF_ENABLEHOOK ;
		}
	cf.lpTemplateName = MAKEINTRESOURCE (IDD_FONTS) ;
	cf.lpfnHook       = FontDlgProc ;
	cf.nSizeMin       = 4 ;
	cf.nSizeMax       = 50 ;
	
	prnfnt = g_prnfnt ;
	pPrnFnts = &prnfnt ;
	
	DeActivate () ;
	if (ChooseFont (&cf) )
		{
		g_prnfnt = prnfnt ;
				
		g_prnfnt.nWeight = lgfnt.lfWeight ;
		g_prnfnt.nSize   = -MulDiv (72, lgfnt.lfHeight, GetDeviceCaps (hdc, LOGPIXELSY) ) ;
		g_prnfnt.bItalic = (lgfnt.lfItalic != 0) ;
		strcpy ((g_prnfnt.bNormalDef ? g_prnfnt.szNormalFaceName : g_prnfnt.szQualityFaceName), 
			lgfnt.lfFaceName) ;
		}
	
	DeleteDC (cf.hDC) ;
	ReleaseDC (NULL, hdc) ;
	}
