// dailogs.c -- Dialog procedures for MSX for Windows
#include <windows.h>
#include <mmsystem.h>
#include <dos.h>
#include <direct.h>
#include <string.h>
#include <wing.h>
#include <commdlg.h>
#include <cderr.h>
#include <stdlib.h>
#include "msx.h"
#include "resource.h"
#include "msxcore.h"
#include "document.h"
#include "dialogs.h"
#include "mem.h"

extern HANDLE		g_hInstance ;
extern HWND		g_hwndMain ;
extern const char	g_szAppName[] ;
extern FILESETTINGS	g_fileset, DefSet ;
extern BOOL		g_bNeedSave, g_bPalette ;
extern char		g_szFileName[], g_szFileTitle[], g_szUntitled[] ;

int MessageID (HWND hwndParent, UINT nIDtext, UINT uFlags)
	{
	char		szText[256] ;
	
	LoadString (g_hInstance, nIDtext, szText, 256) ;
	
	return MessageBox (hwndParent, szText, g_szAppName, uFlags) ;
	}

// about dialog
BOOL FAR PASCAL _export AboutDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	BITMAP			bmp ;
	HDC				hdc ;
	HBITMAP			hbmpOld ;
	static SIZE		sbmp ;
	static HBITMAP		hbmp ;
	static HBRUSH		hbr ;
	LPDRAWITEMSTRUCT	lpdis ;
	char				szBuf[80], szBuf2[80] ;
	struct _diskfree_t	diskfree ;
	
	switch (message)
		{
		case WM_INITDIALOG :
			// free resources
			LoadString (g_hInstance, IDS_SYSTEM_RES, szBuf, 80) ;
			wsprintf (szBuf2, "%u%% Free", GetFreeSystemResources (GFSR_SYSTEMRESOURCES) ) ;
			SetDlgItemText (hDlg, IDC_SYSTEM_RES, szBuf2) ;
			
			// free memory
			LoadString (g_hInstance, IDS_AVAIL_MEM, szBuf, 80) ;
			wsprintf (szBuf2, szBuf, GetFreeSpace(0) / 1024L) ;
			SetDlgItemText (hDlg, IDC_AVAIL_MEM , szBuf2) ;
			
			// free disk space
			if (_dos_getdiskfree(_getdrive(), &diskfree) == 0)
				{
				LoadString (g_hInstance, IDS_AVAIL_MEM, szBuf, 80) ;
			     wsprintf(szBuf2, szBuf, 
				(DWORD)diskfree.avail_clusters *
				(DWORD)diskfree.sectors_per_cluster *
				(DWORD)diskfree.bytes_per_sector / (DWORD)1024L) ;
				}
			else
				LoadString (g_hInstance, IDS_UNAVAIL_MEM, szBuf2, 80) ;
			
			SetDlgItemText (hDlg, IDC_DISK_SPACE , szBuf2) ;
			
			// MSX logo
			hbmp = LoadBitmap (g_hInstance, MAKEINTRESOURCE (IDB_VMSXLOGOS) ) ;
			GetObject (hbmp, sizeof (bmp), &bmp) ;
			sbmp.cy = bmp.bmHeight ;
			sbmp.cx = bmp.bmWidth ;
			hbr = CreateSolidBrush (GetSysColor (COLOR_BTNFACE) ) ;
			
			return TRUE ;
		
		case WM_DRAWITEM :
			lpdis = (LPDRAWITEMSTRUCT) lParam ;
			
			if (lpdis->CtlID == IDC_MSXLOGO)
				{
				FillRect (lpdis->hDC, &lpdis->rcItem, hbr) ;
				
				hdc = CreateCompatibleDC (lpdis->hDC) ;
				hbmpOld = SelectObject (hdc, hbmp) ;
				
				BitBlt (lpdis->hDC, 
					(lpdis->rcItem.right - lpdis->rcItem.left - sbmp.cx) / 2, 
					(lpdis->rcItem.bottom - lpdis->rcItem.top - sbmp.cy) / 2, 
					sbmp.cx, sbmp.cy, hdc, 0, 0, SRCCOPY) ;
				
				SelectObject (hdc, hbmpOld) ;
				DeleteDC (hdc) ;
				
				return TRUE ;
				}
			
			break ;
		
		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
				case IDCANCEL :
					EndDialog (hDlg, wParam == IDOK) ;
					return TRUE ;
				}
			break ;
		
		case WM_DESTROY:
			DeleteObject (hbr) ;
			DeleteObject (hbmp) ;
			
			return TRUE ;
		}
	
	return FALSE ;
	}

// confirmation dialog
extern BOOL	g_bConReset, g_bConStop, g_bExitRun, g_bAskSave ;

BOOL FAR PASCAL _export ConfirmDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	switch (message)
		{
		case WM_INITDIALOG :
			// check boxes
			SendDlgItemMessage (hDlg, IDC_RESETCHK, BM_SETCHECK, g_bConReset, 0L) ;
			SendDlgItemMessage (hDlg, IDC_STOPCHK, BM_SETCHECK, g_bConStop, 0L) ;
			SendDlgItemMessage (hDlg, IDC_ASKSAVECHK, BM_SETCHECK, g_bAskSave, 0L) ;
			SendDlgItemMessage (hDlg, IDC_EXITRUNCHK, BM_SETCHECK, g_bExitRun, 0L) ;
			
			return TRUE ;

		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
					// check boxes
					g_bConReset = (WORD) SendMessage (
						GetDlgItem (hDlg, IDC_RESETCHK) , BM_GETCHECK, 0, 0L) ;
					g_bConStop = (WORD) SendMessage (
						GetDlgItem (hDlg, IDC_STOPCHK) , BM_GETCHECK, 0, 0L) ;
					g_bExitRun = (WORD) SendMessage (
						GetDlgItem (hDlg, IDC_EXITRUNCHK) , BM_GETCHECK, 0, 0L) ;
					g_bAskSave = (WORD) SendMessage (
						GetDlgItem (hDlg, IDC_ASKSAVECHK) , BM_GETCHECK, 0, 0L) ;
				case IDCANCEL :
					EndDialog (hDlg, wParam == IDOK) ;
					return TRUE ;
				}
			
			break ;
		}
				
	return FALSE ;
	}

// general options dialog
static void NEAR SetFps (HWND hDlg, int nFps)
	{
	char		szBuf[256] ;
	int 		i ;
	
	i = 60 / (6 - nFps) ;
	
	wsprintf (szBuf, "%d", i) ;
	SetWindowText (GetDlgItem (hDlg, IDC_FPSTXT), szBuf) ;
	
	SetScrollPos (GetDlgItem (hDlg, IDC_FPSBAR), SB_CTL, nFps, TRUE) ;
	}

BOOL FAR PASCAL _export ScreenOutputDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	int 		i ;
	
	switch (message)
		{
		case WM_INITDIALOG :
			// screen frames-per-second (fps)
			SetScrollRange (GetDlgItem (hDlg, IDC_FPSBAR), SB_CTL, 0, 5, FALSE) ;
			SetFps (hDlg, 5 - g_fileset.nFps) ;
			
			// check boxes
			SendDlgItemMessage (hDlg, IDC_DISPLAYCHK, BM_SETCHECK, g_fileset.bIllegal, 0L) ;
			
			return TRUE ;
		
		case WM_HSCROLL:
			i = GetScrollPos ((HWND)HIWORD (lParam), SB_CTL) ;
			
			if ((HWND)HIWORD (lParam) == GetDlgItem (hDlg, IDC_FPSBAR) )
				{
				switch (wParam)
					{
					case SB_TOP:
						i = 0 ;
						break ;
					case SB_BOTTOM:
						i = 5 ;
						break ;
					case SB_PAGEUP:
					case SB_LINEUP:
						i = max (0, i - 1) ;
						break ;
					case SB_PAGEDOWN:
					case SB_LINEDOWN:
						i = min (5, i + 1) ;
						break ;
					case SB_THUMBPOSITION:
						i = LOWORD (lParam) ;
						break ;
					
					default:
						return FALSE ;
					}
				
				SetFps (hDlg, i) ;
				
				return TRUE ;
				}
			
			return FALSE ;
		
		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
					// check boxes
					g_fileset.bIllegal = (WORD) SendMessage (
						GetDlgItem (hDlg, IDC_DISPLAYCHK) , BM_GETCHECK, 0, 0L) ;
					// sprites may be modified
					bScrModified = 1 ;
					
					// speed scroll bar
					g_fileset.nFps = 5 - GetScrollPos (GetDlgItem (hDlg, IDC_FPSBAR), 
						SB_CTL ) ;
					
					g_bNeedSave = TRUE ;
				case IDCANCEL :
					EndDialog (hDlg, (wParam == IDOK) ) ;
					
					return TRUE ;
				}
			break ;
		}
	
	return FALSE ;
	}

// keyboard dialog
extern BYTE	g_vkTbl[] ;
#define		NUMKEYS 7 

BOOL FAR PASCAL _export KeyboardDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	static const char *szKeys[NUMKEYS] = { "F6", "F7", "F8", "Page Up", 
		"Page Down", "End", "Pause" } ;
	static const BYTE BASED_CODE vkKeys[NUMKEYS] = { VK_F6, VK_F7, VK_F8, VK_PRIOR,
		VK_NEXT, VK_END, VK_PAUSE } ;
	int i, n ;
	BYTE *pByte ;
	char szSelect[256], szBuf[256] ;
	
	switch (message)
		{
		case WM_INITDIALOG :
			// combo boxes (resource IDs and vk-codes in FILESETTINGS are in same sequence)
			pByte = &g_fileset.vkCode ;
			
			for (n=0;n<4;n++)
				{
				for (i=0;i<NUMKEYS;i++)
					{
					if (pByte[n] == vkKeys[i])
						{
						SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + n, 
							CB_ADDSTRING, 0, (LPARAM)(LPCSTR) szKeys[i]) ;
						SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + n, 
							CB_SETCURSEL, 0, 0L) ;
						
						break ;
						}
					}
				}
			
			// check boxes
			SendDlgItemMessage (hDlg, IDC_CAPSCHK, BM_SETCHECK, (WPARAM)g_fileset.bCaps, 0L) ;
			
			return TRUE ;

		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
					// check boxes
					g_fileset.bCaps = (unsigned)SendMessage (
						GetDlgItem (hDlg, IDC_CAPSCHK), BM_GETCHECK, 0, 0L) ;
					// combo boxes
					pByte = &g_fileset.vkCode ;
					
					for (i=0;i<4;i++)
						{
						SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + i, CB_GETLBTEXT, 
							(WPARAM) SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + i, 
								CB_GETCURSEL, 0, 0L), (LPARAM)(LPCSTR) szSelect) ;
						
						for (n=0;n<NUMKEYS;n++)
							{
							if (!strcmp (szSelect, szKeys[n]) )
								{
								pByte[i] = vkKeys[n] ;
								break ;
								}
							}
						}
					
					g_bNeedSave = TRUE ;
					g_vkTbl[3] = g_fileset.vkCode ;
					g_vkTbl[5] = g_fileset.vkGraph ;
					g_vkTbl[9] = g_fileset.vkSelect ;
					g_vkTbl[11] = g_fileset.vkStop ;
					
				case IDCANCEL :
					EndDialog (hDlg, wParam) ;
					return TRUE ;
				
				case IDC_CODEKEYCOMBO:
				case IDC_GRAPHKEYCOMBO:
				case IDC_SELECTKEYCOMBO:
				case IDC_STOPKEYCOMBO:
					if (HIWORD (lParam) != CBN_SETFOCUS)
						break ;
					
					SendMessage ((HWND)LOWORD (lParam), CB_GETLBTEXT, 
						(WPARAM) SendMessage ((HWND)LOWORD (lParam), CB_GETCURSEL, 
							0, 0L), (LPARAM)(LPCSTR) szSelect) ;
					
					// first, remove all the crap that was in it
					SendMessage ((HWND)LOWORD (lParam), CB_RESETCONTENT, 0, 0L) ;
					
				     // then add all choices
				     for (i=0;i<NUMKEYS;i++)
				     	{
				     	SendMessage ((HWND)LOWORD (lParam), CB_ADDSTRING, 
				     		0, (LPARAM)(LPCSTR) szKeys[i]) ;
				     	}
				     
				     // delete all crap choices
				     for (i=0;i<4;i++)
				     	{
				     	SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + i, CB_GETLBTEXT, 
				     		(WPARAM) SendDlgItemMessage (hDlg, IDC_CODEKEYCOMBO + i, 
				     			CB_GETCURSEL, 0, 0L), (LPARAM)(LPCSTR)szBuf) ;
				     	
				     	SendMessage ((HWND)LOWORD (lParam), CB_DELETESTRING, 
				     		(WPARAM) SendMessage ((HWND)LOWORD (lParam), CB_FINDSTRING, 
				     			(WPARAM) -1, (LPARAM)(LPCSTR) szBuf), (LPARAM)(LPCSTR) szBuf) ;
				     	}
				     
				     // set input focus
					SendMessage ((HWND)LOWORD (lParam), CB_SELECTSTRING, 
				     	(WPARAM)-1, (LPARAM)(LPCSTR) szSelect) ;
				
					return TRUE ;
				}
			
			break ;
		}
				
	return FALSE ;
	}

// colors dialog
extern UINT		g_uState ; 
extern HPALETTE	g_hpalScreen ;
extern HDC		g_hdcWinG ;
extern HBITMAP		g_hbmpWinGA, g_hbmpWinGB ;
extern BOOL		g_bBitmapA ;
static PALETTEENTRY	*g_papeClr ;
static UINT		g_nCurColor ;

// forward declartions
static void NEAR UpdateColor (HWND) ;
static void NEAR UpdateItems (HWND) ;

BOOL FAR PASCAL _export ColorsDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char 			szBuf[256] ;
	int				i ;
	PAINTSTRUCT		ps ;
	HBRUSH 			hbr ;
	HDC				hdc ;
	HWND				hwndList ;
	HPALETTE 			hpalOld ;
	WORD 			n ;
	BYTE				*pByte ;
	RECT				rc ;
	
	switch (message)
		{
		case WM_INITDIALOG :
			// palette
			if (!NewLocal ((void**)&g_papeClr, LMEM_FIXED, 15 * sizeof (PALETTEENTRY) ) )
				EndDialog (hDlg, FALSE) ;
			memcpy (g_papeClr, &g_fileset.ape[0], 15 * sizeof (PALETTEENTRY) ) ;
				
			g_nCurColor = 0 ;
			
			// scrollbars
			for (i=0;i<3;i++)
				SetScrollRange (GetDlgItem (hDlg, IDC_REDBAR + i) , SB_CTL, 0, 255, FALSE) ;
			
			// colors listbox
			hwndList = GetDlgItem (hDlg, IDC_COLORSLIST) ;
			
			for (i=0;i<15;i++)
				{
				LoadString (g_hInstance, IDS_COLOR1 + i, szBuf, 256) ;
				SendMessage (hwndList, LB_ADDSTRING, 0, (LONG) (LPSTR) szBuf) ;
				}
			
			// button
			if (!g_uState)
				{
				EnableWindow (GetDlgItem (hDlg, IDC_PREVIEWBTN), FALSE) ;
				}
			
			SendMessage (hwndList, LB_SETCURSEL, g_nCurColor, 0L ) ;
			
			UpdateItems (hDlg) ;
			UpdateColor (hDlg) ;
			
			return TRUE ;

		case WM_PALETTECHANGED:
			if ((HWND) wParam == hDlg )
				return 0 ;
			
		case WM_QUERYNEWPALETTE:
			hdc = GetDC (hDlg) ;
			hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
			
			i = RealizePalette (hdc) ;
          	
          	SelectPalette (hdc, hpalOld, FALSE) ;
			ReleaseDC (hDlg, hdc) ;
			
			if (i)
				InvalidateRect (hDlg, NULL, FALSE) ;
			
			return i ;

		case WM_PAINT:
			BeginPaint (hDlg, &ps) ;
			
			hpalOld = SelectPalette (ps.hdc, g_hpalScreen, FALSE) ;
			hbr = CreateSolidBrush (PALETTEINDEX (FIRSTENTRY + 16) ) ;
			
			GetWindowRect (GetDlgItem (hDlg, IDC_CURRENTCOLOR), &rc) ;
			ScreenToClient (hDlg, (LPPOINT)&rc.left) ;
			ScreenToClient (hDlg, (LPPOINT)&rc.right) ;
			FillRect (ps.hdc, &rc, hbr ) ;
			
			DeleteObject (hbr) ;
			SelectPalette (ps.hdc, hpalOld, FALSE) ;
			
			EndPaint (hDlg, &ps) ;
			
			return TRUE ;

		case WM_HSCROLL:
			i = GetScrollPos ((HWND)HIWORD (lParam), SB_CTL) ;
					
			switch (wParam)
				{
				case SB_TOP:
					i = 0 ;
					break ;
				case SB_BOTTOM:
					i = 255 ;
					break ;
				case SB_PAGEUP:
					i = max (0, i - 15) ;
					break ;
				case SB_PAGEDOWN:
					i = min (255, i + 15) ;
					break ;
				case SB_LINEUP:
					i = max (0, i - 1) ;
					break ;
				case SB_LINEDOWN:
					i = min (255, i + 1) ;
					break ;
				case SB_THUMBPOSITION:
					i = LOWORD (lParam) ;
					break ;
				
				default:
					return FALSE ;
				}
			
			SetScrollPos ((HWND)HIWORD (lParam), SB_CTL, i, TRUE) ;
			
			wsprintf (szBuf, "%d", i) ;
			SetWindowText (GetDlgItem (hDlg, 
				(GetDlgCtrlID ((HWND)HIWORD (lParam)) - IDC_REDBAR + IDC_REDEDIT)), szBuf) ;
			
			pByte = &g_papeClr[g_nCurColor].peRed ;
			
			pByte [GetDlgCtrlID ((HWND)HIWORD (lParam)) - IDC_REDBAR] = (BYTE) i ;
			
			UpdateColor (hDlg) ;
			
			return TRUE ;
		
		case WM_COMMAND :
			switch (wParam)
				{
				case IDC_RESTOREBTN:
					memcpy (&g_papeClr[g_nCurColor], &DefSet.ape[g_nCurColor], 
						sizeof (PALETTEENTRY) ) ;
					UpdateItems (hDlg) ;
					UpdateColor (hDlg) ;
					
					return TRUE ;
				
				case IDC_RESTOREALLBTN:
					memcpy (g_papeClr, &DefSet.ape[0], 
						15 * sizeof (PALETTEENTRY) ) ;
					UpdateItems (hDlg) ;
					UpdateColor (hDlg) ;
					
					return TRUE ;
				
				case IDOK:
					memcpy (&g_fileset.ape[0], g_papeClr, 
						15 * sizeof (PALETTEENTRY) ) ;
					g_bNeedSave = TRUE ;
				case IDCANCEL:
					CreateIdentityPalette (&g_fileset.ape[0]) ;
					FreeLocal ((void**)&g_papeClr) ;
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_PREVIEWBTN:
					CreateIdentityPalette (g_papeClr) ;
					
					return TRUE ;
				
				case IDC_COLORSLIST:
					if (HIWORD (lParam) != LBN_SELCHANGE)
						break ;
					
					g_nCurColor = (UINT) SendMessage  ((HWND)LOWORD (lParam), LB_GETCURSEL, 0, 0L) ;
					
					UpdateColor (hDlg) ;
					UpdateItems (hDlg) ;
					
					return TRUE ;
				
				case IDC_REDEDIT:
				case IDC_GREENEDIT:
				case IDC_BLUEEDIT:
					if (HIWORD (lParam) == EN_CHANGE)
						{
						i = GetDlgItemInt (hDlg, wParam, &n, FALSE) ;
						
						if (!n || i < 0 || i > 255)
							{
							n = GetScrollPos (GetDlgItem (
								hDlg, (wParam - IDC_REDEDIT + IDC_REDBAR) ), SB_CTL) ;
							wsprintf (szBuf, "%d", n) ;
							SetWindowText ((HWND)LOWORD (lParam), szBuf) ;

							SetFocus (GetDlgItem (hDlg, wParam) ) ;
						
							MessageID (hDlg, IDS_ERRCOLORINP, MB_OK | MB_ICONINFORMATION) ;
							}
						else
							{
							SetScrollPos (GetDlgItem (
								hDlg, (wParam - IDC_REDEDIT + IDC_REDBAR) ), 
								SB_CTL, i, TRUE) ;

							pByte = &g_papeClr[g_nCurColor].peRed ;
							
							pByte[wParam - IDC_REDEDIT] = (BYTE) i ;
								
							UpdateColor (hDlg) ;
							}
						
						return TRUE ;
						}
					
					break ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

static void NEAR UpdateColor (HWND hDlg)
	{
	PALETTEENTRY	ape ;
	HDC			hdc ;
	HPALETTE		hpalOld ;
	RECT			rc ;
	RGBQUAD		rgbq ;
	
	hdc = GetDC (hDlg) ;
	hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
	
	if (!g_bPalette)
		{
		GetWindowRect (GetDlgItem (hDlg, IDC_CURRENTCOLOR), &rc) ;
		ScreenToClient (hDlg, (LPPOINT)&rc.left) ;
		ScreenToClient (hDlg, (LPPOINT)&rc.right) ;
		InvalidateRect (hDlg, &rc, FALSE) ;
		
		*((COLORREF*) &ape) = GetNearestColor (hdc, *((COLORREF*) &g_papeClr[g_nCurColor]) ) ;
		}
	else
		ape = g_papeClr[g_nCurColor] ;
	
	ape.peFlags = PC_RESERVED ;
	
	AnimatePalette (g_hpalScreen, FIRSTENTRY + 16, 1, &ape) ;
	
	rgbq.rgbRed      = ape.peRed ;
	rgbq.rgbGreen    = ape.peGreen ;
	rgbq.rgbBlue     = ape.peBlue ;
	rgbq.rgbReserved = 0 ;
	SelectObject (g_hdcWinG, g_hbmpWinGB) ;
	WinGSetDIBColorTable (g_hdcWinG, FIRSTENTRY + 16, 1, &rgbq) ;
	SelectObject (g_hdcWinG, g_hbmpWinGA) ;
	WinGSetDIBColorTable (g_hdcWinG, FIRSTENTRY + 16, 1, &rgbq) ;
	
	SelectPalette (hdc, hpalOld, FALSE) ;
	ReleaseDC (hDlg, hdc) ;
	}

static void NEAR UpdateItems (HWND hDlg)
	{
	char		szBuf[256] ;
	BYTE		*pbyte ;
	int		i ;
	
	pbyte = &g_papeClr[g_nCurColor].peRed ;
	
	for (i=0;i<3;i++)
		{
		SetScrollPos (GetDlgItem (hDlg, IDC_REDBAR + i), 
			SB_CTL, (int)pbyte[i], TRUE ) ;
		wsprintf (szBuf, "%d", (int)pbyte[i]) ;
		SetWindowText (GetDlgItem (hDlg, IDC_REDEDIT + i), szBuf) ;
		}
	}

// joysticks dialog
extern BOOL	g_bJoyPlug[] ;

BOOL FAR PASCAL _export JoystickDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	int		i ;
	char		szBuf[256] ;
	static const char BASED_CODE	szControl[] = "CONTROL Joystick" ;
	
	switch (message)
		{
		case WM_INITDIALOG :
			// scroll bar
			SetScrollRange (GetDlgItem (hDlg, IDC_AUTOFIREBAR), SB_CTL, 1, 5, FALSE) ;
			if (g_fileset.nAutoFire)
				{
				SetScrollPos (GetDlgItem (hDlg, IDC_AUTOFIREBAR), SB_CTL, g_fileset.nAutoFire, TRUE) ;
				SendDlgItemMessage (hDlg, IDC_AUTOFIRECHK, BM_SETCHECK, 1, 0L) ;
				}
			else
				{
				SetScrollPos (GetDlgItem (hDlg, IDC_AUTOFIREBAR), SB_CTL, 1, TRUE) ;
				EnableWindow (GetDlgItem (hDlg, IDC_AUTOFIREBAR), FALSE) ;
				}
			
			// joysticks combo boxes
			for (i=0;i<3;i++)
				{
				LoadString (g_hInstance, IDS_JOYNONE + i, szBuf, 256) ;
				
				SendDlgItemMessage (hDlg, IDC_JOY1CMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPCSTR) szBuf) ;
				SendDlgItemMessage (hDlg, IDC_JOY2CMB, CB_ADDSTRING, 0, 
					(LPARAM)(LPCSTR) szBuf) ;
				}
			
			SendDlgItemMessage (hDlg, IDC_JOY1CMB, CB_SETCURSEL, 
				g_fileset.nJoy1, 0L) ;
			SendDlgItemMessage (hDlg, IDC_JOY2CMB, CB_SETCURSEL, 
				g_fileset.nJoy2, 0L) ;
			
			// weird calibrate
			if (LOWORD (GetVersion ()) >= 0x0400)
				EnableWindow (GetDlgItem (hDlg, IDC_CALIBRATEBTN), FALSE) ;
			
			return TRUE ;

		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
					if (!SendDlgItemMessage (hDlg, IDC_AUTOFIRECHK, BM_GETCHECK, 0, 0L) )
						g_fileset.nAutoFire = 0 ;
					else
						g_fileset.nAutoFire = GetScrollPos (GetDlgItem (hDlg, IDC_AUTOFIREBAR), 
							SB_CTL) ;
					
					g_fileset.nJoy1 = (WORD) SendDlgItemMessage (hDlg, 
						IDC_JOY1CMB, CB_GETCURSEL, 0, 0L) ;
					g_fileset.nJoy2 = (WORD) SendDlgItemMessage (hDlg, 
						IDC_JOY2CMB, CB_GETCURSEL, 0, 0L) ;
					g_bNeedSave = TRUE ;
					g_bJoyPlug[0] = g_bJoyPlug[1] = TRUE ;
				case IDCANCEL :
					EndDialog (hDlg, wParam == IDOK) ;
					return TRUE ;
				
				case IDC_JOY1CMB:
				case IDC_JOY2CMB:
					if (HIWORD (lParam) == CBN_SELCHANGE)
						{
						if (wParam == IDC_JOY1CMB)
							wParam++ ;
						else
							wParam-- ;
						
						i = (int) SendMessage ((HWND)LOWORD (lParam), CB_GETCURSEL, 0, 0L) ;
						
						if (i && i == SendDlgItemMessage (hDlg, wParam, CB_GETCURSEL, 0, 0L) )
							{
							MessageID (hDlg, IDS_MSGJOYASSIGN, MB_OK | MB_ICONEXCLAMATION) ;
							SendDlgItemMessage (hDlg, wParam, CB_SETCURSEL, 0, 0L) ;
							}
						}
					
					return TRUE ;
				
				case IDC_CALIBRATEBTN:
					WinExec (szControl, SW_SHOWNORMAL) ;
					
					return TRUE ;
				
				case IDC_AUTOFIRECHK:
					i = SendDlgItemMessage (hDlg, IDC_AUTOFIRECHK, BM_GETCHECK, 0, 0L) != 0 ;
					EnableWindow (GetDlgItem (hDlg, IDC_AUTOFIREBAR), i) ;
					
					SetScrollPos (GetDlgItem (hDlg, IDC_AUTOFIREBAR), SB_CTL, 1, TRUE) ;
					
					return TRUE ;
				}
			
			break ;
		
		case WM_HSCROLL:
			i = GetScrollPos ((HWND)HIWORD (lParam), SB_CTL) ;
			
			if ((HWND)HIWORD (lParam) == GetDlgItem (hDlg, IDC_AUTOFIREBAR) )
				{
				switch (wParam)
					{
					case SB_TOP:
						i = 1 ;
						break ;
					case SB_BOTTOM:
						i = 5 ;
						break ;
					case SB_PAGEUP:
					case SB_LINEUP:
						i = max (1, i - 1) ;
						break ;
					case SB_PAGEDOWN:
					case SB_LINEDOWN:
						i = min (5, i + 1) ;
						break ;
					case SB_THUMBPOSITION:
						i = LOWORD (lParam) ;
						break ;
					
					default:
						return FALSE ;
					}
				
				SetScrollPos (GetDlgItem (hDlg, IDC_AUTOFIREBAR), SB_CTL, i, TRUE) ;
				
				return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

// cartridges dialog box
extern char		g_szCartAFile[_MAX_PATH], g_szCartBFile[_MAX_PATH] ;

static void NEAR FileErr (UINT nErr, HWND hDlg, char *szFile)
	{
	char		szBuf[256], szBuf2[_MAX_PATH] ;
	
	LoadString (g_hInstance, nErr, szBuf, 256) ;
	wsprintf (szBuf2, szBuf, (LPSTR)szFile) ;
	MessageBox (hDlg, szBuf2, g_szAppName, MB_ICONEXCLAMATION) ;
	}

static BOOL NEAR CheckCartFile (HWND hDlg, char *szFile)
	{
	HFILE	hFile ;
	OFSTRUCT	of ;
	BYTE		byBuf[9] ;
	
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, hDlg, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, hDlg, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, hDlg, szFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	if (_lread (hFile, byBuf, 9) != 9)
		{
		_lclose (hFile) ;
				
		FileErr (IDS_FILEROMBIN, hDlg, szFile) ;
				
		return FALSE ;
		}
	
	_lclose (hFile) ;
	
	if (byBuf[0] == 0xfe)
		{
		if (byBuf[7] != 'A' || byBuf[8] != 'B')
			{
			FileErr (IDS_FILEBIN, hDlg, szFile) ;
			
			return FALSE ;
			}
		}
	else if (byBuf[0] != 'A' || byBuf[1] != 'B')
		{
		FileErr (IDS_FILEROMBIN, hDlg, szFile) ;
		
		return FALSE ;
		}
	
	mmioOpen (szFile, NULL, MMIO_PARSE) ;
	
	return TRUE ;
	}

static BOOL NEAR CartBrowse (HWND hDlg, char *szFile)
	{
	static const char BASED_CODE szFilter[] = "Cartridge Files (*.rom)\0*.rom\0"
		"Binary Files (*.*)\0*.*\0All Files (*.*)\0*.*\0", 
		BASED_CODE szDefExt[] = "rom", 
		BASED_CODE szTitle[] = "Open Cartridge File" ;
	
	OPENFILENAME	ofn ;
	
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = hDlg ;
	ofn.lpstrFilter = szFilter ;
	ofn.lpstrFile   = szFile ;
	ofn.nMaxFile    = _MAX_PATH ;
	ofn.lpstrTitle  = szTitle ;
	ofn.Flags       = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT ;
	ofn.lpstrDefExt = szDefExt ;
	
	if (!GetOpenFileName (&ofn) )
		{
		if (CommDlgExtendedError () == FNERR_INVALIDFILENAME)
			{
			szFile[0] = '\0' ;
			return (GetOpenFileName (&ofn) && CheckCartFile (hDlg, szFile) ) ;
			}
		return FALSE ;
		}
	
	return CheckCartFile (hDlg, szFile) ;
	}

BOOL FAR PASCAL _export CartridgesDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	char			szFile[_MAX_PATH], szFile2[_MAX_PATH] ;
	int			i ;
	FILESETTINGS	fileset ;
	static const char *szDiskROM[] = { 
		"32 Kb RAM, 2 Cartridges, Disk", 
		"64 Kb RAM, 1 Cartridge, Disk", 
		"64 Kb RAM, 2 Cartridges, No Disk" } ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			for (i=0;i<3;i++)
				{
				SendDlgItemMessage (hDlg, IDC_DISKCMB, CB_ADDSTRING, 
					0, (LPARAM)(LPSTR) szDiskROM[i]) ;
				}
			
			SendDlgItemMessage (hDlg, IDC_DISKCMB, CB_SETCURSEL, g_fileset.nDisk, 0L) ;
			
			EnableWindow (GetDlgItem (hDlg, IDC_CARTBEDIT), g_fileset.nDisk != 1) ;
			EnableWindow (GetDlgItem (hDlg, IDC_BROWSEB), g_fileset.nDisk != 1) ;
			
			SetWindowText (GetDlgItem (hDlg, IDC_CARTAEDIT), g_szCartAFile) ;
			SetWindowText (GetDlgItem (hDlg, IDC_CARTBEDIT), g_szCartBFile) ;
			
			return TRUE ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
					GetWindowText (GetDlgItem (hDlg, IDC_CARTAEDIT), szFile, _MAX_PATH) ;
					if (szFile[0])
						{
						if (!CheckCartFile (hDlg, szFile) )
							{
							SetFocus (GetDlgItem (hDlg, IDC_CARTAEDIT) ) ;
							break ;
							}
						}
					GetWindowText (GetDlgItem (hDlg, IDC_CARTBEDIT), szFile2, _MAX_PATH) ;
					if (szFile2[0])
						{
						if (!CheckCartFile (hDlg, szFile2) )
							{
							SetFocus (GetDlgItem (hDlg, IDC_CARTBEDIT) ) ;
							break ;
							}
						}
					AnsiUpper (szFile) ;
					AnsiUpper (szFile2) ;
					fileset = g_fileset ;
					fileset.nDisk = (WORD) SendDlgItemMessage (hDlg, IDC_DISKCMB, CB_GETCURSEL, 0, 0L) ;
					
					if (SetFile (hDlg, &fileset, szFile, szFile2) )
						g_bNeedSave = TRUE ;
					
				case IDCANCEL:
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_BROWSEA:
					GetWindowText (GetDlgItem (hDlg, IDC_CARTAEDIT), szFile, _MAX_PATH) ;
					if (CartBrowse (hDlg, szFile) )
						{
						AnsiUpper (szFile) ;
						SetWindowText (GetDlgItem (hDlg, IDC_CARTAEDIT), szFile) ;
						}
					
					return TRUE ;
				
				case IDC_BROWSEB:
					GetWindowText (GetDlgItem (hDlg, IDC_CARTBEDIT), szFile, _MAX_PATH) ;
					if (CartBrowse (hDlg, szFile) )
						{
						AnsiUpper (szFile) ;
						SetWindowText (GetDlgItem (hDlg, IDC_CARTBEDIT), szFile) ;
						}
					
					return TRUE ;
				
				case IDC_DISKCMB:
					if (HIWORD (lParam) == CBN_SELCHANGE)
						{
						i = (int)SendDlgItemMessage (hDlg, 
							IDC_DISKCMB, CB_GETCURSEL, 0, 0L) ;
						
						EnableWindow (GetDlgItem (hDlg, IDC_CARTBEDIT), i != 1) ;
						EnableWindow (GetDlgItem (hDlg, IDC_BROWSEB), i != 1) ;
						}
					
					return TRUE ;
				}
			
			break ;
		}
	
	return FALSE ;
	}

// splash dialog
BOOL FAR PASCAL _export SplashDlgProc (HWND hDlg, UINT message, UINT wParam, 
												LONG lParam)
	{
	HFONT			hFont ;
	LOGFONT			lFont ;
	RECT				rc, rc2 ;
	LPDRAWITEMSTRUCT	lpdis ;
	BITMAP			bmp ;
	HDC				hdc ;
	HBITMAP			hbmpOld ;
	static HBITMAP		hbmp ;
	static SIZE		sbmp ;
	static HBRUSH		hbr ;
	
	switch (message)
		{
		case WM_INITDIALOG:
			// set font
			hFont = (HFONT) SendMessage (hDlg, WM_GETFONT, 0, 0L) ;
			if (hFont != NULL)
				if (GetObject (hFont, sizeof (LOGFONT), &lFont) )
					{
					lFont.lfWeight = FW_NORMAL ;
					hFont = CreateFontIndirect (&lFont)  ;
					if (hFont != NULL)
						{
						SendDlgItemMessage (hDlg, IDC_INTROTEXT, WM_SETFONT, 
							(WPARAM)hFont, 0L) ;
						SendDlgItemMessage (hDlg, IDC_INTROTEXT2, WM_SETFONT, 
							(WPARAM)hFont, 0L) ;
						}
					}
			
			// center dialog
			GetWindowRect (GetDesktopWindow (), &rc) ;
			GetClientRect (hDlg, &rc2) ;
			
			MoveWindow (hDlg, 
				(rc.right - rc2.right) / 2, 
				(rc.bottom - rc2.bottom) / 2, 
				rc2.right, rc2.bottom, FALSE) ;
			
			// load bitmap
			hbmp = LoadBitmap (g_hInstance, MAKEINTRESOURCE (IDB_VMSXLOGO) ) ;
			GetObject (hbmp, sizeof (bmp), &bmp) ;
			sbmp.cy = bmp.bmHeight ;
			sbmp.cx = bmp.bmWidth ;
			hbr = CreateSolidBrush (GetSysColor (COLOR_BTNFACE) ) ;
			
			return TRUE ;
		
		case WM_DRAWITEM :
			lpdis = (LPDRAWITEMSTRUCT) lParam ;
			
			if (lpdis->CtlID == IDC_MSXLOGO)
				{
				FillRect (lpdis->hDC, &lpdis->rcItem, hbr) ;
				
				hdc = CreateCompatibleDC (lpdis->hDC) ;
				hbmpOld = SelectObject (hdc, hbmp) ;
				
				BitBlt (lpdis->hDC, 
					(lpdis->rcItem.right - lpdis->rcItem.left - sbmp.cx) / 2, 
					(lpdis->rcItem.bottom - lpdis->rcItem.top - sbmp.cy) / 2, 
					sbmp.cx, sbmp.cy, hdc, 0, 0, SRCCOPY) ;
				
				SelectObject (hdc, hbmpOld) ;
				DeleteDC (hdc) ;
				
				return TRUE ;
				}
			
			break ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
				case IDCANCEL:
					EndDialog (hDlg, wParam == IDOK) ;
					
					return TRUE ;
				
				case IDC_HELP:
					Help (HELP_CONTEXT, 100) ;
					
					return TRUE ;
				}
			
			break ;
		
		case WM_DESTROY:
			DeleteObject (hbmp) ;
			DeleteObject (hbr) ;
			
			return TRUE ;
		}
	
	return FALSE ;
	}
