; =============================================================================
; GBDEMO 1.1
; by Jens Ch. Restemeier <jchrr@hrz.uni-bielefeld.de>
; you need my GB-tools to build it.
; =============================================================================
; Greetings to:
;  Jeff Frohwein
;  Marat Fayzullin
;  Marcel de Kogel
;  Hero Zero
;  Dr. Pan
;  Tom Hammersley
;  Pascal Felber
;  Mr. Pita
;  - keep up the good work !
; =============================================================================
; Interesting parts:
;  APA-GFX, using Bresenham line and circle
;  GFX compression using my own algorithm
;  Maybe I write a real demo soon (with scrolling or 3D parts), but I don't
;  have much time, and I still need lots of information...
;  Has anyone started a musicplayer, yet ?
; =============================================================================
; History:
;  1.0 : first version
;  1.1 : added "GAMEBOY.INC" and used the symbols
; =============================================================================

#include "GameBoy.INC"

lorambase       =       0c000h
hirambase       =       0ff80h

#DEFINE LOBYTEVAR(X)  X = lorambase \lorambase  .set (lorambase + 1)
#DEFINE HIBYTEVAR(X)  X = hirambase \hirambase  .set (hirambase + 1)
#DEFINE LOWORDVAR(X)  X = lorambase \lorambase  .set (lorambase + 2)
#DEFINE HIWORDVAR(X)  X = hirambase \hirambase  .set (hirambase + 2)

; Create variables in hi-ram
HIBYTEVAR(JOY_TIPP)
HIBYTEVAR(JOY_HOLD)

HIBYTEVAR(x1)
HIBYTEVAR(y1)
HIBYTEVAR(x2)
HIBYTEVAR(y2)
HIBYTEVAR(radius)
HIBYTEVAR(color)

HIBYTEVAR(xc)
HIBYTEVAR(yc)
HIBYTEVAR(i1)
HIBYTEVAR(i2)
HIBYTEVAR(sx)
HIBYTEVAR(sy)
HIWORDVAR(d)

; =============================================================================
.org 0
; Try "TYPE GBDEMO.GBS" to see this:
.text "A small GFX-DEMO for GameBoy"
; This is: LF, CR, EOF
.byte 00ah,00dh,01ah
; =============================================================================

; Set all irq vectors to do nothing.
.org 40h                ; VBlank IRQ
 reti                   ; Do nothing
.org 48h                ; LCDC Status IRQ
 reti                   ; Do nothing
.org 50h                ; Timer Owerflow IRQ
 reti                   ; Do nothing
.org 58h                ; Serial Transfer Completion IRQ
 reti                   ; Do nothing
.org 60h                ; Joypad action (?) IRQ
 reti                   ; Do nothing
; Irqs done..

.org 70h
bitmask:                ; For a simple bitmask-calculation
			; The label isn't neccessary, because the table MUST
			; be located at org $70 !
.byte 080h,040h,020h,010h,008h,004h,002h,001h,000h

; = Gameboy Header ============================================================
.org 100h
		nop
		jp      start

.byte $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83 ; Nintendo Logo
.byte $00,$0C,$00,$0D,$00,$08,$11,$1F,$88,$89,$00,$0E
.byte $DC,$CC,$6E,$E6,$DD,$DD,$D9,$99,$BB,$BB,$67,$63
.byte $6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E

.byte "GAMEBOY DEMO    "        ; Cart name   16bytes
.byte 0,0,0                     ; Not used
.byte 0                         ; Cart type   ROM Only
.byte 0                         ; ROM Size    32k
.byte 0                         ; RAM Size     0k
.word 000h                      ; Maker ID
.byte 1                         ; Version     =2
.byte 0ffh                      ; Complement check (Don't know )
.word 0ffffh                    ; Cheksum (calculated with CALC_CRC)
; =============================================================================

; =============================================================================
; Main procedure
; =============================================================================
start:          di                   
		ld      sp,0fff4h       

		ld      a,0             ; No IRQs at all
		ldh     (IE_H),a

		sub     a               ; Misc standard init things..
		ldh     (LCDC_H),a      ; LCDC Status
		ldh     (SCX_H),a       ; Screen scroll Y=0
		ldh     (SCY_H),a       ; Screen scroll X=0

		call    waitvbl         ; Must be in VBL before turning the screen off.

		ld      a,00010001b     ; LCD Controller = Off (No picture on screen)
					; WindowBank = $9800 (Not used)
					; Window = OFF
					; BG Chr = $8000
					; BG Bank= $9800
					; OBJ    = 8x8
					; OBJ    = Off
					; BG     = On
		ldh     (LCDC_H),a

		ld      a,11100100b     ; grey 3=11 (Black)
					; grey 2=10 (Dark grey)
					; grey 1=01 (Light grey)
					; grey 0=00 (Transparent)
		ldh     (BGP_H),a

		call    init_apa
		call    show_scr1

		ld      a,10010001b     ; LCD Controller = On
		ldh     (LCDC_H),a

		; draw a triangle
		ld      a,1
		ld      (color),a
		ld      a,64
		ld      (x1),a
		ld      a,8
		ld      (y1),a
		ld      (x2),a
		ld      a,120
		ld      (y2),a
		call    line                
		ld      a,8
		ld      (x1),a
		ld      a,120
		ld      (y1),a
		ld      (y2),a
		ld      a,120
		ld      (x2),a
		call    line                
		ld      a,64
		ld      (x1),a
		ld      a,8
		ld      (y1),a
		ld      a,120
		ld      (y2),a
		ld      a,120
		ld      (x2),a
		call    line                

		; and a bunch of circles
		ld      a,64
		ld      (x1),a
		ld      (y1),a
		ld      a,3
		ld      (color),a
		ld      a,10
		ld      (radius),a
		call    circle
		ld      a,2
		ld      (color),a
		ld      a,20
		ld      (radius),a
		call    circle
		ld      a,1
		ld      (color),a
		ld      a,30
		ld      (radius),a
		call    circle

		call    wait_key

		ld      a,00010001b     ; LCD Controller = Off
		ldh     (LCDC_H),a

		call    show_scr2

		ld      a,10010001b     ; LCD Controller = On
		ldh     (LCDC_H),a

		call    wait_key

		ld      a,00010001b     ; LCD Controller = Off
		ldh     (LCDC_H),a

		; nextscreen...

end:            jp      start

; =============================================================================
; Wait for a key
; =============================================================================
wait_key:       call    readjoy
		ld      a,(JOY_TIPP)
		or      a
		jp      z,wait_key
		ret

; =============================================================================
; Read joypad
; =============================================================================
readjoy:        ld      a,020h  ; read first nibble
		ldh     (JOYPAD_H),a
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		cpl
		and     00fh
		swap    a
		ld      b,a
		ld      a,010h  ; read second nibble
		ldh     (JOYPAD_H),a
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		ldh     a,(JOYPAD_H)
		cpl
		and     00fh
		or      b               ; combine them
		ld      c,a
		ld      a,(JOY_HOLD)
		xor     c
		and     c
		ld      (JOY_TIPP),a
		ld      a,c
		ld      (JOY_HOLD),a
		ld      a,030h
		ldh     (JOYPAD_H),a
		ret

; =============================================================================
; Wait for VBL
; =============================================================================
waitvbl:        ldh     a,(LCDC_H)      ; Wait for VBL
		add     a,a
		ret     nc
notyet:         ldh     a,(LY_H) 
		cp      90h             ; $90 and bigger = in VBL
		jr      nz,notyet       ; Loop until it $90
		ret

; =============================================================================
; Draw a line from (X1),(Y1) to (X2),(Y2) with (color)
; =============================================================================
line:           xor     a
		ld      (d),a
		ld      (d+1),a

		ld      a,(x2)
		ld      b,a
		ld      a,(x1)
		ld      (xc),a
		sub     b
		ld      b,0
		or      a
		jr      z,l_px
		ld      b,0ffh
		bit     7,a
		jr      z,l_px
		neg
		ld      b,01h
l_px:           ld      d,a             ; dx sichern
		sla     a
		ld      (i2),a          ; i2=dx*2
		ld      a,b
		ld      (sx),a
		ld      a,(y2)
		ld      b,a
		ld      a,(y1)
		ld      (yc),a
		sub     b
		ld      b,0
		jr      z,l_py
		ld      b,0ffh
		bit     7,a
		jr      z,l_py
		neg
		ld      b,01h
l_py:           ld      e,a             ; dy sichern
		sla     a
		ld      (i1),a          ; i1=dy*2
		ld      a,b
		ld      (sy),a
		ld      a,d
		cp      e               ; dx<dy ?
		jr      c,dloop2
; dx>dy
dloop:          ld      a,(xc)          ; if ((x1==x2)&&(y1==y2)) return;
		ld      b,a
		ld      a,(yc)
		ld      c,a
		call    point
		ld      a,(xc)
		ld      b,a
		ld      a,(x2)
		cp      b
		jr      nz,dnext
		ld      a,(yc)
		ld      b,a
		ld      a,(y2)
		cp      b
		jr      nz,dnext
		ret
dnext:          ld      a,(d)
		ld      e,a
		ld      a,(d+1)
		ld      d,a
		bit     7,d
		jr      nz,xxp
		ld      a,(sy)          ; yc+=sy
		ld      b,a
		ld      a,(yc)
		add     a,b
		ld      (yc),a

		ld      a,(i2)          ; d-=i2
		ld      b,a
		ld      a,e
		sub     b
		ld      e,a
		jr      nc,jnc1
		dec     d
jnc1:
xxp:            ld      a,(sx)          ; xc+=sx
		ld      b,a
		ld      a,(xc)
		add     a,b
		ld      (xc),a

		ld      a,(i1)          ; d+=i1
		ld      b,a
		ld      a,e
		add     a,b
		ld      (d),a
		jr      nc,jnc2
		inc     d
jnc2:           ld      a,d
		ld      (d+1),a
		jr      dloop
; dy>dx
dloop2:         ld      a,(xc)          ; if ((x1==x2)&&(y1==y2)) return;
		ld      b,a
		ld      a,(yc)
		ld      c,a
		call    point
		ld      a,(xc)
		ld      b,a
		ld      a,(x2)
		cp      b
		jr      nz,dnext2
		ld      a,(yc)
		ld      b,a
		ld      a,(y2)
		cp      b
		jr      nz,dnext2
		ret
dnext2:         ld      a,(d)
		ld      e,a
		ld      a,(d+1)
		ld      d,a
		bit     7,d
		jr      nz,yyp
		ld      a,(sx)          ; xc+=sy
		ld      b,a
		ld      a,(xc)
		add     a,b
		ld      (xc),a

		ld      a,(i1)          ; d-=i2
		ld      b,a
		ld      a,e
		sub     b
		ld      e,a
		jr      nc,jnc12
		dec     d
jnc12:
yyp:            ld      a,(sy)          ; yc+=sy
		ld      b,a
		ld      a,(yc)
		add     a,b
		ld      (yc),a

		ld      a,(i2)          ; d+=i1
		ld      b,a
		ld      a,e
		add     a,b
		ld      (d),a
		jr      nc,jnc22
		inc     d
jnc22:          ld      a,d
		ld      (d+1),a
		jr      dloop2

; =============================================================================
; Draw a circle to (x1),(y1) with (radius)
; =============================================================================
circle:         ld      a,(radius)
		ld      e,a             ; e=sy
		ld      l,a
		xor     a
		ld      d,a             ; d=sx
		ld      h,a             
		sla     l               ; hl=3-(hl<<1)
		rl      h
		ld      a,3
		sub     l
		ld      l,a
		ld      a,h
		sbc     a,0
		ld      h,a

		ld      a,(x1)          ; b=x
		ld      b,a
		ld      a,(y1)          ; c=y
		ld      c,a

		push    hl

		push    de
		push    bc              ;  put(px+RADIUS,py)
		ld      a,b
		add     a,e
		ld      b,a
		call    point
		pop     bc
		pop     de

		push    de
		push    bc              ;  put(px-RADIUS,py)
		ld      a,b
		sub     e
		ld      b,a
		call    point
		pop     bc
		pop     de

		push    de
		push    bc              ;  put(px,py+RADIUS)
		ld      a,c
		add     a,e
		ld      c,a
		call    point
		pop     bc
		pop     de

		push    de
		push    bc              ;  put(px,py-RADIUS)
		ld      a,c
		sub     e
		ld      c,a
		call    point
		pop     bc
		pop     de

		pop     hl

cl:             inc     d

		bit     7,h
		jr      z,no_y

		ld      a,d             ; d += (x<<2)
		ld      c,a
		xor     a
		ld      b,a
		sla     c
		rl      b
		sla     c
		rl      b
		add     hl,bc
		jr      cp

no_y:           ld      a,d             ; d += ((x - y)<<2)
		sub     e
		ld      c,a
		ld      a,0
		sbc     a,0
		ld      b,a
		sla     c
		rl      b
		sla     c
		rl      b
		add     hl,bc

		dec     e               ; y--

cp:             push    hl

		push    de              ; put(px+sx,py+sy)
		ld      a,(x1)          ; b=x
		add     a,d
		ld      b,a
		ld      a,(y1)          ; c=y
		add     a,e
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px+sx,py-sy)
		ld      a,(x1)          ; b=x
		add     a,d
		ld      b,a
		ld      a,(y1)          ; c=y
		sub     e
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px-sx,py+sy)
		ld      a,(x1)          ; b=x
		sub     d
		ld      b,a
		ld      a,(y1)          ; c=y
		add     a,e
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px-sx,py-sy)
		ld      a,(x1)          ; b=x
		sub     d
		ld      b,a
		ld      a,(y1)          ; c=y
		sub     e
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px+sy,py+sx)
		ld      a,(x1)          ; b=x
		add     a,e
		ld      b,a
		ld      a,(y1)          ; c=y
		add     a,d
		ld      c,a
		call    point
		pop     de
		
		push    de              ; put(px+sy,py-sx)
		ld      a,(x1)          ; b=x
		add     a,e
		ld      b,a
		ld      a,(y1)          ; c=y
		sub     d
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px-sy,py+sx)
		ld      a,(x1)          ; b=x
		sub     e
		ld      b,a
		ld      a,(y1)          ; c=y
		add     a,d
		ld      c,a
		call    point
		pop     de

		push    de              ; put(px-sy,py-sx)
		ld      a,(x1)          ; b=x
		sub     e
		ld      b,a
		ld      a,(y1)          ; c=y
		sub     d
		ld      c,a
		call    point
		pop     de

		pop     hl

		ld      a,d
		cp      e
		jr      z,ce
		jp      c,cl

ce:             ret

; =============================================================================
; Put a pixel to (b/c) with (color)
; =============================================================================
point:          ld      a,c             ; de = 8000h + y*2 + (x/8)*256
		rlc     a
		ld      e,a
		ld      a,b
		srl     a
		srl     a
		srl     a
		add     a,080h
		ld      d,a
		ld      a,b             
		and     7
		or      070h
		ld      l,a
		ld      h,0          ; hl=070h+(B&7)
		ld      a,(HL)
		ld      b,a
point1:         ld      hl,color        ; check color
		bit     0,(hl)
		jr      z,point3
point2:         ldh     a,(STAT_H)         ; Wait for H/V-Retrace
		bit     1,a
		jp      nz,point2
		ld      a,(de)
		xor     b
		ld      (de),a
point3:         inc     de
		bit     1,(hl)          ; check color
		jr      z,point5
point4:         ldh     a,(STAT_H)         ; Wait for H/V-Retrace
		bit     1,a
		jp      nz,point4
		ld      a,(de)
		xor     b
		ld      (de),a
point5:         ret

; =============================================================================
;  Show a GBAPA-Pic
; =============================================================================
show_scr1:      ld      hl,init_gfx
		ld      de,lorambase
		call    decompress      ; decompress into RAM
		ld      bc,4096
		ld      de,lorambase
		ld      hl,08000h
		call    copy_data       ; copy to VRAM
		ret

; =============================================================================
;  Show a optimized Pic
; =============================================================================
show_scr2:      ld      hl,font1        ; Copy the font
		ld      de,lorambase
		call    decompress      ; decompress into RAM
		ld      de,lorambase    
		ld      hl,08000h
		ld      bc,4096
		call    copy_data       ; copy to VRAM
		; Copy the map:
		ld      hl,9800h
		ld      bc,map1
		ld      e,18
sloop1:         ld      d,20
sloop2:         ld      a,(bc)
		ldi     (hl),a
		inc     bc
		dec     d
		jp      nz,sloop2
		push    de
		ld      de,12
		add     hl,de
		pop     de
		dec     e
		jp      nz,sloop1
		ret

; =============================================================================
; Copy bc bytes from de to hl
; =============================================================================
copy_data:      ld      a,(de)
		ldi     (hl),a
		inc     de
		dec     bc
		ld      a,b
		or      c
		jp      nz,copy_data
		ret

; =============================================================================
; Fill bc bytes from hl with a
; =============================================================================
fill_data:      ld      d,a
f1:             ld      a,d
		ldi     (hl),a
		dec     bc
		ld      a,b
		or      c
		jp      nz,f1
		ret

; =============================================================================
; Clear screen
; =============================================================================
cls:            ld      hl,8000h
		ld      bc,2048
		ld      a,0
		call    fill_data
		ret

; =============================================================================
; Initialize screen for apa-mode (all points adressable)
; =============================================================================
init_apa:       ld      hl,9800h        ; First clear the screen
		ld      bc,32*32        ; complete screen
cloop2:         ld      a,00h           ; char 0 is empty on demo screen
		call    fill_data       ; clear screen
		ld      b,0
		ld      hl,9822h        ; Now draw the 16*16 matrix
		ld      e,10h
loop1:          ld      d,10h
loop2:          ld      a,b
		swap    a               ; The screen must be rotated by 90.
		ldi     (hl),a
		inc     b
		dec     d
		jp      nz,loop2
		push    de
		ld      d,0
		ld      e,010h
		add     hl,de
		pop     de
		dec     e
		jp      nz,loop1
		ret

; = Decompression of packed data: =============================================
#include "DECOMP.INC"
; =============================================================================

; first gfx: gbapa-mode
init_gfx:
#include "gbdemo1.pch"

; second gfx: optimized map
map1:
#include "gbdemo1.mh"
font1:
#include "gbdemo1.fch"

; Single bank/second bank: check for ROM-overflow
#if ($ > 07FFFh)
		ROM_OVERFLOW_ERROR
#endif

; First bank: check for bank-overflow
;#if ($ > 03FFFh)
;               BANK_OVERFLOW_ERROR
;#endif

; =============================================================================

.end
