; =============================================================================
;  Get the analog values from the Joystick.
; =============================================================================

IDEAL
P386

; Config:

BOX_SIZE	EQU 010h

JOY_DOWN        EQU 080h
JOY_UP          EQU 040h
JOY_LEFT        EQU 020h
JOY_RIGHT       EQU 010h

GLOBAL Init_AnalogJoystick:NEAR
GLOBAL Get_AnalogJoystick:NEAR
GLOBAL Joypad:BYTE
;GLOBAL Joybase:WORD
;GLOBAL Maxjoy:WORD

SEGMENT Code PARA PUBLIC 'CODE'
ASSUME CS:Code,DS:Code

JoyBase dw 0201h        ; Base-Adr of Joystick-Board
MaxJoy  dw 0h           ; Max Loop for Joy

; Center
XM      dw 0h
YM      dw 0h

PROC Init_AnalogJoystick NEAR
	    Cli
	    Push BP
	    Push AX
	    Push BX
	    Push CX
	    Push DX
	    Mov [CS:MaxJoy],0FFFh
	    Xor BX,BX
	    Xor CX,CX
	    Xor BP,BP
	    Mov DX,[CS:JoyBase]
	    Out DX,AL
@@ReadLoop: In AL,DX
	    Test AL,1
	    Jz SHORT @@V1Stop
	    Mov BX,BP
@@V1Stop:   Test AL,2
	    Jz SHORT @@V2Stop
	    Mov CX,BP
@@V2Stop:   Test AL,00Fh
	    Jz SHORT @@Done
	    Inc BP
	    Cmp BP,[MaxJoy]
	    Jne SHORT @@ReadLoop
@@Done:     Mov [CS:XM],BX
	    Mov [CS:YM],CX
	    Cmp BX,CX
	    Jg SHORT @@G
	    Mov BX,CX
@@G:	    Shl BX,1
	    Mov [CS:MaxJoy],BX
	    Pop DX
	    Pop CX
	    Pop BX
	    Pop AX
	    Pop BP
	    Sti
	    Ret
ENDP

PROC Get_AnalogJoystick NEAR
	    Cli
	    Push BP
	    Push AX
	    Push BX
	    Push CX
	    Push DX
	    Xor BX,BX
	    Xor CX,CX
	    Xor BP,BP
	    Mov [CS:Joypad],000h
	    Mov DX,[CS:JoyBase]
	    Out DX,AL
@@ReadLoop: In AL,DX
	    Test AL,1
	    Jz SHORT @@V1Stop
	    Mov BX,BP
@@V1Stop:   Test AL,2
	    Jz SHORT @@V2Stop
	    Mov CX,BP
@@V2Stop:   Test AL,00Fh
	    Jz SHORT @@Done
	    Shr AL,4
	    Xor AL,00Fh
	    Or [CS:JoyPad],AL
	    Inc BP
	    Cmp BP,[MaxJoy]
	    Jne SHORT @@ReadLoop
@@Done:     Sub BX,[CS:XM]
	    js SHORT @@XG
	    Cmp BX,BOX_SIZE
	    Jng SHORT @@XL
	    Or [CS:JoyPad],JOY_RIGHT
	    Jmp SHORT @@XL
@@XG:       Neg BX
	    Cmp BX,BOX_SIZE
	    Jng SHORT @@XL
	    Or [CS:JoyPad],JOY_LEFT
@@XL:       Sub CX,[CS:YM]
	    Js SHORT @@YG
	    Cmp CX,BOX_SIZE
	    Jng SHORT @@YL
	    Or [CS:JoyPad],JOY_DOWN
	    Jmp SHORT @@YL
@@YG:       Neg CX
	    Cmp CX,BOX_SIZE
	    Jng SHORT @@YL
	    Or [CS:JoyPad],JOY_UP
@@YL:       Xor [CS:JoyPad],0FFh
	    Pop DX
	    Pop CX
	    Pop BX
	    Pop AX
	    Pop BP
	    Sti
	    Ret
ENDP

ENDS

END
