{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+,M 16384,0,400000}
PROGRAM GBSim;

USES
  Crt,Dos,GBDis,WinTest,USEMM386,LabTool;

CONST
  VMin = 99;
  VMaj = 0;

{ ========================================================================== }
{ Dieses Programm ist ein Gameboy Emulator mit integriertem Debugger.        }
{ ========================================================================== }

{ CPU-Emulator }
{$L C:\ASM\GBSIM\GBCPU.OBJ}
PROCEDURE CallGB;External;
PROCEDURE aAsmData;External;

{ Joypad Treiber: }
{$L C:\ASM\GBSIM\JOYPAD.OBJ}
PROCEDURE Init_AnalogJoystick;External;
PROCEDURE Get_AnalogJoystick;External;

TYPE
  TStyle     = ARRAY [0..7] OF Char;

CONST
  HexDigits : String = '0123456789ABCDEF';

  Button_A   = 1;
  Button_B   = 2;
  Button_Sel = 4;
  Button_Str = 8;
  Joy_Rechts = 16;
  Joy_Links  = 32;
  Joy_Oben   = 64;
  Joy_Unten  = 128;

  F_TimerInt      = 1;  {  Timer-Int wurde ausgefhrt  }
  F_SerInt        = 2;	{                              }
  F_KeyInt        = 4;	{                              }
  F_Error         = 8;	{  Fehler (Illegal Opcode)     }
  F_Halt          = 16;	{  HLT-Befehl                  }
  F_SingleStep    = 32;	{  Einzelschritt-Modus         }
  F_MMUAccess     = 64;	{  Schreibzugriff auf $2000    }
  F_MMU_Error     = 128;

  Style1     : TStyle = 'ͻͼ';
  Style2     : TStyle = 'Ŀ';
  Style3     : TStyle = '͸';

  MaxBPoints = 9;

  Log_File   = 'C:\GBSIM.LOG';

TYPE
  PWRegStruc = ^TWRegStruc;
  TWRegStruc = RECORD
                  reg_AF,reg_BC,reg_DE,reg_HL,reg_SP,reg_PC : Word;
               END;
  PBRegStruc = ^TBRegStruc;
  TBRegStruc = RECORD
                 reg_A,reg_F,reg_C,reg_B,reg_E,reg_D,reg_L,reg_H : Byte;
               END;

  TBreakpoint = RECORD
                  Adress   : Word;
                  Old_Byte : Byte;
                  Enable   : Byte;
                END;
  TAsmData    = RECORD
                  Regs     : TWRegStruc;
                  Flags    : Word;
                  IE       : Byte;
                  Writeseg : Word;
                  ReadSeg  : Word;
                  MMUPage  : Byte;
                  Joypad   : Byte;
                  IOReg    : Word;
                  PScrInfo : Pointer;
                END;
  PAsmData    = ^TAsmData;
  TPal        = ARRAY  [0..3] OF Byte;
  TArray      = ARRAY[0..65534] OF Byte;

VAR
  NumBPoints      : Word;
  EXPHandle       : Word;
  EXPNum          : Word;
  BlockNum        : Word;
  CodeAnf,CodeEnd : Word;
  Cursor          : Word;
  MemoryPos       : Word;
  DataSize        : Word;
  GameData        : Word;
  MME             : Word;
  LineBuf         : ARRAY [0..$FF] OF Byte;
  FlipTable       : ARRAY [0..$FF] OF Byte;
  ScreenBuf       : ARRAY [0..23039] OF Byte;
  ScrInfo         : ARRAY [0..143,0..11] OF Byte;
  APal            : ARRAY [0..255] OF TPal;
  MapArray        : ARRAY [0..7] OF MapInfo;
  BPoints         : ARRAY [0..MaxBPoints] OF TBreakPoint;
  Grafmode        : Boolean;
  Ende            : Boolean;
  Filename        : String;
  AsmData         : PAsmData;
  MusicRip        : Boolean;
  MusicFile       : FILE;

FUNCTION DStr(I:LongInt):String;
VAR
  D:String;
BEGIN
  D:='';
  REPEAT
    D:=Char(48+(I MOD 10))+D;
    I:=I DIV 10;
  UNTIL I=0;
  DStr:=D;
END;

FUNCTION Exist(N:String):Boolean;
VAR
  S:SearchRec;
BEGIN
  FindFirst(N,AnyFile,S);
  Exist:=DosError=0;
END;

{ Labelverwaltung initialisieren  }
PROCEDURE ReadLabelList(NNN:String);
VAR
  L:TEXT;
  Line,Lab:String;
  Adr:Word;
BEGIN
  IF Exist(NNN) THEN BEGIN
    Assign(L,NNN);
    Reset(L);
    WHILE NOT Eof(L) DO BEGIN
      ReadLn(L,Line);
      IF Pos(';',Line)>0 THEN Line[0]:=Char(Pos(';',Line)-1);
      WHILE Pos(#9,Line)>0 DO Line[Pos(#9,Line)]:=#32;
      WHILE (Line[1]=#32) AND (Length(Line)>0) DO Delete(Line,1,1);
      WHILE Pos('  ',Line)>0 DO Delete(Line,Pos('  ',Line),1);
      IF Length(Line)>0 THEN BEGIN
        Lab:=Copy(Line,1,Pos(#32,Line)-1);
        Delete(Line,1,Pos('EQU ',Line)+3);
        Adr:=Dez(Line);
        IF Adr>-1 THEN AddLabel(Lab,Adr);
      END;
    END;
    Close(L);
  END ELSE BEGIN
    WriteLn(NNN,' not found !');
  END;
END;

{ GBSIM initialisieren }
PROCEDURE Init;
VAR
  C1,C2:Byte;
BEGIN
  { Create Table: }
  FOR C1:=0 TO $FF DO BEGIN
    FlipTable[C1]:=0;
    FOR C2:=0 TO 7 DO
      IF (C1 AND (1 SHL C2))>0 THEN
        FlipTable[C1]:=FlipTable[C1] OR ($80 SHR C2);
  END;
  FillChar(ScreenBuf,SizeOf(ScreenBuf),0);
  FOR C1:=0 TO 255 DO BEGIN
    APal[C1,0]:=(C1 AND 3);
    APal[C1,1]:=((C1 SHR 2) AND 3);
    APal[C1,2]:=((C1 SHR 4) AND 3);
    APal[C1,3]:=((C1 SHR 6) AND 3);
  END;

  If ParamCount=0 THEN FileName:='TETRIS' ELSE FileName:=ParamStr(1);
  IF Pos('.',FileName)=0 THEN FileName:=FileName+'.GB';
  WriteLn('General labels ...');
  ReadLabelList('GAMEBOY.L');
  WriteLn('Labellist ...');
  ReadLabelList(Copy(FileName,1,Pos('.',FileName))+'L');
  FillChar(BPoints,SizeOf(BPoints),0);
  MemoryPos:=0;
  NumBPoints:=0;

  MapArray[0].SA:=GameData;
  MapArray[0].PP:=0;
  MapArray[1].SA:=GameData+1024;
  MapArray[1].PP:=1;
  MapArray[2].SA:=GameData+2048;
  MapArray[2].PP:=2;
  MapArray[3].SA:=GameData+3072;
  MapArray[3].PP:=3;

  MapArray[4].SA:=AsmData^.WriteSeg;
  MapArray[4].PP:=0;
  MapArray[5].SA:=AsmData^.WriteSeg+1024;
  MapArray[5].PP:=1;
  MapArray[6].SA:=AsmData^.WriteSeg+2048;
  MapArray[6].PP:=2;
  MapArray[7].SA:=AsmData^.WriteSeg+3072;
  MapArray[7].PP:=3;
END;

PROCEDURE Done;
VAR
  R:Registers;
BEGIN
  R.AX:=$1104;R.BL:=0;
  Intr($10,R);
END;

{ == Stringoperationen ===================================================== }

FUNCTION LeerString(L:Byte):String;
VAR
  D:String;
BEGIN
  FillChar(D,SizeOf(D),#32);
  D[0]:=Char(L);
  LeerString:=D;
END;

PROCEDURE Extend(VAR S:String;L:Byte);
BEGIN
  WHILE Length(S)<L DO S:=S+#32;
END;

FUNCTION UpString(S:String):String;
VAR
  C:Byte;
BEGIN
  FOR C:=1 TO Length(S) DO S[C]:=UpCase(S[C]);
  UpString:=S;
END;

{ == Die "grafische" Oberflche ============================================ }

VAR
  O:Word;

PROCEDURE GotoXY(X,Y:Byte);
BEGIN
  O:=(X-1)*2+(Y-1)*160;
END;

PROCEDURE Write(S:String);
VAR
  C:Byte;
BEGIN
  FOR C:=1 TO Length(S) DO BEGIN
    MEM[$B800:O]:=Byte(S[C]);
    MEM[$B800:O+1]:=TextAttr;
    Inc(O,2);
  END;
END;

PROCEDURE Box(X1,Y1,X2,Y2:Byte;TC,TB:Byte;Style:TStyle);
VAR
  C1,C2 : Byte;
BEGIN
  TextColor(TC);TextBackground(TB);
  GotoXY(X1,Y1);Write(Style[0]);FOR C1:=X1+1 TO X2-1 DO Write(Style[1]);Write(Style[2]);
  FOR C1:=Y1+1 TO Y2-1 DO BEGIN
    GotoXY(X1,C1);Write(Style[3]);FOR C2:=X1+1 TO X2-1 DO Write(#32);Write(Style[4]);
  END;
  GotoXY(X1,Y2);Write(Style[5]);FOR C1:=X1+1 TO X2-1 DO Write(Style[6]);Write(Style[7]);
END;

PROCEDURE Eingabe(T:String;VAR E:String);
BEGIN
  Box(1,22,40,24,Black,Cyan,Style2);
  GotoXY(4,22);Write('  '+T+'  ');
  Crt.GotoXY(2,23);ReadLn(E);
  Box(1,22,40,24,Black,Black,Style2);
END;

PROCEDURE Meldung(T:String);
BEGIN
  Box(2,2,40,4,White,Red,Style2);
  GotoXY(3,3);Write(T);
END;

{ == Tools ================================================================= }

PROCEDURE Log_IO;
VAR
  F:TEXT;
  C:Word;
  D,An:String;
BEGIN
  Assign(F,Log_File);
  Append(F);
  IF IOResult<>0 THEN ReWrite(F);
  D:='';
  Eingabe('Comment',An);
  FOR C:=$00 TO $4F DO
    D:=D+Hex(MEM[Gamedata:$FF00+C],2)+' ';
  WriteLn(F,D,'-> ',An);
  Close(F);
END;

PROCEDURE RomInfo;
VAR
  C,Man,X,Y:Word;
  R:Registers;
  FF : ARRAY [0..15,0..15] OF Byte;
BEGIN
  Box(5,5,40,11,White,Green,Style2);
  GotoXY(8,5);Write('  ROM Information  ');
  GotoXY(7,6);Write('Name:');
  FOR C:=0 TO 17 DO Write(Char(MEM[GameData:$134+C]));
  Man:=MEM[GameData:$14B];
{
  IF Man=51 THEN
    Man:=(Pos(Char(MEM[GameData:$144]),HexDigits)-1)*16+(Pos(Char(MEM[GameData:$145]),HexDigits)-1);
  C:=0;WHILE (C<ManNum) AND (Manufacturers[C].Num<>Man) DO Inc(C);
  GotoXY(7,7);Write('Producer: 0'+Hex(Man,2)+'h ');
  IF (C<ManNum) THEN
    Write('('+Manufacturers[C].S+')')
  ELSE
    Write('(Unknown)');
}
  GotoXY(7,8);Write('ROM: '+DStr($20 SHL MEM[GameData:$148])+' kByte');
  IF MEM[GameData:$149]>0 THEN Write('  RAM:'+DStr(2 SHL ((MEM[GameData:$149]-1) SHL 1))+' kByte');
  GotoXY(7,9);
  CASE  MEM[GameData:$147] OF
    0: Write('ROM ONLY');
    1: Write('ROM+MBC1');
    2: Write('ROM+MBC1+RAM');
    3: Write('ROM+MBC1+RAM+BATTERY');
    5: Write('ROM+MBC2');
    6: Write('ROM+MBC2+BATTERY');
  END;
  FillChar(FF,SizeOf(FF),0);
  FOR Y:=0 TO 7 DO
    FOR X:=0 TO 47 DO
      IF ((MEM[GameData:$104+(Y SHR 2)*24+(X SHR 2)*2+((Y SHR 1) AND 1)] SHL ((X AND 3)+((Y AND 1)*4))) AND 128)>0
      THEN
        FF[(X*2) SHR 3,Y*2]:=FF[(X*2) SHR 3,Y*2] OR (128 SHR (((X*2) AND 7)));

  R.AX:=$1100;
  R.BX:=$1000;
  R.CX:=16;
  R.DX:=235;
  R.ES:=Seg(FF);
  R.BP:=Ofs(FF);
  Intr($10,R);

  GotoXY(7,10);Write('Logo: ');FOR C:=0 TO 15 DO Write(Char(235+C));
  GotoXY(8,11);Write('  GBSIM Version '+DStr(VMaj)+'.'+DStr(VMin)+'  ');
  ReadKey;
END;

{ == Breakpoints =========================================================== }

FUNCTION CheckBreakPoint(A:Word):Boolean;
VAR
  C:Word;
BEGIN
  CheckBreakPoint:=False;
  FOR C:=0 TO MaxBPoints DO BEGIN
    WITH BPoints[C] DO BEGIN
      IF (Enable>0) AND (Adress=A) THEN CheckBreakPoint:=True;
    END;
  END;
END;

PROCEDURE ClearBreakPoint(A:Word);
VAR
  C:Word;
BEGIN
  FOR C:=0 TO MaxBPoints DO BEGIN
    WITH BPoints[C] DO BEGIN
      IF (Enable>0) AND (Adress=A) THEN BEGIN
        Dec(Enable);
        IF Enable=0 THEN Dec(NumBPoints);
      END;
    END;
  END;
END;

PROCEDURE SetBreakPoint(A:Word);
VAR
  C:Word;
BEGIN
  ClearBreakPoint(A);
  C:=0;
  REPEAT
    WITH BPoints[C] DO BEGIN
      IF (Enable=0) OR (Adress=A) THEN BEGIN
        IF Enable=0 THEN Inc(NumBPoints);
        Inc(Enable);
        Adress:=A;
        C:=MaxBPoints;
      END;
    END;
    Inc(C);
  UNTIL (C>MaxBPoints);
END;

PROCEDURE FlipBreakPoint(A:Word);
BEGIN
  IF CheckBreakPoint(A) THEN
    ClearBreakPoint(A)
  ELSE
    IF NumBPoints<MaxBPoints THEN SetBreakPoint(A);
END;

FUNCTION FindNextBreakPoint(A:Word):Word;
VAR
  F,C:Word;
BEGIN
  F:=$FFFF;
  FOR C:=0 TO MaxBPoints DO BEGIN
    WITH BPoints[C] DO BEGIN
      IF (Enable>0) AND (Adress>A) AND (F>Adress) THEN F:=Adress;
    END;
  END;
  IF F<$FFFF THEN FindNextBreakPoint:=F ELSE FindNextBreakPoint:=A;
END;

PROCEDURE ClearAllBreakpoints;
BEGIN
  FillChar(BPoints,SizeOf(BPoints),0);
  NumBPoints:=0;
END;

{ == Modul laden =========================================================== }

PROCEDURE Load_Game;
VAR
  F      : File;
  R,C,DR : Word;
  Buf    : ARRAY[0..3] OF Byte;
BEGIN
  Assign(F,FileName);
  Reset(F,1);
  R:=IOResult;
  IF R>0 THEN BEGIN
    WriteLn('Error:',R,' File:',FileName);
    Halt(R);
  END;
  BlockRead(F,Buf,SizeOf(Buf));
  IF (Char(Buf[0])='C') AND (Char(Buf[1])='T') AND  (Char(Buf[2])='T') THEN
    Seek(F,70)
  ELSE
    IF (LongInt(Buf[0])*$2000)+(LongInt(Buf[1])*$200000)=(FileSize(F)-512) THEN
      Seek(F,512)
    ELSE
      Seek(F,0);
  BlockNum:=(FileSize(F)+$3FFF) DIV $4000;
  EXPNum:=BlockNum+3; { 2 RamPages, eine fr zeugs }

  { Speicher anfordern }
  AllocPages(EXPHandle,EXPNum,'GBSIM___');

  { Modul laden }
  FOR C:=1 TO BlockNum DO BEGIN
    MapArray[0].PP:=C-1;
    MapPages(EXPHandle,MapArray,1);
    BlockRead(F,MEM[GameData:0],$4000,DR);
    System.Write(#13,'Reading ',Round((FilePos(F)/FileSize(F))*100),'%');
    R:=IOResult;
    IF R>0 THEN BEGIN
      System.WriteLn;
      System.WriteLn('Error:',R,' File:',FileName);
      Halt(R);
    END;
  END;
  System.WriteLn;

  MapArray[0].PP:=0;
  MapPages(EXPHandle,MapArray,1);

  MapArray[0].PP:=BlockNum;
  MapArray[1].PP:=BlockNum+1;
  MapPages(EXPHandle,MapArray,2);
  FillChar(MEM[GameData:0],$8000,0); { Clear Memory }

  MapArray[0].PP:=0;
  MapPages(EXPHandle,MapArray,1);

  Close(F);
END;

PROCEDURE Dispose_Game;
BEGIN
  MapArray[0].PP:=$FFFF;
  MapArray[1].PP:=$FFFF;
  MapArray[2].PP:=$FFFF;
  MapArray[3].PP:=$FFFF;
  MapArray[4].PP:=$FFFF;
  MapArray[5].PP:=$FFFF;
  MapArray[6].PP:=$FFFF;
  MapArray[7].PP:=$FFFF;
  MapPages(EXPHandle,MapArray,8);
  FreePages(EXPHandle);
END;

{ == Zusatz ================================================================ }

PROCEDURE Set_Timer_Speed(Count:LongInt);
BEGIN
  Count:=$1234DD DIV Count;
  ASM CLI END;
  Port[$43]:=$34;
  Port[$40]:=Lo(Count);
  Port[$40]:=Hi(Count);
  ASM STI END;
END;

PROCEDURE Reset_Timer;
BEGIN
  ASM CLI END;
  Port[$43]:=$34;
  Port[$40]:=0;
  Port[$40]:=0;
  ASM STI END;
END;

{ == Grafik ================================================================ }

PROCEDURE Graf_On;
VAR C:Byte;
BEGIN
  ASM
    Mov AX,$13
    Int $10
  END;
  Grafmode:=True;
  MEM[Gamedata:$FF00+$44]:=0;
  FOR C:=0 TO 3 DO BEGIN
    Port[$3C8]:=C;
    Port[$3C9]:=63-12*C;
    Port[$3C9]:=63-12*C;
    Port[$3C9]:=63-12*C;
  END;
END;

PROCEDURE Graf_Off;
BEGIN
  ASM
    Mov AX,$3
    Int $10
  END;
  Grafmode:=False;
END;

PROCEDURE Copy_Screen;ASSEMBLER;
ASM
     Mov AX,$A235
     Mov ES,AX
     Mov SI,OFFSET ScreenBuf
     Mov DI,0
     Cld
     Mov AX,144
@@L: Mov CX,40
     DB $F3,$66,$A5
     Add DI,160
     Dec AX
     Jnz @@L
END;

VAR
  CharAdr,L1,L2,Mask,PX : Word;
  SPAdr                 : Word;
  BPAdr                 : Word;
  CCX,PY,AA             : Byte;

PROCEDURE Show_Sprites;ASSEMBLER;
ASM
    Mov AX,[GameData]
    Mov ES,AX
    Xor SI,SI                   { SI = sprite number }
@@SL: { Calc Y-pos and startline }
      Mov AL,[ES:$FE00+SI]
      Sub AL,16
      Mov [PY],AL
      Xor AH,AH
      DB $69,$C0                { IMul AX,AX,160 }
      DW 160
      Add AX,OFFSET ScreenBuf
      Mov DI,AX

      { Calc byte- and bit-offset }
      Xor AH,AH
      Mov AL,[ES:$FE01+SI]
      Mov [CCX],AL
      And [CCX],7
      Sub AL,8
      And AL,$F8
      Mov [PX],AX
      Add DI,AX

      Mov AL,[ES:$FE02+SI]
      Xor AH,AH
      Shl AX,4
      Mov [CharAdr],AX
      Mov AL,[ES:$FE03+SI]
      Mov [AA],AL

      Add SI,4                  { Spter: Inc SI .. [SI*4]

      Cmp [PX],143
      Jg @@EY
      Or [PX],0
      Js @@EY

      { Read correct palette }
      Mov BX,8
      Test [AA],16
      Jz @@Pal1
      Inc BX
@@Pal1:
      Mov BL,[OFFSET ScrInfo+BX]
      Xor BH,BH
      Shl BX,2
      Add BX,OFFSET APal
      Mov [SPAdr],BX

      { Y-Size: 8/16 }
      Mov CX,8
      Test [BYTE PTR ScrInfo],4
      Jz @@no_double
      Shl CX,1
@@no_double:
@@LY:   Cmp [PY],144
        Jz @@EY
        Push CX
        Mov BX,[CharAdr]
        Or BX,$8000
        Mov AX,[ES:BX]
        Add [CharAdr],2
        Mov [BYTE PTR L1],AL
        Mov [BYTE PTR L2],AH
        Xor AL,AL
        Mov [BYTE PTR L1+1],AL
        Mov [BYTE PTR L2+1],AL
        Test [AA],32
        Jnz @@No_Flip
          Mov BX,[L1]
          Xor BH,BH
          Mov BL,[OFFSET Fliptable+BX]
          Mov [L1],BX
          Mov BX,[L2]
          Xor BH,BH
          Mov BL,[OFFSET Fliptable+BX]
          Mov [L2],BX
@@No_Flip:
        Mov CL,[CCX]
        Shl [L1],CL
        Shl [L2],CL
        Mov AX,[L1]
        Or AX,[L2]
        Mov [Mask],AX
        Mov CX,16
        Mov DX,[PX]
        Push DI
@@LX:     Cmp DX,160
          Jge @@EX

          Xor BX,BX
          shr [L2],1
          rcl BX,1
          shr [L1],1
          rcl BX,1
          Add BX,[SPAdr]
          Shr [Mask],1
          Jnc @@Not_Visible
            Mov AL,[DS:BX]
            Mov [DI],AL
@@not_Visible:
          Inc DX
          Inc DI
          Dec CX
        Jnz @@LX
@@EX:   Pop DI
        Add DI,160
        Inc [PY]
        Pop CX
        Dec CX
      Jnz @@LY
@@EY:
    Cmp SI,160
    Jnz @@SL
END;

PROCEDURE Show_Screen;
VAR
  BTT,WTT,TDA,L,Z,CC,XX,ScrOfs  : Word;
  XC,X,YY,N,CY,A,SX,Stat,AE,GStat     : Byte;
BEGIN
  ScrOfs:=OFS (ScreenBuf);GStat:=0;
  FOR CY:=0 TO 143 DO BEGIN
    BPAdr:=Ofs(APal)+4*ScrInfo[CY,7];
    Stat:=ScrInfo[CY,0];GStat:=GStat OR Stat;
    SX:=ScrInfo[CY,3];

    IF ((Stat AND 8)=0) THEN BTT:=$9800 ELSE BTT:=$9C00;
    IF ((Stat AND 16)=0) THEN TDA:=$8800 ELSE TDA:=$8000;
    IF ((Stat AND 64)=0) THEN WTT:=$9800 ELSE WTT:=$9C00;

    IF (Stat AND 33)>0 THEN BEGIN
      A:=0;AE:=160;
      IF ((Stat AND 32)>0) AND (CY>=ScrInfo[CY,$A]) THEN
        AE:=ScrInfo[CY,$B]-7;
      IF AE>160 THEN AE:=160;
      IF ((Stat AND 1)>0) THEN BEGIN { Screen }
        YY:=CY+ScrInfo[CY,2];
        L:=((YY AND $F8) SHL 2)+BTT;
        TDA:=TDA+(YY AND 7) SHL 1;
        XC:=SX shr 3;X:=SX and 7;

        CC:=MEM[GameData:L+XC];
        IF ((Stat AND 16)=0) THEN CC:=CC XOR $80;
        Z:=MEMW[GameData:TDA+(Word(CC) SHL 4)] SHL X;

        X:=(X XOR $7)+1;

        WHILE A<AE DO BEGIN
          ASM
            Mov DI,[ScrOfs]
@@BL:       Xor BX,BX
            Mov AX,[Z]
            Shl AH,1
            Rcl bl,1
            Shl AL,1
            Rcl bl,1
            Mov [Z],AX
            Add BX,[BPAdr]

            Mov AL,[BX]
            Mov [DI],AL
            Inc DI

            Inc [A]
            Mov AL,[A]
            Cmp AL,160
            Je @@BE

            Dec [X]
            Jnz @@BL
@@BE:       Mov [X],8

            Inc [XC]
            And [XC],31
            Mov [ScrOfs],DI
          END;

          CC:=MEM[GameData:L+XC];
          IF ((Stat AND 16)=0) THEN CC:=CC XOR $80;
          Z:=MEMW[GameData:TDA+(Word(CC) SHL 4)];
        END;
      END;
      YY:=CY-ScrInfo[CY,$A];
      L:=((YY AND $F8) SHL 2)+WTT;
      TDA:=$8800+((YY AND 7) SHL 1);
      WHILE A<160 DO BEGIN
        CC:=MEM[GameData:L] XOR $80;
        Z:=MEMW[GameData:TDA+(Word(CC) SHL 4)];
        ASM
            Mov DI,[ScrOfs]
            Mov [x],8
@@WL:         Xor BX,BX
              Mov AX,[Z]
              Shl AH,1
              rcl bl,1
              Shl AL,1
              rcl bl,1
              Add BX,[BPAdr]
              Mov [Z],AX

              Mov AL,[BX]
              Mov [DI],AL
              Inc DI
              Inc [A]
              Mov AL,[A]
              Cmp AL,160
              Je @@WE

              Dec [x]
            Jnz @@WL
@@WE:       Mov [ScrOfs],DI
            Inc [L]
        END;
      END;
    END ELSE
      ASM  { Clear a Line }
        Mov AX,DS
        Mov ES,AX
        Xor AH,AH
        Mov DI,OFFSET ScreenBuf
        Mov AL,[CY]
        Mov BX,160
        Mul BX
        Add DI,AX
        Cld
        Mov CX,40
        DB $66,$33,$C0,$F3,$66,$AB
      END;
  END;

  { Sprites }
  IF (GStat AND $01)>0 THEN { Eigentlich check Bit 2 }
    Show_Sprites;

  IF Grafmode AND ((GStat AND $80)>0) THEN
    Copy_Screen;
END;

PROCEDURE SaveScreen(N:String);
TYPE
  TBMHDInfo = RECORD
                XAufl,YAufl,
                XPos,YPos     : Word;
                Bitplanes,
                Maskentechnik,
                Komprimiert   : Byte;
                Transparentfarbe,
                Aspect_Ratio,
                Hoehe,Breite  : Word;
              END;
VAR
  F:File;
  S:String[4];
  L:Longint;
  X:ARRAY[0..3] OF Byte ABSOLUTE L;
  BH:TBMHDInfo;
  CM:ARRAY[0..3,0..2] OF Byte;
  CC:Byte;
BEGIN
  FillChar(CM,SizeOf(CM),255);
  FOR CC:=0 TO 3 DO BEGIN
    CM[CC,0]:=255-64*CC;
    CM[CC,1]:=255-64*CC;
    CM[CC,2]:=255-64*CC;
  END;
  WITH BH DO BEGIN
    XAufl:=swap(160);YAufl:=Swap(144);
    XPos:=swap(80);YPos:=swap(28);
    Bitplanes:=8;Maskentechnik:=0;Komprimiert:=0;
    Transparentfarbe:=swap(1);Aspect_Ratio:=swap(1);
    Hoehe:=swap(320);Breite:=swap(200);
  END;
  Assign(F,N+'.LBM');
  ReWrite(F,1);
  S:='FORM';L:=SizeOf(ScreenBuf)+SizeOf(TBMHDInfo)+SizeOf(CM)+29;
  BlockWrite(F,S[1],4);FOR CC:=3 DOWNTO 0 DO BlockWrite(F,X[CC],1);
  S:='PBM ';BlockWrite(F,S[1],4);
  S:='BMHD';L:=SizeOf(TBMHDInfo);BlockWrite(F,S[1],4);FOR CC:=3 DOWNTO 0 DO BlockWrite(F,X[CC],1);
  BlockWrite(F,BH,SizeOf(TBMHDInfo)+1);
  S:='CMAP';L:=SizeOf(CM);BlockWrite(F,S[1],4);FOR CC:=3 DOWNTO 0 DO BlockWrite(F,X[CC],1);
  BlockWrite(F,CM,SizeOf(CM));
  S:='BODY';L:=SizeOf(ScreenBuf);BlockWrite(F,S[1],4);FOR CC:=3 DOWNTO 0 DO BlockWrite(F,X[CC],1);
  BlockWrite(F,ScreenBuf,Sizeof(ScreenBuf));
  Close(F);
END;

{ == Emulationsroutinen ==================================================== }

PROCEDURE Map_Ram;
BEGIN
  MME:=AsmData^.MMUPage;
  IF AsmData^.MMUPage=0 THEN AsmData^.MMUPage:=1;
  IF AsmData^.MMUPage>=BlockNum THEN BEGIN
    AsmData^.MMUPage:=AsmData^.MMUPage AND (BlockNum-1);
    AsmData^.Flags:=AsmData^.Flags OR F_MMU_Error;
  END;

{ MapStuff }

{ Read }
  MapArray[0].PP:=0;
  MapArray[1].PP:=AsmData^.MMUPage;
  MapArray[2].PP:=BlockNum;
  MapArray[3].PP:=BlockNum+1;

{ Write }
  MapArray[4].PP:=BlockNum+2;
  MapArray[5].PP:=BlockNum+2;
  MapArray[6].PP:=BlockNum;
  MapArray[7].PP:=BlockNum+1;

  MapPages(EXPHandle,MapArray,8);

  IF Error>0 THEN System.Write(#7);
END;

PROCEDURE Holds;
VAR
  Y:Byte;
  X:Word;

  PROCEDURE Interrupt(N:Byte);
  BEGIN
    MEM[Gamedata:$FF0F]:=(1 SHL N) AND MEM[Gamedata:$FFFF];
  END;

BEGIN
  IF (AsmData^.Flags AND F_TimerInt>0) THEN BEGIN
    Y:=MEM[Gamedata:$FF00+$44];
    IF Y=0 THEN BEGIN
      Get_AnalogJoystick;
      Show_Screen;
    END;
    IF Y<144 THEN Move(MEM[Gamedata:$FF00+$40],ScrInfo[Y,0],12);
    IF Y=144 THEN BEGIN
      MEM[Gamedata:$FF00+$41]:=MEM[Gamedata:$FF00+$41] AND NOT 3;
      IF ((MEM[Gamedata:$FF00+$41] AND 8)>0) THEN Interrupt(1);
    END;
    Inc(Y);
    IF (Y=MEM[Gamedata:$FF00+$45]) AND ((MEM[Gamedata:$FF00+$41] AND 64)>0) THEN BEGIN
      MEM[Gamedata:$FF00+$41]:=MEM[Gamedata:$FF00+$41] OR 4;
      Interrupt(1);
    END ELSE
      MEM[Gamedata:$FF00+$41]:=MEM[Gamedata:$FF00+$41] AND NOT 4;
    IF Y>153 THEN BEGIN
      Y:=0;
      Interrupt(0);
      If MusicRip THEN
        BlockWrite(MusicFile,MEM[Gamedata:$FF10],22);
      { Reset Start-Flag for all voices }
      MEM[Gamedata:$FF14]:=0;MEM[Gamedata:$FF19]:=0;
      MEM[Gamedata:$FF1E]:=0;MEM[Gamedata:$FF23]:=0;
    END;
    IF ((Y AND 1)>0) AND ((MEM[Gamedata:$FF00+$07] AND 4)>0) THEN BEGIN
      X:=MEM[Gamedata:$FF00+5];
      CASE (MEM[Gamedata:$FF00+7] AND 3) OF
        0:Inc(X);
        1:Inc(X,64);
        2:Inc(X,16);
        3:Inc(X,4);
      END;
      IF X>$FF THEN BEGIN
        MEM[Gamedata:$FF00+5]:=MEM[Gamedata:$FF00+6];
        Interrupt(2);
      END ELSE MEM[Gamedata:$FF00+5]:=X;
    END;
    AsmData^.Flags:=AsmData^.Flags AND NOT F_TimerInt;
    MEM[Gamedata:$FF00+$44]:=Y;
{
    Call_IRQ;
}
  END;

  IF (AsmData^.Flags AND F_MMUAccess)>0 THEN BEGIN
    Map_Ram;
    AsmData^.Flags:=AsmData^.Flags AND NOT F_MMUAccess;
  END;

  IF (AsmData^.Flags AND F_KeyInt>0) THEN AsmData^.Flags:=AsmData^.Flags AND NOT F_KeyInt;
END;

PROCEDURE GotoGB;
BEGIN
{
  Set_Timer_Speed(70);
}
  ASM
    Call CallGB
  END;
{
  Reset_Timer;
}
END;

PROCEDURE CodeTrace;
BEGIN
  AsmData^.Flags:=F_SingleStep;
  GotoGB;
  Holds;
  AsmData^.Flags:=AsmData^.Flags AND NOT F_SingleStep;
END;

PROCEDURE Run;
VAR
  C:Byte;
BEGIN
  { Aktuellen Befehl ohne Beachtung der BP ausfhren }
  CodeTrace;

  { BreakPoints setzen }
  FOR C:=0 TO MaxBPoints DO BEGIN
    WITH BPoints[C] DO BEGIN
      IF Enable>0 THEN BEGIN
        Old_Byte:=MEM[GameData:Adress];
        MEM[GameData:Adress]:=$76; { Halt }
      END;
    END;
  END;

  REPEAT
    AsmData^.Flags:=0;
    GotoGB;
    Holds;
    IF Keypressed THEN
      IF ReadKey=#27 THEN
        AsmData^.Flags:=AsmData^.Flags OR F_KeyInt
      ELSE
        AsmData^.Flags:=AsmData^.Flags AND NOT F_KeyInt;
  UNTIL (AsmData^.Flags>0);
  WHILE KeyPressed DO ReadKey;

  IF (AsmData^.Flags AND (F_Halt OR F_Error))>0 THEN BEGIN
    Dec(AsmData^.Regs.Reg_PC);
    AsmData^.Flags:=AsmData^.Flags AND NOT (F_Halt OR F_Error);
  END;

  { BreakPoints entfernen }
  FOR C:=0 TO MaxBPoints DO BEGIN
    WITH BPoints[C] DO BEGIN
      IF Enable>0 THEN MEM[GameData:Adress]:=Old_Byte;
    END;
  END;
END;

PROCEDURE RunTo(Adr:Word);
BEGIN
  CodeTrace;
  SetBreakPoint(Adr);
  Run;
  ClearBreakPoint(Adr);
END;

PROCEDURE CodeStep;
VAR
  Adr : Word;
BEGIN
  IF MEM[GameData:AsmData^.Regs.reg_PC]=$CD THEN BEGIN
    Adr:=AsmData^.Regs.reg_PC+CodeSize(AsmData^.Regs.reg_PC,@MEM[GameData:0]);
    RunTo(Adr);
  END ELSE CodeTrace;
END;

PROCEDURE Look;
VAR
  C:Word;
  Ch:Char;
BEGIN
  Graf_On;
  Copy_Screen;
  C:=0;
  REPEAT
    AsmData^.Flags:=0;
    GotoGB;
    Holds;
    IF Keypressed THEN
      IF ReadKey=#27 THEN
        AsmData^.Flags:=AsmData^.Flags OR F_KeyInt
      ELSE
        AsmData^.Flags:=AsmData^.Flags AND NOT F_KeyInt;
  UNTIL (AsmData^.Flags>0);
  IF (AsmData^.Flags AND (F_Halt OR F_Error))>0 THEN BEGIN
    Dec(AsmData^.Regs.Reg_PC);
    AsmData^.Flags:=AsmData^.Flags AND NOT (F_Halt OR F_Error);
  END;
  Graf_Off;
  WHILE KeyPressed DO ReadKey;
END;

PROCEDURE Reset_CPU;
BEGIN
  AsmData^.IE:=0;
  Cursor:=$100;
  AsmData^.MMUPage:=1;
  Map_Ram;
  MEM[Gamedata:$FF00+$00]:=$0F;
  MEM[Gamedata:$FF00+$47]:=$E4;
  MEM[Gamedata:$FF00+$48]:=$E4;
  MEM[Gamedata:$FF00+$49]:=$E4;
  WITH AsmData^.Regs DO BEGIN
    reg_AF:=0;
    reg_BC:=0;
    reg_DE:=0;
    reg_HL:=0;
    reg_SP:=0;
    reg_PC:=$100;
  END;
END;

{ == ShowCode ============================================================== }

PROCEDURE ShowCode;
VAR
  C,C2,A:Word;
  L     :String;
BEGIN
  Box(1,1,53,18,Yellow,Blue,Style3);
  GotoXY(4,1);Write('  Code  ');
  A:=CodeAnf;
  FOR C:=0 TO 15 DO BEGIN
    GotoXY(2,2+C);
    IF AsmData^.Regs.reg_PC=A THEN BEGIN
      TextColor(Black);
      TextBackground(Cyan);
    END ELSE BEGIN
      IF CheckBreakPoint(A) THEN BEGIN
        TextColor(White);
        TextBackground(Red);
      END ELSE BEGIN
        TextColor(Yellow);
        TextBackground(Blue);
      END;
    END;
    IF Cursor=A THEN Write(#16) ELSE Write(#32);
    Write(Hex(A,4)+' ');
    L:=Copy(Find_Name(A),1,11);
    IF Length(L)>0 THEN L:=L+':';
    WHILE Length(L)<12 DO L:=L+#32;
    Write(L);
    FOR C2:=0 TO 2 DO
      IF C2<CodeSize(A,@MEM[GameData:0]) THEN Write(Hex(MEM[GameData:A+C2],2)+' ')
                                         ELSE Write('   ');
    Write(' '+DisAssemble(A,@MEM[GameData:0]));
    A:=A+CodeSize(A,@MEM[GameData:0]);
  END;
  CodeEnd:=A;
END;

PROCEDURE ShowRegs;
VAR
  B:Byte;
CONST
  FN : String = 'SZXAXPXC';
BEGIN
  Box(1,19,80,22,White,Red,Style2);
  GotoXY(4,19);Write('  Registers  ');
  GotoXY(2,20);Write(' A  BC   DE   HL   SP   PC   Flags    IRQ MMU');
  WITH AsmData^.Regs DO BEGIN
    GotoXY(2,21);
    Write(' '+Hex(Lo(reg_AF),2)+' '+Hex(reg_BC,4)+' '+Hex(reg_DE,4)+' '+Hex(reg_HL,4)+' '+Hex(reg_SP,4)+' '+Hex(reg_PC,4)+' ');
    FOR B:=7 DownTo 0 DO IF (Hi(reg_AF) AND (1 SHL B))>0 THEN Write(FN[8-B]) ELSE Write('-');
    IF AsmData^.IE=0 THEN Write(' OFF ') ELSE Write(' ON  ');
    Write(Hex(AsmData^.MMUPage,2)+' ');
  END;
END;

PROCEDURE ShowMemory;
VAR
  C:Word;
BEGIN
  Box(54,1,80,18,White,Cyan,Style1);
  GotoXY(57,1);Write('  Memory from '+Hex(MemoryPos,4)+'  ');
  FOR C:=0 TO 127 DO BEGIN
    IF (C MOD 8)=0 THEN GotoXY(56,2+(C DIV 8));
    Write(Hex(MEM[GameData:MemoryPos+C],2)+#32);
  END;
END;

{ == Freezer =============================================================== }

{ RAM und Register sichern, sollte irgendwann komprimiert werden... }
PROCEDURE SaveGame;
VAR
  F:File;
  R:Word;
BEGIN
  Meldung('Saving: Are you shure ? (y/n)');
  IF UpCase(ReadKey) IN ['Y','Z','J'] THEN BEGIN
    Meldung('Saving Game');
    Assign(F,FileName+'.SAV');
    ReWrite(F,1);
    R:=IOResult;
    IF R>0 THEN BEGIN
      Meldung('Error on writing:'+Hex(R,4));
      ReadKey;
    END ELSE BEGIN
      BlockWrite(F,AsmData^.Regs,SizeOf(TWRegStruc));
      BlockWrite(F,MEM[GameData:$8000],$7FFF);
      Close(F);
    END;
  END;
END;

{ RAM und Register laden. }
PROCEDURE RestoreGame;
VAR
  F:File;
  R:Word;
BEGIN
  Meldung('Loading: Are you shure ? (y/n)');
  IF UpCase(ReadKey) IN ['Y','Z','J'] THEN BEGIN
    Meldung('Loading Game');
    Assign(F,FileName+'.SAV');
    Reset(F,1);
    R:=IOResult;
    IF R>0 THEN BEGIN
      Meldung('Error on reading:'+Hex(R,4));
      ReadKey;
    END ELSE BEGIN
      BlockRead(F,AsmData^.Regs,SizeOf(TWRegStruc));
      BlockRead(F,MEM[GameData:$8000],$7FFF);
      Close(F);
      Cursor:=AsmData^.Regs.reg_PC;
    END;
  END;
END;

{ == Steuerung ============================================================= }

PROCEDURE Go;
VAR
  Ch:Char;
  W,X:Word;
  E1,E2:String;
BEGIN
  AsmData^.Regs.reg_PC:=$100;
  Cursor:=AsmData^.Regs.reg_PC;
  CodeAnf:=Cursor;
  AsmData^.Joypad:=$FF;
  Grafmode:=False;
  REPEAT
    Ende:=False;
    ShowCode;
    ShowRegs;
    ShowMemory;
    Ch:=ReadKey;
    CASE UpCase(Ch) OF
      'U' : BEGIN
              MusicRip:=Not MusicRip;
              If MusicRip THEN BEGIN
                System.write(#7);
                Assign(MusicFile,'\MUSICRIP.BIN');
                ReWrite(MusicFile,1);
              END ELSE
                Close(MusicFile);
            END;
      'T' : BEGIN
              CodeTrace;
              Cursor:=AsmData^.Regs.reg_PC;
            END;
      'S' : BEGIN
              Meldung(' Running ...');
              CodeStep;
              Cursor:=AsmData^.Regs.reg_PC;
            END;
      'H' : BEGIN
              Meldung(' Running ...');
              RunTo(Cursor);
              Cursor:=AsmData^.Regs.reg_PC;
            END;
      'G' : BEGIN
              Eingabe('New Adress',E1);
              IF E1<>'' THEN Cursor:=Dez(E1);
            END;
      'N' : Reset_CPU;
      'M' : BEGIN
              Eingabe('Memory Position',E1);
              IF E1<>'' THEN MemoryPos:=Dez(E1);
            END;
      'R' : BEGIN
              Meldung(' Running ...');
              Run;
              Cursor:=AsmData^.Regs.reg_PC;
            END;
      'L' : BEGIN
              Look;
              Cursor:=AsmData^.Regs.reg_PC;
            END;
      'O' : BEGIN
              Eingabe('Adress',E1);
              IF E1<>'' THEN BEGIN
                Eingabe('Old:'+Hex(MEM[GameData:Dez(E1)],2)+' New:',E2);
                IF E2<>'' THEN MEM[GameData:Dez(E1)]:=Dez(E2);
              END;
            END;
      'I' : BEGIN
              Graf_on;
              Copy_Screen;
              ReadKey;
              Graf_off;
            END;
      'P' : BEGIN
              Eingabe('MMU-Page:',E1);
              IF E1<>'' THEN BEGIN
                AsmData^.MMUPage:=Dez(E1);
                Map_Ram;
              END;
            END;
      'Q' : AsmData^.IE:=AsmData^.IE XOR 1;
      'B' : FlipBreakPoint(Cursor);
      'C' : ClearAllBreakpoints;
      'F' : Cursor:=FindNextBreakPoint(Cursor);
      '+' : Log_IO;
      #8  : BEGIN
              X:=CodeSize(Cursor,@MEM[GameData:0]);
              FOR W:=Cursor TO Cursor+X-1 DO
                MEM[GameData:W]:=0;
              Cursor:=Cursor+X;
            END;
      #27 : BEGIN
              Meldung('End: Are you shure ? (y/n)');
              Ende:=UpCase(ReadKey) IN ['Y','Z','J'];
            END;
      #0  : CASE ReadKey OF
              #$4D : Inc(Cursor);
              #$4B : Dec(Cursor);
              #$50 : Inc(Cursor,CodeSize(Cursor,@MEM[GameData:0]));
              #$3B : SaveGame;
              #$3C : RestoreGame;
              #$3D : BEGIN
                       Eingabe('Name for Screen:',E1);
                       IF E1<>'' THEN
                         SaveScreen(E1);
                     END;
              #$3F : RomInfo;
            END;
    END;
    IF (Cursor>=CodeEnd) OR (Cursor<CodeAnf) THEN BEGIN
      CodeAnf:=Cursor;
      CodeEnd:=Cursor+10;
    END;
    IF (Cursor>=(CodeEnd-5)) THEN Inc(CodeAnf,CodeSize(CodeAnf,@MEM[GameData:0]));
    IF (AsmData^.Flags AND F_MMU_Error)>0 THEN BEGIN
      AsmData^.Flags:=AsmData^.Flags AND NOT F_MMU_Error;
      Meldung('MMU-Fehler ! '+Hex(MME,2));
      ReadKey;
    END;
  UNTIL Ende;
END;

BEGIN
  Init_AnalogJoystick;
  AsmData:=@aAsmData;
  AsmData^.ReadSeg:=(Ptr2Word(Heaporg).S+$3FFF) AND $C000;
  AsmData^.WriteSeg:=AsmData^.ReadSeg+$1000;
  AsmData^.PScrInfo:=@ScrInfo;
  Ptr2Word(Heaporg).S:=AsmData^.WriteSeg+$1000;
  GameData:=AsmData^.ReadSeg;
  IF CheckWindows THEN BEGIN
    System.WriteLn('This Program is NOT designed to run with MS-Windows !');
  END ELSE BEGIN
    InitEMM386;
    IF Error=0 THEN BEGIN
      System.WriteLn('GBSIM V',VMaj,'.',VMin);
      Init;
      WriteLn('Loading Game ...');
      Load_Game;
      TextColor(White);TextBackground(Black);
      ClrScr;
      Reset_CPU;
      Go;
      Dispose_Game;
      Done;
      If MusicRip THEN Close(MusicFile);
      TextColor(LightGray);TextBackground(Black);
      ClrScr;
    END ELSE BEGIN
      CASE Error OF
        erNoEMM386 : WriteLn('EMM386 not found.');
        erEMMError : WriteLn('Expanded Memory error.');
        erNoVCPI   : WriteLn('VCPI not supported by EXP-Manager.');
      END;
    END;
  END;
END.
