PROGRAM GDump; { Grafische Darstellung der Moduldaten }

USES
  Crt;

TYPE
  PBuffer = ^TBuffer;
  TBuffer = ARRAY [0..65534] OF Byte;

CONST
  { This is information from TETRIS !! }
  ColFont2 = 12863; { - 16015 , 197 Zeichen , Mens, Steine und "Bonustnzer"}
  Screens4 = 16015; { - 16735 , 2 Stck... , Gametyp A+B }
  MonoFont = 16735; { - 17047 , 39 Zeichen, aber Mono }
  ColFont1 = 17047; { - 17191 , 9 Zeichen }
  ColFont3 = 17191; { - 18951 , 110 Zeichen Titelgrafik }
  Screens1 = 18951; { - 20751 , 5 Stck... 20 x 18 , Titel und Mens}
  Screens2 = 20751; { - 20931 , 1 Stck, und auch noch halb gro... 10 x 18 , "Bonustnzer"}
  Himmel   = 20931; { - 21012 , Himmel und Stadtsilouette im Spritefont }
  Screens3 = 21012; { - 21732 , 2 Stck... , Mario versus Luigi }
  Screens5 = 21732; { - 21932 , 1 Stck, Ergebnisse Mario v. Luigi, 20 x 10 }
  Sprites  = 21932; { - 25260 , 208 Zeichen }

{  Vermutung: ab 25260 Musik ? }

  StartScreen = Screens1;
  StartFont   = ColFont3;

VAR
  Data         : File;
  Screen       : ARRAY [0..199,0..319] OF Byte ABSOLUTE $A000:0000;

  Buffer       : PBuffer;
  BufSize      : Word;

  C            : Byte;
  Ch           : Char;

  ScrPos       : Word;
  FontPos      : Word;
  ScrWidth     : Word;

  MultMode     : Boolean;

PROCEDURE ShowChar(X,Y,C : Byte);
VAR
  XX,YY : Word;
  C1,C2 : Byte;
  AF    : Word;
BEGIN
  IF MultMode THEN BEGIN
    IF C<39 THEN BEGIN
      FOR YY:=0 TO 7 DO
        FOR XX:=0 TO 7 DO BEGIN
          C1:=(Buffer^[MonoFont+C*8+YY] AND (128 SHR XX)) SHR (7-XX);
          Screen[Y*8+YY,X*8+XX]:=C1*128;
        END;
    END ELSE BEGIN
      IF C>47 THEN BEGIN
        Dec(C,48);
        AF:=FontPos;
      END ELSE BEGIN
        Dec(C,39);
        AF:=ColFont1;
      END;
      FOR YY:=0 TO 7 DO
        FOR XX:=0 TO 7 DO BEGIN
          C1:=(Buffer^[AF+C*16+YY*2] AND (128 SHR XX)) SHR (7-XX);
          C2:=(Buffer^[AF+C*16+YY*2+1] AND (128 SHR XX)) SHR (7-XX);
          Screen[Y*8+YY,X*8+XX]:=(C1+2*C2)*64;
        END;
    END;
  END ELSE BEGIN
    FOR YY:=0 TO 7 DO
      FOR XX:=0 TO 7 DO BEGIN
        C1:=(Buffer^[FontPos+C*16+YY*2] AND (128 SHR XX)) SHR (7-XX);
        C2:=(Buffer^[FontPos+C*16+YY*2+1] AND (128 SHR XX)) SHR (7-XX);
        Screen[Y*8+YY,X*8+XX]:=(C1+2*C2)*64;
      END;
  END;
END;

PROCEDURE ShowScreen;
VAR
  XC,YC : Word;
BEGIN
  FOR YC:=0 TO 17 DO
    FOR XC:=0 TO 19 DO
      ShowChar(XC,YC,Buffer^[ScrPos+YC*ScrWidth+XC]);
END;

PROCEDURE ShowFont;
VAR
  C : Word;
BEGIN
  FOR C:=0 TO 255 DO
    ShowChar(21+(C MOD 16),C DIV 16,C);
END;

BEGIN
  IF ParamCount<>1 THEN BEGIN
    WriteLn('Syntax: GBGRAPH <File>');
  END ELSE BEGIN
    New(Buffer);
    DirectVideo:=False;
    Assign(Data,ParamStr(1));
    Reset(Data,1);
    Blockread(Data,Buffer^,SizeOf(TBuffer),BufSize);
    Close(Data);
    ASM
      Mov AX,$13
      INT $10
    END;
    FOR C:=0 TO 255 DO BEGIN
      Port[$3C8]:=255-C;
      Port[$3C9]:=Word((63*C) DIV 255);
      Port[$3C9]:=Word((63*C) DIV 255);
      Port[$3C9]:=Word((63*C) DIV 255);
    END;
    ScrPos:=StartScreen;
    FontPos:=StartFont;
    ScrWidth:=20;
    MultMode:=True;
    REPEAT
      ShowScreen;
      ShowFont;
      Ch:=ReadKey;
      CASE UpCase(Ch) OF
        '+' : Inc(FontPos,2);
        '-' : Dec(FontPos,2);
        '1' : Inc(FontPos,16);
        '2' : Dec(FontPos,16);
        '3' : Inc(FontPos,128);
        '4' : Dec(FontPos,128);
        '5' : Inc(FontPos,4096);
        '6' : Dec(FontPos,4096);
        '7' : IF ScrWidth<$FFFF THEN Inc(ScrWidth);
        '8' : IF ScrWidth>0     THEN Dec(ScrWidth);
        'S' : FontPos:=FontPos XOR 1;
        'M' : MultMode:=NOT MultMode;
        #0 : CASE ReadKey OF
               'M':IF ScrPos<BufSize THEN Inc(ScrPos);
               'K':IF ScrPos>0 THEN Dec(ScrPos);
               'P':IF ScrPos<(BufSize-20) THEN Inc(ScrPos,20);
               'H':IF ScrPos>19 THEN Dec(ScrPos,20);
               'I':IF ScrPos>359 THEN Dec(ScrPos,360);
               'Q':IF ScrPos<(BufSize-360) THEN Inc(ScrPos,360);
             END;
      END;
    UNTIL Ch=#27;
    ASM
      Mov AX,$3
      INT $10
    END;
    Dispose(Buffer);
  END;
END.