{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+,M 16384,0,655360}
PROGRAM GBDisAss;
{ Ein einfacher Disassembler fr Gameboy-Code. Bis jetzt werden nur 32K }
{ Module korrekt verarbeitet. }

USES
  Crt,Dos;

CONST
  Version   = '1.0';

  HexDigits : String = '0123456789ABCDEF';

dir_opc		= 1;
tab_opc		= 2;
dir_par		= 3;
tab_par		= 4;
abs_par         = 5;
rst_par		= 6;
bts_par         = 7;

t_tree		= 0;
t_end		= 1;

par_1		= 0;
par_2		= 1;
bit_4		= 2;

Bit_8		= 0;
Bit_16		= 1;
Ptr		= 2;
Relative	= 4;
Absolute	= 8;
Conditional	= 16;
_Jump		= 32;
_Call		= 64;
IO_Tab		= 128;

MaxLabel        = 2900;
MaxData         = 199;

PROCEDURE OpCodeTab;EXTERNAL;
{$L DISGBTAB.OBJ}

CONST
  L_Jump = 1;
  L_Call = 2;
  L_IO   = 4;
  L_Used = 8;

TYPE
  PArray = ^TArray;
  TArray = ARRAY [0..65534] OF Byte;

  String17 = String[17];
  TLabel   = RECORD
               Name : String17;
               Adr  : Word;
               Flags : Byte;
             END;
  TData    = RECORD
               A,E : Word;
               T   : Byte;
             END;


VAR
  OpCodeTabSeg : Word;
  OpCodeTabOfs : Word;
  Testdata   : PArray;
  Datasize   : Word;

  LabTab      : ARRAY [0..MaxLabel] OF TLabel;
  LabNum      : Word;
  DataTab     : ARRAY [0..MaxData] OF TData;
  DataNum     : Word;
  ArtLabNum   : Word;
  IOLabNum    : Word;

  DataName,
  LabelName,
  SourceName,
  ListName        : String;

{  == Infos ber das Modul == }

  Module_Name : String;

{ == Hex - Dez Umrechnung ================================================== }

FUNCTION Hex(I:Word;N:Byte):String;
VAR
  D:String;
BEGIN
  D:='';
  WHILE N>0 DO BEGIN
    D:=HexDigits[(I AND 15)+1]+D;
    I:=I SHR 4;
    Dec(N);
  END;
  Hex:=D;
END;

FUNCTION Dez(S:String):Word;
VAR
  D:Word;
BEGIN
  D:=0;
  WHILE S<>'' DO BEGIN
    D:=D SHL 4;
    D:=D+Pos(UpCase(S[1]),HexDigits)-1;
    Delete(S,1,1);
  END;
  Dez:=D;
END;

{ == Stringoperationen ===================================================== }

FUNCTION LeerString(L:Byte):String;
VAR
  D:String;
BEGIN
  FillChar(D,SizeOf(D),#32);
  D[0]:=Char(L);
  LeerString:=D;
END;

PROCEDURE Extend(VAR S:String;L:Byte);
BEGIN
  WHILE Length(S)<L DO S:=S+#32;
END;

FUNCTION UpString(S:String):String;
VAR
  C:Byte;
BEGIN
  FOR C:=1 TO Length(S) DO S[C]:=UpCase(S[C]);
  UpString:=S;
END;

{ == Tools: ================================================================ }

FUNCTION Exist(S:String):Boolean;
VAR
  DirInfo:SearchRec;
BEGIN
  FindFirst(S,AnyFile AND NOT Directory,DirInfo);
  Exist:=DosError=0;
END;

{ == Labelverwaltung ======================================================= }

PROCEDURE AddLabel(S:String;A:Word;F:Byte);
VAR
  C1,C2 : Word;
BEGIN
  IF (LabNum<=MaxLabel) THEN BEGIN
    WHILE Pos(#32,S)>0 DO Delete(S,Pos(#32,S),1);
    C1:=0;
    WHILE (LabTab[C1].Adr<A) AND (C1<LabNum) DO Inc(C1);
    IF (LabTab[C1].Adr<>A) AND (C1<=LabNum) THEN BEGIN
      FOR C2:=LabNum DOWNTO C1+1 DO
        LabTab[C2]:=LabTab[C2-1];
      LabTab[C1].Name:=S;
      LabTab[C1].Adr:=A;
      LabTab[C1].Flags:=F;
      Inc(LabNum);
    END;
  END;
END;

PROCEDURE FindLabel(A:Word;VAR L:String;VAR F:Byte);
VAR
  C,O,U:Word;
BEGIN
  L:='';F:=0;
  O:=LabNum-1;
  U:=0;
  REPEAT
    C:=(O+U) SHR 1;
    IF LabTab[C].Adr=A THEN BEGIN
      L:=LabTab[C].Name;
      F:=LabTab[C].Flags;
      O:=U;
    END ELSE
      IF LabTab[C].Adr<A THEN BEGIN
        IF U=C THEN U:=C+1 ELSE U:=C;
      END ELSE BEGIN
        O:=C;
      END;
  UNTIL U=O;
END;

FUNCTION DataArea(A:Word):Boolean;
VAR
  C:Word;
BEGIN
  DataArea:=False;
  IF A<=DataSize THEN
    FOR C:=1 TO DataNum DO
      IF (DataTab[C-1].A<=A) AND (DataTab[C-1].E>=A) THEN DataArea:=True;
END;

FUNCTION DataType(A:Word):Byte;
VAR
  C:Word;
BEGIN
  DataType:=0;
  IF A<=DataSize THEN
    FOR C:=1 TO DataNum DO
      IF (DataTab[C-1].A<=A) AND (DataTab[C-1].E>=A) THEN DataType:=DataTab[C-1].T;
END;

PROCEDURE ReadLabelList(NNN:String);
VAR
  L:TEXT;
  Line,Lab:String;
  Adr:Word;
  Attr:Byte;
  DA,DB:Word;
BEGIN
  Attr:=0;
  Assign(L,NNN);
  Reset(L);
  WHILE NOT Eof(L) DO BEGIN
    ReadLn(L,Line);
    WHILE Pos(#9,Line)>0 DO Line[Pos(#9,Line)]:=#32;
    WHILE (Line[1]=#32) AND (Length(Line)>0) DO Delete(Line,1,1);
    IF Length(Line)>0 THEN BEGIN
      IF Line[1]=';' THEN BEGIN
        WHILE Pos(#32,Line)>0 DO Delete(Line,Pos(#32,Line),1);
        IF Pos('DATA',UpString(Line))>0 THEN BEGIN
          Delete(Line,1,5);
          DA:=Dez(Copy(Line,1,4));
          DB:=Dez(Copy(Line,6,10));
          DataTab[DataNum].A:=DA;
          DataTab[DataNum].E:=DB;
          DataTab[DataNum].T:=0;
          Inc(DataNum);
        END ELSE
        IF Pos('STRING',UpString(Line))>0 THEN BEGIN
          Delete(Line,1,7);
          DA:=Dez(Copy(Line,1,4));
          DB:=Dez(Copy(Line,6,10));
          DataTab[DataNum].A:=DA;
          DataTab[DataNum].E:=DB;
          DataTab[DataNum].T:=1;
          Inc(DataNum);
        END ELSE
        IF Pos('JTABLE',UpString(Line))>0 THEN BEGIN
          Delete(Line,1,7);
          DA:=Dez(Copy(Line,1,4));
          DB:=Dez(Copy(Line,6,10));
          DataTab[DataNum].A:=DA;
          DataTab[DataNum].E:=DB;
          DataTab[DataNum].T:=2;
          Inc(DataNum);
        END ELSE
        IF Pos('FUN',UpString(Line))>0 THEN Attr:=L_Call
        ELSE
        IF Pos('LABEL',UpString(Line))>0 THEN Attr:=0;
      END ELSE BEGIN
        IF Pos(';',Line)>0 THEN Line[0]:=Char(Pos(';',Line)-1);
        WHILE Pos('  ',Line)>0 DO Delete(Line,Pos('  ',Line),1);
        IF Length(Line)>0 THEN BEGIN
          Lab:=Copy(Line,1,Pos(#32,Line)-1);
          Delete(Line,1,Pos('EQU 0',Line)+3);
          Delete(Line,Pos('h',Line),Length(Line)-Pos('h',Line)+1);
          Adr:=Dez(Line);
          AddLabel(Lab,Adr,Attr);
        END;
      END;
    END;
  END;
  Close(L);
END;

{ == Verwaltung ============================================================ }

PROCEDURE LoadData;
VAR
  F : File;
BEGIN
  Assign(F,DataName);
  Reset(F,1);
  BlockRead(F,testdata^,$8000,DataSize);
  Close(F);
  Dec(DataSize);
END;

{ == Disassembler ========================================================== }

FUNCTION DisAssemble(VAR Adr:Word):String;
VAR
  TabOfs   : Word;
  A,B,C    : Byte;
  ID,BT    : Word;
  ZW1,ZW2  : Word;
  Param    : String;
  Count    : Integer;
  Line     : String;
  LabName  : String;
  LabFlag  : Byte;
  PROCEDURE WriteDat(A:Word);
  BEGIN
    IF A>0 THEN BEGIN
      WHILE MEM[OpCodeTabSeg:A]<>0 DO BEGIN
        Line:=Line+Char(MEM[OpCodeTabSeg:A]);
        Inc(A);
      END;
    END;
  END;
BEGIN
  IF TestData^[Adr]=$76 THEN BEGIN
    Line:='halt';
    Inc(Adr);
  END ELSE BEGIN
    IF TestData^[Adr]=$CB THEN BEGIN
      TabOfs:=OpCodeTabOfs+8;
      Inc(Adr);
    END ELSE TabOfs:=OpCodeTabOfs;
    A:=TestData^[Adr] SHR 6;
    B:=(TestData^[Adr] SHR 3) AND 7;
    C:=TestData^[Adr] AND 7;
    Inc(Adr);Line:='';
    TabOfs:=MEMW[OpCodeTabSeg:TabOfs+A*2];
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID=t_tree THEN BEGIN
                     BT:=MEMW[OpCodeTabSeg:TabOfs];
                     TabOfs:=TabOfs+2;
                     CASE BT OF
                       par_1 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+B*2];
                       par_2 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+C*2];
                       bit_4 : BEGIN
                                 TabOfs:=MEMW[OpCodeTabSeg:TabOfs+(B AND 1)*2];
                                 B:=B SHR 1;
                               END;
                     END;
                   END;
    UNTIL (ID=t_end) OR (TabOfs=0);
    Count:=0;
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID>0 THEN BEGIN
        CASE Count OF
          1 : Line:=Line+' ';
          2 : Line:=Line+',';
        END;
        Inc(Count);
        CASE ID OF
          dir_opc  : BEGIN
                       WriteDat(MEMW[OpCodeTabSeg:TabOfs]);
                       TabOfs:=TabOfs+2;
                     END;
          tab_opc  : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       ZW2:=MEMW[OpCodeTabSeg:TabOfs];;
                       TabOfs:=TabOfs+2;
                       CASE ZW1 OF
                         par_1 : ZW2:=ZW2+B*2;
                         par_2 : ZW2:=ZW2+C*2;
                       END;
                       WriteDat(MEMW[OpCodeTabSeg:ZW2]);
                     END;
          dir_par : BEGIN
                       WriteDat(MEMW[OpCodeTabSeg:TabOfs]);
                       TabOfs:=TabOfs+2;
                    END;
          tab_par : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       ZW2:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE ZW1 OF
                         par_1 : ZW2:=ZW2+B*2;
                         par_2 : ZW2:=ZW2+C*2;
                       END;
                       WriteDat(MEMW[OpCodeTabSeg:ZW2]);
                    END;
          abs_par : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE (ZW1 AND 1) OF
                         Bit_8 : BEGIN
                                   ZW2:=TestData^[Adr];
                                   IF (Zw1 AND Relative)>0 THEN ZW2:=Adr+ShortInt(ZW2)+1;
                                   Adr:=Adr+1;
                                   IF (Zw1 AND IO_TAB)>0 THEN Zw2:=$FF00+Zw2;
                                   FindLabel(ZW2,LabName,LabFlag);
                                   IF LabName=''
                                   THEN BEGIN
                                     IF (Zw1 AND (Relative OR IO_Tab))>0 THEN Param:='0'+Hex(Zw2,4)+'h'
                                     ELSE Param:='0'+Hex(Zw2,2)+'h'
                                   END ELSE Param:=LabName;
                                 END;
                         Bit_16: BEGIN
                                   ZW2:=TestData^[Adr]+TestData^[Adr+1]*256;
                                   IF (Zw1 AND Relative)>0 THEN ZW2:=Adr+Integer(ZW2)+1;
                                   Adr:=Adr+2;
                                   FindLabel(Zw2,LabName,LabFlag);
                                   IF LabName=''
                                   THEN
                                     Param:='0'+Hex(Zw2,4)+'h'
                                   ELSE
                                     Param:=LabName;
                                 END;
                       END;
                       IF (ZW1 AND Ptr)>0 THEN Param:='['+Param+']';
                       Line:=Line+Param;
                     END;
          rst_par  : BEGIN
                       FindLabel(B*8,LabName,LabFlag);
                       IF LabName=''
                       THEN
                         Param:='0'+Hex(B*8,2)+'h'
                       ELSE
                         Param:=LabName;
                       Line:=Line+Param;
                     END;
          bts_par  : BEGIN
                       Zw1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       Case Zw1 OF
                         par_1 : Line:=Line+Hex(B,1);
                         par_2 : Line:=Line+Hex(C,1);
                       END;
                     END;
        END;
      END;
    UNTIL ID=0;
  END;
  DisAssemble:=Line;
END;

{ == Source-Analyser ======================================================= }

PROCEDURE AnalyseData;
VAR
  TabOfs   : Word;
  A,B,C    : Byte;
  ID,BT    : Word;
  ZW1,ZW2  : Word;
  Adresse  : Word;
  LabName  : String;
  LabFlag  : Byte;
  W1,W2,A1 : Word;
BEGIN
  FOR W1:=0 TO MaxData DO BEGIN
    IF DataTab[W1].T=2 THEN BEGIN
      FOR W2:=0 TO ((DataTab[W1].E-DataTab[W1].A) SHR 1) DO BEGIN
        A1:=TestData^[DataTab[W1].A+W2*2]+TestData^[DataTab[W1].A+W2*2+1]*256;
        FindLabel(A1,LabName,LabFlag);
        IF LabName='' THEN AddLabel('XXCA'+Hex(A1,4),A1,L_Call);
      END;
    END;
  END;
  Adresse:=0;
  REPEAT
    WHILE DataArea(Adresse) DO Inc(Adresse);
    IF TestData^[Adresse]<>$76 THEN BEGIN
      IF TestData^[Adresse]=$CB THEN BEGIN
        TabOfs:=OpCodeTabOfs+8;
        Inc(Adresse);
      END ELSE TabOfs:=OpCodeTabOfs;
      A:=TestData^[Adresse] SHR 6;
      B:=(TestData^[Adresse] SHR 3) AND 7;
      C:=TestData^[Adresse] AND 7;
      Inc(Adresse);
      TabOfs:=MEMW[OpCodeTabSeg:TabOfs+A*2];
      REPEAT
        ID:=MEMW[OpCodeTabSeg:TabOfs];
        TabOfs:=TabOfs+2;
        IF ID=t_tree THEN BEGIN
                       BT:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE BT OF
                         par_1 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+B*2];
                         par_2 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+C*2];
                         bit_4 : BEGIN
                                   TabOfs:=MEMW[OpCodeTabSeg:TabOfs+(B AND 1)*2];
                                   B:=B SHR 1;
                                 END;
                       END;
                     END;
      UNTIL (ID=t_end) OR (TabOfs=0);
      REPEAT
        ID:=MEMW[OpCodeTabSeg:TabOfs];
        TabOfs:=TabOfs+2;
        IF ID>0 THEN BEGIN
          CASE ID OF
            dir_opc : TabOfs:=TabOfs+2;
            tab_opc : TabOfs:=TabOfs+4;
            dir_par : TabOfs:=TabOfs+2;
            tab_par : TabOfs:=TabOfs+4;
            abs_par : BEGIN
                         ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                         TabOfs:=TabOfs+2;
                         CASE (ZW1 AND 1) OF
                           Bit_8 : BEGIN
                                     ZW2:=TestData^[Adresse];
                                     IF (Zw1 AND Relative)>0 THEN ZW2:=Adresse+ShortInt(ZW2)+1;
                                     Adresse:=Adresse+1;
                                     IF (ZW1 AND IO_TAB)>0 THEN Zw2:=$FF00+Zw2;
                                     FindLabel(Zw2,LabName,LabFlag);
                                     IF LabName='' THEN BEGIN
                                       IF (Zw1 AND Relative)>0 THEN BEGIN
                                         AddLabel('XXRE'+Hex(Zw2,4),Zw2,L_JUMP);
                                       END ELSE
                                       IF (ZW1 AND IO_TAB)>0 THEN BEGIN
                                         AddLabel('XXXX'+Hex(Zw2,4),Zw2,0);
                                       END;
                                     END;
                                   END;
                           Bit_16: BEGIN
                                     ZW2:=TestData^[Adresse]+TestData^[Adresse+1]*256;
                                     Adresse:=Adresse+2;
                                     FindLabel(Zw2,LabName,LabFlag);
                                     IF LabName=''
                                     THEN BEGIN
                                         IF (Zw1 AND _Jump)>0 THEN AddLabel('XXJP'+Hex(Zw2,4),Zw2,L_JUMP)
                                           ELSE
                                             IF (Zw1 AND _Call)>0 THEN AddLabel('XXCA'+Hex(Zw2,4),Zw2,L_CALL)
                                               ELSE
                                                 IF ZW2>$1FF THEN AddLabel('XXXX'+Hex(Zw2,4),Zw2,0);
                                     END;
                                   END;
                         END;
                       END;
            rst_par  : BEGIN
                         FindLabel(B*8,LabName,LabFlag);
                         IF LabName='' THEN AddLabel('XXRS'+Hex(B*8,4),B*8,L_CALL);
                       END;
            bts_par : TabOfs:=TabOfs+2;
          END;
        END;
      UNTIL ID=0;
    END ELSE Inc(Adresse);
  UNTIL Adresse>=DataSize;
END;

{ == Zusatzfeatures ======================================================== }

PROCEDURE WriteLabels;
VAR
  C:Word;
  Z:String;
  T:Text;
BEGIN
  Assign(T,ListName);
  Rewrite(t);
  WriteLn(T,'; ========================================================================= ');
  WriteLn(T,'; Labels');
  WriteLn(T,'; ========================================================================= ');
  WriteLn(T);
  WriteLn(T,'; Routinen:');
  WriteLn(T);
  FOR C:=1 TO LabNum DO BEGIN
    IF (LabTab[C-1].Flags AND L_Call)>0 THEN BEGIN
      Z:=LabTab[C-1].Name;
      Extend(Z,20);
      Z:=Z+'EQU 0'+Hex(LabTab[C-1].Adr,4)+'h';
      WriteLn(T,Z);
    END;
  END;
  WriteLn(T);
  WriteLn(T,'; Speicheradressen:');
  WriteLn(T);
  FOR C:=1 TO LabNum DO BEGIN
    IF (LabTab[C-1].Flags AND (L_IO OR L_Call OR L_Jump))=0 THEN BEGIN
      Z:=LabTab[C-1].Name;
      Extend(Z,20);
      Z:=Z+'EQU 0'+Hex(LabTab[C-1].Adr,4)+'h';
      WriteLn(T,Z);
    END;
  END;

  WriteLn(T);
  Close(T);
END;

PROCEDURE Get_Info;
VAR
  C:Byte;
BEGIN
  Move(TestData^[$134],Module_Name[1],32);
  C:=1;WHILE (C<32) AND (Module_Name[C]<>#0) DO Inc(C);
  Module_Name[0]:=Char(C);
END;

{ == Hauptprogramm ========================================================= }

VAR
  Start,AktuAdr,C : Word;
  Zeile           : String;
  AnzBytes        : Byte;
  Dest            : Text;
  LabName         : String;
  LabFlag         : Byte;
  ParamNum        : Word;

BEGIN
  OpCodeTabSeg:=Seg(OpCodeTab);
  OpCodeTabOfs:=Ofs(OpCodeTab);
  IF ParamCount=0 THEN BEGIN
    WriteLn('GBDISASS <binfile> [Params]');
    WriteLn('Valid Params:');
    WriteLn('-l <labelfile>  ; read labels');
    WriteLn('-o <output>     ; standart: <binfile>+".ASM"');
    WriteLn('-n <labelfile>  ; list of new labels, standart: no list');
  END ELSE BEGIN
    DataName:=ParamStr(1);

    IF NOT Exist(DataName) THEN BEGIN
      IF Pos('.',DataName)=0 THEN
        IF Exist(DataName+'.BIN') THEN DataName:=DataName+'.BIN'
      ELSE BEGIN
        WriteLn('File not found:',DataName);
        Halt(0);
      END;
    END;
    IF Pos('.',DataName)=0 THEN SourceName:=DataName
                           ELSE SourceName:=Copy(DataName,1,Pos('.',DataName)-1);
    SourceName:=SourceName+'.ASM';
    ListName:='';

    ParamNum:=2;
    While ParamNum<=ParamCount DO BEGIN
      Zeile:=ParamStr(ParamNum);
      IF (Zeile[1]<>'-') OR (Length(Zeile)>2) THEN BEGIN
        WriteLn('Parameter expected:',Zeile);
        Halt(0);
      END ELSE BEGIN
        CASE UpCase(Zeile[2]) OF
          'L' : BEGIN
                  Inc(ParamNum);
                  Zeile:=ParamStr(ParamNum);
                  IF NOT Exist(Zeile) THEN BEGIN
                    IF Pos('.',Zeile)=0 THEN
                      IF Exist(Zeile+'.L') THEN Zeile:=Zeile+'L'
                    ELSE BEGIN
                      WriteLn('File not found:',Zeile);
                      Halt(0);
                    END;
                  END;
                  ReadLabelList(Zeile);
                END;
          'O' : BEGIN
                  Inc(ParamNum);
                  SourceName:=ParamStr(ParamNum);
                END;
          'N' : BEGIN
                  Inc(ParamNum);
                  ListName:=ParamStr(ParamNum);
                END;
          ELSE BEGIN
            WriteLn('Unknown Parameter:',Zeile);
            Halt(0);
          END;
        END;
        Inc(ParamNum);
      END;
    END;

    Assign(Dest,SourceName);
    Rewrite(Dest);

    LabNum:=0;DataNum:=0;

    New(TestData);
    WriteLn(' Daten lesen ...');
    LoadData;
    WriteLn(' Label lesen ...');
    ReadLabelList('GAMEBOY.L');
    WriteLn(' Daten analysieren ...');
    AnalyseData;
    WriteLn(' Quelltext speichern ...');
    Start:=0;

    Get_Info;

    WriteLn(Dest,'; =======================================================================');
    WriteLn(Dest,'; Modulname:'+Module_Name);
    WriteLn(Dest,'; Datei:'+DataName);
    WriteLn(Dest,'; =======================================================================');
    WriteLn(Dest);

    REPEAT
      AktuAdr:=Start;
      FindLabel(AktuAdr,LabName,LabFlag);
      IF (LabFlag AND L_IO)=0 THEN Zeile:=LabName ELSE Zeile:='';
      IF Zeile<>'' THEN Zeile:=Zeile+':';
      Extend(Zeile,15);
      IF DataArea(AktuAdr) THEN BEGIN
        IF DataType(Start)>=2 THEN BEGIN
          FindLabel(TestData^[Start]+TestData^[Start+1]*256,LabName,LabFlag);
          Zeile:=Zeile+'.DW OFFSET '+LabName;
          Inc(Start,2);
          LabName:='';LabFlag:=0;AnzBytes:=2;
        END ELSE BEGIN
          AnzBytes:=0;
          Zeile:=Zeile+'.DB ';
          LabName:='';
          WHILE DataArea(Start) AND (AnzBytes<16) AND (LabName='') DO BEGIN
            CASE DataType(Start) OF
              0 : Zeile:=Zeile+Hex(TestData^[Start],2)+#32;
              1 : IF TestData^[Start]>32 THEN Zeile:=Zeile+Char(TestData^[Start]) ELSE Zeile:=Zeile+'.';
            END;
            Inc(AnzBytes);
            Inc(Start);
            FindLabel(Start,LabName,LabFlag);
          END;
        END;
        Extend(Zeile,67);
        Zeile:=Zeile+'; '+Hex(AktuAdr,4);
        WriteLn(Dest,Zeile);
      END ELSE BEGIN
        Zeile:=Zeile+DisAssemble(Start);
        Extend(Zeile,40);
        Zeile:=Zeile+';';
        FOR C:=AktuAdr TO Start-1 DO
          Zeile:=Zeile+#32+Hex(TestData^[C],2);
        Extend(Zeile,69);
        Zeile:=Zeile+Hex(AktuAdr,4);
        WriteLn(Dest,Zeile);

        IF TestData^[AktuAdr] IN [$C9,$D9,$E9,$C3,$18] THEN
          WriteLn(Dest,'; -----------------------------------------------------------------------');
      END;
      Write(#13,'Adr:',Hex(Start,4));
    UNTIL Start > DataSize;
    WriteLn;

    IF ListName<>'' THEN WriteLabels;

    Dispose(TestData);

    Close(Dest);
  END;
END.