{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,R-,S-,V-,X+}
UNIT GBDIS; { Ein einfacher Disassembler fr Z80-Code }

INTERFACE

USES
   LabTool;

TYPE
  PArray = ^TArray;
  TArray = ARRAY [0..65534] OF Byte;

FUNCTION DisAssemble(Adr:Word;Data:PArray):String;
FUNCTION CodeSize(Adr:Word;Data:PArray):Word;
FUNCTION Hex(I:LongInt;N:Byte):String;
FUNCTION Dez(N:String):LongInt;

IMPLEMENTATION

CONST
  HexDigits : String = '0123456789ABCDEF';

  dir_opc		= 1;
  tab_opc		= 2;
  dir_par		= 3;
  tab_par		= 4;
  abs_par               = 5;
  rst_par		= 6;
  Bts_par               = 7;

  t_tree		= 0;
  t_end		        = 1;

  par_1		        = 0;
  par_2		        = 1;
  bit_4		        = 2;

  Bit_8		        = 0;
  Bit_16		= 1;
  Ptr		        = 2;
  Relative	        = 4;
  Absolute	        = 8;
  Conditional	        = 16;
  IO_Tab		= 128;

PROCEDURE OpCodeTab;EXTERNAL;
{$L DISGBTAB.OBJ}

VAR
  OpCodeTabSeg : Word;
  OpCodeTabOfs : Word;

{ == Hex - Dez Umrechnung ================================================== }

FUNCTION Hex(I:LongInt;N:Byte):String;
VAR
  D:String;
BEGIN
  D:='';
  WHILE N>0 DO BEGIN
    D:=HexDigits[(I AND 15)+1]+D;
    I:=I SHR 4;
    Dec(N);
  END;
  Hex:=D;
END;

FUNCTION StrVal(I:LongInt;N:Byte):String;
VAR
  D:String;
BEGIN
  D:=Find_Name(I);
  IF D='' THEN BEGIN
    WHILE N>0 DO BEGIN
      D:=HexDigits[(I AND 15)+1]+D;
      I:=I SHR 4;
      Dec(N);
    END;
    D:='0'+D+'h';
  END;
  StrVal:=D;
END;

FUNCTION Dez(N:String):LongInt;
VAR
  Num : LongInt;
BEGIN
  WHILE (Length(N)>0) AND (N[1]=#32) DO  Delete(N,1,1);
  WHILE (Length(N)>0) AND (N[Length(N)]=#32) DO Delete(N,Length(N),1);
  IF UpCase(N[Length(N)])='H' THEN Delete(N,Length(N),1);
  Num:=Find_Value(N);
  IF Num=-1 THEN  BEGIN
    Num:=0;
    WHILE Length(N)>0 DO BEGIN
      Num:=Num*16+(Pos(UpCase(N[1]),HexDigits)-1);
      Delete(N,1,1);
    END;
  END;
  Dez:=Num;
END;

{ == Disassembler ========================================================== }

FUNCTION DisAssemble(Adr:Word;Data:PArray):String;
VAR
  TabOfs   : Word;
  A,B,C    : Byte;
  ID,BT    : Word;
  ZW1,ZW2  : Word;
  Param    : String;
  Count    : Integer;
  Line     : String;
  LabName  : String;
  LabFlag  : Byte;
  PROCEDURE WriteDat(A:Word);
  BEGIN
    IF A>0 THEN BEGIN
      WHILE MEM[OpCodeTabSeg:A]<>0 DO BEGIN
        Line:=Line+Char(MEM[OpCodeTabSeg:A]);
        Inc(A);
      END;
    END;
  END;
BEGIN
  IF Data^[Adr]=$76 THEN Line:='halt' ELSE BEGIN
    IF Data^[Adr]=$CB THEN BEGIN
      TabOfs:=OpcodeTabOfs+8;
      Inc(Adr);
    END ELSE TabOfs:=OpCodeTabOfs;
    A:=Data^[Adr] SHR 6;
    B:=(Data^[Adr] SHR 3) AND 7;
    C:=Data^[Adr] AND 7;
    Inc(Adr);Line:='';
    TabOfs:=MEMW[OpCodeTabSeg:TabOfs+2*A];
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID=t_tree THEN BEGIN
                     BT:=MEMW[OpCodeTabSeg:TabOfs];
                     TabOfs:=TabOfs+2;
                     CASE BT OF
                       par_1 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+B*2];
                       par_2 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+C*2];
                       bit_4 : BEGIN
                                 TabOfs:=MEMW[OpCodeTabSeg:TabOfs+(B AND 1)*2];;
                                 B:=B SHR 1;
                               END;
                     END;
                   END;
    UNTIL (ID=t_end) OR (TabOfs=0);
    Count:=0;
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID>0 THEN BEGIN
        CASE Count OF
          1 : Line:=Line+' ';
          2 : Line:=Line+',';
        END;
        Inc(Count);
        CASE ID OF
          dir_opc  : BEGIN
                       WriteDat(MEMW[OpCodeTabSeg:TabOfs]);
                       TabOfs:=TabOfs+2;
                     END;
          tab_opc  : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       ZW2:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE ZW1 OF
                         par_1 : ZW2:=ZW2+B*2;
                         par_2 : ZW2:=ZW2+C*2;
                       END;
                       WriteDat(MEMW[OpCodeTabSeg:ZW2]);
                     END;
          dir_par : BEGIN
                       WriteDat(MEMW[OpCodeTabSeg:TabOfs]);
                       TabOfs:=TabOfs+2;
                    END;
          tab_par : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       ZW2:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE ZW1 OF
                         par_1 : ZW2:=ZW2+B*2;
                         par_2 : ZW2:=ZW2+C*2;
                       END;
                       WriteDat(MEMW[OpCodeTabSeg:ZW2]);
                    END;
          abs_par : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE (ZW1 AND 1) OF
                         Bit_8 : BEGIN
                                   ZW2:=Data^[Adr];
                                   IF (Zw1 AND Relative)>0 THEN ZW2:=Adr+ShortInt(ZW2)+1;
                                   IF (Zw1 AND IO_Tab)>0 THEN ZW2:=$FF00+Zw2;
                                   Adr:=Adr+1;
                                   IF (Zw1 AND (Relative OR IO_TAB))>0 THEN Param:=StrVal(Zw2,4)
                                     ELSE Param:=StrVal(Zw2,2)
                                 END;
                         Bit_16: BEGIN
                                   ZW2:=Data^[Adr]+Data^[Adr+1]*256;
                                   IF (Zw1 AND Relative)>0 THEN ZW2:=Adr+Integer(ZW2)+1;
                                   Adr:=Adr+2;
                                   Param:=StrVal(Zw2,4)
                                 END;
                       END;
                       IF (ZW1 AND Ptr)>0 THEN Param:='('+Param+')';
                       Line:=Line+Param;
                     END;
          rst_par  : BEGIN
                       Line:=Line+StrVal(B*8,2);
                     END;
          bts_par  : BEGIN
                       Zw1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       Case Zw1 OF
                         par_1 : Line:=Line+Hex(B,1);
                         par_2 : Line:=Line+Hex(C,1);
                       END;
                     END;
        END;
      END;
    UNTIL ID=0;
  END;
  DisAssemble:=Line;
END;

FUNCTION CodeSize(Adr:Word;Data:PArray):Word;
VAR
  TabOfs   : Word;
  A,B,C    : Byte;
  ID,BT    : Word;
  Count    : Integer;
  CS,ZW1   : Word;
BEGIN
  CS:=0;
  IF Data^[Adr]=$76 THEN CS:=1 ELSE BEGIN
    IF Data^[Adr]=$CB THEN BEGIN
      TabOfs:=OpCodeTabOfs+8;
      Inc(Adr);Inc(CS);
    END ELSE TabOfs:=OpCodeTabOfs;
    A:=Data^[Adr] SHR 6;
    B:=(Data^[Adr] SHR 3) AND 7;
    C:=Data^[Adr] AND 7;
    Inc(Adr);Inc(CS);
    TabOfs:=MEMW[OpCodeTabSeg:TabOfs+2*A];
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID=t_tree THEN BEGIN
                     BT:=MEMW[OpCodeTabSeg:TabOfs];
                     TabOfs:=TabOfs+2;
                     CASE BT OF
                       par_1 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+B*2];
                       par_2 : TabOfs:=MEMW[OpCodeTabSeg:TabOfs+C*2];
                       bit_4 : BEGIN
                                 TabOfs:=MEMW[OpCodeTabSeg:TabOfs+(B AND 1)*2];;
                                 B:=B SHR 1;
                               END;
                     END;
                   END;
    UNTIL (ID=t_end) OR (TabOfs=0);
    Count:=0;
    REPEAT
      ID:=MEMW[OpCodeTabSeg:TabOfs];
      TabOfs:=TabOfs+2;
      IF ID>0 THEN BEGIN
        Inc(Count);
        CASE ID OF
          dir_opc  : TabOfs:=TabOfs+2;
          tab_opc  : TabOfs:=TabOfs+4;
          dir_par  : TabOfs:=TabOfs+2;
          tab_par  : TabOfs:=TabOfs+4;
          abs_par : BEGIN
                       ZW1:=MEMW[OpCodeTabSeg:TabOfs];
                       TabOfs:=TabOfs+2;
                       CASE (ZW1 AND 1) OF
                         Bit_8 : CS:=CS+1;
                         Bit_16: CS:=CS+2;
                       END;
                     END;
          bts_par : TabOfs:=TabOfs+2;
        END;
      END;
    UNTIL ID=0;
  END;
  CodeSize:=CS;
END;

BEGIN
  OpCodeTabSeg:=Seg(OpCodeTab);
  OpCodeTabOfs:=Ofs(OpCodeTab);
END.